/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.UserPatterns;
import com.intellij.database.util.TokenPattern;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokenPatternCache {
    private static final Pattern ourSplitter = Pattern.compile("[\\s,]+");
    private final DatabaseSettings mySettings;
    private final ConcurrentMap<Couple<Language>, TokenPattern> myCache1;
    private final ConcurrentMap<String, TokenPattern> myCache2;
    private final ConcurrentMap<String, Boolean> myValidityCache;

    @Nullable
    public static TokenPattern getPattern(@NotNull DatabaseSettings settings, @Nullable Language hostLanguage, @Nullable Language language) {
        if (settings == null) {
            TokenPatternCache.$$$reportNull$$$0(0);
        }
        return settings.patternCache.getPattern((Couple<Language>)Couple.of((Object)hostLanguage, (Object)language));
    }

    @Nullable
    public static String getPatternError(@NotNull String pattern) {
        if (pattern == null) {
            TokenPatternCache.$$$reportNull$$$0(1);
        }
        try {
            new TokenPattern(pattern);
            return null;
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
    }

    public TokenPatternCache(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            TokenPatternCache.$$$reportNull$$$0(2);
        }
        this.myCache1 = ConcurrentFactoryMap.createMap(key2 -> this.createPattern((Couple<Language>)key2));
        this.myCache2 = ConcurrentFactoryMap.createMap(key2 -> TokenPatternCache.compilePattern(key2));
        this.myValidityCache = ConcurrentFactoryMap.createMap(key2 -> TokenPatternCache.getPatternError(key2) == null);
        this.mySettings = settings;
    }

    public void clear() {
        this.myCache1.clear();
        this.myCache2.clear();
        this.myValidityCache.clear();
    }

    public TokenPattern getPattern(@NotNull Couple<Language> key2) {
        if (key2 == null) {
            TokenPatternCache.$$$reportNull$$$0(3);
        }
        return (TokenPattern)this.myCache1.get(key2);
    }

    @Nullable
    private TokenPattern createPattern(Couple<Language> key2) {
        Application application = ApplicationManager.getApplication();
        boolean useHardcoded = !PlatformUtils.isDataGrip() || application == null || application.isUnitTestMode();
        UserPatterns userPatterns = this.mySettings.getUserPatterns();
        boolean isInjection = key2.first != null;
        boolean isEnabled = isInjection ? userPatterns.inLiterals : userPatterns.inScripts;
        JBIterable p2 = JBIterable.empty().append((Iterable)(useHardcoded ? UserPatterns.Predef.HARDCODED_PATTERNS : JBIterable.empty())).append((Iterable)(isEnabled ? userPatterns.patterns : JBIterable.empty()));
        return this.createPattern((Iterable<UserPatterns.ParameterPattern>)p2, (Language)key2.first, (Language)key2.second);
    }

    @Nullable
    private TokenPattern createPattern(Iterable<UserPatterns.ParameterPattern> patterns2, Language hostLanguage, Language language) {
        StringBuilder sb = new StringBuilder();
        for (UserPatterns.ParameterPattern p2 : patterns2) {
            if (!this.isApplicable(p2, hostLanguage, language)) continue;
            if (!sb.isEmpty()) {
                sb.append("|");
            }
            sb.append(p2.pattern);
        }
        if (sb.isEmpty()) {
            return null;
        }
        return (TokenPattern)this.myCache2.get(sb.toString());
    }

    private boolean isApplicable(UserPatterns.ParameterPattern p2, @Nullable Language hostLanguage, @Nullable Language language) {
        ThreeState hostInScope;
        boolean enabled;
        boolean injected = hostLanguage != null;
        boolean bl = enabled = injected ? p2.inLiterals : p2.inScripts;
        if (!enabled) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)p2.pattern)) {
            return false;
        }
        if (this.myValidityCache.get(p2.pattern) != Boolean.TRUE) {
            return false;
        }
        String adjustedScope = StringUtil.notNullize((String)StringUtil.nullize((String)p2.scope, (boolean)true), (String)"*");
        HashSet parsed = ContainerUtil.newHashSet((Object[])ourSplitter.split(adjustedScope));
        ThreeState threeState = hostInScope = hostLanguage == null ? ThreeState.YES : TokenPatternCache.inScope(hostLanguage, null, parsed);
        if (hostInScope != ThreeState.YES) {
            return false;
        }
        SqlLanguage toCheck = language == null ? SqlLanguage.INSTANCE : language;
        ThreeState langInScope = TokenPatternCache.inScope(toCheck, hostLanguage != null ? SqlLanguage.INSTANCE : null, parsed);
        if (langInScope == ThreeState.UNSURE) {
            return hostLanguage != null;
        }
        return langInScope == ThreeState.YES;
    }

    private static ThreeState inScope(Language language, Language stopAt, Set<String> scope2) {
        Language l = language;
        while (l != null && l != stopAt) {
            String languageId = TokenPatternCache.getId(l);
            if (scope2.contains(languageId)) {
                return ThreeState.YES;
            }
            if (scope2.contains("-" + languageId)) {
                return ThreeState.NO;
            }
            l = l == Language.ANY ? null : (Language)ObjectUtils.notNull((Object)l.getBaseLanguage(), (Object)Language.ANY);
        }
        return ThreeState.UNSURE;
    }

    @NotNull
    private static String getId(Language l) {
        String string = l == Language.ANY ? "*" : l.getID();
        if (string == null) {
            TokenPatternCache.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static TokenPattern compilePattern(@NotNull String pattern) {
        if (pattern == null) {
            TokenPatternCache.$$$reportNull$$$0(5);
        }
        try {
            return new TokenPattern(pattern);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/TokenPatternCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/TokenPatternCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPattern";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPatternError";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compilePattern";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

