/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.targetChooser;

import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/targetChooser/DataSourceTargetItem;", "Lcom/intellij/openapi/util/ColoredItem;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "dsId", "", "path", "Lcom/intellij/database/util/ObjectPath;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/String;Lcom/intellij/database/util/ObjectPath;Lcom/intellij/openapi/project/Project;)V", "getDs", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getDsId", "()Ljava/lang/String;", "getPath", "()Lcom/intellij/database/util/ObjectPath;", "getProject", "()Lcom/intellij/openapi/project/Project;", "prepareTarget", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationOptions$Target;", "toString", "getColor", "Ljava/awt/Color;", "intellij.database.impl"})
public final class DataSourceTargetItem
implements ColoredItem {
    @Nullable
    private final LocalDataSource ds;
    @NotNull
    private final String dsId;
    @Nullable
    private final ObjectPath path;
    @NotNull
    private final Project project;

    public DataSourceTargetItem(@Nullable LocalDataSource ds, @NotNull String dsId, @Nullable ObjectPath path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.ds = ds;
        this.dsId = dsId;
        this.path = path;
        this.project = project;
    }

    @Nullable
    public final LocalDataSource getDs() {
        return this.ds;
    }

    @NotNull
    public final String getDsId() {
        return this.dsId;
    }

    @Nullable
    public final ObjectPath getPath() {
        return this.path;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DatabaseScriptRunConfigurationOptions.Target prepareTarget() {
        ObjectPath objectPath = this.path;
        return new DatabaseScriptRunConfigurationOptions.Target(this.dsId, objectPath != null ? objectPath.serialize() : null);
    }

    @NotNull
    public String toString() {
        Object object;
        Object object2 = this.ds;
        if (object2 == null || (object2 = ((AbstractDataSource)object2).getName()) == null) {
            object2 = this.dsId;
        }
        if ((object = this.path) == null || (object = ((ObjectPath)object).toString()) == null) {
            object = "";
        }
        return (String)object2 + "/" + (String)object;
    }

    @Nullable
    public Color getColor() {
        return DatabaseColorManager.getColor(this.project, this.ds);
    }
}

