/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.targetChooser;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.targetChooser.DataSourceTargetItem;
import com.intellij.database.targetChooser.DataSourceTargetItemRenderer;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.util.containers.JBIterable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/targetChooser/DataSourceSchemaComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/database/targetChooser/DataSourceTargetItem;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "intellij.database.impl"})
public final class DataSourceSchemaComboBox
extends ComboBox<DataSourceTargetItem> {
    public DataSourceSchemaComboBox(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.setSwingPopup(false);
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        JBIterable jBIterable = storage.getDataSourcesImpl().flatMap(arg_0 -> DataSourceSchemaComboBox._init_$lambda$5(arg_0 -> DataSourceSchemaComboBox._init_$lambda$4(project, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"flatMap(...)");
        JBIterable targets = jBIterable;
        this.setModel(new DefaultComboBoxModel<Object>(targets.toArray((Object[])new DataSourceTargetItem[0])));
        this.setRenderer((ListCellRenderer)((Object)new DataSourceTargetItemRenderer(project)));
        this.setSelectedIndex(-1);
        this.putClientProperty(DarculaComboBoxUI.PAINT_VERTICAL_LINE, true);
    }

    private static final boolean lambda$4$lambda$0(BasicNamespace namespace) {
        return Intrinsics.areEqual((Object)namespace.getKind(), (Object)ObjectKind.SCHEMA) && !DbImplUtil.getDbms(namespace).eq(Dbms.MONGO);
    }

    private static final boolean lambda$4$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final DataSourceTargetItem lambda$4$lambda$2(LocalDataSource $ds, Project $project, BasicNamespace namespace) {
        String string = $ds.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        return new DataSourceTargetItem($ds, string, ObjectPaths.of(namespace), $project);
    }

    private static final DataSourceTargetItem lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (DataSourceTargetItem)$tmp0.invoke(p0);
    }

    private static final Iterable _init_$lambda$4(Project $project, LocalDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        TreePattern scope2 = DbImplUtil.getIntrospectionScope(ds);
        return (Iterable)DbImplUtilCore.getNamespaces(ds, scope2).filter(arg_0 -> DataSourceSchemaComboBox.lambda$4$lambda$1(DataSourceSchemaComboBox::lambda$4$lambda$0, arg_0)).map(arg_0 -> DataSourceSchemaComboBox.lambda$4$lambda$3(arg_0 -> DataSourceSchemaComboBox.lambda$4$lambda$2(ds, $project, arg_0), arg_0));
    }

    private static final Iterable _init_$lambda$5(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }
}

