/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.sql.common.impl.formatter.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.database.sql.common.impl.formatter.settings.SqlCodeStyleMainPanel;
import com.intellij.database.sql.common.impl.formatter.settings.SqlPreviewExamples;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralSqlCodeStyleMainPanel
extends SqlCodeStyleMainPanel {
    @NotNull
    private static final SqlLanguage MY_SETTINGS_LANGUAGE = SqlLanguage.INSTANCE;
    @NotNull
    private SqlLanguageDialect myPreviewDialect = GeneralSqlCodeStyleMainPanel.getDefaultPreviewDialect();
    public static final String LAST_USER_PREVIEW_DIALECT_PROPERTY_NAME = "sql.codeStylePanel.last.previewDialect";
    private ComboBox<DialectItem> myDialectSelector;
    private DefaultComboBoxModel<DialectItem> myDialectSelectorModel;
    private TreeSet<DialectItem> myCurrentInheritedDialects;

    public GeneralSqlCodeStyleMainPanel(CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        super(MY_SETTINGS_LANGUAGE, currentSettings, settings);
        JComponent panel2 = this.getPanel();
        assert (panel2 != null);
        panel2.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                GeneralSqlCodeStyleMainPanel.this.justShown();
            }
        });
    }

    @Override
    protected boolean isGeneral() {
        return true;
    }

    @Override
    @NotNull
    protected Language getSettingLanguage() {
        SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
        if (sqlLanguage == null) {
            GeneralSqlCodeStyleMainPanel.$$$reportNull$$$0(0);
        }
        return sqlLanguage;
    }

    @Override
    @NotNull
    protected SqlLanguageDialect getPreviewDialect() {
        return this.myPreviewDialect != null ? this.myPreviewDialect : GeneralSqlCodeStyleMainPanel.getDefaultPreviewDialect();
    }

    @NotNull
    private static SqlLanguageDialect getDefaultPreviewDialect() {
        SqlLanguageDialect sqlLanguageDialect = SqlCodeStyles.getPreviewDialectFor(MY_SETTINGS_LANGUAGE);
        if (sqlLanguageDialect == null) {
            GeneralSqlCodeStyleMainPanel.$$$reportNull$$$0(1);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public Language getDefaultLanguage() {
        return this.getSettingLanguage();
    }

    @Override
    @NotNull
    protected Class<? extends SqlCodeStyleSettings> getSettingsClass() {
        return SqlCodeStyleSettings.class;
    }

    @Override
    @Nullable
    protected JComponent createDialectSelectorStripe(CodeStyleSettings settings) {
        this.myCurrentInheritedDialects = GeneralSqlCodeStyleMainPanel.gatherInheritedDialects(settings);
        this.myDialectSelectorModel = new DefaultComboBoxModel<DialectItem>(this.myCurrentInheritedDialects.toArray(new DialectItem[0]));
        this.myDialectSelector = new ComboBox(this.myDialectSelectorModel);
        this.myDialectSelector.setSelectedIndex(0);
        this.myDialectSelector.setMaximumRowCount(15);
        this.restoreUserLastPreviewDialect();
        this.myDialectSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item;
                if (e.getStateChange() == 1 && (item = GeneralSqlCodeStyleMainPanel.this.myDialectSelector.getSelectedItem()) instanceof DialectItem) {
                    GeneralSqlCodeStyleMainPanel.this.handlePreviewDialectChanged((DialectItem)item);
                    GeneralSqlCodeStyleMainPanel.this.rememberUserLastPreviewDialect();
                }
            }
        });
        JPanel dialectStripe = new JPanel(new BorderLayout());
        dialectStripe.setBorder((Border)JBUI.Borders.empty((int)2, (int)10));
        dialectStripe.add((Component)this.myDialectSelector, "Center");
        JBLabel dialectLabel = new JBLabel(SqlBundle.message("settings.code.style.preview.dialect", new Object[0]));
        dialectLabel.setLabelFor(this.myDialectSelector);
        dialectStripe.add((Component)dialectLabel, "West");
        return dialectStripe;
    }

    private void restoreUserLastPreviewDialect() {
        Project currentProject = ProjectUtil.guessCurrentProject((JComponent)this.getPanel());
        PropertiesComponent pc = PropertiesComponent.getInstance((Project)currentProject);
        String lastDialectName = pc.getValue(LAST_USER_PREVIEW_DIALECT_PROPERTY_NAME);
        if (lastDialectName != null) {
            int n = this.myDialectSelectorModel.getSize();
            for (int i2 = 0; i2 < n; ++i2) {
                DialectItem e = this.myDialectSelectorModel.getElementAt(i2);
                if (!e.toString().equalsIgnoreCase(lastDialectName)) continue;
                this.myDialectSelector.setSelectedIndex(i2);
                this.handlePreviewDialectChanged(e);
            }
        }
    }

    private void rememberUserLastPreviewDialect() {
        int selectedIndex = this.myDialectSelector.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        DialectItem e = this.myDialectSelectorModel.getElementAt(selectedIndex);
        if (e == null) {
            return;
        }
        String lastDialectName = e.toString();
        Project currentProject = ProjectUtil.guessCurrentProject((JComponent)this.getPanel());
        PropertiesComponent pc = PropertiesComponent.getInstance((Project)currentProject);
        pc.setValue(LAST_USER_PREVIEW_DIALECT_PROPERTY_NAME, lastDialectName);
    }

    @NotNull
    private static TreeSet<DialectItem> gatherInheritedDialects(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            GeneralSqlCodeStyleMainPanel.$$$reportNull$$$0(2);
        }
        TreeSet<DialectItem> dialectItems = new TreeSet<DialectItem>();
        dialectItems.add(new DialectItem(0, GeneralSqlCodeStyleMainPanel.getDefaultPreviewDialect()));
        dialectItems.addAll(SqlCodeStyles.listSqlDialects().filter(d -> SqlCodeStyles.pickSqlSettings((CodeStyleSettings)settings, (Language)d).USE_GENERAL_STYLE).transform(d -> new DialectItem(1, (SqlLanguageDialect)d)).toList());
        TreeSet<DialectItem> treeSet = dialectItems;
        if (treeSet == null) {
            GeneralSqlCodeStyleMainPanel.$$$reportNull$$$0(3);
        }
        return treeSet;
    }

    protected void justShown() {
        boolean somethingChanged;
        CodeStyleSettings settings = this.getModelSettings();
        if (settings == null) {
            return;
        }
        TreeSet<DialectItem> dialectItems = GeneralSqlCodeStyleMainPanel.gatherInheritedDialects(settings);
        boolean bl = somethingChanged = !this.myCurrentInheritedDialects.equals(dialectItems);
        if (somethingChanged) {
            DefaultComboBoxModel<DialectItem> model = new DefaultComboBoxModel<DialectItem>(dialectItems.toArray(new DialectItem[0]));
            this.myDialectSelector.setModel(model);
            boolean currentWasRemoved = JBIterable.from(dialectItems).filter(item -> item.dialect == this.myPreviewDialect).isEmpty();
            this.myCurrentInheritedDialects = dialectItems;
            if (currentWasRemoved) {
                this.myDialectSelector.setSelectedIndex(0);
                this.handlePreviewDialectChanged(this.myCurrentInheritedDialects.first());
            }
        }
    }

    private void handlePreviewDialectChanged(@NotNull DialectItem dialectItem) {
        if (dialectItem == null) {
            GeneralSqlCodeStyleMainPanel.$$$reportNull$$$0(4);
        }
        if (this.myPreviewDialect == dialectItem.dialect) {
            return;
        }
        if (this.myPanels == null) {
            return;
        }
        this.myPreviewDialect = dialectItem.dialect;
        for (CodeStyleAbstractPanel panel2 : this.myPanels) {
            if (!(panel2 instanceof SqlCodeStyleMainPanel.SqlSettingsPanel)) continue;
            SqlCodeStyleMainPanel.SqlSettingsPanel p2 = (SqlCodeStyleMainPanel.SqlSettingsPanel)panel2;
            String text2 = SqlPreviewExamples.read(this.myPreviewDialect, p2.getType());
            p2.updatePreviewText(text2);
        }
    }

    @Override
    protected PsiFile createFileFromText(@NotNull Project project, @NotNull String text2) {
        if (project == null) {
            GeneralSqlCodeStyleMainPanel.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            GeneralSqlCodeStyleMainPanel.$$$reportNull$$$0(6);
        }
        PsiFile previewFile = SqlCodeStyleSettingsUtil.createSqlFileForCodeStyleSettingsPreview(project, text2, this.getPreviewDialect());
        previewFile.setName("Generic-SQL-preview.sql");
        return previewFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/sql/common/impl/formatter/settings/GeneralSqlCodeStyleMainPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectItem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPreviewDialect";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/sql/common/impl/formatter/settings/GeneralSqlCodeStyleMainPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "gatherInheritedDialects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "gatherInheritedDialects";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handlePreviewDialectChanged";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private static final class DialectItem
    implements Comparable<DialectItem> {
        final int weight;
        final SqlLanguageDialect dialect;

        private DialectItem(int weight, SqlLanguageDialect dialect) {
            this.weight = weight;
            this.dialect = dialect;
        }

        @Override
        public int compareTo(@NotNull DialectItem o) {
            if (o == null) {
                DialectItem.$$$reportNull$$$0(0);
            }
            if (this.weight < o.weight) {
                return -1;
            }
            if (this.weight > o.weight) {
                return 1;
            }
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return this.dialect.getDisplayName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/sql/common/impl/formatter/settings/GeneralSqlCodeStyleMainPanel$DialectItem", "compareTo"));
        }
    }
}

