/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.sql.backend.core;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.sql.backend.core.SqlRoutineIndex;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.messages.Topic;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 +2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0006+,-./0B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0003H\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00032\u0006\u0010#\u001a\u00020$H\u0002J6\u0010&\u001a\b\u0012\u0004\u0012\u0002H(0\u0003\"\u0004\b\u0000\u0010(2\u0006\u0010#\u001a\u00020$2\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u0002H(0*H\u0002\u00a8\u00061"}, d2={"Lcom/intellij/database/sql/backend/core/SqlRoutineIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$IdentifiablePath;", "", "Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Value;", "<init>", "()V", "getName", "Lcom/intellij/util/indexing/ID;", "dependsOnFileContent", "", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "pathFor", "Lcom/intellij/database/util/ObjectPath;", "definition", "Lcom/intellij/sql/psi/impl/SqlProcedureDefinitionImpl;", "path", "valueFromDefinition", "references", "", "Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Call;", "calls", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "(Ljava/util/List;)[Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Call;", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "getKeyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getVersion", "", "readPath", "input", "Ljava/io/DataInput;", "readSrcPath", "readBatch", "", "T", "reader", "Lkotlin/Function2;", "Companion", "IdentifiablePath", "Value", "Call", "SqlRoutineIndexListener", "Persistent", "intellij.database.sql.backend.core"})
@SourceDebugExtension(value={"SMAP\nSqlRoutineIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlRoutineIndex.kt\ncom/intellij/database/sql/backend/core/SqlRoutineIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,271:1\n1617#2,9:272\n1869#2:281\n1870#2:283\n1626#2:284\n1878#2,3:289\n1491#2:292\n1516#2,3:293\n1519#2,3:303\n1252#2,2:308\n1563#2:310\n1634#2,3:311\n1255#2:314\n1#3:282\n37#4:285\n36#4,3:286\n382#5,7:296\n463#5:306\n413#5:307\n*S KotlinDebug\n*F\n+ 1 SqlRoutineIndex.kt\ncom/intellij/database/sql/backend/core/SqlRoutineIndex\n*L\n115#1:272,9\n115#1:281\n115#1:283\n115#1:284\n223#1:289,3\n85#1:292\n85#1:293,3\n85#1:303,3\n86#1:308,2\n87#1:310\n87#1:311,3\n86#1:314\n115#1:282\n119#1:285\n119#1:286,3\n85#1:296,7\n86#1:306\n86#1:307\n*E\n"})
public final class SqlRoutineIndex
extends FileBasedIndexExtension<IdentifiablePath, List<? extends Value>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ID<IdentifiablePath, List<Value>> indexId;
    @NotNull
    private static final Topic<SqlRoutineIndexListener> topic;
    @NotNull
    private static final String batchTerminator = "$";
    @NotNull
    private static final String nullValue = "<null>";

    @NotNull
    public ID<IdentifiablePath, List<Value>> getName() {
        return indexId;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public DataIndexer<IdentifiablePath, List<Value>, FileContent> getIndexer() {
        return arg_0 -> SqlRoutineIndex.getIndexer$lambda$7(this, arg_0);
    }

    private final ObjectPath pathFor(SqlProcedureDefinitionImpl definition, ObjectPath path) {
        if (!Intrinsics.areEqual((Object)path.kind, (Object)ObjectKind.ROUTINE)) {
            ObjectPath parent = path.parent;
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(definition);
            Intrinsics.checkNotNull((Object)sqlLanguageDialect, (String)"null cannot be cast to non-null type com.intellij.sql.dialects.SqlLanguageDialectEx");
            SqlLanguageDialectEx sqlDialect = (SqlLanguageDialectEx)sqlLanguageDialect;
            ObjectPath defPath = ObjectPaths.of(definition, sqlDialect);
            ObjectPath objectPath = ObjectPath.create(defPath.name, defPath.kind, defPath.isQuoted(), defPath.getIdentity(), parent);
            Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"create(...)");
            return objectPath;
        }
        return path;
    }

    private final Value valueFromDefinition(SqlProcedureDefinitionImpl definition) {
        FilteredTraverserBase filteredTraverserBase = SqlImplUtil.sqlTraverser(definition).filter(arg_0 -> SqlRoutineIndex.valueFromDefinition$lambda$9(arg_0 -> SqlRoutineIndex.valueFromDefinition$lambda$8(definition, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"filter(...)");
        SyntaxTraverser functionTraverser = (SyntaxTraverser)filteredTraverserBase;
        boolean pure = ((SyntaxTraverser)functionTraverser.filter(arg_0 -> SqlRoutineIndex.valueFromDefinition$lambda$11(SqlRoutineIndex::valueFromDefinition$lambda$10, arg_0))).traverse().isEmpty();
        List list = functionTraverser.filter(SqlFunctionCallExpression.class).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List functionCalls = list;
        return new Value(pure, this.references(functionCalls));
    }

    /*
     * WARNING - void declaration
     */
    private final Call[] references(List<? extends SqlFunctionCallExpression> calls) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = calls;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Call call;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SqlFunctionCallExpression call2 = (SqlFunctionCallExpression)element$iv$iv;
            boolean bl2 = false;
            SqlReferenceExpression nameElement = call2.getNameElement();
            Object object = nameElement;
            if (object == null || (object = object.getText()) == null) {
                call = null;
            } else {
                Object text2 = object;
                String string = nameElement.getReferenceElementType().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                call = new Call((String)text2, string);
            }
            if (call == null) continue;
            Call it$iv$iv = call;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Call[0]);
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileType[] fileTypeArray = new FileType[]{SqlFileType.INSTANCE};
        FileType[] fileTypeArray2 = fileTypeArray;
        return (FileBasedIndex.InputFilter)new DefaultFileTypeSpecificInputFilter(fileTypeArray2){

            public boolean acceptInput(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return DbSrcUtilsCore.isDbSrcFile(file);
            }
        };
    }

    @NotNull
    public KeyDescriptor<IdentifiablePath> getKeyDescriptor() {
        return (KeyDescriptor)new KeyDescriptor<IdentifiablePath>(this){
            final /* synthetic */ SqlRoutineIndex this$0;
            {
                this.this$0 = $receiver;
            }

            public int getHashCode(IdentifiablePath value) {
                IdentifiablePath identifiablePath = value;
                return identifiablePath != null ? identifiablePath.hashCode() : 0;
            }

            public void save(DataOutput out, IdentifiablePath value) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                    IdentifiablePath identifiablePath = value;
                    if (identifiablePath == null) break block0;
                    identifiablePath.write(out);
                }
            }

            public IdentifiablePath read(DataInput input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return SqlRoutineIndex.access$readPath(this.this$0, input);
            }

            public boolean isEqual(IdentifiablePath val1, IdentifiablePath val2) {
                return Intrinsics.areEqual((Object)val1, (Object)val2);
            }
        };
    }

    @NotNull
    public DataExternalizer<List<Value>> getValueExternalizer() {
        return (DataExternalizer)new DataExternalizer<List<? extends Value>>(this){
            final /* synthetic */ SqlRoutineIndex this$0;
            {
                this.this$0 = $receiver;
            }

            public void save(DataOutput out, List<Value> value) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                if (value != null) {
                    com.intellij.database.sql.backend.core.SqlRoutineIndex$Companion.access$writePersistentBatch(SqlRoutineIndex.Companion, out, value);
                }
            }

            public List<Value> read(DataInput input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return SqlRoutineIndex.access$readBatch(this.this$0, input, (arg_0, arg_1) -> getValueExternalizer.1.read$lambda$1(this.this$0, arg_0, arg_1));
            }

            private static final Call read$lambda$1$lambda$0(DataInput iInner, String valueInner) {
                Intrinsics.checkNotNullParameter((Object)iInner, (String)"iInner");
                Intrinsics.checkNotNullParameter((Object)valueInner, (String)"valueInner");
                String type = IOUtil.readUTF((DataInput)iInner);
                Intrinsics.checkNotNull((Object)type);
                return new Call(valueInner, type);
            }

            private static final Value read$lambda$1(SqlRoutineIndex this$0, DataInput i2, String value) {
                Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                boolean pure = Boolean.parseBoolean(value);
                List calls = SqlRoutineIndex.access$readBatch(this$0, i2, getValueExternalizer.1::read$lambda$1$lambda$0);
                Collection $this$toTypedArray$iv = calls;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return new Value(pure, thisCollection$iv.toArray(new Call[0]));
            }
        };
    }

    public int getVersion() {
        return 1;
    }

    private final IdentifiablePath readPath(DataInput input) {
        String dataSource = IOUtil.readUTF((DataInput)input);
        Intrinsics.checkNotNull((Object)dataSource);
        return new IdentifiablePath(dataSource, this.readSrcPath(input));
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectPath readSrcPath(DataInput input) {
        List<String> names = this.readBatch(input);
        List<String> kinds = this.readBatch(input);
        String disambiguator = SqlRoutineIndex.Companion.readUtfNullable(input);
        ObjectPath parent = null;
        Iterable $this$forEachIndexed$iv = names;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void n;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i2 = n2;
            boolean bl = false;
            ObjectKind objectKind = DbSrcUtilsCore.findKind(kinds.get(i2));
            if (objectKind == null) {
                objectKind = ObjectKind.NONE;
            }
            ObjectKind kind = objectKind;
            parent = ObjectPath.create((String)n, kind, true, i2 == names.size() - 1 ? disambiguator : null, parent);
        }
        ObjectPath objectPath = parent;
        Intrinsics.checkNotNull(objectPath);
        return objectPath;
    }

    private final List<String> readBatch(DataInput input) {
        return this.readBatch(input, SqlRoutineIndex::readBatch$lambda$14);
    }

    private final <T> List<T> readBatch(DataInput input, Function2<? super DataInput, ? super String, ? extends T> reader) {
        String value = IOUtil.readUTF((DataInput)input);
        ArrayList<Object> values = new ArrayList<Object>();
        while (value != null && !Intrinsics.areEqual((Object)value, (Object)batchTerminator)) {
            values.add(reader.invoke((Object)input, (Object)value));
            value = IOUtil.readUTF((DataInput)input);
        }
        return values;
    }

    private static final boolean getIndexer$lambda$7$lambda$0(PsiElement it) {
        return !(it instanceof SqlProcedureDefinitionImpl);
    }

    private static final boolean getIndexer$lambda$7$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Pair getIndexer$lambda$7$lambda$2(String $dataSource, SqlRoutineIndex this$0, ObjectPath $srcPath, SqlProcedureDefinitionImpl it) {
        Intrinsics.checkNotNull((Object)it);
        return new Pair((Object)new IdentifiablePath($dataSource, this$0.pathFor(it, $srcPath)), (Object)this$0.valueFromDefinition(it));
    }

    private static final Pair getIndexer$lambda$7$lambda$3(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getIndexer$lambda$7(SqlRoutineIndex this$0, FileContent inputData) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        PsiFile psiFile;
        ObjectPath srcPath;
        String dataSource;
        block10: {
            block11: {
                SqlLanguageDialectEx sqlDialect;
                Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
                VirtualFile virtualFile = inputData.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                VirtualFile file = virtualFile;
                String string = DbSrcUtilsCore.getDataSource(file);
                if (string == null) {
                    return MapsKt.emptyMap();
                }
                dataSource = string;
                ObjectPath objectPath = DbSrcUtilsCore.getFullPath(file.getPath());
                if (objectPath == null) {
                    return MapsKt.emptyMap();
                }
                srcPath = objectPath;
                PsiFile psiFile2 = inputData.getPsiFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getPsiFile(...)");
                psiFile = psiFile2;
                SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect((PsiElement)psiFile);
                SqlLanguageDialectEx sqlLanguageDialectEx = sqlDialect = sqlLanguageDialect instanceof SqlLanguageDialectEx ? (SqlLanguageDialectEx)sqlLanguageDialect : null;
                if (Intrinsics.areEqual((Object)srcPath.kind, (Object)ObjectKind.ROUTINE)) break block10;
                if (!Intrinsics.areEqual((Object)srcPath.kind, (Object)ObjectKind.BODY)) break block11;
                Object object = sqlDialect;
                if (object != null && (object = ((SqlLanguageDialect)object).getDbms()) != null ? ((Dbms)object).isOracle() : false) break block10;
            }
            return MapsKt.emptyMap();
        }
        JBIterable jBIterable = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)psiFile)).expand(arg_0 -> SqlRoutineIndex.getIndexer$lambda$7$lambda$1(SqlRoutineIndex::getIndexer$lambda$7$lambda$0, arg_0))).filter(SqlProcedureDefinitionImpl.class).map(arg_0 -> SqlRoutineIndex.getIndexer$lambda$7$lambda$3(arg_0 -> SqlRoutineIndex.getIndexer$lambda$7$lambda$2(dataSource, this$0, srcPath, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        Iterable iterable = (Iterable)jBIterable;
        boolean $i$f$groupBy = false;
        void var10_10 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            key$iv$iv = (IdentifiablePath)it.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void entry;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)entry.getValue();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add((Value)it.getSecond());
            }
            List list = (List)destination$iv$iv2;
            map3.put(k, list);
        }
        Map values = destination$iv$iv;
        ((SqlRoutineIndexListener)inputData.getProject().getMessageBus().syncPublisher(topic)).built();
        return values;
    }

    private static final boolean valueFromDefinition$lambda$8(SqlProcedureDefinitionImpl $definition, PsiElement e) {
        return !Intrinsics.areEqual((Object)e, (Object)$definition);
    }

    private static final boolean valueFromDefinition$lambda$9(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean valueFromDefinition$lambda$10(PsiElement e) {
        return e instanceof SqlDmlStatement || e instanceof SqlDdlStatement;
    }

    private static final boolean valueFromDefinition$lambda$11(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String readBatch$lambda$14(DataInput dataInput, String value) {
        Intrinsics.checkNotNullParameter((Object)dataInput, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value;
    }

    public static final /* synthetic */ IdentifiablePath access$readPath(SqlRoutineIndex $this, DataInput input) {
        return $this.readPath(input);
    }

    public static final /* synthetic */ List access$readBatch(SqlRoutineIndex $this, DataInput input, Function2 reader) {
        return $this.readBatch(input, reader);
    }

    static {
        ID iD = ID.create((String)"sql.routine.index");
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"create(...)");
        indexId = iD;
        topic = new Topic("sql.routine.index.listener", SqlRoutineIndexListener.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Call;", "Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Persistent;", "text", "", "type", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getType", "write", "", "output", "Ljava/io/DataOutput;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.database.sql.backend.core"})
    public static final class Call
    implements Persistent {
        @NotNull
        private final String text;
        @NotNull
        private final String type;

        public Call(@NotNull String text2, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.text = text2;
            this.type = type;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @Override
        public void write(@NotNull DataOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            IOUtil.writeUTF((DataOutput)output, (String)this.text);
            IOUtil.writeUTF((DataOutput)output, (String)this.type);
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final Call copy(@NotNull String text2, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Call(text2, type);
        }

        public static /* synthetic */ Call copy$default(Call call, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = call.text;
            }
            if ((n & 2) != 0) {
                string2 = call.type;
            }
            return call.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Call(text=" + this.text + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Call)) {
                return false;
            }
            Call call = (Call)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)call.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)call.type);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0002J\u001e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0018H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Companion;", "", "<init>", "()V", "indexId", "Lcom/intellij/util/indexing/ID;", "Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$IdentifiablePath;", "", "Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Value;", "getIndexId", "()Lcom/intellij/util/indexing/ID;", "topic", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$SqlRoutineIndexListener;", "getTopic", "()Lcom/intellij/util/messages/Topic;", "batchTerminator", "", "nullValue", "writeBatch", "", "output", "Ljava/io/DataOutput;", "values", "", "writePersistentBatch", "Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Persistent;", "readUtfNullable", "input", "Ljava/io/DataInput;", "writeUtfNullable", "value", "intellij.database.sql.backend.core"})
    @SourceDebugExtension(value={"SMAP\nSqlRoutineIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlRoutineIndex.kt\ncom/intellij/database/sql/backend/core/SqlRoutineIndex$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n1563#2:272\n1634#2,3:273\n*S KotlinDebug\n*F\n+ 1 SqlRoutineIndex.kt\ncom/intellij/database/sql/backend/core/SqlRoutineIndex$Companion\n*L\n40#1:272\n40#1:273,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ID<IdentifiablePath, List<Value>> getIndexId() {
            return indexId;
        }

        @NotNull
        public final Topic<SqlRoutineIndexListener> getTopic() {
            return topic;
        }

        /*
         * WARNING - void declaration
         */
        private final void writeBatch(DataOutput output, Iterable<String> values) {
            Collection<writeBatch.1.1> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable<String> iterable = values;
            DataOutput dataOutput = output;
            Companion companion = this;
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Persistent((String)it){
                    final /* synthetic */ String $it;
                    {
                        this.$it = $it;
                    }

                    public void write(DataOutput output) {
                        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                        IOUtil.writeUTF((DataOutput)output, (String)this.$it);
                    }
                });
            }
            collection = (List)destination$iv$iv;
            companion.writePersistentBatch(dataOutput, (Iterable<? extends Persistent>)collection);
        }

        private final void writePersistentBatch(DataOutput output, Iterable<? extends Persistent> values) {
            for (Persistent persistent : values) {
                persistent.write(output);
            }
            IOUtil.writeUTF((DataOutput)output, (String)SqlRoutineIndex.batchTerminator);
        }

        private final String readUtfNullable(DataInput input) {
            String value = IOUtil.readUTF((DataInput)input);
            return Intrinsics.areEqual((Object)value, (Object)SqlRoutineIndex.nullValue) ? null : value;
        }

        private final void writeUtfNullable(DataOutput output, String value) {
            String string = value;
            if (string == null) {
                string = SqlRoutineIndex.nullValue;
            }
            IOUtil.writeUTF((DataOutput)output, (String)string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$IdentifiablePath;", "Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Persistent;", "dataSource", "", "path", "Lcom/intellij/database/util/ObjectPath;", "<init>", "(Ljava/lang/String;Lcom/intellij/database/util/ObjectPath;)V", "getDataSource", "()Ljava/lang/String;", "getPath", "()Lcom/intellij/database/util/ObjectPath;", "write", "", "output", "Ljava/io/DataOutput;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.database.sql.backend.core"})
    public static final class IdentifiablePath
    implements Persistent {
        @NotNull
        private final String dataSource;
        @NotNull
        private final ObjectPath path;

        public IdentifiablePath(@NotNull String dataSource, @NotNull ObjectPath path) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.dataSource = dataSource;
            this.path = path;
        }

        @NotNull
        public final String getDataSource() {
            return this.dataSource;
        }

        @NotNull
        public final ObjectPath getPath() {
            return this.path;
        }

        @Override
        public void write(@NotNull DataOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            IOUtil.writeUTF((DataOutput)output, (String)this.dataSource);
            this.write(this.path, output);
        }

        private final void write(ObjectPath $this$write, DataOutput output) {
            List names = new ArrayList();
            List kinds = new ArrayList();
            $this$write.forEach(arg_0 -> IdentifiablePath.write$lambda$0(names, kinds, arg_0));
            Companion.writeBatch(output, names);
            Companion.writeBatch(output, kinds);
            Companion.writeUtfNullable(output, $this$write.getIdentity());
        }

        @NotNull
        public final String component1() {
            return this.dataSource;
        }

        @NotNull
        public final ObjectPath component2() {
            return this.path;
        }

        @NotNull
        public final IdentifiablePath copy(@NotNull String dataSource, @NotNull ObjectPath path) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new IdentifiablePath(dataSource, path);
        }

        public static /* synthetic */ IdentifiablePath copy$default(IdentifiablePath identifiablePath, String string, ObjectPath objectPath, int n, Object object) {
            if ((n & 1) != 0) {
                string = identifiablePath.dataSource;
            }
            if ((n & 2) != 0) {
                objectPath = identifiablePath.path;
            }
            return identifiablePath.copy(string, objectPath);
        }

        @NotNull
        public String toString() {
            return "IdentifiablePath(dataSource=" + this.dataSource + ", path=" + this.path + ")";
        }

        public int hashCode() {
            int result2 = this.dataSource.hashCode();
            result2 = result2 * 31 + this.path.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IdentifiablePath)) {
                return false;
            }
            IdentifiablePath identifiablePath = (IdentifiablePath)other;
            if (!Intrinsics.areEqual((Object)this.dataSource, (Object)identifiablePath.dataSource)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.path, (Object)identifiablePath.path);
        }

        private static final void write$lambda$0(List $names, List $kinds, ObjectPath it) {
            String string = it.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            $names.add(string);
            String string2 = it.kind.code();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"code(...)");
            $kinds.add(string2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Persistent;", "", "write", "", "output", "Ljava/io/DataOutput;", "intellij.database.sql.backend.core"})
    private static interface Persistent {
        public void write(@NotNull DataOutput var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$SqlRoutineIndexListener;", "", "built", "", "intellij.database.sql.backend.core"})
    public static interface SqlRoutineIndexListener {
        public void built();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ(\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001aJ\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Value;", "Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Persistent;", "pure", "", "calls", "", "Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Call;", "<init>", "(Z[Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Call;)V", "getPure", "()Z", "getCalls", "()[Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Call;", "[Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Call;", "write", "", "output", "Ljava/io/DataOutput;", "equals", "other", "", "hashCode", "", "component1", "component2", "copy", "(Z[Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Call;)Lcom/intellij/database/sql/backend/core/SqlRoutineIndex$Value;", "toString", "", "intellij.database.sql.backend.core"})
    public static final class Value
    implements Persistent {
        private final boolean pure;
        @NotNull
        private final Call[] calls;

        public Value(boolean pure, @NotNull Call[] calls) {
            Intrinsics.checkNotNullParameter((Object)calls, (String)"calls");
            this.pure = pure;
            this.calls = calls;
        }

        public final boolean getPure() {
            return this.pure;
        }

        @NotNull
        public final Call[] getCalls() {
            return this.calls;
        }

        @Override
        public void write(@NotNull DataOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            IOUtil.writeUTF((DataOutput)output, (String)String.valueOf(this.pure));
            Companion.writePersistentBatch(output, ArraysKt.asIterable((Object[])this.calls));
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Value && ((Value)other).pure == this.pure && Arrays.equals(this.calls, ((Value)other).calls);
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.pure);
            return result2 + 31 * result2 + Arrays.hashCode(this.calls);
        }

        public final boolean component1() {
            return this.pure;
        }

        @NotNull
        public final Call[] component2() {
            return this.calls;
        }

        @NotNull
        public final Value copy(boolean pure, @NotNull Call[] calls) {
            Intrinsics.checkNotNullParameter((Object)calls, (String)"calls");
            return new Value(pure, calls);
        }

        public static /* synthetic */ Value copy$default(Value value, boolean bl, Call[] callArray, int n, Object object) {
            if ((n & 1) != 0) {
                bl = value.pure;
            }
            if ((n & 2) != 0) {
                callArray = value.calls;
            }
            return value.copy(bl, callArray);
        }

        @NotNull
        public String toString() {
            return "Value(pure=" + this.pure + ", calls=" + Arrays.toString(this.calls) + ")";
        }
    }
}

