/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J.\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\t2\u0006\u0010\u000f\u001a\u0002H\rH\u0086\u0002\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u0004\u0018\u00010\n2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u001c\u0010\u0013\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/script/generator/DelegateScriptingOptions;", "Lcom/intellij/database/script/generator/ScriptingOptions;", "delegate", "<init>", "(Lcom/intellij/database/script/generator/ScriptingOptions;)V", "getDelegate", "()Lcom/intellij/database/script/generator/ScriptingOptions;", "options", "", "Lcom/intellij/database/script/generator/ScriptingOption;", "", "set", "", "T", "o", "v", "(Lcom/intellij/database/script/generator/ScriptingOption;Ljava/lang/Object;)V", "getStoredValue", "option", "export", "map", "", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nScriptingOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingOptions.kt\ncom/intellij/database/script/generator/DelegateScriptingOptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class DelegateScriptingOptions
implements ScriptingOptions {
    @NotNull
    private final ScriptingOptions delegate;
    @NotNull
    private final Map<ScriptingOption<?>, Object> options;

    public DelegateScriptingOptions(@NotNull ScriptingOptions delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.options = new HashMap();
    }

    @NotNull
    public final ScriptingOptions getDelegate() {
        return this.delegate;
    }

    public final <T> void set(@NotNull ScriptingOption<T> o, @NotNull T v) {
        Intrinsics.checkNotNullParameter(o, (String)"o");
        Intrinsics.checkNotNullParameter(v, (String)"v");
        this.options.put(o, v);
    }

    @Override
    @Nullable
    public Object getStoredValue(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Object object = this.options.get(option);
        if (object == null) {
            object = this.delegate.getStoredValue(option);
        }
        return object;
    }

    @Override
    public void export(@NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.delegate.export(map2);
        for (Map.Entry<ScriptingOption<?>, Object> entry : this.options.entrySet()) {
            String it;
            ScriptingOption<?> k = entry.getKey();
            Object v = entry.getValue();
            if (Intrinsics.areEqual(k.getDefaultValue(), (Object)v)) {
                map2.remove(k.getCode());
                continue;
            }
            if (ScriptingOptionStatic.exportScriptingOptionValue(v) == null) continue;
            boolean bl = false;
            map2.put(k.getCode(), it);
        }
    }
}

