/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantee;
import com.intellij.database.model.basic.BasicGrantsHolder;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a&\u0010\b\u001a\u00020\u00022\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a*\u0010\b\u001a\u00020\u00022\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001aP\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\r\u001a\u00020\u000e\u001a*\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002\u001aJ\u0010\u0011\u001a\u00020\u00122\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\fH\u0002\u001aB\u0010\u001a\u001a\u00020\u00122\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a \u0010\u001e\u001a\u00020\u00022\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u001f\u001a\u00020\fH\u0000\u00a8\u0006 "}, d2={"parse", "", "", "text", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "qualified", "grantCtl", "Lcom/intellij/database/model/properties/Grants$Controller;", "e", "Lcom/intellij/database/model/basic/BasicElement;", "u", "Lcom/intellij/database/model/basic/BasicGrantee;", "r", "Lcom/intellij/database/model/ObjectKind;", "isInHolder", "", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "holder", "Lcom/intellij/database/model/basic/BasicGrantsHolder;", "getHolderMeta", "qName", "parent", "match", "g", "i", "", "namePart", "cur", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbUserGrantsModelApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbUserGrantsModelApplier.kt\ncom/intellij/database/schemaEditor/model/applier/DbUserGrantsModelApplierKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public final class DbUserGrantsModelApplierKt {
    private static final List<String> parse(String text2, Dbms dbms, Project project) {
        if (((CharSequence)text2).length() == 0 || Intrinsics.areEqual((Object)"server", (Object)text2)) {
            return CollectionsKt.emptyList();
        }
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(dbms);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        SqlLanguageDialect dialect = sqlLanguageDialect;
        SqlCodeFragment sqlCodeFragment = SqlPsiFacade.getInstance(project).createExpressionFragment(dialect, null, null, text2, false, true);
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeFragment, (String)"createExpressionFragment(...)");
        SqlCodeFragment frag = sqlCodeFragment;
        SqlReferenceExpression ref2 = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)frag), SqlReferenceExpression.class);
        if (ref2 == null) {
            char[] cArray = new char[]{'.'};
            return CollectionsKt.reversed((Iterable)StringsKt.split$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        }
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)ref2, DbUserGrantsModelApplierKt::parse$lambda$0), DbUserGrantsModelApplierKt::parse$lambda$1));
    }

    @NotNull
    public static final String qualified(@NotNull Grants.Controller<?, ?> grantCtl, @NotNull BasicElement e, @NotNull BasicGrantee u) {
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        BasicElement basicElement = u.getParent();
        return DbUserGrantsModelApplierKt.qualified(grantCtl, e, basicElement != null ? basicElement.getKind() : null);
    }

    private static final String qualified(Grants.Controller<?, ?> grantCtl, BasicElement e, ObjectKind r) {
        StringBuilder res2 = new StringBuilder();
        BasicElement cur = e;
        while (true) {
            BasicElement basicElement = cur;
            if (Intrinsics.areEqual((Object)(basicElement != null ? basicElement.getKind() : null), (Object)r) || cur == null || cur.getParent() == null) break;
            if (((CharSequence)res2).length() > 0) {
                res2.insert(0, '.');
            }
            res2.insert(0, DbUserGrantsModelApplierKt.namePart(grantCtl, cur));
            cur = cur.getParent();
        }
        if (((CharSequence)res2).length() == 0 && cur != null) {
            return DbUserGrantsModelApplierKt.namePart(grantCtl, cur);
        }
        String string = res2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final boolean isInHolder(@NotNull Project project, @NotNull Dbms dbms, @NotNull Grants.Controller<?, ?> grantCtl, @NotNull String text2, @Nullable BasicMetaObject<?> meta, @NotNull BasicGrantsHolder<?> holder, @NotNull BasicGrantee u) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        return DbUserGrantsModelApplierKt.isInHolder(grantCtl, DbUserGrantsModelApplierKt.parse(text2, dbms, project), meta, holder, u.getParent());
    }

    private static final BasicMetaObject<?> getHolderMeta(Grants.Controller<?, ?> grantCtl, BasicMetaObject<?> meta) {
        for (BasicMetaObject<?> tmp = meta; tmp != null; tmp = tmp.getParent()) {
            BasicMetaObject<BasicGrantsHolder> basicMetaObject;
            BasicMetaObject<BasicGrantsHolder> basicMetaObject2;
            BasicMetaObject<BasicGrantsHolder> basicMetaObject3 = tmp.tryCast(BasicGrantsHolder.class);
            if (basicMetaObject3 == null) continue;
            BasicMetaObject<BasicGrantsHolder> it = basicMetaObject2 = basicMetaObject3;
            boolean bl = false;
            BasicMetaObject<BasicGrantsHolder> basicMetaObject4 = basicMetaObject = !Intrinsics.areEqual(it, meta) || grantCtl.holdsItsGrants(it) ? basicMetaObject2 : null;
            if (basicMetaObject == null) continue;
            it = basicMetaObject;
            boolean bl2 = false;
            return it;
        }
        return null;
    }

    private static final boolean isInHolder(Grants.Controller<?, ?> grantCtl, List<String> qName, BasicMetaObject<?> meta, BasicGrantsHolder<?> holder, BasicElement parent) {
        BasicMetaObject<?> basicMetaObject = meta;
        if (basicMetaObject != null) {
            BasicMetaObject<?> it = basicMetaObject;
            boolean bl = false;
            BasicMetaObject<?> basicMetaObject2 = DbUserGrantsModelApplierKt.getHolderMeta(grantCtl, meta);
            basicMetaObject = basicMetaObject2;
            if (basicMetaObject2 != null) {
                BasicMetaObject<?> hm = basicMetaObject;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(holder.getMetaObject(), hm)) {
                    return false;
                }
            }
        }
        if (DasUtil.isAncestor(holder, parent, false) && Intrinsics.areEqual(holder, (Object)parent) && !grantCtl.holdsItsGrants(holder)) {
            return false;
        }
        if (qName.isEmpty()) {
            return Intrinsics.areEqual((Object)holder.getKind(), (Object)ObjectKind.ROOT);
        }
        BasicElement tmp = holder;
        int i2 = 0;
        while (!Intrinsics.areEqual((Object)tmp, (Object)parent)) {
            BasicElement basicElement = tmp;
            if ((basicElement != null ? basicElement.getParent() : null) == null) break;
            ++i2;
            tmp = tmp.getParent();
        }
        if (qName.size() < i2) {
            return false;
        }
        if (qName.size() == i2 && !grantCtl.holdsItsGrants(holder)) {
            return false;
        }
        int s = qName.size();
        BasicElement basicElement = parent;
        return DbUserGrantsModelApplierKt.match(grantCtl, holder, basicElement != null ? basicElement.getKind() : null, qName.subList(s - i2, s), 0);
    }

    public static final boolean match(@NotNull Grants.Controller<?, ?> grantCtl, @Nullable BasicElement g, @Nullable ObjectKind r, @NotNull List<String> qName, int i2) {
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        Intrinsics.checkNotNullParameter(qName, (String)"qName");
        BasicElement basicElement = g;
        ObjectKind objectKind = basicElement != null ? basicElement.getKind() : null;
        ObjectKind objectKind2 = r;
        if (objectKind2 == null) {
            objectKind2 = ObjectKind.ROOT;
        }
        boolean stop = Intrinsics.areEqual((Object)objectKind, (Object)objectKind2);
        if (g == null || stop) {
            return qName.size() <= i2;
        }
        return StringsKt.equals((String)DbUserGrantsModelApplierKt.namePart(grantCtl, g), (String)((String)CollectionsKt.getOrNull(qName, (int)i2)), (boolean)true) && (stop || DbUserGrantsModelApplierKt.match(grantCtl, g.getParent(), r, qName, i2 + 1));
    }

    @NotNull
    public static final String namePart(@NotNull Grants.Controller<?, ?> grantCtl, @NotNull BasicElement cur) {
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        Intrinsics.checkNotNullParameter((Object)cur, (String)"cur");
        return grantCtl.targetText(cur, null);
    }

    private static final SqlReferenceExpression parse$lambda$0(SqlReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SqlExpression sqlExpression = it.getQualifierExpression();
        return sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
    }

    private static final String parse$lambda$1(SqlReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }
}

