/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.csv.ui.FormatsListAndPreviewPanel;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DbGridDataHookUpUtil;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DbGridEditGuard implements GridEditGuard
{
    READ_ONLY_PREVIEW{

        public boolean rejectEdit(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                1.$$$reportNull$$$0(0);
            }
            DatabaseGridDataHookUp up = DataGridUtil.getDatabaseHookUp(grid);
            return up instanceof DbGridDataHookUpUtil.ReadOnlyDatabaseGridDataHookUp;
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                1.$$$reportNull$$$0(1);
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                1.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NlsContexts.HintText
        @NotNull
        String getReasonInner(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                1.$$$reportNull$$$0(3);
            }
            String string = DbGridEditGuard.defaultMessage();
            if (string == null) {
                1.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DbGridEditGuard$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DbGridEditGuard$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonText";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
    ,
    READ_ONLY_DATABASE_TABLE{

        public boolean rejectEdit(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            DatabaseGridDataHookUp up;
            if (grid == null) {
                2.$$$reportNull$$$0(0);
            }
            return (up = DataGridUtil.getDatabaseHookUp(grid)) != null && up.getDatabaseTable() != null && !up.isEditableTable();
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                2.$$$reportNull$$$0(1);
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                2.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NlsContexts.HintText
        @NotNull
        String getReasonInner(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                2.$$$reportNull$$$0(3);
            }
            DasObject table = DataGridUtilCore.getDatabaseTable(grid);
            String string = DatabaseBundle.message("hint.text.can.t.edit", DbPresentationCore.getPresentableName(table.getKind(), DbImplUtilCore.getDbms(table)), DbPresentationCore.getPresentableName(table, true));
            if (string == null) {
                2.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DbGridEditGuard$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DbGridEditGuard$2";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonText";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
    ,
    READ_ONLY_CONNECTION{

        public boolean rejectEdit(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            DbDataSource system;
            if (grid == null) {
                3.$$$reportNull$$$0(0);
            }
            return (system = DataGridUtilCore.getDatabaseSystem(grid)) != null && !system.isWritable();
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                3.$$$reportNull$$$0(1);
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                3.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NlsContexts.HintText
        @NotNull
        String getReasonInner(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                3.$$$reportNull$$$0(3);
            }
            String string = DatabaseBundle.message("hint.text.connection.read.only", new Object[0]);
            if (string == null) {
                3.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DbGridEditGuard$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DbGridEditGuard$3";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonText";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
    ,
    MISSING_IDENTIFIER{

        public boolean rejectEdit(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                4.$$$reportNull$$$0(0);
            }
            return grid.getDataModel(DataAccessType.DATABASE_DATA).getColumnCount() > 0 && !DataGridUtil.canBuildWhereClause(grid);
        }

        @Override
        @NlsContexts.HintText
        @NotNull
        String getReasonInner(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                4.$$$reportNull$$$0(1);
            }
            String string = DatabaseBundle.message("hint.text.missing.row.identifier", new Object[0]);
            if (string == null) {
                4.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DbGridEditGuard$4";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DbGridEditGuard$4";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
    ,
    META_DATA_ERROR{

        public boolean rejectEdit(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                5.$$$reportNull$$$0(0);
            }
            return DataGridUtil.getDatabaseHookUp(grid) != null && DataGridUtil.getDatabaseHookUp(grid).getGridTablesModel() != null && Objects.requireNonNull(DataGridUtil.getDatabaseHookUp(grid).getGridTablesModel()).isNotEditable();
        }

        @Override
        @NlsContexts.HintText
        @NotNull
        String getReasonInner(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                5.$$$reportNull$$$0(1);
            }
            String string = Objects.requireNonNull(DataGridUtil.getDatabaseHookUp(grid).getGridTablesModel()).getIsNotEditableReason();
            if (string == null) {
                5.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NlsContexts.HintText
        @NotNull
        public String getReasonText(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                5.$$$reportNull$$$0(3);
            }
            String string = DatabaseBundle.message("hint.text.div.style.text.align.center.result.set.read.only.br.div", this.getReasonInner(grid));
            if (string == null) {
                5.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DbGridEditGuard$5";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DbGridEditGuard$5";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
    ,
    UNRESOLVED_TABLE{

        public boolean rejectEdit(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                6.$$$reportNull$$$0(0);
            }
            return DataGridUtil.getDatabaseHookUp(grid) != null && DataGridUtil.getDatabaseHookUp(grid).getGridTablesModel() != null && Objects.requireNonNull(DataGridUtil.getDatabaseHookUp(grid).getGridTablesModel()).isTablesEmpty();
        }

        @Override
        @NlsContexts.HintText
        @NotNull
        String getReasonInner(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                6.$$$reportNull$$$0(1);
            }
            String string = DatabaseBundle.message("hint.text.unresolved.table.reference", new Object[0]);
            if (string == null) {
                6.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DbGridEditGuard$6";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DbGridEditGuard$6";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
    ,
    MODAL_IMPORT{

        public boolean rejectEdit(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                7.$$$reportNull$$$0(0);
            }
            return DataImporter.isBusy(DataGridUtilCore.getDatabaseTable(grid));
        }

        @Override
        @NlsContexts.HintText
        @NotNull
        String getReasonInner(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                7.$$$reportNull$$$0(1);
            }
            String string = DatabaseBundle.message("hint.text.it.using.in.data.import", new Object[0]);
            if (string == null) {
                7.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DbGridEditGuard$7";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DbGridEditGuard$7";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
    ,
    SEARCH_PATH_MISMATCH{

        public boolean rejectEdit(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                8.$$$reportNull$$$0(0);
            }
            return !grid.isReady();
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                8.$$$reportNull$$$0(1);
            }
            String string = DatabaseBundle.message("hint.text.search.path.mismatch", new Object[0]);
            if (string == null) {
                8.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DbGridEditGuard$8";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DbGridEditGuard$8";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
    ,
    CSV_PREVIEW{

        public boolean rejectEdit(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                9.$$$reportNull$$$0(0);
            }
            return UIUtil.getParentOfType(FormatsListAndPreviewPanel.class, (Component)((DataGrid)grid).getPanel().getComponent()) != null;
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                9.$$$reportNull$$$0(1);
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                9.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NlsContexts.HintText
        @NotNull
        String getReasonInner(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                9.$$$reportNull$$$0(3);
            }
            String string = DatabaseBundle.message("hint.text.csv.preview", DatabaseBundle.message("dialog.ok.action.format", new Object[0]));
            if (string == null) {
                9.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DbGridEditGuard$9";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DbGridEditGuard$9";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonText";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
    ,
    READ_ONLY_FILE{

        public boolean rejectEdit(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            DocumentDataHookUp up;
            if (grid == null) {
                10.$$$reportNull$$$0(0);
            }
            return (up = GridUtil.getDocumentDataHookUp(grid)) != null && up.isReadOnly();
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                10.$$$reportNull$$$0(1);
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                10.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NlsContexts.HintText
        @NotNull
        String getReasonInner(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                10.$$$reportNull$$$0(3);
            }
            String string = DbGridEditGuard.defaultMessage();
            if (string == null) {
                10.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/DbGridEditGuard$10";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/DbGridEditGuard$10";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonText";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    };


    @NlsContexts.HintText
    @NotNull
    public String getReasonText(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            DbGridEditGuard.$$$reportNull$$$0(0);
        }
        String string = DatabaseBundle.message("hint.text.div.style.text.align.center.table.read.only.br.div", this.getReasonInner(grid));
        if (string == null) {
            DbGridEditGuard.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    abstract String getReasonInner(@NotNull CoreGrid<GridRow, GridColumn> var1);

    @NlsContexts.HintText
    @NotNull
    private static String defaultMessage() {
        String string = EditorBundle.message((String)"editing.viewer.hint", (Object[])new Object[0]);
        if (string == null) {
            DbGridEditGuard.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/DbGridEditGuard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/DbGridEditGuard";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReasonText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReasonText";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

