/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.audit;

import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/run/audit/TxMarkerAuditor;", "Lcom/intellij/database/datagrid/DataAuditor;", "markerHolder", "Lcom/intellij/database/run/audit/TxMarkerAuditor$TxMarkerHolder;", "<init>", "(Lcom/intellij/database/run/audit/TxMarkerAuditor$TxMarkerHolder;)V", "requestStarted", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "txCompleted", "event", "Lcom/intellij/database/datagrid/DataAuditor$TxEvent;", "TxMarkerHolder", "intellij.database.connectivity"})
public final class TxMarkerAuditor
implements DataAuditor {
    @NotNull
    private final TxMarkerHolder markerHolder;

    public TxMarkerAuditor(@NotNull TxMarkerHolder markerHolder) {
        Intrinsics.checkNotNullParameter((Object)markerHolder, (String)"markerHolder");
        this.markerHolder = markerHolder;
    }

    @Override
    public void requestStarted(@NotNull DataRequest.Context context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        if (!(context.request instanceof DataRequest.TxRequest)) {
            DataRequest.TxMarker txMarker = context.txMarker;
            Intrinsics.checkNotNullExpressionValue((Object)txMarker, (String)"txMarker");
            this.markerHolder.setCurrentTx(txMarker);
        }
    }

    @Override
    public void txCompleted(@NotNull DataRequest.Context context, @NotNull DataAuditor.TxEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        DataRequest.TxMarker txMarker = event.completed || event.reverted ? DataRequest.START_NEW : DataRequest.IN_PROGRESS;
        Intrinsics.checkNotNull((Object)txMarker);
        this.markerHolder.setCurrentTx(txMarker);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/run/audit/TxMarkerAuditor$TxMarkerHolder;", "", "setCurrentTx", "", "marker", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "intellij.database.connectivity"})
    public static interface TxMarkerHolder {
        public void setCurrentTx(@NotNull DataRequest.TxMarker var1);
    }
}

