/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseObjectNormalizer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridModelWithInjections;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteBlob;
import com.intellij.database.run.ResultReference;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.actions.GridCellValueLoader;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J8\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00172\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00180\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J4\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/database/run/actions/LoadFullCellAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/database/run/actions/GridAction;", "<init>", "()V", "TOO_HEAVY_CLOB_THRESHOLD", "", "DONT_SHOW_DIALOG", "Lcom/intellij/openapi/util/Key;", "", "myGridCellLoader", "Lcom/intellij/database/run/actions/GridCellValueLoader;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "hasTooHeavyColumn", "dataGrid", "Lcom/intellij/database/datagrid/DataGrid;", "columns", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridColumn;", "rows", "Lcom/intellij/database/datagrid/GridRow;", "confirmed", "project", "Lcom/intellij/openapi/project/Project;", "populateLoadedData", "row", "rowIndex", "colIndex", "getLoadedObject", "", "normalizedObject", "normalizer", "Lcom/intellij/database/datagrid/DatabaseObjectNormalizer;", "column", "intellij.database.impl"})
public final class LoadFullCellAction
extends DumbAwareAction
implements GridAction {
    private final long TOO_HEAVY_CLOB_THRESHOLD;
    @NotNull
    private final Key<Boolean> DONT_SHOW_DIALOG;
    @NotNull
    private final GridCellValueLoader myGridCellLoader;

    public LoadFullCellAction() {
        this.TOO_HEAVY_CLOB_THRESHOLD = 0x1400000L;
        Key key2 = Key.create((String)"SHOW_TOO_HEAVY_CLOB_DIALOG");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        this.DONT_SHOW_DIALOG = key2;
        String string = DataGridBundle.message((String)"action.Console.TableResult.LoadFullCellAction.ErrorCellLoading.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myGridCellLoader = new GridCellValueLoader(string);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        List<GridColumn> list;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = GridUtil.getDataGrid((DataContext)e.getDataContext());
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (dataGrid == null) {
            presentation2.setEnabled(false);
            presentation2.setVisible(e.isFromActionToolbar());
            return;
        }
        GridModel gridModel = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel model = gridModel;
        ModelIndex modelIndex = dataGrid.getSelectionModel().getSelectedColumn();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"getSelectedColumn(...)");
        ModelIndex colIndex = modelIndex;
        GridColumn col = (GridColumn)model.getColumn(colIndex);
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isMongo()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        DasTable table = DataGridUtil.getDatabaseTable(dataGrid);
        if (col == null) {
            list = CollectionsKt.emptyList();
        } else {
            DasObject dasObject = table;
            List list2 = model.getColumns();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getColumns(...)");
            list = this.myGridCellLoader.getWhereClauseColumns(col, dbms2, dasObject, list2);
        }
        List<GridColumn> whereClauseColumns = list;
        Object cellObject = model.getValueAt(dataGrid.getSelectionModel().getSelectedRow(), colIndex);
        boolean isCellWithLob = cellObject instanceof LobInfo;
        LobInfo lobInfo = cellObject instanceof LobInfo ? (LobInfo)cellObject : null;
        boolean isCellTruncated = lobInfo != null ? lobInfo.isTruncated() : false;
        boolean enabled = dataGrid.isReady() && !whereClauseColumns.isEmpty() && isCellTruncated;
        boolean isFromEditorToolbar = e.isFromActionToolbar() && !Intrinsics.areEqual((Object)e.getPlace(), (Object)"TableFloatingToolbar");
        boolean visible = isCellWithLob && (isFromEditorToolbar || e.isFromSearchPopup() || enabled);
        presentation2.setEnabled(enabled);
        presentation2.setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = GridUtil.getDataGrid((DataContext)e.getDataContext());
        if (dataGrid == null) {
            return;
        }
        DataGrid dataGrid2 = dataGrid;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        JBIterable jBIterable = dataGrid2.getSelectionModel().getSelectedColumns().asIterable();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"asIterable(...)");
        JBIterable selectedColumns = jBIterable;
        JBIterable jBIterable2 = dataGrid2.getSelectionModel().getSelectedRows().asIterable();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"asIterable(...)");
        JBIterable selectedRows = jBIterable2;
        if (this.hasTooHeavyColumn(dataGrid2, (JBIterable<ModelIndex<GridColumn>>)selectedColumns, (JBIterable<ModelIndex<GridRow>>)selectedRows) && !this.confirmed(dataGrid2, project2)) {
            return;
        }
        for (ModelIndex selectedColumnIdx : selectedColumns) {
            for (ModelIndex selectedRowIdx : selectedRows) {
                Intrinsics.checkNotNull((Object)selectedRowIdx);
                Intrinsics.checkNotNull((Object)selectedColumnIdx);
                this.myGridCellLoader.loadCellValue(dataGrid2, project2, (ModelIndex<GridRow>)selectedRowIdx, (ModelIndex<GridColumn>)selectedColumnIdx, (Function2<? super GridRow, ? super GridColumn, Unit>)((Function2)(arg_0, arg_1) -> LoadFullCellAction.actionPerformed$lambda$0(this, selectedRowIdx, selectedColumnIdx, dataGrid2, arg_0, arg_1)));
            }
        }
    }

    private final boolean hasTooHeavyColumn(DataGrid dataGrid, JBIterable<ModelIndex<GridColumn>> columns, JBIterable<ModelIndex<GridRow>> rows) {
        for (ModelIndex column2 : columns) {
            for (ModelIndex row : rows) {
                GridRow it;
                if ((GridRow)dataGrid.getDataModel(DataAccessType.DATABASE_DATA).getRow(row) == null) continue;
                boolean bl = false;
                Object cellObject = it.getValue(column2.value);
                if (!(cellObject instanceof LobInfo) || ((LobInfo)cellObject).length <= this.TOO_HEAVY_CLOB_THRESHOLD) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean confirmed(DataGrid dataGrid, Project project) {
        boolean doNotShowDialog = Intrinsics.areEqual((Object)dataGrid.getUserData(this.DONT_SHOW_DIALOG), (Object)true);
        if (doNotShowDialog) {
            return true;
        }
        String string = DataGridBundle.message((String)"action.Console.TableResult.LoadFullCellAction.Confirmation.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        String string2 = DataGridBundle.message((String)"action.Console.TableResult.LoadFullCellAction.Confirmation.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String text2 = string2;
        boolean confirmed2 = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(title, text2).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(dataGrid, this){
            final /* synthetic */ DataGrid $dataGrid;
            final /* synthetic */ LoadFullCellAction this$0;
            {
                this.$dataGrid = $dataGrid;
                this.this$0 = $receiver;
            }

            public void rememberChoice(boolean selected, int exitCode) {
                this.$dataGrid.putUserData(LoadFullCellAction.access$getDONT_SHOW_DIALOG$p(this.this$0), (Object)(selected && exitCode == 0 ? 1 : 0));
            }
        })).icon(Messages.getWarningIcon())).ask(project);
        return confirmed2;
    }

    private final void populateLoadedData(GridRow row, ModelIndex<GridRow> rowIndex, ModelIndex<GridColumn> colIndex, DataGrid dataGrid) {
        DatabaseObjectNormalizer normalizer = new DatabaseObjectNormalizer(DataGridUtil.getDbms(dataGrid));
        GridColumn gridColumn = (GridColumn)dataGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(colIndex);
        if (gridColumn == null) {
            return;
        }
        GridColumn column2 = gridColumn;
        Object object = normalizer.objectToObject(row.getValue(colIndex.value), column2);
        if (object == null) {
            return;
        }
        Object normalizedObject = object;
        Object loadedObject = this.getLoadedObject(normalizedObject, normalizer, column2);
        GridModel gridModel = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel model = gridModel;
        if (!(model instanceof GridModelWithInjections)) {
            return;
        }
        ((GridModelWithInjections)model).injectValue(rowIndex, colIndex, loadedObject);
        dataGrid.fireContentChanged(null);
    }

    private final Object getLoadedObject(Object normalizedObject, DatabaseObjectNormalizer normalizer, GridColumn column2) {
        if (normalizedObject instanceof String) {
            LobInfo.ClobInfo clobInfo;
            LobInfo.ClobInfo $this$getLoadedObject_u24lambda_u242 = clobInfo = new LobInfo.ClobInfo((long)((String)normalizedObject).length(), (String)normalizedObject);
            boolean bl = false;
            $this$getLoadedObject_u24lambda_u242.setFullyReloaded(true);
            return clobInfo;
        }
        if (normalizedObject instanceof LobInfo.ClobInfo) {
            ((LobInfo.ClobInfo)normalizedObject).setFullyReloaded(true);
            return normalizedObject;
        }
        if (normalizedObject instanceof LobInfo) {
            ((LobInfo)normalizedObject).setFullyReloaded(true);
            return normalizedObject;
        }
        if (normalizedObject instanceof byte[]) {
            LobInfo.BlobInfo blobInfo;
            LobInfo.BlobInfo $this$getLoadedObject_u24lambda_u243 = blobInfo = new LobInfo.BlobInfo((long)((byte[])normalizedObject).length, (byte[])normalizedObject);
            boolean bl = false;
            $this$getLoadedObject_u24lambda_u243.setFullyReloaded(true);
            return blobInfo;
        }
        if (normalizedObject instanceof ResultReference) {
            Object object = ((ResultReference)normalizedObject).getReference();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReference(...)");
            Object ref2 = object;
            if (ref2 instanceof RemoteBlob) {
                long length = ((RemoteBlob)ref2).length();
                byte[] bytes2 = ((RemoteBlob)ref2).getBytes(1L, (int)length);
                Object object2 = normalizer.objectToObject(bytes2, column2);
                Intrinsics.checkNotNull((Object)object2);
                return this.getLoadedObject(object2, normalizer, column2);
            }
        }
        return normalizedObject;
    }

    private static final Unit actionPerformed$lambda$0(LoadFullCellAction this$0, ModelIndex $selectedRowIdx, ModelIndex $selectedColumnIdx, DataGrid $dataGrid, GridRow row, GridColumn column2) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNull((Object)$selectedRowIdx);
        Intrinsics.checkNotNull((Object)$selectedColumnIdx);
        this$0.populateLoadedData(row, (ModelIndex<GridRow>)$selectedRowIdx, (ModelIndex<GridColumn>)$selectedColumnIdx, $dataGrid);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Key access$getDONT_SHOW_DIALOG$p(LoadFullCellAction $this) {
        return $this.DONT_SHOW_DIALOG;
    }
}

