/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectName
implements Comparable<ObjectName> {
    public static final ObjectName[] EMPTY_ARRAY = new ObjectName[0];
    public static final ObjectName NULL = null;
    public final String name;
    public final boolean quoted;
    private Integer myInsensitiveHash;

    public static ObjectName quoted(@Nullable String name2) {
        return ObjectName.create(name2, true);
    }

    public static ObjectName plain(@Nullable String name2) {
        return ObjectName.create(name2, false);
    }

    public static ObjectName create(@Nullable String name2, boolean quoted) {
        return name2 == null ? null : new ObjectName(name2, quoted);
    }

    public ObjectName(@NotNull String name2, boolean quoted) {
        if (name2 == null) {
            ObjectName.$$$reportNull$$$0(0);
        }
        this.myInsensitiveHash = null;
        this.name = name2;
        this.quoted = quoted;
    }

    public static boolean equals(@Nullable ObjectName a, @Nullable ObjectName b, @NotNull Casing casing) {
        if (casing == null) {
            ObjectName.$$$reportNull$$$0(1);
        }
        return a == null || b == null ? a == b : a.equals(b, casing);
    }

    public boolean equals(@NotNull ObjectName other, @NotNull Casing casing) {
        if (other == null) {
            ObjectName.$$$reportNull$$$0(2);
        }
        if (casing == null) {
            ObjectName.$$$reportNull$$$0(3);
        }
        if (this == other) {
            return true;
        }
        if (this.hashCode(casing) != other.hashCode(casing)) {
            return false;
        }
        Case case1 = this.getCase(casing);
        Case case2 = other.getCase(casing);
        return ObjectName.namesEqual(this.name, case1, other.name, case2);
    }

    public static boolean namesEqual(@NotNull String name1, @NotNull Case case1, @NotNull String name2, @NotNull Case case2) {
        if (name1 == null) {
            ObjectName.$$$reportNull$$$0(4);
        }
        if (case1 == null) {
            ObjectName.$$$reportNull$$$0(5);
        }
        if (name2 == null) {
            ObjectName.$$$reportNull$$$0(6);
        }
        if (case2 == null) {
            ObjectName.$$$reportNull$$$0(7);
        }
        if (case1 == Case.MIXED || case2 == Case.MIXED) {
            return StringUtil.equalsIgnoreCase((CharSequence)name1, (CharSequence)name2);
        }
        return case1.apply(name1).equals(case2.apply(name2));
    }

    @NotNull
    private Case getCase(@NotNull Casing casing) {
        if (casing == null) {
            ObjectName.$$$reportNull$$$0(8);
        }
        Case case_ = casing.choose(!this.quoted);
        if (case_ == null) {
            ObjectName.$$$reportNull$$$0(9);
        }
        return case_;
    }

    public int hashCode(@NotNull Casing casing) {
        if (casing == null) {
            ObjectName.$$$reportNull$$$0(10);
        }
        if (casing.plain == Case.EXACT && casing.quoted == Case.EXACT) {
            return this.name.hashCode();
        }
        if (this.myInsensitiveHash == null) {
            this.myInsensitiveHash = StringUtil.stringHashCodeInsensitive((CharSequence)this.name);
        }
        return this.myInsensitiveHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectName name1 = (ObjectName)o;
        if (this.quoted != name1.quoted) {
            return false;
        }
        return this.name.equals(name1.name);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + (this.quoted ? 1 : 0);
        return result2;
    }

    public String toString() {
        return this.quoted ? "`" + this.name.replace("`", "``") + "`" : this.name;
    }

    public static ObjectName[] toArray(@Nullable Iterable<ObjectName> items) {
        if (items == null) {
            return null;
        }
        Collection collection = items instanceof Collection ? (Collection)items : ContainerUtil.collect(items.iterator());
        return collection.isEmpty() ? EMPTY_ARRAY : collection.toArray(new ObjectName[0]);
    }

    @Override
    public int compareTo(@NotNull ObjectName o) {
        int res2;
        if (o == null) {
            ObjectName.$$$reportNull$$$0(11);
        }
        return (res2 = Comparing.compare((Comparable)((Object)this.name), (Comparable)((Object)o.name))) != 0 ? res2 : Boolean.compare(this.quoted, o.quoted);
    }

    public static String name(@Nullable ObjectName name2) {
        return name2 == null ? null : name2.name;
    }

    public static Set<ObjectName> createCasingAwareSet(@NotNull ObjectKind kind, @NotNull CasingProvider casingProvider) {
        if (kind == null) {
            ObjectName.$$$reportNull$$$0(12);
        }
        if (casingProvider == null) {
            ObjectName.$$$reportNull$$$0(13);
        }
        final Casing casing = casingProvider.getCasing(kind, null);
        return CollectionFactory.createCustomHashingStrategySet((HashingStrategy)new HashingStrategy<ObjectName>(){

            public int hashCode(ObjectName object) {
                return StringUtil.toLowerCase((String)object.name).hashCode();
            }

            public boolean equals(ObjectName o1, ObjectName o2) {
                return ObjectName.equals(o1, o2, casing);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "case1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "case2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ObjectName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ObjectName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "namesEqual";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCase";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hashCode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCasingAwareSet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

