/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.sql.SqlBundle;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.nio.file.Files;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelExternalDataUtils {
    private static final Logger LOG = Logger.getInstance(ModelExternalDataUtils.class);

    @Nullable
    public static String getOrChooseExternalDataPath(@NotNull Project project, @NotNull LocalDataSource ds) {
        String path;
        if (project == null) {
            ModelExternalDataUtils.$$$reportNull$$$0(0);
        }
        if (ds == null) {
            ModelExternalDataUtils.$$$reportNull$$$0(1);
        }
        if ((path = ModelExternalData.getExternalDataPath(ds)) != null) {
            return path;
        }
        String simplified = DbImplUtil.simplify(ds.getName());
        VirtualFileWrapper res2 = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(SqlBundle.message("dialog.title.save.external.data.for", ds.getName()), "", "xml"), project).save(ProjectUtil.guessProjectDir((Project)project), "external-data-" + simplified + ".xml");
        if (res2 == null) {
            return null;
        }
        if (res2.exists()) {
            try {
                Files.delete(res2.getFile().toPath());
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        try {
            path = res2.getFile().getCanonicalPath();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            path = res2.getFile().getPath();
        }
        ModelExternalData.setExternalDataPath(ds, path);
        DataSourceStorage.getProjectStorage(project).updateDataSource(ds);
        return path;
    }

    public static void modifyExternalData(@NotNull Project project, @NotNull LocalDataSource ds, @NotNull Consumer<? super ModelExternalData.Data> modifier) {
        String path;
        if (project == null) {
            ModelExternalDataUtils.$$$reportNull$$$0(2);
        }
        if (ds == null) {
            ModelExternalDataUtils.$$$reportNull$$$0(3);
        }
        if (modifier == null) {
            ModelExternalDataUtils.$$$reportNull$$$0(4);
        }
        if ((path = ModelExternalDataUtils.getOrChooseExternalDataPath(project, ds)) != null) {
            ModelExternalData.modify(path, modifier);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/model/ModelExternalDataUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrChooseExternalDataPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyExternalData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

