/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.ElementCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.basic.BasicElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004BJ\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012-\u0010\u0007\u001a)\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ1\u0010\u0014\u001a\u00020\r2#\u0010\u0015\u001a\u001f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u0012\u0004\u0012\u00020\r0\u0016\u00a2\u0006\u0002\b\u0017H\u0086\b\u00f8\u0001\u0000J\u0015\u0010\u0018\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\rJ\u0017\u0010\u001c\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u001dR5\u0010\u0007\u001a)\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/model/ElementDataCollector;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "D", "", "searcher", "Lcom/intellij/database/model/ElementSearcher;", "consumer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "e", "", "", "<init>", "(Lcom/intellij/database/model/ElementSearcher;Lkotlin/jvm/functions/Function2;)V", "cache", "Lcom/intellij/database/model/ElementCache;", "collected", "", "collectAll", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "collect", "data", "(Ljava/lang/Object;)Lcom/intellij/database/model/basic/BasicElement;", "finish", "onChanged", "(Lcom/intellij/database/model/basic/BasicElement;)V", "intellij.database.core.impl"})
public final class ElementDataCollector<T extends BasicElement, D> {
    @NotNull
    private final Function2<T, List<? extends D>, Unit> consumer;
    @NotNull
    private final ElementCache<T, D> cache;
    @NotNull
    private List<D> collected;

    public ElementDataCollector(@NotNull ElementSearcher<T, D> searcher2, @NotNull Function2<? super T, ? super List<? extends D>, Unit> consumer) {
        Intrinsics.checkNotNullParameter(searcher2, (String)"searcher");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.consumer = consumer;
        this.cache = searcher2.cache();
        this.collected = new ArrayList();
    }

    public final void collectAll(@NotNull Function1<? super ElementDataCollector<T, D>, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$collectAll = false;
        block.invoke((Object)this);
        this.finish();
    }

    @Nullable
    public final T collect(D data) {
        T cur;
        T prev2 = this.cache.getCurrent();
        if (!Intrinsics.areEqual(prev2, cur = this.cache.find(data)) || cur == null) {
            this.onChanged(prev2);
        }
        ((Collection)this.collected).add(data);
        return cur;
    }

    public final void finish() {
        this.onChanged(this.cache.getCurrent());
    }

    private final void onChanged(T e) {
        if (e != null) {
            this.consumer.invoke(e, this.collected);
        }
        this.collected.clear();
    }
}

