/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataStub;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelEntityStorage;
import com.intellij.database.model.ModelIdIndex;
import com.intellij.database.model.ModelMemoryManager;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ModelReader;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicIntrospectableArea;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.psi.ModelNameIndexImpl;
import com.intellij.database.types.DasType;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectNamePart;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SingletonIterator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseModel
implements BasicModModel {
    private static final AtomicInteger ourModelCounter = new AtomicInteger(0);
    private static final long MY_NO_LOCK = Long.MIN_VALUE;
    private static final boolean ourUseIndexInFamilyOnRenew = Registry.is((String)"database.model.family.use.index.on.renew.child", (boolean)true);
    private final int myModelInstanceNumber;
    @NotNull
    private ModelTextStorage myTextStorage;
    @NotNull
    private BasicResolveAssistant myResolveAssistant;
    @NotNull
    private final ModelEntityStorage myEntityStorage;
    @NotNull
    private final Logger log;
    @NotNull
    private final ModelNameIndex myIndex;
    @NotNull
    private final ConcurrentMap<DasObject, DasType> myDasTypeCache;
    private final Set<BaseElement<?>> myLastCreatedElements;
    private final Set<BaseElement<?>> myLastModifiedElements;
    private final Set<BaseElement<?>> myLastRemovedElements;
    private final ReentrantReadWriteLock myLock;
    private volatile long myModificationThreadId;
    private final CopyOnWriteArrayList<BasicModelListener> myListeners;
    private boolean myFastMode;
    private boolean myForceNotifications;
    private boolean myFrozen;
    private boolean myPreserveSources;

    @Override
    @NotNull
    public abstract BasicRoot getRoot();

    protected BaseModel(@NotNull ModelTextStorage textStorage) {
        if (textStorage == null) {
            BaseModel.$$$reportNull$$$0(0);
        }
        this.myModelInstanceNumber = ourModelCounter.incrementAndGet();
        this.myResolveAssistant = BasicResolveAssistant.DEFAULT;
        this.log = Logger.getInstance(this.getClass());
        this.myIndex = new ModelNameIndexImpl(this);
        this.myDasTypeCache = new ConcurrentHashMap<DasObject, DasType>();
        this.myLastCreatedElements = new HashSet();
        this.myLastModifiedElements = new HashSet();
        this.myLastRemovedElements = new HashSet();
        this.myLock = new ReentrantReadWriteLock();
        this.myModificationThreadId = Long.MIN_VALUE;
        this.myListeners = new CopyOnWriteArrayList();
        this.myTextStorage = textStorage;
        ModelEntityStorage.Backend backend = textStorage.createEntityStorage();
        if (backend.isPersistent()) {
            ModelMemoryManager.getInstance().registerModel(this);
        }
        this.myEntityStorage = new ModelEntityStorage((BasicMetaModel<?>)this.getMetaModel(), backend);
    }

    public void moveEntities() {
        if (this.myEntityStorage.isPersistent()) {
            ModelEntityStorage.Backend backend = this.myTextStorage.createEntityStorage();
            this.myEntityStorage.moveEntities(backend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V read(@NotNull ModelReader<? super BasicModel, V> reader) {
        if (reader == null) {
            BaseModel.$$$reportNull$$$0(1);
        }
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            V v = reader.perform(this);
            return v;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public <R extends BasicModRoot> void modify(@NotNull Class<R> rootClass, @NotNull ModelModifier<? super R> modifier) {
        if (rootClass == null) {
            BaseModel.$$$reportNull$$$0(2);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(3);
        }
        this.modify(this.getRoot(), rootClass, modifier);
    }

    @Override
    public <E extends BasicElement, M extends E> void modify(@NotNull E element, @NotNull Class<M> clazz, @NotNull ModelModifier<? super M> modifier) {
        if (element == null) {
            BaseModel.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            BaseModel.$$$reportNull$$$0(5);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(6);
        }
        this.modify(element, clazz, this.myFastMode, modifier);
    }

    public <E extends BasicElement, M extends E> void modify(@NotNull E element, @NotNull Class<M> clazz, boolean fast, @NotNull ModelModifier<? super M> modifier) {
        if (element == null) {
            BaseModel.$$$reportNull$$$0(7);
        }
        if (clazz == null) {
            BaseModel.$$$reportNull$$$0(8);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(9);
        }
        if (element.getModel() == null) {
            throw new IllegalArgumentException("Orphan element (the element doesn't belong to any model)");
        }
        if (!this.contains(element)) {
            throw new IllegalArgumentException("Alien element (the element belong to another model)");
        }
        Class<?> elementClass = element.getClass();
        if (!clazz.isAssignableFrom(elementClass)) {
            throw new IllegalArgumentException("Attempt to modify element of " + elementClass.getSimpleName() + " as an instance of " + clazz.getSimpleName());
        }
        E modElement = element;
        this.modify(modElement, fast, modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends BasicElement> void modify(@NotNull E element, boolean fast, @NotNull ModelModifier<? super E> modifier) {
        if (element == null) {
            BaseModel.$$$reportNull$$$0(10);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(11);
        }
        long time1 = System.currentTimeMillis();
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        boolean alreadyHeld = writeLock.isHeldByCurrentThread();
        writeLock.lock();
        long time2 = System.currentTimeMillis();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Model entered into modifying mode (lock delay was " + (time2 - time1) + " ms)");
        }
        boolean prevFast = this.myFastMode;
        try {
            boolean bl = this.myFastMode = (!alreadyHeld || this.myFastMode) && fast;
            if (!alreadyHeld) {
                this.clearModifications();
            }
            this.myModificationThreadId = Thread.currentThread().getId();
            long time3 = System.currentTimeMillis();
            modifier.perform(element);
            long time4 = System.currentTimeMillis();
            this.compactListeners();
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.format("Model was modified during %d ms, %d created, %d updated, %d removed ", time4 - time3, this.myLastCreatedElements.size(), this.myLastModifiedElements.size(), this.myLastRemovedElements.size()));
            }
        }
        finally {
            long timeFreeze = System.currentTimeMillis();
            try {
                this.freezeAllData();
            }
            finally {
                this.myFastMode = prevFast;
                writeLock.unlock();
            }
            this.myModificationThreadId = Long.MIN_VALUE;
            long time5 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Freezing took " + (time5 - timeFreeze) + " ms");
            }
            if (!alreadyHeld) {
                this.notifyListeners();
                this.clearModifications();
            }
            long time6 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Listeners took " + (time6 - time5) + " ms");
            }
            long time7 = System.currentTimeMillis();
            this.removeDroppedSources();
            long time8 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Dropping sources took " + (time8 - time7) + " ms");
            }
            this.clearCaches();
        }
    }

    private void clearCaches() {
        this.myIndex.clear();
        this.myDasTypeCache.clear();
    }

    void doingObjectCreate(@NotNull BaseElement<?> element) {
        if (element == null) {
            BaseModel.$$$reportNull$$$0(12);
        }
        this.doingAnyModification();
        if (this.shouldCollectChanges()) {
            this.myLastCreatedElements.add(element);
        }
    }

    private boolean shouldCollectChanges() {
        return !this.myFastMode && (this.myForceNotifications || this.isUnderLock());
    }

    private boolean isUnderLock() {
        return this.myModificationThreadId != Long.MIN_VALUE;
    }

    void doingObjectModify(@NotNull BaseElement<?> element) {
        if (element == null) {
            BaseModel.$$$reportNull$$$0(13);
        }
        if (element.isBeingDropped() || element.isDropped()) {
            return;
        }
        this.doingAnyModification();
        if (this.shouldCollectChanges()) {
            this.myLastModifiedElements.add(element);
        }
    }

    void doingObjectRemove(@NotNull BaseElement<?> element) {
        if (element == null) {
            BaseModel.$$$reportNull$$$0(14);
        }
        this.doingAnyModification();
        if (element instanceof BasicModIdentifiedElement) {
            ((BasicModIdentifiedElement)((Object)element)).setObjectId(Long.MIN_VALUE);
        }
        if (!this.myPreserveSources && (element instanceof BasicSourceAware || element instanceof BasicNamespace)) {
            this.myTextStorage.queueDelete(element);
        }
        if (this.shouldCollectChanges()) {
            this.myLastRemovedElements.add(element);
        }
        element.putToStorage(null);
    }

    private void doingAnyModification() {
        if (this.myFrozen) {
            throw new IllegalStateException("Model is frozen");
        }
        this.clearCaches();
    }

    public void setFrozen(boolean frozen) {
        this.myFrozen = frozen;
    }

    @Override
    public void addListener(@NotNull BasicModelListener listener2) {
        if (listener2 == null) {
            BaseModel.$$$reportNull$$$0(15);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull BasicModelListener listener2) {
        if (listener2 == null) {
            BaseModel.$$$reportNull$$$0(16);
        }
        this.myListeners.remove(listener2);
    }

    @Override
    public void clearModel() {
        this.modify(BasicModRoot.class, r -> {
            r.importProperties(new NameValueGetter.FromMap<String>(Collections.emptyMap()));
            BasicModMixinElement.dropChildren(r);
            this.myEntityStorage.clear();
        });
    }

    @Override
    public void writeSources(@NotNull Runnable r) {
        if (r == null) {
            BaseModel.$$$reportNull$$$0(17);
        }
        this.myTextStorage.writeSession(this, r);
    }

    private void compactListeners() {
        this.myLastCreatedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastCreatedElements);
    }

    private void freezeAllData() {
        if (this.myFastMode) {
            for (BaseElement element : this.basicTraverser().filter(BaseElement.class)) {
                element.freezeData();
            }
        } else {
            for (BaseElement<?> element : this.myLastCreatedElements) {
                element.freezeData();
            }
            for (BaseElement<?> element : this.myLastModifiedElements) {
                element.freezeData();
            }
        }
    }

    private void notifyListeners() {
        if (!this.hasNotifications()) {
            return;
        }
        Set<BasicElement> lastCreatedElements = Collections.unmodifiableSet(this.myLastCreatedElements);
        Set<BasicElement> lastModifiedElements = Collections.unmodifiableSet(this.myLastModifiedElements);
        Set<BasicElement> lastRemovedElements = Collections.unmodifiableSet(this.myLastRemovedElements);
        for (BasicModelListener listener2 : this.myListeners) {
            listener2.modified(lastCreatedElements, lastModifiedElements, lastRemovedElements);
        }
    }

    private boolean hasNotifications() {
        return !this.myLastCreatedElements.isEmpty() || !this.myLastModifiedElements.isEmpty() || !this.myLastRemovedElements.isEmpty();
    }

    private void removeDroppedSources() {
        this.myTextStorage.flushQueues();
    }

    private void clearModifications() {
        this.myLastCreatedElements.clear();
        this.myLastModifiedElements.clear();
        this.myLastRemovedElements.clear();
    }

    public void preserveSources(Runnable r) {
        boolean prev2 = this.myPreserveSources;
        this.myPreserveSources = true;
        try {
            r.run();
        }
        finally {
            this.myPreserveSources = prev2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unloadAll(boolean tryLock, @Nullable Condition<? super BasicElement> filter) {
        ReentrantReadWriteLock.WriteLock lock;
        ReentrantReadWriteLock.WriteLock writeLock = lock = tryLock ? this.myLock.writeLock() : null;
        if (lock != null && !lock.tryLock()) {
            return false;
        }
        try {
            this.modify(this.getRoot(), true, (? super E r) -> {
                JBIterable objects = ((JBTreeTraverser)this.basicTraverser().withRoot(r)).traverse();
                if (filter != null) {
                    objects = objects.filter(filter);
                }
                for (BaseElement element : objects.filter(BaseElement.class)) {
                    element.unload();
                }
            });
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return true;
    }

    @Override
    @NotNull
    public ModelNameIndex getNameIndex() {
        ModelNameIndex modelNameIndex = this.myIndex;
        if (modelNameIndex == null) {
            BaseModel.$$$reportNull$$$0(18);
        }
        return modelNameIndex;
    }

    @Override
    @NotNull
    public DasType getCacheableDasType(@NotNull DasObject element, @NotNull Supplier<? extends DasType> computeType) {
        DasType dasType;
        if (element == null) {
            BaseModel.$$$reportNull$$$0(19);
        }
        if (computeType == null) {
            BaseModel.$$$reportNull$$$0(20);
        }
        if ((dasType = (DasType)this.myDasTypeCache.get(element)) == null) {
            dasType = (DasType)ConcurrencyUtil.cacheOrGet(this.myDasTypeCache, (Object)element, (Object)computeType.get());
        }
        DasType dasType2 = dasType;
        if (dasType2 == null) {
            BaseModel.$$$reportNull$$$0(21);
        }
        return dasType2;
    }

    @Nullable
    public static ObjectNamePart computeNamePart(@Nullable BasicElement e) {
        if (e == null) {
            return null;
        }
        BasicModel model = e.getModel();
        if (model instanceof BaseModel && ((BaseModel)model).myFastMode) {
            return ObjectPath.create(e.getName(), e.getKind(), DbSqlUtilCore.isQuoted(e), null, null);
        }
        return BasicPaths.append(e, model, null);
    }

    @Override
    public void saveSourceText(@NotNull BasicSourceAware object, @Nullable CompositeText sourceText) {
        if (object == null) {
            BaseModel.$$$reportNull$$$0(22);
        }
        this.myTextStorage.save(object, sourceText);
    }

    @Override
    @Nullable
    public CompositeText loadSourceText(@NotNull BasicSourceAware object) {
        if (object == null) {
            BaseModel.$$$reportNull$$$0(23);
        }
        return this.myTextStorage.load(object);
    }

    @Override
    public void setSchemaSourcesVersion(@NotNull BasicSchema schema, @Nullable Long version) {
        if (schema == null) {
            BaseModel.$$$reportNull$$$0(24);
        }
        this.myTextStorage.setVersion(schema, version);
    }

    @Override
    @Nullable
    public Long getSchemaSourcesVersion(@NotNull BasicSchema schema) {
        if (schema == null) {
            BaseModel.$$$reportNull$$$0(25);
        }
        return this.myTextStorage.getVersion(schema);
    }

    public void setTextStorage(@NotNull ModelTextStorage textStorage) {
        if (textStorage == null) {
            BaseModel.$$$reportNull$$$0(26);
        }
        this.myTextStorage = textStorage;
    }

    @Override
    @NotNull
    public ModelTextStorage getTextStorage() {
        ModelTextStorage modelTextStorage = this.myTextStorage;
        if (modelTextStorage == null) {
            BaseModel.$$$reportNull$$$0(27);
        }
        return modelTextStorage;
    }

    @Override
    @NotNull
    public BasicResolveAssistant getResolveAssistant() {
        BasicResolveAssistant basicResolveAssistant = this.myResolveAssistant;
        if (basicResolveAssistant == null) {
            BaseModel.$$$reportNull$$$0(28);
        }
        return basicResolveAssistant;
    }

    @Override
    public void shelve(boolean clear) {
        if (clear) {
            this.myEntityStorage.clear();
        }
        this.myEntityStorage.shelve();
    }

    public void handleRename(@NotNull BasicHierarchicalObject e, @NotNull ObjectNamePart oldName) {
        if (e == null) {
            BaseModel.$$$reportNull$$$0(29);
        }
        if (oldName == null) {
            BaseModel.$$$reportNull$$$0(30);
        }
        if (e.isBeingDropped() || e.isDropped()) {
            return;
        }
        if (oldName.name.isEmpty() && oldName.getIdentity() == null || this.myFastMode) {
            return;
        }
        this.getTextStorage().handleRename(e, oldName);
    }

    @Contract(value="null,_ -> null", pure=true)
    @Nullable
    static <X> X findFirst(@Nullable Iterable<? extends X> items, @NotNull Predicate<? super X> predicate) {
        if (predicate == null) {
            BaseModel.$$$reportNull$$$0(31);
        }
        if (items == null) {
            return null;
        }
        for (X item : items) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public int hashCode() {
        return this.myModelInstanceNumber;
    }

    public String toString() {
        return String.format("%s model [instance %d]", this.getDbms().getName(), this.myModelInstanceNumber);
    }

    public static boolean isLoaded(@NotNull BasicElement e) {
        BaseElement element;
        if (e == null) {
            BaseModel.$$$reportNull$$$0(32);
        }
        return (element = (BaseElement)ObjectUtils.tryCast((Object)e, BaseElement.class)) != null && BaseElement.asData(element.myData) != null;
    }

    public static boolean forceLoad(@NotNull BasicElement e) {
        if (e == null) {
            BaseModel.$$$reportNull$$$0(33);
        }
        if (BaseModel.isLoaded(e)) {
            return true;
        }
        BaseElement element = (BaseElement)ObjectUtils.tryCast((Object)e, BaseElement.class);
        if (element != null) {
            element.getData();
        }
        return BaseModel.isLoaded(e);
    }

    public static void forceNotifications(@NotNull BasicModModel model, boolean force) {
        BaseModel m;
        if (model == null) {
            BaseModel.$$$reportNull$$$0(34);
        }
        if ((m = (BaseModel)ObjectUtils.tryCast((Object)model, BaseModel.class)) != null) {
            m.myForceNotifications = force;
            if (!force) {
                m.clearModifications();
            }
        }
    }

    public static boolean hasUnfiredNotifications(@NotNull BasicModModel model) {
        BaseModel m;
        if (model == null) {
            BaseModel.$$$reportNull$$$0(35);
        }
        if ((m = (BaseModel)ObjectUtils.tryCast((Object)model, BaseModel.class)) == null) {
            return false;
        }
        return m.hasNotifications();
    }

    public static boolean forceUnload(@NotNull BasicModel model, boolean tryLock, @Nullable Condition<? super BasicElement> filter) {
        BaseModel m;
        if (model == null) {
            BaseModel.$$$reportNull$$$0(36);
        }
        if ((m = (BaseModel)ObjectUtils.tryCast((Object)model, BaseModel.class)) == null) {
            return true;
        }
        return m.unloadAll(tryLock, filter);
    }

    public static void modifyFast(@NotNull BasicModel model, @NotNull ModelModifier<? super BasicModRoot> modifier) {
        BaseModel m;
        if (model == null) {
            BaseModel.$$$reportNull$$$0(37);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(38);
        }
        if ((m = (BaseModel)ObjectUtils.tryCast((Object)model, BaseModel.class)) == null) {
            return;
        }
        m.modify(m.getRoot(), BasicModRoot.class, true, modifier);
    }

    public static void setResolveAssistant(@NotNull BasicModModel m, @NotNull BasicResolveAssistant resolveAssistant) {
        BaseModel model;
        if (m == null) {
            BaseModel.$$$reportNull$$$0(39);
        }
        if (resolveAssistant == null) {
            BaseModel.$$$reportNull$$$0(40);
        }
        if ((model = (BaseModel)ObjectUtils.tryCast((Object)m, BaseModel.class)) != null) {
            model.myResolveAssistant = resolveAssistant;
        }
    }

    public static boolean isUnderSubstituted(BasicElement e) {
        return e instanceof BaseElement && ((BaseElement)e).isUnderSubstituted();
    }

    public static boolean isPersistent(BasicModModel m) {
        BaseModel model = (BaseModel)ObjectUtils.tryCast((Object)m, BaseModel.class);
        return model != null && model.myEntityStorage.isPersistent();
    }

    public static boolean restoreFromStorage(BasicModModel m) {
        BaseModel model = (BaseModel)ObjectUtils.tryCast((Object)m, BaseModel.class);
        if (model == null || !model.myEntityStorage.isPersistent()) {
            return false;
        }
        Ref res2 = Ref.create((Object)false);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        model.modify(model.getRoot(), BaseRoot.class, true, r -> {
            BaseRoot er = r;
            for (ModFamily modFamily : er.getFamilies()) {
                modFamily.clear();
            }
            res2.set((Object)model.myEntityStorage.processHierarchy(er.myEntityId, er, (children2, parent, out) -> {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                if (parent == null) {
                    return;
                }
                MultiMap grouped = ContainerUtil.groupBy((Iterable)children2, ModelEntityStorage.HProcessor.Child::getObjectKind);
                for (Map.Entry g : grouped.entrySet()) {
                    Family family = parent.familyOf((ObjectKind)g.getKey());
                    if (family == null) continue;
                    ((BaseFamily)family).createBulk((Iterable)g.getValue(), ModelEntityStorage.HProcessor.Child::getEntityId, (e, c2) -> {
                        e.setData(c2.getStub(), null);
                        out.accept(c2, e);
                    });
                }
            }));
            for (BasicModElement basicModElement : model.basicTraverser().filter(BasicModElement.class)) {
                for (ModFamily modFamily : basicModElement.getFamilies()) {
                    modFamily.sort();
                }
            }
        });
        return (Boolean)res2.get();
    }

    @Nullable
    public static <E extends BasicElement> List<BasicIdentifiedElement> getIndexedElementsWithId(@NotNull Family<E> f, long objectId) {
        if (f == null) {
            BaseModel.$$$reportNull$$$0(41);
        }
        return f instanceof BaseIdentifyingFamily ? BaseIdentifyingFamily.getIndexedElementsWithId((BaseIdentifyingFamily)f, objectId) : null;
    }

    @NotNull
    public static <T extends BasicElement, V> List<T> createBulk(@NotNull Family<T> family, @NotNull Iterable<V> elements, @Nullable PairConsumer<T, V> init) {
        if (family == null) {
            BaseModel.$$$reportNull$$$0(42);
        }
        if (elements == null) {
            BaseModel.$$$reportNull$$$0(43);
        }
        List<T> list = ((BaseFamily)family).createBulk(elements, null, init);
        if (list == null) {
            BaseModel.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    public static <T extends BasicElement> List<T> createBulk(@NotNull Family<T> family, @NotNull Iterable<T> elements) {
        if (family == null) {
            BaseModel.$$$reportNull$$$0(45);
        }
        if (elements == null) {
            BaseModel.$$$reportNull$$$0(46);
        }
        return BaseModel.createBulk(family, elements, (e, c2) -> ((BaseElement)e).setData(c2, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 21, 27, 28, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textStorage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 18: 
            case 21: 
            case 27: 
            case 28: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/BaseModel";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeType";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 29: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveAssistant";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/BaseModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIndex";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheableDasType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextStorage";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveAssistant";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createBulk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectCreate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectModify";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectRemove";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeSources";
                break;
            }
            case 18: 
            case 21: 
            case 27: 
            case 28: 
            case 44: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCacheableDasType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "saveSourceText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadSourceText";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setSchemaSourcesVersion";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaSourcesVersion";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setTextStorage";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isLoaded";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "forceLoad";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "forceNotifications";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasUnfiredNotifications";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "forceUnload";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "modifyFast";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setResolveAssistant";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedElementsWithId";
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createBulk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 21, 27, 28, 44 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static abstract class BaseElement<D extends BasicModElement>
    implements BasicHierarchicalObject {
        private static final AtomicFieldUpdater<BaseElement<?>, Object> ourDataUpdater = AtomicFieldUpdater.forFieldOfType(BaseElement.class, Object.class);
        @Nullable
        private volatile Object myData;
        private final int myEntityId;

        protected BaseElement(int entityId) {
            this.myEntityId = entityId;
        }

        protected boolean setData(@Nullable Object data, @Nullable Object prev2) {
            return data == this.myData || ourDataUpdater.compareAndSet((Object)this, prev2, data);
        }

        protected boolean setData(@Nullable BasicDataObject data, boolean freeze, @Nullable Object prev2) {
            BasicDataObject newData = data == null || data.isFrozen() || freeze ? this.putToStorage(data) : data;
            return this.setData(newData, prev2);
        }

        @Override
        @NotNull
        public String identity() {
            String string = this.identity(true);
            if (string == null) {
                BaseElement.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String identity(boolean includingSurrogate) {
            String string = this.identity(includingSurrogate, false, false);
            if (string == null) {
                BaseElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        private BasicDataObject putToStorage(@Nullable BasicDataObject data) {
            int parentId;
            BaseElement parent = (BaseElement)ObjectUtils.tryCast((Object)this.getParent(), BaseElement.class);
            int n = parentId = parent == null ? Integer.MIN_VALUE : parent.myEntityId;
            if (this.isUnderSubstituted()) {
                this.getEntityStorage().setDataObject(this.myEntityId, parentId, null);
                return data;
            }
            return this.getEntityStorage().setDataObject(this.myEntityId, parentId, data);
        }

        private boolean isUnderSubstituted() {
            BasicNamespace nsp = DasUtil.getParentOfClass(this, BasicNamespace.class, true);
            while (nsp != null) {
                if (nsp.isSubstituted()) {
                    return true;
                }
                nsp = (BasicNamespace)ObjectUtils.tryCast((Object)nsp.getParent(), BasicNamespace.class);
            }
            return false;
        }

        private boolean isPersisted() {
            return this.getEntityStorage().isPersistent() && !this.isUnderSubstituted();
        }

        @NotNull
        private ModelEntityStorage getEntityStorage() {
            ModelEntityStorage modelEntityStorage = this.getModel().myEntityStorage;
            if (modelEntityStorage == null) {
                BaseElement.$$$reportNull$$$0(2);
            }
            return modelEntityStorage;
        }

        @NotNull
        protected BasicDataObject getData() {
            Object prev2;
            BasicDataObject newData;
            do {
                BasicDataObject stored;
                if ((stored = BaseElement.asData(prev2 = this.myData)) != null) {
                    BasicDataObject basicDataObject = stored;
                    if (basicDataObject == null) {
                        BaseElement.$$$reportNull$$$0(3);
                    }
                    return basicDataObject;
                }
                newData = this.loadEntity();
                if (newData != null) continue;
                newData = (BasicDataObject)this.getMetaObject().newDataObject();
            } while (!this.setData(newData, prev2));
            BasicDataObject basicDataObject = newData;
            if (basicDataObject == null) {
                BaseElement.$$$reportNull$$$0(4);
            }
            return basicDataObject;
        }

        @Nullable
        private BasicDataObject loadEntity() {
            return this.getEntityStorage().getDataObject(this.myEntityId, this.getMetaObject());
        }

        @NotNull
        protected String getNameImpl() {
            String string = DataStub.getName(this.myData);
            if (string == null) {
                BaseElement.$$$reportNull$$$0(5);
            }
            return string;
        }

        protected boolean isNameQuotedImpl() {
            return DataStub.isNameQuoted(this.myData);
        }

        protected boolean isNameScriptedImpl() {
            return DataStub.isNameScripted(this.myData);
        }

        protected boolean isCurrentImpl() {
            return DataStub.isCurrent(this.myData);
        }

        private boolean unload() {
            Object prev2;
            BasicDataObject data;
            Object stub;
            if (!this.isPersisted()) {
                return false;
            }
            do {
                if ((data = BaseElement.asData(prev2 = this.myData)) == null) {
                    return true;
                }
                if (data.isFrozen()) continue;
                return false;
            } while (!this.setData(stub = BaseElement.getDataStub(data), prev2));
            return true;
        }

        protected boolean affectsParentPath() {
            return false;
        }

        @Nullable
        private static Object getDataStub(@Nullable BasicDataObject data) {
            return data == null ? null : DataStub.create(data);
        }

        @Nullable
        private static BasicDataObject asData(Object data) {
            return (BasicDataObject)ObjectUtils.tryCast((Object)data, BasicDataObject.class);
        }

        private void freezeData() {
            Object prev2;
            BasicDataObject data;
            do {
                if ((data = BaseElement.asData(prev2 = this.myData)) != null && !data.isFrozen()) continue;
                return;
            } while (!this.setData(data, true, prev2));
        }

        private void unfreeze() {
            Object prev2;
            BasicDataObject unfrozen;
            do {
                prev2 = this.myData;
                BasicDataObject data = this.getData();
                boolean frozen = data.isFrozen();
                if (!frozen) {
                    return;
                }
                unfrozen = data.copy();
                assert (!unfrozen.isFrozen());
            } while (!this.setData(unfrozen, false, prev2));
        }

        protected D getDelegate() {
            return (D)this.getData();
        }

        @Override
        public int getStoredHashCode() {
            return this.getData().getStoredHashCode();
        }

        @NotNull
        public abstract BasicMetaObject<D> getMetaObject();

        @Override
        @NotNull
        public abstract BaseModel getModel();

        @Override
        public void handleRename(@NotNull ObjectNamePart oldName) {
            if (oldName == null) {
                BaseElement.$$$reportNull$$$0(6);
            }
            this.getModel().handleRename(this, oldName);
        }

        @Override
        public boolean hasData(@NotNull BasicDataObject data) {
            if (data == null) {
                BaseElement.$$$reportNull$$$0(7);
            }
            return this.getData() == data;
        }

        @Override
        public BasicDataObject frozenData() {
            BasicDataObject data = this.getData();
            if (data.isFrozen()) {
                return data;
            }
            this.freezeData();
            return this.getData();
        }

        @Override
        public boolean applyData(@NotNull BasicDataObject next) {
            ModelIdIndex index;
            long nextId;
            long fromId;
            BasicIdentifiedElement idThis;
            ObjectNamePart oldParentName;
            BaseElement parent;
            ObjectNamePart oldName;
            Object prev2;
            if (next == null) {
                BaseElement.$$$reportNull$$$0(8);
            }
            do {
                BasicDataObject data;
                if (next == (data = this.getData())) {
                    return true;
                }
                if (next.getMetaObject() != this.getMetaObject()) {
                    return false;
                }
                this.modifying(false);
                prev2 = this.myData;
                oldName = BaseModel.computeNamePart(data);
                parent = this.affectsParentPath() ? (BaseElement)this.getParent() : null;
                oldParentName = this.affectsParentPath() ? BaseModel.computeNamePart(parent) : null;
                idThis = (BasicIdentifiedElement)ObjectUtils.tryCast((Object)this, BasicIdentifiedElement.class);
                fromId = idThis == null ? -1L : idThis.getObjectId();
                nextId = idThis == null ? -1L : ((BasicIdentifiedElement)((Object)next)).getObjectId();
                ModelIdIndex modelIdIndex = index = fromId != nextId ? ModelIdIndex.getIndex(this.getDatabase()) : null;
            } while (!this.setData(next, true, prev2));
            if (index != null) {
                index.unregisterIdentifiedElement(fromId, idThis);
                index.registerIdentifiedElement(nextId, idThis);
            }
            if (!oldName.equals(BaseModel.computeNamePart(next))) {
                this.handleRename(oldName);
            }
            if (oldParentName != null && !oldParentName.equals(BaseModel.computeNamePart(parent))) {
                parent.handleRename(oldParentName);
            }
            return true;
        }

        protected void modifying(boolean data) {
            this.getModel().doingObjectModify(this);
            if (data) {
                this.unfreeze();
            }
        }

        @Override
        @Nullable
        public abstract BaseFamily<?> familyOf(@NotNull ObjectKind var1);

        @Override
        public void drop() {
            this.internalDrop(true);
        }

        abstract void internalDrop(boolean var1);

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public void resetSyncPending() {
            this.setOutdated(false);
            this.setSyncPending(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 6, 7, 8 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "next";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "identity";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEntityStorage";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameImpl";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "handleRename";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "hasData";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "applyData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 6, 7, 8 -> new IllegalArgumentException(string);
            };
        }
    }

    protected static abstract class BaseRoot<D extends BasicModRoot>
    extends BaseElement<D>
    implements BasicModRoot {
        private final RootFamily<D> myFamily;

        protected BaseRoot(@NotNull BaseModel model) {
            if (model == null) {
                BaseRoot.$$$reportNull$$$0(0);
            }
            super(model.myEntityStorage.rootEntityId());
            this.myFamily = new RootFamily<BaseRoot>(model, this);
        }

        @Nullable
        public RootFamily<D> getParentFamily() {
            return this.myFamily;
        }

        @Override
        @NotNull
        public BaseModel getModel() {
            BaseModel baseModel = ((RootFamily)this.getParentFamily()).getModel();
            if (baseModel == null) {
                BaseRoot.$$$reportNull$$$0(1);
            }
            return baseModel;
        }

        @Override
        @Nullable
        public BaseRoot<?> getParent() {
            return null;
        }

        @Override
        @Nullable
        public BasicSchema getSchema() {
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                BaseRoot.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
            if (syncPending) {
                throw new IllegalStateException("Cannot set the root element as sync pending");
            }
        }

        @Override
        public boolean isSyncPending() {
            return false;
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            throw new IllegalStateException("Cannot drop a root element");
        }

        @Override
        public boolean isDropped() {
            return false;
        }

        @Override
        public boolean isBeingDropped() {
            return false;
        }

        public String toString() {
            return "ROOT";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    protected static class BaseIdentifyingFamily<E extends BaseElement<?>>
    extends BaseFamily<E>
    implements ModIdentifyingFamily<E> {
        public BaseIdentifyingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            return BaseIdentifyingFamily.createOrGetImpl(objectId, this);
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            return BaseIdentifyingFamily.getByObjectIdImpl(objectId, this);
        }

        @NotNull
        static <E extends BaseElement<?>> E createOrGetImpl(long objectId, ModIdentifyingFamily<E> f) {
            BaseElement element = (BaseElement)f.getByObjectId(objectId);
            if (element == null) {
                element = (BaseElement)f.createNewOne();
                ((BasicModIdentifiedElement)((Object)element)).setObjectId(objectId);
            } else {
                element.resetSyncPending();
            }
            BaseElement baseElement = element;
            if (baseElement == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(3);
            }
            return (E)baseElement;
        }

        @Nullable
        static <E extends BaseElement<?>> E getByObjectIdImpl(long objectId, BaseFamily<E> f) {
            List<BasicIdentifiedElement> indexed;
            List elements = f.myElements;
            if (elements == null) {
                return null;
            }
            List<BasicIdentifiedElement> list = indexed = ourUseIndexInFamilyOnRenew && elements.size() > 10 ? BaseIdentifyingFamily.getIndexedElementsWithId(f, objectId) : null;
            if (indexed != null && indexed.size() < elements.size()) {
                return (E)((BaseElement)BaseIdentifyingFamily.findElementByFamily(indexed, f));
            }
            return (E)((BaseElement)BaseIdentifyingFamily.findElementById(elements, objectId));
        }

        @Nullable
        private static <E extends BasicIdentifiedElement> List<BasicIdentifiedElement> getIndexedElementsWithId(@NotNull HostFamily<E> f, long objectId) {
            if (f == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(4);
            }
            if (objectId == Long.MIN_VALUE || objectId == -9223372036854775807L) {
                return null;
            }
            ModelIdIndex.Provider idxProvider = DasUtil.getParentOfClass(f.getHost(), ModelIdIndex.Provider.class, true);
            if (idxProvider == null) {
                return null;
            }
            return idxProvider.getIndex().findIdentifiedElements(objectId);
        }

        @Nullable
        private static <E extends BasicIdentifiedElement> E findElementById(@NotNull List<E> elements, long objectId) {
            if (elements == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(5);
            }
            for (BasicIdentifiedElement element : elements) {
                if (element.getObjectId() != objectId) continue;
                return (E)element;
            }
            return null;
        }

        @Nullable
        private static <E extends BasicElement> E findElementByFamily(@NotNull List<? extends BasicElement> elements, Family<E> f) {
            if (elements == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(6);
            }
            for (BasicElement basicElement : elements) {
                if (basicElement.getParentFamily() != f) continue;
                return (E)basicElement;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseIdentifyingFamily";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "f";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseIdentifyingFamily";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGetImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndexedElementsWithId";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findElementById";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findElementByFamily";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    protected static class BaseFamily<E extends BaseElement<?>>
    implements HostFamily<E>,
    ModFamily<E> {
        @NotNull
        public final BaseElement<?> owner;
        @Nullable
        protected volatile List<E> myElements;
        private final BasicMetaObject<?> myMeta;
        private final BaseFactory<E> myFactory;

        public BaseFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseFamily.$$$reportNull$$$0(2);
            }
            this(owner, Objects.requireNonNull(BasicMetaUtils.findChild(owner.getMetaObject(), kind)), factory);
        }

        public BaseFamily(@NotNull BaseElement<?> owner, @NotNull BasicMetaObject<?> meta, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseFamily.$$$reportNull$$$0(3);
            }
            if (meta == null) {
                BaseFamily.$$$reportNull$$$0(4);
            }
            if (factory == null) {
                BaseFamily.$$$reportNull$$$0(5);
            }
            this.myElements = null;
            this.owner = owner;
            this.myMeta = meta;
            this.myFactory = factory;
        }

        @Override
        @NotNull
        public DvFamilyId getFamilyId() {
            DvFamilyId dvFamilyId = DvFamilyId.Companion.wrap(this.getChildrenKind());
            if (dvFamilyId == null) {
                BaseFamily.$$$reportNull$$$0(6);
            }
            return dvFamilyId;
        }

        @Override
        @NotNull
        public BasicMetaObject<?> getMetaObject() {
            BasicMetaObject<?> basicMetaObject = this.myMeta;
            if (basicMetaObject == null) {
                BaseFamily.$$$reportNull$$$0(7);
            }
            return basicMetaObject;
        }

        @Override
        @NotNull
        public BasicElement getHost() {
            BaseElement<?> baseElement = this.owner;
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(8);
            }
            return baseElement;
        }

        @Override
        @NotNull
        public ObjectKind getChildrenKind() {
            ObjectKind objectKind = this.myMeta.kind;
            if (objectKind == null) {
                BaseFamily.$$$reportNull$$$0(9);
            }
            return objectKind;
        }

        @Override
        public void removeSyncPendingChildren() {
            this.remove(BasicModMixinElement::isSyncPending);
        }

        @Override
        public void markChildrenAsSyncPending() {
            for (BaseElement e : this) {
                e.setSyncPending(true);
            }
        }

        @NotNull
        protected E instantiate(int entityId) {
            E e = this.myFactory.create(this, entityId);
            if (e == null) {
                BaseFamily.$$$reportNull$$$0(10);
            }
            return e;
        }

        @Override
        @NotNull
        public E createNewOne() {
            E e = this.createNewOne(this.getModel().myEntityStorage.allocateEntityId());
            if (e == null) {
                BaseFamily.$$$reportNull$$$0(11);
            }
            return e;
        }

        @NotNull
        public E createNewOne(int entityId) {
            ObjectNamePart oldParentName;
            BaseModel model = this.owner.getModel();
            this.owner.modifying(false);
            E newOne = this.instantiate(entityId);
            ObjectNamePart objectNamePart = oldParentName = ((BaseElement)newOne).affectsParentPath() ? BaseModel.computeNamePart(this.owner) : null;
            if (this.myElements == null) {
                this.myElements = new CopyOnWriteArrayList();
            }
            this.myElements.add(newOne);
            if (oldParentName != null) {
                this.owner.handleRename(oldParentName);
            }
            model.doingObjectCreate((BaseElement<?>)newOne);
            E e = newOne;
            if (e == null) {
                BaseFamily.$$$reportNull$$$0(12);
            }
            return e;
        }

        @NotNull
        private <X> List<E> createBulk(@NotNull Iterable<X> items, @Nullable @Nullable Function<X, @Nullable Integer> idGetter, @Nullable PairConsumer<E, X> init) {
            ObjectNamePart oldParentName;
            Iterator<X> it;
            if (items == null) {
                BaseFamily.$$$reportNull$$$0(13);
            }
            if (!(it = items.iterator()).hasNext()) {
                List list = Collections.emptyList();
                if (list == null) {
                    BaseFamily.$$$reportNull$$$0(14);
                }
                return list;
            }
            BaseModel model = this.owner.getModel();
            this.owner.modifying(false);
            List modelElements = ContainerUtil.map(it, e -> {
                ModelIdIndex index;
                BasicIdentifiedElement ie;
                Integer id = idGetter == null ? null : (Integer)idGetter.apply(e);
                E me = this.instantiate(id == null ? model.myEntityStorage.allocateEntityId() : id.intValue());
                if (init != null) {
                    init.accept(me, e);
                }
                if (me instanceof BasicIdentifiedElement && (ie = (BasicIdentifiedElement)me).getObjectId() != Long.MIN_VALUE && (index = ModelIdIndex.getIndex(ie.getDatabase())) != null) {
                    index.registerIdentifiedElement(ie.getObjectId(), ie);
                }
                return me;
            });
            ObjectNamePart objectNamePart = oldParentName = ContainerUtil.or((Iterable)modelElements, BaseElement::affectsParentPath) ? BaseModel.computeNamePart(this.owner) : null;
            if (this.myElements == null) {
                this.myElements = new CopyOnWriteArrayList();
            }
            this.myElements.addAll(modelElements);
            if (oldParentName != null) {
                this.owner.handleRename(oldParentName);
            }
            modelElements.forEach(model::doingObjectCreate);
            List list = modelElements;
            if (list == null) {
                BaseFamily.$$$reportNull$$$0(15);
            }
            return list;
        }

        @Override
        @NotNull
        public E createNewOne(@Nullable BasicDataObject data) {
            BasicModElement newOne = this.createNewOne();
            ((BaseElement)newOne).setData(data, false, null);
            BasicModElement basicModElement = newOne;
            if (basicModElement == null) {
                BaseFamily.$$$reportNull$$$0(16);
            }
            return (E)basicModElement;
        }

        @Override
        @NotNull
        public BaseModel getModel() {
            BaseModel baseModel = this.owner.getModel();
            if (baseModel == null) {
                BaseFamily.$$$reportNull$$$0(17);
            }
            return baseModel;
        }

        @Override
        @NotNull
        public E first() {
            List<E> elements = this.myElements;
            if (elements == null || elements.isEmpty()) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(0);
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(18);
            }
            return (E)baseElement;
        }

        @Override
        @NotNull
        public E last() {
            List<E> elements = this.myElements;
            if (elements == null || elements.isEmpty()) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(elements.size() - 1);
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(19);
            }
            return (E)baseElement;
        }

        @Override
        public int indexOf(@Nullable BasicElement element) {
            if (element == null) {
                return -1;
            }
            List<E> elements = this.myElements;
            if (elements == null) {
                return -1;
            }
            return elements.indexOf(element);
        }

        @Override
        public boolean hasChildren() {
            List<E> elements = this.myElements;
            return elements != null && !elements.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            List<E> elements = this.myElements;
            return elements == null || elements.isEmpty();
        }

        @Override
        public int size() {
            List<E> elements = this.myElements;
            return elements != null ? elements.size() : 0;
        }

        @Override
        @Nullable
        public E find(@NotNull Predicate<? super E> predicate) {
            List<E> elements;
            if (predicate == null) {
                BaseFamily.$$$reportNull$$$0(20);
            }
            if ((elements = this.myElements) == null) {
                return null;
            }
            for (BaseElement element : elements) {
                if (!predicate.test(element)) continue;
                return (E)element;
            }
            return null;
        }

        @Override
        public Iterator<E> iterator() {
            List<E> elements = this.myElements;
            if (elements != null) {
                return elements.iterator();
            }
            return Collections.emptyListIterator();
        }

        @Override
        public void remove(@NotNull Predicate<? super E> condition) {
            List<E> elements;
            if (condition == null) {
                BaseFamily.$$$reportNull$$$0(21);
            }
            if ((elements = this.myElements) == null) {
                return;
            }
            ObjectNamePart parentOldName = null;
            int n = elements.size();
            int droppedCount = 0;
            for (int i2 = n - 1; i2 >= 0; --i2) {
                BaseElement e = (BaseElement)elements.get(i2);
                if (!condition.test(e)) continue;
                if (droppedCount == 0) {
                    parentOldName = e.affectsParentPath() ? BaseModel.computeNamePart(this.owner) : null;
                    this.owner.modifying(false);
                }
                ++droppedCount;
                e.internalDrop(false);
            }
            if (droppedCount == n) {
                this.myElements = null;
            } else {
                this.actualRemove();
            }
            if (parentOldName != null) {
                this.owner.handleRename(parentOldName);
            }
        }

        protected void actualRemove() {
            if (this.myElements != null) {
                this.myElements.removeIf(BasicModMixinElement::isDropped);
            }
        }

        @Override
        public void sort() {
            List<E> elements = this.myElements;
            if (elements == null || elements.size() < 2) {
                return;
            }
            Comparator<E> comparator = this.getElementsComparator();
            if (BaseFamily.isSorted(elements, comparator)) {
                return;
            }
            ObjectNamePart parentOldName = ((BaseElement)elements.get(0)).affectsParentPath() ? BaseModel.computeNamePart(this.owner) : null;
            this.owner.modifying(false);
            if (!(elements instanceof ArrayList) && !(elements instanceof CopyOnWriteArrayList)) {
                throw new IllegalStateException("Unknown how to reorder elements inside a " + elements.getClass().getSimpleName());
            }
            elements.sort(comparator);
            if (parentOldName != null) {
                this.owner.handleRename(parentOldName);
            }
        }

        private static <E> boolean isSorted(List<E> elements, Comparator<? super E> comparator) {
            int e = elements.size() - 1;
            for (int i2 = 0; i2 < e; ++i2) {
                if (comparator.compare(elements.get(i2), elements.get(i2 + 1)) <= 0) continue;
                return false;
            }
            return true;
        }

        protected Comparator<? super E> getElementsComparator() {
            return ModelUtil.DISPLAY_ORDER_COMPARATOR;
        }

        @Override
        public void clear() {
            List<E> elements = this.myElements;
            if (elements == null) {
                return;
            }
            ObjectNamePart parentOldName = ((BaseElement)elements.get(0)).affectsParentPath() ? BaseModel.computeNamePart(this.owner) : null;
            this.owner.modifying(false);
            this.myElements = null;
            for (int i2 = elements.size() - 1; i2 >= 0; --i2) {
                BaseElement e = (BaseElement)elements.get(i2);
                e.internalDrop(false);
            }
            if (parentOldName != null) {
                this.owner.handleRename(parentOldName);
            }
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.myMeta.kind.code();
            if (string == null) {
                BaseFamily.$$$reportNull$$$0(22);
            }
            return string;
        }

        public String toString() {
            StringBuilder bf = new StringBuilder();
            if (this.isEmpty()) {
                bf.append("Empty Family of ");
            } else {
                bf.append("Family of ").append(this.size()).append(' ');
            }
            bf.append(this.getChildrenKind().getPresentableName());
            BaseElement<?> host = this.owner;
            bf.append(" (host: ").append(host.getKind().getPresentableName()).append(' ').append(host.identity()).append(')');
            return bf.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 22 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseFamily";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseFamily";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyId";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaObject";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHost";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenKind";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instantiate";
                    break;
                }
                case 11: 
                case 12: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBulk";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "first";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "last";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 22: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "createBulk";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 22 -> new IllegalStateException(string);
            };
        }
    }

    protected static class NullFamily<T extends BasicModNamedElement & BasicModArrangedElement>
    implements ModPositioningNamingFamily<T>,
    ModNamingIdentifyingFamily<T>,
    ModSingletonFamily<T> {
        public static final NullFamily INSTANCE = new NullFamily();

        protected NullFamily() {
        }

        @Override
        @Nullable
        public T get(@NotNull String name2) {
            if (name2 == null) {
                NullFamily.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        @Nullable
        public T get(@NotNull String name2, boolean caseSensitive) {
            if (name2 == null) {
                NullFamily.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Override
        @Nullable
        public T find(@NotNull Predicate<? super T> predicate) {
            if (predicate == null) {
                NullFamily.$$$reportNull$$$0(2);
            }
            return null;
        }

        @Override
        @Nullable
        public T getByNaturalPosition(short position) {
            return null;
        }

        @Override
        @Nullable
        public T get(@NotNull String name2, boolean caseSensitive, Predicate<? super T> predicate) {
            if (name2 == null) {
                NullFamily.$$$reportNull$$$0(3);
            }
            return null;
        }

        @Override
        public void markChildrenAsSyncPending() {
        }

        @Override
        public void removeSyncPendingChildren() {
        }

        @Override
        @Nullable
        public T getByObjectId(long id) {
            return null;
        }

        @Override
        @NotNull
        public BasicModModel getModel() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return "null-family";
        }

        @Override
        @NotNull
        public T first() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T last() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(@Nullable BasicElement element) {
            return -1;
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        @NotNull
        public BasicMetaObject<T> getMetaObject() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T createNewOne() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T createNewOne(@Nullable BasicDataObject data) {
            BasicModElement basicModElement = this.createNewOne();
            if (basicModElement == null) {
                NullFamily.$$$reportNull$$$0(4);
            }
            return (T)basicModElement;
        }

        @Override
        public void remove(@NotNull Predicate condition) {
            if (condition == null) {
                NullFamily.$$$reportNull$$$0(5);
            }
        }

        @Override
        public void sort() {
        }

        @Override
        public void clear() {
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            Iterator iterator = JBIterable.empty().iterator();
            if (iterator == null) {
                NullFamily.$$$reportNull$$$0(6);
            }
            return iterator;
        }

        @Override
        public T renewAt(short position, @NotNull String name2) {
            if (name2 == null) {
                NullFamily.$$$reportNull$$$0(7);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public T createOrGet(@NotNull String name2) {
            if (name2 == null) {
                NullFamily.$$$reportNull$$$0(8);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public T createOrGetAt(short position) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public T get() {
            return null;
        }

        @Override
        @NotNull
        public T createOrGet() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T renew(long objectId, String name2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T renew(long objectId, String name2, BiConsumer<T, String> renameHandler) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T createOrGet(long objectId) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$NullFamily";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$NullFamily";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "renewAt";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createOrGet";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 6 -> new IllegalStateException(string);
            };
        }
    }

    protected static class BaseNamingIdentifyingFamily<E extends BaseElement<?> & BasicModIdentifiedElement>
    extends BaseNamingFamily<E>
    implements ModNamingIdentifyingFamily<E> {
        public BaseNamingIdentifyingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public E renew(long objectId, @NotNull String string) {
            void name2;
            if (string == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(3);
            }
            BaseElement baseElement = this.renew(objectId, (String)name2, (E s, String s2) -> {});
            if (baseElement == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(4);
            }
            return (E)baseElement;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public E renew(long objectId, @NotNull String name2, @NotNull BiConsumer<E, String> biConsumer) {
            E e;
            if (name2 == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(5);
            }
            if (biConsumer == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(6);
            }
            if (objectId != Long.MIN_VALUE && (e = this.getByObjectId(objectId)) != null) {
                String oldName = ((BasicNamedElement)e).getName();
                ((BasicModNamedElement)e).setName(name2);
                ((BaseElement)e).resetSyncPending();
                String newName = ((BasicNamedElement)e).getName();
                if (!Objects.equals(oldName, newName)) {
                    void renameHandler;
                    renameHandler.accept(e, oldName);
                }
                E e2 = e;
                if (e2 == null) {
                    BaseNamingIdentifyingFamily.$$$reportNull$$$0(7);
                }
                return e2;
            }
            List elements = this.myElements;
            if (elements != null && StringUtil.isNotEmpty((String)name2)) {
                for (BaseElement e3 : elements) {
                    if (((BasicIdentifiedElement)((Object)e3)).getObjectId() != Long.MIN_VALUE || !((BasicNamedElement)((Object)e3)).getName().equals(name2)) continue;
                    ((BasicModIdentifiedElement)((Object)e3)).setObjectId(objectId);
                    e3.resetSyncPending();
                    BaseElement baseElement = e3;
                    if (baseElement == null) {
                        BaseNamingIdentifyingFamily.$$$reportNull$$$0(8);
                    }
                    return (E)baseElement;
                }
            }
            BaseElement e4 = this.createNewOne();
            ((BasicModIdentifiedElement)((Object)e4)).setObjectId(objectId);
            ((BasicModNamedElement)((Object)e4)).setName(name2);
            BaseElement baseElement = e4;
            if (baseElement == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(9);
            }
            return (E)baseElement;
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            Object e = BaseIdentifyingFamily.createOrGetImpl(objectId, this);
            if (e == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(10);
            }
            return e;
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            return BaseIdentifyingFamily.getByObjectIdImpl(objectId, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseNamingIdentifyingFamily";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renameHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseNamingIdentifyingFamily";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "renew";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "renew";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 7, 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static interface BasePositioningFamilyMixin<E extends BaseElement<?>>
    extends ModPositioningFamily<E> {
        @Override
        default public E createOrGetAt(short position) {
            List elements = ((BaseFamily)((Object)this)).myElements;
            if (elements == null) {
                BaseElement element = (BaseElement)this.createNewOne();
                ((BasicModArrangedElement)((Object)element)).setPosition(position);
                CopyOnWriteArrayList<BaseElement> newElements = new CopyOnWriteArrayList<BaseElement>();
                newElements.add(element);
                ((BaseFamily)((Object)this)).myElements = newElements;
                return (E)element;
            }
            for (BaseElement element : elements) {
                if (((BasicArrangedElement)((Object)element)).getPosition() != position) continue;
                element.resetSyncPending();
                return (E)element;
            }
            BaseElement element = (BaseElement)this.createNewOne();
            ((BasicModArrangedElement)((Object)element)).setPosition(position);
            return (E)element;
        }

        @Override
        @Nullable
        default public E getByNaturalPosition(short position) {
            List elements = ((BaseFamily)((Object)this)).myElements;
            return (E)BaseModel.findFirst(elements, e -> ((BasicArrangedElement)((Object)e)).getPosition() == position);
        }
    }

    protected static class BasePositioningNamingFamily<E extends BaseElement<? extends BasicModNamedElement> & BasicModNamedElement>
    extends BaseNamingFamily<E>
    implements ModPositioningNamingFamily<E>,
    BasePositioningFamilyMixin<E> {
        public BasePositioningNamingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        public E renewAt(short position, @NotNull String name2) {
            List elements;
            BaseElement e;
            if (name2 == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(3);
            }
            if ((e = BaseModel.findFirst(elements = this.myElements, x -> ((BasicArrangedElement)((Object)x)).getPosition() == position && ((BasicNamedElement)((Object)x)).getName().equals(name2))) != null) {
                e.resetSyncPending();
                return (E)e;
            }
            e = BaseModel.findFirst(elements, x -> ((BasicArrangedElement)((Object)x)).getPosition() == position && DasUtil.isNoName(((BasicNamedElement)((Object)x)).getName()));
            if (e != null) {
                ((BasicModNamedElement)((Object)e)).setName(name2);
                e.resetSyncPending();
                return (E)e;
            }
            if (!(position != 0 && name2.equals(ModelConsts.NO_NAME) || (e = BaseModel.findFirst(elements, x -> ((BasicArrangedElement)((Object)x)).getPosition() == 0 && ((BasicNamedElement)((Object)x)).getName().equals(name2))) == null)) {
                ((BasicModArrangedElement)((Object)e)).setPosition(position);
                e.resetSyncPending();
                return (E)e;
            }
            e = this.createNewOne();
            ((BasicModArrangedElement)((Object)e)).setPosition(position);
            ((BasicModNamedElement)((Object)e)).setName(name2);
            return (E)e;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/BaseModel$BasePositioningNamingFamily";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renewAt";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class BaseNamingFamily<E extends BaseElement<?>>
    extends BaseFamily<E>
    implements ModNamingFamily<E> {
        public BaseNamingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseNamingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseNamingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseNamingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        public E createOrGet(@NotNull String name2) {
            Object element;
            if (name2 == null) {
                BaseNamingFamily.$$$reportNull$$$0(3);
            }
            if ((element = this.get(name2)) == null) {
                element = this.createNewOne();
                ((BasicModNamedElement)element).setName(name2);
            } else {
                ((BaseElement)element).resetSyncPending();
            }
            return element;
        }

        @Override
        @Nullable
        public E get(@NotNull String name2) {
            if (name2 == null) {
                BaseNamingFamily.$$$reportNull$$$0(4);
            }
            return this.get(name2, true);
        }

        @Override
        @Nullable
        public E get(@NotNull String name2, boolean caseSensitive) {
            if (name2 == null) {
                BaseNamingFamily.$$$reportNull$$$0(5);
            }
            return this.get(name2, caseSensitive, null);
        }

        @Override
        @Nullable
        public E get(@NotNull String name2, boolean caseSensitive, @Nullable Predicate<? super E> predicate) {
            List elements;
            if (name2 == null) {
                BaseNamingFamily.$$$reportNull$$$0(6);
            }
            if ((elements = this.myElements) == null) {
                return null;
            }
            for (BaseElement element : elements) {
                boolean matched;
                boolean bl = matched = caseSensitive ? ((BasicNamedElement)((Object)element)).getName().equals(name2) : ((BasicNamedElement)((Object)element)).getName().equalsIgnoreCase(name2);
                if (matched && predicate != null) {
                    matched = predicate.test(element);
                }
                if (!matched) continue;
                return (E)element;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/BaseModel$BaseNamingFamily";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createOrGet";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class BaseSingletonFamily<E extends BaseElement<?>>
    extends BaseFamily<E>
    implements ModSingletonFamily<E> {
        public BaseSingletonFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseSingletonFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseSingletonFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseSingletonFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        protected void actualRemove() {
            if (this.myElements != null && ((BaseElement)this.myElements.get(0)).isDropped()) {
                this.myElements = null;
            }
        }

        @Override
        @Nullable
        public E get() {
            List elements = this.myElements;
            return (E)(elements == null ? null : (BaseElement)elements.get(0));
        }

        @Override
        @NotNull
        public E createNewOne(int entityId) {
            this.owner.modifying(false);
            assert (this.myElements == null);
            Object newOne = this.instantiate(entityId);
            ObjectNamePart oldParentName = ((BaseElement)newOne).affectsParentPath() ? BaseModel.computeNamePart(this.owner) : null;
            this.myElements = Collections.singletonList(newOne);
            if (oldParentName != null) {
                this.owner.handleRename(oldParentName);
            }
            this.getModel().doingObjectCreate((BaseElement<?>)newOne);
            Object e = newOne;
            if (e == null) {
                BaseSingletonFamily.$$$reportNull$$$0(3);
            }
            return e;
        }

        @Override
        @NotNull
        public E createOrGet() {
            if (this.isEmpty()) {
                BasicModElement basicModElement = this.createNewOne();
                if (basicModElement == null) {
                    BaseSingletonFamily.$$$reportNull$$$0(4);
                }
                return (E)basicModElement;
            }
            BasicElement first2 = this.first();
            ((BaseElement)first2).resetSyncPending();
            BasicElement basicElement = first2;
            if (basicElement == null) {
                BaseSingletonFamily.$$$reportNull$$$0(5);
            }
            return (E)basicElement;
        }

        @Override
        public void sort() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseSingletonFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseSingletonFamily";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    protected static class RootFamily<E extends BasicModRoot>
    implements SingletonFamily<E> {
        private final BaseModel myModel;
        private final E myRoot;

        public RootFamily(@NotNull BaseModel model, @NotNull E root) {
            if (model == null) {
                RootFamily.$$$reportNull$$$0(0);
            }
            if (root == null) {
                RootFamily.$$$reportNull$$$0(1);
            }
            this.myModel = model;
            this.myRoot = root;
        }

        @Override
        @Nullable
        public E find(@NotNull Predicate<? super E> predicate) {
            if (predicate == null) {
                RootFamily.$$$reportNull$$$0(2);
            }
            return predicate.test(this.myRoot) ? (E)this.myRoot : null;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.getMetaObject().kind.code();
            if (string == null) {
                RootFamily.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public BaseModel getModel() {
            return this.myModel;
        }

        @Override
        @NotNull
        public E first() {
            E e = this.myRoot;
            if (e == null) {
                RootFamily.$$$reportNull$$$0(4);
            }
            return e;
        }

        @Override
        @NotNull
        public E last() {
            E e = this.myRoot;
            if (e == null) {
                RootFamily.$$$reportNull$$$0(5);
            }
            return e;
        }

        @Override
        public int indexOf(@Nullable BasicElement element) {
            return element == this.myRoot ? 0 : -1;
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public BasicMetaObject<?> getMetaObject() {
            return ((BasicMetaModel)this.getModel().getMetaModel()).root;
        }

        @Override
        @Nullable
        public E get() {
            return this.myRoot;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return new SingletonIterator(this.myRoot);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$RootFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$RootFamily";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "first";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "last";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    @FunctionalInterface
    protected static interface BaseFactory<E extends BaseElement<?>> {
        public E create(BaseFamily<E> var1, int var2);
    }

    protected static abstract class BaseRegularElement<D extends BasicModElement>
    extends BaseElement<D> {
        private static final byte SYNC_PENDING = 1;
        private static final byte DROPPED = 2;
        private static final byte DROPPING = 4;
        @NotNull
        protected final BaseFamily<? extends BaseElement<D>> myParentFamily;
        private transient byte myFlags;

        public BaseRegularElement(@NotNull BaseFamily<? extends BaseElement<D>> parentFamily, int entityId) {
            if (parentFamily == null) {
                BaseRegularElement.$$$reportNull$$$0(0);
            }
            super(entityId);
            this.myParentFamily = parentFamily;
        }

        @NotNull
        public BaseFamily<? extends BaseElement<D>> getParentFamily() {
            BaseFamily<? extends BaseElement<D>> baseFamily = this.myParentFamily;
            if (baseFamily == null) {
                BaseRegularElement.$$$reportNull$$$0(1);
            }
            return baseFamily;
        }

        @Override
        @NotNull
        public BaseModel getModel() {
            BaseModel baseModel = this.myParentFamily.getModel();
            if (baseModel == null) {
                BaseRegularElement.$$$reportNull$$$0(2);
            }
            return baseModel;
        }

        @Override
        @NotNull
        public BasicMetaObject<D> getMetaObject() {
            BasicMetaObject<?> basicMetaObject = ((BaseFamily)this.getParentFamily()).getMetaObject();
            if (basicMetaObject == null) {
                BaseRegularElement.$$$reportNull$$$0(3);
            }
            return basicMetaObject;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
            this.myFlags = BitUtil.set((byte)this.myFlags, (byte)1, (boolean)syncPending);
        }

        @Override
        public boolean isSyncPending() {
            return BitUtil.isSet((byte)this.myFlags, (byte)1);
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            this.getModel().doingObjectRemove(this);
            this.myFlags = (byte)(this.myFlags | BitUtil.set((byte)this.myFlags, (byte)4, (boolean)true));
            BasicModMixinElement.dropChildren(this);
            if (removeFromParent) {
                ((BaseFamily)this.getParentFamily()).remove(e -> e == this);
            }
            this.myFlags = (byte)(this.myFlags | BitUtil.set((byte)BitUtil.set((byte)this.myFlags, (byte)4, (boolean)false), (byte)2, (boolean)true));
        }

        @Override
        public boolean isDropped() {
            return BitUtil.isSet((byte)this.myFlags, (byte)2);
        }

        @Override
        public boolean isBeingDropped() {
            return BitUtil.isSet((byte)this.myFlags, (byte)4);
        }

        public String toString() {
            return this.identity(true) + ": " + StringUtil.toLowerCase((String)this.getKind().name());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentFamily";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseRegularElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseRegularElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentFamily";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    protected static abstract class LightBaseRegularElement
    extends LightBaseElement {
        protected LightBaseRegularElement() {
        }

        public String toString() {
            return this.identity(true) + ": " + this.getKind().name().toLowerCase(Locale.ROOT);
        }
    }

    protected static abstract class LightBaseRoot
    extends LightBaseElement
    implements BasicModRoot {
        protected LightBaseRoot() {
        }

        @NotNull
        protected Dbms validateDbms(@NotNull Dbms dbms) {
            if (dbms == null) {
                LightBaseRoot.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication() != null && this.getMetaObject().getModel() != DbImplUtilCore.getMetaModel(dbms)) {
                throw new AssertionError((Object)(dbms.getName() + " does not match " + String.valueOf(this.getMetaObject().getModel().dbms)));
            }
            Dbms dbms2 = dbms;
            if (dbms2 == null) {
                LightBaseRoot.$$$reportNull$$$0(1);
            }
            return dbms2;
        }

        @Override
        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                LightBaseRoot.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        public BasicIntrospectableArea getParent() {
            return null;
        }

        public String toString() {
            return "ROOT";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$LightBaseRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$LightBaseRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validateDbms";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "validateDbms";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class LightBaseElement
    implements BasicDataObject,
    Cloneable {
        @Override
        public BasicDataObject copy() {
            try {
                LightBaseElement cloned = (LightBaseElement)this.clone();
                cloned.setStoredHashCode(0);
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                ExceptionUtil.rethrow((Throwable)e);
                return this;
            }
        }

        @Override
        @NotNull
        public String identity() {
            String string = this.identity(true);
            if (string == null) {
                LightBaseElement.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String identity(boolean includingSurrogate) {
            String string = this.identity(includingSurrogate, false, false);
            if (string == null) {
                LightBaseElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public final ObjectKind getKind() {
            ObjectKind objectKind = this.getMetaObject().kind;
            if (objectKind == null) {
                LightBaseElement.$$$reportNull$$$0(2);
            }
            return objectKind;
        }

        @Override
        @Nullable
        public BasicDatabase getDatabase() {
            return null;
        }

        @Override
        @Nullable
        public BasicSchema getSchema() {
            return null;
        }

        @Override
        @Nullable
        public Family<? extends BasicElement> getParentFamily() {
            return null;
        }

        @Override
        @Nullable
        public BasicElement getParent() {
            return null;
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        @NotNull
        public Iterable<? extends BasicElement> getPredecessors() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                LightBaseElement.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @Override
        public boolean isFrozen() {
            return this.getStoredHashCode() != 0;
        }

        @Override
        public boolean freeze() {
            int hashCode = BasicMetaUtils.hashCode(this);
            assert (hashCode != 0);
            this.setStoredHashCode(hashCode);
            return true;
        }

        protected abstract void setStoredHashCode(int var1);

        private Map<BasicMetaPropertyId<?>, Object> _properties() {
            return new AbstractMap<BasicMetaPropertyId<?>, Object>(){
                private final Set<Map.Entry<BasicMetaPropertyId<?>, Object>> myEntries = new HashSet();
                {
                    final LightBaseElement obj2 = this;
                    for (final BasicMetaProperty property : BasicMetaUtils.getMetaObject(obj2).getAllProperties()) {
                        this.myEntries.add(new Map.Entry<BasicMetaPropertyId<?>, Object>(){

                            @Override
                            public BasicMetaPropertyId<?> getKey() {
                                return property.id;
                            }

                            @Override
                            public Object getValue() {
                                return property.get(obj2);
                            }

                            @Override
                            public Object setValue(Object value) {
                                Object prev2 = this.getValue();
                                property.set(obj2, value);
                                return prev2;
                            }
                        });
                    }
                }

                @Override
                @NotNull
                public Set<Map.Entry<BasicMetaPropertyId<?>, Object>> entrySet() {
                    Set<Map.Entry<BasicMetaPropertyId<?>, Object>> set = this.myEntries;
                    if (set == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return set;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/BaseModel$LightBaseElement$1", "entrySet"));
                }
            };
        }

        protected void checkFrozen() {
            if (this.isFrozen()) {
                throw new UnsupportedOperationException(this.getName() + ":" + this.getKind().code() + " is frozen!");
            }
        }

        @Override
        public void drop() {
            throw new UnsupportedOperationException("Light object");
        }

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public void resetSyncPending() {
        }

        @Override
        @Nullable
        public BasicModModel getModel() {
            return null;
        }

        @Override
        @NotNull
        public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
            List list = Collections.emptyList();
            if (list == null) {
                LightBaseElement.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        @NotNull
        public JBIterable<? extends BasicModElement> getChildren() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                LightBaseElement.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public JBIterable<? extends BasicModElement> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                LightBaseElement.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        @Override
        public @Nullable ModFamily<? extends @NotNull BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                LightBaseElement.$$$reportNull$$$0(7);
            }
            return null;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
        }

        @Override
        public boolean isSyncPending() {
            return false;
        }

        @Override
        public void setOutdated(boolean outdated) {
        }

        @Override
        public boolean isOutdated() {
            return false;
        }

        @Override
        public boolean isDropped() {
            return false;
        }

        @Override
        public boolean isBeingDropped() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$LightBaseElement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "identity";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPredecessors";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilies";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$LightBaseElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "familyOf";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

