/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.liveTemplates.macros;

import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.database.liveTemplates.macros.DbContextMacroBase;
import com.intellij.database.model.DasColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/database/liveTemplates/macros/DbColumnsMacro;", "Lcom/intellij/database/liveTemplates/macros/DbContextMacroBase;", "<init>", "()V", "getName", "", "calcResultFromDbContext", "Lcom/intellij/codeInsight/template/Result;", "target", "Lcom/intellij/database/psi/DbElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.database.impl"})
public final class DbColumnsMacro
extends DbContextMacroBase {
    @NotNull
    public String getName() {
        return "dbColumns";
    }

    @Override
    @NotNull
    protected Result calcResultFromDbContext(@NotNull DbElement target2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project = target2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor2.getDocument());
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(target2);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        SqlLanguageDialect dialect = sqlLanguageDialect;
        DdlBuilder ddlBuilder = new DdlBuilder().applyCodeStyle(project2, dialect);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"applyCodeStyle(...)");
        DdlBuilder builder = ddlBuilder;
        if (psiFile != null) {
            builder.configureBuilder(SqlCodeStyles.getSqlSettings(psiFile));
        }
        SqlEditorOptions sqlEditorOptions = SqlEditorOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)sqlEditorOptions, (String)"getInstance(...)");
        SqlEditorOptions options = sqlEditorOptions;
        SqlEditorOptions.QualificationType qualificationType = options.getTableQualification().and(options.getLiveTemplateQualification());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)qualificationType), (String)"and(...)");
        SqlEditorOptions.QualificationType qualification = qualificationType;
        boolean shouldQualify = qualification.shouldQualify(1);
        Iterator iterator = ((Iterable)DasUtil.getColumns(target2)).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            DasColumn column2 = (DasColumn)iterator.next();
            if (index > 0) {
                builder.symbol(", ");
            }
            if (shouldQualify) {
                builder.identifier(target2, target2.getName()).symbol(".");
            }
            builder.identifier(column2, column2.getName());
        }
        return (Result)new TextResult(builder.getStatement());
    }
}

