/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.FixWithProgress;
import com.intellij.database.dialects.sqlite.SqliteUtilsKt;
import com.intellij.database.dialects.sqlite.model.SqliteConfigValidator;
import com.intellij.database.util.common.StringFun;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/sqlite/model/SqliteConfigValidator;", "Lcom/intellij/database/dataSource/validation/DatabaseConfigValidator;", "Lcom/intellij/database/dataSource/LocalDataSource;", "<init>", "()V", "getTargetClass", "Ljava/lang/Class;", "collectProblems", "", "project", "Lcom/intellij/openapi/project/Project;", "target", "problems", "Lcom/intellij/util/Consumer;", "Lcom/intellij/database/dataSource/validation/DataSourceProblem;", "configInfoProvider", "Lcom/intellij/database/view/ui/ActualConfigInfoProvider;", "intellij.database.dialects.sqlite.ex"})
public final class SqliteConfigValidator
extends DatabaseConfigValidator<LocalDataSource> {
    @Override
    @NotNull
    public Class<LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target2, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        if (SqliteUtilsKt.isLockableSqliteUnderWSL(target2)) {
            String string = DatabaseBundle.message("sqlite.wsl.sqlite.fix.wsl.url", new Object[0]);
            DataSourceProblem hint2 = new DataSourceProblem(this, null, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(DatabaseBundle.message("sqlite.wsl.notification.title", new Object[0]), DatabaseBundle.message("sqlite.wsl.notification.description", new Object[0]), DatabaseBundle.message("sqlite.wsl.notification.description", new Object[0]), new Object[0]), new FixWithProgress(target2, string){
                final /* synthetic */ LocalDataSource $target;
                {
                    this.$target = $target;
                    super($super_call_param$1);
                }

                public void run(ProgressIndicator indicator, DatabaseConfigEditor editor2) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ApplicationManager.getApplication().invokeAndWait(() -> collectProblems.hint.1.run$lambda$0(editor2, this.$target));
                }

                private static final void run$lambda$0(DatabaseConfigEditor $editor, LocalDataSource $target) {
                    if ($editor == null) {
                        return;
                    }
                    DataSourceConfigurable dataSourceConfigurable = $editor.getConfigurable($target, true, DataSourceConfigurable.class);
                    if (dataSourceConfigurable == null) {
                        return;
                    }
                    DataSourceConfigurable configurable = dataSourceConfigurable;
                    UrlEditorModel urlEditorModel = configurable.getUrlEditor().getEditorModel();
                    Intrinsics.checkNotNullExpressionValue((Object)urlEditorModel, (String)"getEditorModel(...)");
                    UrlEditorModel model = urlEditorModel;
                    String string = model.getParameter("file");
                    if (string == null) {
                        return;
                    }
                    String file = string;
                    file = StringFun.prefixWith(file, "file:");
                    model.setParameter("file", file);
                    model.setParameter("NOLOCK", "1");
                    model.commit(true);
                    $editor.onDataSourceUpdated($target);
                }
            });
            problems.consume((Object)hint2);
        }
    }
}

