/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.spark;

import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.hivebase.HiveDialectBase;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import org.jetbrains.annotations.NotNull;

public abstract class SparkDialectBase
extends HiveDialectBase {
    public SparkDialectBase() {
        super(new TypeHelper.HiveTypeHelper());
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            SparkDialectBase.$$$reportNull$$$0(0);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA && current.kind != ObjectKind.DATABASE) {
            return null;
        }
        NamingService namingService = this.getNamingService();
        String qualifier = current.parent != null && current.parent.kind == ObjectKind.DATABASE ? namingService.catToScript(current.parent.name, ObjectKind.DATABASE, this.getCodeStyle().getQuotesPriority()) : null;
        String schema = namingService.catToScript(current.name, current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", qualifier == null ? schema : qualifier + "." + schema);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dialects/spark/SparkDialectBase", "sqlSetSearchPath"));
    }
}

