/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.redshift.model.RsExternalTable;
import com.intellij.database.dialects.redshift.model.properties.RsExternalTableStorageType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.util.Version;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u000e\u0018\u00010\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J4\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/redshift/model/RsModelHelper;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "<init>", "()V", "sequenceTypeSince", "Lcom/intellij/database/util/Version;", "getSequenceTypeSince", "()Lcom/intellij/database/util/Version;", "getCustomName", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/Nullable;", "kind", "Lcom/intellij/database/model/ObjectKind;", "plural", "", "getSyntheticColumnNameByPosition", "position", "", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "vars", "", "modifyParent", "intellij.database.dialects.redshift"})
@SourceDebugExtension(value={"SMAP\nRsModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsModelHelper.kt\ncom/intellij/database/dialects/redshift/model/RsModelHelper\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,49:1\n18#2:50\n18#2:51\n*S KotlinDebug\n*F\n+ 1 RsModelHelper.kt\ncom/intellij/database/dialects/redshift/model/RsModelHelper\n*L\n18#1:50\n19#1:51\n*E\n"})
public final class RsModelHelper
extends PgBaseModelHelper {
    @NotNull
    public static final RsModelHelper INSTANCE = new RsModelHelper();
    @NotNull
    private static final Version sequenceTypeSince;

    private RsModelHelper() {
    }

    @Override
    @NotNull
    public Version getSequenceTypeSince() {
        return sequenceTypeSince;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getCustomName(@NotNull ObjectKind kind, boolean plural) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE)) {
            int _true_$iv;
            void $this$choose$iv;
            Object[] objectArray = new Object[1];
            boolean bl = plural;
            int n = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv != false ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message("CustomObjectKind.external.table", objectArray);
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_FUNCTION)) {
            Object[] objectArray = new Object[1];
            boolean $this$choose$iv = plural;
            int _true_$iv = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message("CustomObjectKind.external.function", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getSyntheticColumnNameByPosition(short position) {
        return switch (position) {
            case -1 -> "ctid";
            case -2 -> "oid";
            case -3 -> "xmin";
            case -4 -> "cmin";
            case -5 -> "xmax";
            case -6 -> "cmax";
            case -7 -> "tableoid";
            default -> super.getSyntheticColumnNameByPosition(position);
        };
    }

    @Override
    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars, modifyParent);
        if (e instanceof RsExternalTable) {
            if (modifyParent) {
                this.setTemplateName(((RsExternalTable)e).getSchema(), "schema_name");
            }
            vars.put(((RsExternalTable)e).getName(), "schema_name." + ((RsExternalTable)e).getName());
            ((RsExternalTable)e).setStorageType(RsExternalTableStorageType.PARQUET);
            vars.put("storage_type", "parquet");
            ((RsExternalTable)e).setSerializationLib("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
            vars.put("serialisation_lib", ScriptGeneratorHelperKt.getSqlString("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"));
        }
    }

    static {
        Version version = Version.INFINITY;
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"INFINITY");
        sequenceTypeSince = version;
    }
}

