/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.model;

import com.intellij.database.dialects.redshift.model.RsTable;
import com.intellij.database.dialects.redshift.model.RsTableColumn;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0002\u00a8\u0006\b"}, d2={"isDefaultEncoding", "", "Lcom/intellij/database/dialects/redshift/model/RsTableColumn;", "hasInterleavedSortKey", "Lcom/intellij/database/dialects/redshift/model/RsTable;", "isRaw", "isLzo", "isRawEncodingDataType", "intellij.database.dialects.redshift"})
@SourceDebugExtension(value={"SMAP\nRsModelFun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsModelFun.kt\ncom/intellij/database/dialects/redshift/model/RsModelFunKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,26:1\n1#2:27\n*E\n"})
public final class RsModelFunKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDefaultEncoding(@NotNull RsTableColumn $this$isDefaultEncoding) {
        Intrinsics.checkNotNullParameter((Object)$this$isDefaultEncoding, (String)"<this>");
        if ($this$isDefaultEncoding.getTable() == null) return true;
        if (Intrinsics.areEqual((Object)$this$isDefaultEncoding.getEncoding(), (Object)"none")) return true;
        if ($this$isDefaultEncoding.getEncoding() == null) {
            return true;
        }
        if (RsModelFunKt.isRaw($this$isDefaultEncoding)) {
            RsTable rsTable = $this$isDefaultEncoding.getTable();
            Intrinsics.checkNotNull((Object)rsTable);
            if (rsTable.isTemporary()) return true;
            if ($this$isDefaultEncoding.getSortKeyOrder() != 0) return true;
            if (RsModelFunKt.isRawEncodingDataType($this$isDefaultEncoding)) return true;
        }
        if (!RsModelFunKt.isLzo($this$isDefaultEncoding)) return false;
        return true;
    }

    public static final boolean hasInterleavedSortKey(@NotNull RsTable $this$hasInterleavedSortKey) {
        Intrinsics.checkNotNullParameter((Object)$this$hasInterleavedSortKey, (String)"<this>");
        PositioningNamingFamily positioningNamingFamily = $this$hasInterleavedSortKey.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
        Integer minOrder = (Integer)SequencesKt.minOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)positioningNamingFamily), RsModelFunKt::hasInterleavedSortKey$lambda$0));
        return minOrder != null && minOrder < 0;
    }

    private static final boolean isRaw(RsTableColumn $this$isRaw) {
        return Intrinsics.areEqual((Object)$this$isRaw.getEncoding(), (Object)"raw");
    }

    private static final boolean isLzo(RsTableColumn $this$isLzo) {
        return Intrinsics.areEqual((Object)$this$isLzo.getEncoding(), (Object)"lzo");
    }

    private static final boolean isRawEncodingDataType(RsTableColumn $this$isRawEncodingDataType) {
        Object v2;
        block1: {
            Object[] objectArray = new String[]{"boolean", "double precision", "real"};
            Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                CharSequence charSequence = it;
                DasType dasType = $this$isRawEncodingDataType.getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                if (!StringUtil.equalsIgnoreCase((CharSequence)charSequence, (CharSequence)DasTypeUtilsKt.getTypeName(dasType))) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2 != null;
    }

    private static final int hasInterleavedSortKey$lambda$0(RsTableColumn it) {
        return it.getSortKeyOrder();
    }
}

