/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.testing.utplsql.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.coverage.SuccessCoverageLoadingResult;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dialects.base.DataSourceRunConfigurationOptions;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlRunConfiguration;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlRunConfigurationOptions;
import com.intellij.database.dialects.oracle.testing.utplsql.coverage.UtPlSqlCoverageEngine;
import com.intellij.database.dialects.oracle.testing.utplsql.coverage.UtPlSqlCoverageRunnerKt;
import com.intellij.database.dialects.oracle.testing.utplsql.coverage.UtPlSqlCoverageSuite;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Function;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/coverage/UtPlSqlCoverageRunner;", "Lcom/intellij/coverage/CoverageRunner;", "<init>", "()V", "getPresentableName", "", "getDataFileExtension", "getId", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "loadCoverageData", "Lcom/intellij/coverage/CoverageLoadingResult;", "sessionDataFile", "Ljava/io/File;", "baseCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "reporter", "Lcom/intellij/coverage/CoverageLoadErrorReporter;", "loadData", "Lcom/intellij/rt/coverage/data/ProjectData;", "json", "Lorg/codehaus/jettison/json/JSONObject;", "suite", "Lcom/intellij/database/dialects/oracle/testing/utplsql/coverage/UtPlSqlCoverageSuite;", "extractFilePath", "objName", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nUtPlSqlCoverageRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UtPlSqlCoverageRunner.kt\ncom/intellij/database/dialects/oracle/testing/utplsql/coverage/UtPlSqlCoverageRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,347:1\n1869#2:348\n1869#2,2:349\n1870#2:355\n37#3:351\n36#3,3:352\n*S KotlinDebug\n*F\n+ 1 UtPlSqlCoverageRunner.kt\ncom/intellij/database/dialects/oracle/testing/utplsql/coverage/UtPlSqlCoverageRunner\n*L\n92#1:348\n96#1:349,2\n92#1:355\n108#1:351\n108#1:352,3\n*E\n"})
public final class UtPlSqlCoverageRunner
extends CoverageRunner {
    @NotNull
    public String getPresentableName() {
        return "utPLSQL";
    }

    @NotNull
    public String getDataFileExtension() {
        return "json";
    }

    @NotNull
    public String getId() {
        return "utPlSqlCoverageRunner";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine instanceof UtPlSqlCoverageEngine;
    }

    @NotNull
    protected CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        CoverageLoadingResult coverageLoadingResult;
        Intrinsics.checkNotNullParameter((Object)sessionDataFile, (String)"sessionDataFile");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        try {
            if (!(baseCoverageSuite instanceof UtPlSqlCoverageSuite)) {
                Object object = baseCoverageSuite;
                String message = "Wrong suite type: Expected UtPlSql coverage suite, got " + (object != null && (object = object.getClass()) != null ? ((Class)object).getName() : null);
                return (CoverageLoadingResult)new FailedCoverageLoadingResult(message);
            }
            JSONObject json = new JSONObject(new JSONTokener(FileUtil.loadFile((File)sessionDataFile)));
            coverageLoadingResult = (CoverageLoadingResult)new SuccessCoverageLoadingResult(this.loadData(json, (UtPlSqlCoverageSuite)baseCoverageSuite, reporter));
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof CancellationException || exception instanceof ControlFlowException) {
                throw e;
            }
            UtPlSqlCoverageRunnerKt.access$getLOG$p().warn((Throwable)e);
            coverageLoadingResult = (CoverageLoadingResult)new FailedCoverageLoadingResult(e, true);
        }
        return coverageLoadingResult;
    }

    /*
     * WARNING - void declaration
     */
    private final ProjectData loadData(JSONObject json, UtPlSqlCoverageSuite suite, CoverageLoadErrorReporter reporter) {
        ProjectData res2 = new ProjectData();
        JSONArray files2 = json.getJSONArray("source_files");
        res2.getClasses();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)files2.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int idx = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            JSONObject file = files2.getJSONObject(idx);
            JSONArray coverage = file.getJSONArray("coverage");
            ArrayList<LineData> lines = new ArrayList<LineData>();
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)coverage.length());
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                void $this$loadData_u24lambda_u242_u24lambda_u241_u24lambda_u240;
                LineData lineData;
                int element$iv2;
                int ln = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                int ht = coverage.optInt(ln, -1);
                if (ht < 0) continue;
                LineData lineData2 = lineData = new LineData(ln + 1, null);
                ArrayList<LineData> arrayList = lines;
                boolean bl3 = false;
                $this$loadData_u24lambda_u242_u24lambda_u241_u24lambda_u240.setHits(ht);
                arrayList.add(lineData);
            }
            String string = file.getString("name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String name2 = this.extractFilePath(string, suite, reporter);
            if (name2 == null) continue;
            ClassData classData = res2.getOrCreateClassData(name2);
            Collection $this$toTypedArray$iv = lines;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            classData.setLines(thisCollection$iv.toArray(new LineData[0]));
        }
        return res2;
    }

    private final String extractFilePath(String objName, UtPlSqlCoverageSuite suite, CoverageLoadErrorReporter reporter) {
        Object object = suite.getConfiguration();
        if (object == null || (object = (UtPlSqlRunConfigurationOptions)((Object)object.getState())) == null || (object = ((DataSourceRunConfigurationOptions)((Object)object)).getDataSourceId()) == null) {
            UtPlSqlCoverageRunner $this$extractFilePath_u24lambda_u243 = this;
            boolean bl = false;
            String message = "Could not find DB data source ID for given UtPlSql coverage suite";
            UtPlSqlCoverageRunnerKt.access$getLOG$p().warn(message);
            CoverageLoadErrorReporter.reportWarning$default((CoverageLoadErrorReporter)reporter, (String)message, null, (int)2, null);
            return null;
        }
        UtPlSqlRunConfiguration dsId = object;
        DbDataSource dbDataSource = DbPsiFacade.getInstance(suite.getProject()).findDataSource((String)((Object)dsId));
        if (dbDataSource == null) {
            UtPlSqlCoverageRunner $this$extractFilePath_u24lambda_u244 = this;
            boolean bl = false;
            String message = "Could not find DB data source with ID " + (String)((Object)dsId);
            UtPlSqlCoverageRunnerKt.access$getLOG$p().warn(message);
            CoverageLoadErrorReporter.reportWarning$default((CoverageLoadErrorReporter)reporter, (String)message, null, (int)2, null);
            return null;
        }
        DbDataSource dataSource = dbDataSource;
        BasicSourceAware obj2 = (BasicSourceAware)QNameUtil.findByQName(dataSource.getModel(), objName, (Function<? super DasObject, String>)((Function)arg_0 -> UtPlSqlCoverageRunner.extractFilePath$lambda$6(UtPlSqlCoverageRunner::extractFilePath$lambda$5, arg_0))).filterMap(arg_0 -> UtPlSqlCoverageRunner.extractFilePath$lambda$8(UtPlSqlCoverageRunner::extractFilePath$lambda$7, arg_0)).filter(BasicSourceAware.class).first();
        Project project = suite.getProject();
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource(dataSource);
        Intrinsics.checkNotNull((Object)localDataSource);
        return DbSrcUtils.getPath(project, localDataSource, obj2, dataSource.getModel(), DbSrcFileSystemCore.ItemType.SRC);
    }

    private static final String extractFilePath$lambda$5(DasObject it) {
        return StringUtil.toLowerCase((String)it.getName());
    }

    private static final String extractFilePath$lambda$6(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final DasObject extractFilePath$lambda$7(DasObject it) {
        ObjectKind objectKind = it.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.PACKAGE) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE) ? (DasObject)it.getDasChildren(ObjectKind.BODY).first() : it;
    }

    private static final DasObject extractFilePath$lambda$8(Function1 $tmp0, Object p0) {
        return (DasObject)$tmp0.invoke(p0);
    }
}

