/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.debugger.SqlProgramSource;
import com.intellij.database.debugger.SqlVariable;
import com.intellij.database.debugger.SqlVariableKind;
import com.intellij.database.dialects.oracle.debugger.OraProgram;
import com.intellij.database.dialects.oracle.debugger.OracleDebugHelper;
import com.intellij.database.dialects.oracle.generator.OraNamingService;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a.\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001j\u0004\u0018\u0001`\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00012\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a(\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001j\u0004\u0018\u0001`\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0002\u001a(\u0010\u0015\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0002\u001a&\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0002\u001aX\u0010\u001c\u001a\u0004\u0018\u00010\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u001e2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\u001b2\b\b\u0002\u0010'\u001a\u00020\u001eH\u0002\u001a \u0010(\u001a\n\u0012\u0004\u0012\u0002H)\u0018\u00010\u0001\"\u0004\b\u0000\u0010)*\b\u0012\u0004\u0012\u0002H)0\u0001H\u0002\u00a8\u0006*"}, d2={"findVariables", "", "Lcom/intellij/database/debugger/SqlVariable;", "Lcom/intellij/database/debugger/SqlVariables;", "programSource", "Lcom/intellij/database/debugger/SqlProgramSource;", "program", "Lcom/intellij/database/dialects/oracle/debugger/OraProgram;", "lineNr", "", "glueRight", "Lcom/intellij/psi/PsiElement;", "element", "findEnclosingBlocks", "Lcom/intellij/sql/psi/SqlBlockStatement;", "peekVariablesFromRoutine", "", "routineDefinition", "Lcom/intellij/sql/psi/impl/SqlProcedureDefinitionImpl;", "list", "", "peekFieldsFromPackage", "packageDefinition", "Lcom/intellij/sql/psi/SqlCreateStatement;", "peekVariablesFromBlock", "block", "variableKind", "Lcom/intellij/database/debugger/SqlVariableKind;", "prepareVariable", "name", "", "packageName", "schemaName", "dasType", "Lcom/intellij/database/types/DasType;", "direction", "Lcom/intellij/database/model/ArgumentDirection;", "kind", "rootKind", "prefix", "orNull", "E", "intellij.database.dialects.oracle.ex"})
@JvmName(name="OraVariableFinderFun")
@SourceDebugExtension(value={"SMAP\nOraVariableFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraVariableFinder.kt\ncom/intellij/database/dialects/oracle/debugger/OraVariableFinderFun\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1869#2,2:167\n1869#2,2:169\n*S KotlinDebug\n*F\n+ 1 OraVariableFinder.kt\ncom/intellij/database/dialects/oracle/debugger/OraVariableFinderFun\n*L\n119#1:167,2\n128#1:169,2\n*E\n"})
public final class OraVariableFinderFun {
    @Nullable
    public static final List<SqlVariable> findVariables(@NotNull SqlProgramSource programSource, @Nullable OraProgram program, int lineNr) {
        Intrinsics.checkNotNullParameter((Object)programSource, (String)"programSource");
        PsiFile psiFile = programSource.getPsiFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        return (List)OracleDebugHelper.inReadAction(() -> OraVariableFinderFun.findVariables$lambda$0(programSource, lineNr, file, program));
    }

    private static final PsiElement glueRight(PsiElement element) {
        PsiElement next;
        if (element instanceof PsiWhiteSpace && (next = ((PsiWhiteSpace)element).getNextSibling()) != null) {
            return next;
        }
        return element;
    }

    private static final List<SqlBlockStatement> findEnclosingBlocks(PsiElement element) {
        ArrayList blocks = new ArrayList(8);
        for (PsiElement el = element; el != null; el = el.getParent()) {
            if (el instanceof SqlBlockStatement) {
                ((Collection)blocks).add(el);
            }
            if (el instanceof PsiFile) break;
        }
        if (blocks.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        CollectionsKt.reverse((List)blocks);
        return blocks;
    }

    private static final List<SqlVariable> findVariables(OraProgram program, PsiElement element) {
        List list = new ArrayList();
        for (PsiElement elem = element; elem != null; elem = elem.getParent()) {
            PsiElement psiElement = elem;
            if (psiElement instanceof SqlBlockStatement) {
                OraVariableFinderFun.peekVariablesFromBlock(elem, SqlVariableKind.LOCAL, list);
                continue;
            }
            if (psiElement instanceof SqlProcedureDefinitionImpl) {
                OraVariableFinderFun.peekVariablesFromRoutine((SqlProcedureDefinitionImpl)elem, list);
                break;
            }
            if (!(psiElement instanceof SqlCreateStatement)) continue;
            OraVariableFinderFun.peekFieldsFromPackage(program, (SqlCreateStatement)elem, list);
            break;
        }
        return !((Collection)list).isEmpty() ? list : null;
    }

    private static final void peekVariablesFromRoutine(SqlProcedureDefinitionImpl routineDefinition, List<SqlVariable> list) {
        Iterable<SqlParameterDefinition> iterable = routineDefinition.getArguments();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getArguments(...)");
        Iterable<SqlParameterDefinition> arguments = iterable;
        for (SqlParameterDefinition argument : arguments) {
            SqlVariable variable = OraVariableFinderFun.prepareVariable$default(argument.getName(), null, null, argument.getDasType(), argument.getArgumentDirection(), SqlVariableKind.ARG, null, null, 192, null);
            if (variable == null) continue;
            ((Collection)list).add(variable);
        }
        OraVariableFinderFun.peekVariablesFromBlock(routineDefinition, SqlVariableKind.LOCAL, list);
    }

    private static final void peekFieldsFromPackage(OraProgram program, SqlCreateStatement packageDefinition, List<SqlVariable> list) {
        JBIterable jBIterable = SqlImplUtil.sqlChildren(packageDefinition).filter(SqlVariableDefinition.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlVariableDefinition it = (SqlVariableDefinition)element$iv;
            boolean bl = false;
            OraProgram oraProgram = program;
            OraProgram oraProgram2 = program;
            SqlVariable variable = OraVariableFinderFun.prepareVariable$default(it.getName(), oraProgram != null ? oraProgram.getProgramName() : null, oraProgram2 != null ? oraProgram2.getSchemaName() : null, it.getDasType(), null, SqlVariableKind.FIELD, null, null, 192, null);
            if (variable == null) continue;
            ((Collection)list).add(variable);
        }
    }

    private static final void peekVariablesFromBlock(PsiElement block, SqlVariableKind variableKind, List<SqlVariable> list) {
        JBIterable jBIterable = SqlImplUtil.sqlChildren(block).filter(SqlVariableDefinition.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlVariableDefinition it = (SqlVariableDefinition)element$iv;
            boolean bl = false;
            SqlVariable variable = OraVariableFinderFun.prepareVariable$default(it.getName(), null, null, it.getDasType(), null, variableKind, null, null, 192, null);
            if (variable == null) continue;
            ((Collection)list).add(variable);
        }
    }

    private static final SqlVariable prepareVariable(String name2, String packageName, String schemaName, DasType dasType, ArgumentDirection direction, SqlVariableKind kind, SqlVariableKind rootKind, String prefix) {
        int n;
        CharSequence charSequence = name2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || dasType == null) {
            return null;
        }
        String qname = prefix + OraNamingService.INSTANCE.catToScript(name2, ObjectKind.VARIABLE, true);
        ArrayList<SqlVariable> fields = null;
        if (dasType instanceof DasTableType && (n = ((DasTableType)dasType).getColumnCount()) > 0) {
            fields = new ArrayList<SqlVariable>(n);
            for (int i2 = 0; i2 < n; ++i2) {
                DasType innerType;
                String innerName = ((DasTableType)dasType).getColumnName(i2);
                SqlVariable innerVariable = OraVariableFinderFun.prepareVariable(innerName, packageName, schemaName, innerType = ((DasTableType)dasType).getColumnDasType(i2), null, SqlVariableKind.FIELD, rootKind, qname + ".");
                if (innerVariable == null) continue;
                fields.add(innerVariable);
            }
        }
        ArrayList<SqlVariable> arrayList = fields;
        return new SqlVariable(name2, qname, packageName, schemaName, kind, rootKind, direction, dasType, arrayList != null ? OraVariableFinderFun.orNull((List)arrayList) : null);
    }

    static /* synthetic */ SqlVariable prepareVariable$default(String string, String string2, String string3, DasType dasType, ArgumentDirection argumentDirection, SqlVariableKind sqlVariableKind, SqlVariableKind sqlVariableKind2, String string4, int n, Object object) {
        if ((n & 0x40) != 0) {
            sqlVariableKind2 = sqlVariableKind;
        }
        if ((n & 0x80) != 0) {
            string4 = "";
        }
        return OraVariableFinderFun.prepareVariable(string, string2, string3, dasType, argumentDirection, sqlVariableKind, sqlVariableKind2, string4);
    }

    private static final <E> List<E> orNull(List<? extends E> $this$orNull) {
        return !((Collection)$this$orNull).isEmpty() ? $this$orNull : null;
    }

    private static final List findVariables$lambda$0(SqlProgramSource $programSource, int $lineNr, PsiFile $file, OraProgram $program) {
        int positionOffset = $programSource.getLineOffset($lineNr);
        PsiElement psiElement = $file.findElementAt(positionOffset);
        if (psiElement == null) {
            return null;
        }
        PsiElement positionElement = psiElement;
        positionElement = OraVariableFinderFun.glueRight(positionElement);
        return OraVariableFinderFun.findVariables($program, positionElement);
    }

    public static final /* synthetic */ PsiElement access$glueRight(PsiElement element) {
        return OraVariableFinderFun.glueRight(element);
    }

    public static final /* synthetic */ List access$findEnclosingBlocks(PsiElement element) {
        return OraVariableFinderFun.findEnclosingBlocks(element);
    }

    public static final /* synthetic */ void access$peekVariablesFromBlock(PsiElement block, SqlVariableKind variableKind, List list) {
        OraVariableFinderFun.peekVariablesFromBlock(block, variableKind, list);
    }
}

