/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.properties.CompositeText;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0007J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0007J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraProgramLineMapper;", "", "<init>", "()V", "skips", "Ljava/util/WeakHashMap;", "Lcom/intellij/database/model/basic/BasicSourceAware;", "", "lock", "Ljava/lang/Object;", "obtainSkip", "programObject", "calculateSkip", "calculateSkipForTrigger", "trigger", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "mapOraToFile", "oraLine", "mapOraToFileForTrigger", "mapOraToFileForRegularProgram", "mapFileToOra", "fileLine", "mapFileToOraForTrigger", "mapFileToOraForRegularProgram", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nOraProgramLineMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraProgramLineMapper.kt\ncom/intellij/database/dialects/oracle/debugger/OraProgramLineMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,88:1\n1#2:89\n1104#3,3:90\n*S KotlinDebug\n*F\n+ 1 OraProgramLineMapper.kt\ncom/intellij/database/dialects/oracle/debugger/OraProgramLineMapper\n*L\n35#1:90,3\n*E\n"})
public final class OraProgramLineMapper {
    @NotNull
    private final WeakHashMap<BasicSourceAware, Integer> skips = new WeakHashMap(4);
    @NotNull
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int obtainSkip(BasicSourceAware programObject) {
        int n;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Integer skip = this.skips.get(programObject);
            if (skip == null) {
                skip = this.calculateSkip(programObject);
                ((Map)this.skips).put(programObject, skip);
            }
            n = skip;
        }
        return n;
    }

    private final int calculateSkip(BasicSourceAware programObject) {
        return programObject instanceof OraTrigger ? this.calculateSkipForTrigger((OraTrigger)programObject) : 0;
    }

    private final int calculateSkipForTrigger(OraTrigger trigger2) {
        Object v1;
        CompositeText source;
        block4: {
            CompositeText compositeText = trigger2.getSourceText();
            if (compositeText == null) {
                return 0;
            }
            source = compositeText;
            Iterable iterable = source.getFragments();
            for (Object t : iterable) {
                CompositeText.Fragment it = (CompositeText.Fragment)t;
                boolean bl = false;
                if (!it.getKind().getContent()) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        CompositeText.Fragment fragment = v1;
        if (fragment == null) {
            return 0;
        }
        CompositeText.Fragment content = fragment;
        int offset = content.getBegin();
        CharSequence $this$count$iv = source.getText().subSequence(0, offset);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char c2 = element$iv = $this$count$iv.charAt(j);
            boolean bl = false;
            if (!(c2 == '\n')) continue;
            ++count$iv;
        }
        int lineBreaks = count$iv;
        return Integer.max(lineBreaks - 1, 0);
    }

    public final int mapOraToFile(@Nullable BasicSourceAware programObject, int oraLine) {
        if (oraLine <= 0) {
            return -1;
        }
        return programObject instanceof OraTrigger ? this.mapOraToFileForTrigger((OraTrigger)programObject, oraLine) : this.mapOraToFileForRegularProgram(oraLine);
    }

    private final int mapOraToFileForTrigger(OraTrigger trigger2, int oraLine) {
        if (oraLine == 1) {
            return 0;
        }
        int skipped = this.obtainSkip(trigger2);
        int shiftedLine = oraLine + skipped;
        return shiftedLine - 1;
    }

    private final int mapOraToFileForRegularProgram(int oraLine) {
        return oraLine - 1;
    }

    public final int mapFileToOra(@Nullable BasicSourceAware programObject, int fileLine) {
        if (fileLine < 0) {
            return 0;
        }
        return programObject instanceof OraTrigger ? this.mapFileToOraForTrigger((OraTrigger)programObject, fileLine) : this.mapFileToOraForRegularProgram(fileLine);
    }

    private final int mapFileToOraForTrigger(OraTrigger trigger2, int fileLine) {
        if (fileLine == 0) {
            return 1;
        }
        int skipped = this.obtainSkip(trigger2);
        int shiftedLine = Integer.max(fileLine - skipped, 1);
        return shiftedLine + 1;
    }

    private final int mapFileToOraForRegularProgram(int fileLine) {
        return fileLine + 1;
    }
}

