/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.util.ThreeState;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/mysqlbase/MysqlBaseExecutionEnvironmentHelper;", "Lcom/intellij/database/dialects/base/BaseExecutionEnvironmentHelper;", "<init>", "()V", "getSslState", "Lcom/intellij/util/ThreeState;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "getTimeZoneManager", "Lcom/intellij/database/console/ExecutionEnvironmentHelper$TimeZoneManager;", "MysqlBaseTimeZoneManager", "intellij.database.dialects.mysqlbase"})
@SourceDebugExtension(value={"SMAP\nMysqlBaseExecutionEnvironmentHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlBaseExecutionEnvironmentHelper.kt\ncom/intellij/database/dialects/mysqlbase/MysqlBaseExecutionEnvironmentHelper\n+ 2 StandardResultsProcessors.kt\ncom/intellij/database/dataSource/connection/statements/StandardResultsProcessors\n*L\n1#1,42:1\n149#2:43\n*S KotlinDebug\n*F\n+ 1 MysqlBaseExecutionEnvironmentHelper.kt\ncom/intellij/database/dialects/mysqlbase/MysqlBaseExecutionEnvironmentHelper\n*L\n14#1:43\n*E\n"})
public final class MysqlBaseExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @Override
    @NotNull
    public ThreeState getSslState(@NotNull DatabaseConnectionCore connection2) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        boolean $i$f$first = false;
        String sslVer = SmartStatementFactoryService.Companion.getInstance().poweredBy(connection2).simple().execute("show status like 'ssl_version'", (ExecutionMode)StandardExecutionMode.QUERY, new ResultsProducer.VoidReadyProcessor<String>(){

            public String empty() {
                Object rs = null;
                boolean bl = false;
                return null;
            }

            public String results(RemoteResultSet resultSet, int subQueryIndex, int resultSetIndex, ResultsProducer.ReferenceInfo referenceInfo, Function2<? super RemoteResultSet, ? super ResultsProducer.ReferenceInfo, Unit> referenceConsumer) {
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
                Intrinsics.checkNotNullParameter(referenceConsumer, (String)"referenceConsumer");
                RemoteResultSet rs = resultSet.next() ? resultSet : null;
                boolean bl = false;
                RemoteResultSet remoteResultSet = rs;
                return remoteResultSet != null ? remoteResultSet.getString(2) : null;
            }

            public String parameterResults(List<? extends OutParameter<?>> parameters, int subQueryIndex, int resultSetIndex, Function1<? super OutParameter<?>, ? extends Object> retriever) {
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter(retriever, (String)"retriever");
                Object rs = null;
                boolean bl = false;
                return null;
            }

            public String updateCount(int count) {
                Object rs = null;
                boolean bl = false;
                return null;
            }
        }).rightOr((Object)null);
        return sslVer == null ? ThreeState.UNSURE : (((CharSequence)sslVer).length() > 0 ? ThreeState.YES : ThreeState.NO);
    }

    @Override
    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        return MysqlBaseTimeZoneManager.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/mysqlbase/MysqlBaseExecutionEnvironmentHelper$MysqlBaseTimeZoneManager;", "Lcom/intellij/database/console/ExecutionEnvironmentHelper$TimeZoneManager;", "<init>", "()V", "canChange", "", "changeTimeZone", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "timeZone", "", "intellij.database.dialects.mysqlbase"})
    public static final class MysqlBaseTimeZoneManager
    implements ExecutionEnvironmentHelper.TimeZoneManager {
        @NotNull
        public static final MysqlBaseTimeZoneManager INSTANCE = new MysqlBaseTimeZoneManager();

        private MysqlBaseTimeZoneManager() {
        }

        @Override
        public boolean canChange() {
            return true;
        }

        @Override
        public void changeTimeZone(@NotNull DatabaseConnectionCore connection2, @NotNull String timeZone) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
            BarrenStatement.QuietBarrenStatement<String> quietBarrenStatement = SmartStatementFactoryService.Companion.getInstance().poweredBy(connection2).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).barren().quiet();
            String string = "set session time_zone = '%s'";
            Object[] objectArray = new Object[]{timeZone};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            quietBarrenStatement.execute(string2);
        }
    }
}

