/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.introspector;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.mssql.introspector.ExtPropId;
import com.intellij.database.dialects.mssql.introspector.MsIntroQueries;
import com.intellij.database.dialects.mssql.introspector.PropertyClass;
import com.intellij.database.dialects.mssql.model.MsArgument;
import com.intellij.database.dialects.mssql.model.MsCustomType;
import com.intellij.database.dialects.mssql.model.MsDatabase;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsGrantsHolder;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsKey;
import com.intellij.database.dialects.mssql.model.MsLikeColumn;
import com.intellij.database.dialects.mssql.model.MsLikeTable;
import com.intellij.database.dialects.mssql.model.MsPrincipal;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsSchema;
import com.intellij.database.dialects.mssql.model.MsSchemaObject;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.MsTableTypeColumn;
import com.intellij.database.dialects.mssql.model.properties.MsObjectGrant;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicMixinColumniation;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00d6\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0002\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\f\u0010\n\u001a\u00020\u0007*\u00020\u0005H\u0002\u001a7\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\f0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002\u001a\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a \u0010\u001d\u001a\u00020\u0001*\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0002\u001a\u0012\u0010/\u001a\u0002002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0002\u001a*\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u00072\u0006\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u001cH\u0002\u001a\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001cH\u0002\u001a\u0012\u0010=\u001a\u0002002\b\u0010\u001b\u001a\u0004\u0018\u00010%H\u0002\u001aB\u0010@\u001a\u00020\u0001*\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u000e\u0010F\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010G2\u0014\u0010I\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020J0\u0004\u0018\u00010GH\u0002\u001a,\u0010K\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020M0L2\u0006\u0010N\u001a\u00020J2\b\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010B\u001a\u00020CH\u0002\"\u000e\u0010\"\u001a\u00020\u001cX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\u001cX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010$\u001a\u00020\u001c*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\"\u0018\u0010(\u001a\u00020)*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\"\u0016\u0010,\u001a\n .*\u0004\u0018\u00010-0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0019\u00107\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b908X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010>\u001a\u00020?X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"setExtProps", "", "Lcom/intellij/database/dialects/mssql/model/MsExtendedPropertiesHolder;", "props", "", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneProperty;", "comment", "", "properties", "Lcom/intellij/database/model/NameValueType;", "asLiteral", "renewType", "T", "Lcom/intellij/database/dialects/mssql/model/MsCustomType;", "family", "Lcom/intellij/database/model/families/ModNamingFamily;", "typeId", "", "name", "(Lcom/intellij/database/model/families/ModNamingFamily;ILjava/lang/String;)Lcom/intellij/database/dialects/mssql/model/MsCustomType;", "findKeyByColumns", "Lcom/intellij/database/dialects/mssql/model/MsKey;", "Lcom/intellij/database/dialects/mssql/model/MsTable;", "names", "unpackEvents", "", "Lcom/intellij/database/model/TrigEvent;", "e", "", "setCreatedAndModifiedTimestamps", "Lcom/intellij/database/dialects/mssql/model/MsSchemaObject;", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "ALIAS_TYPE_KIND", "TABLE_TYPE_KIND", "extendedPropertyClassCode", "Lcom/intellij/database/model/basic/BasicElement;", "getExtendedPropertyClassCode", "(Lcom/intellij/database/model/basic/BasicElement;)B", "extendedPropertyId", "Lcom/intellij/database/dialects/mssql/introspector/ExtPropId;", "getExtendedPropertyId", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/dialects/mssql/introspector/ExtPropId;", "SURROGATE_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "detectSurrogateName", "", "makeDasType", "Lcom/intellij/database/types/DasType;", "type_name", "max_length", "precision", "scale", "VARIABLE_TYPES", "Lcom/google/common/collect/ImmutableSet;", "Lkotlin/jvm/internal/EnhancedNullability;", "makeCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "code", "canCheckOutdated", "FULLTEXT_INDEX_POSITION", "", "retrievePermissions", "Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext;", "obj", "Lcom/intellij/database/dialects/mssql/model/MsGrantsHolder;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "checkSumQuery", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "grantsQuery", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OnePermission;", "addGrant", "", "Lcom/intellij/database/dialects/mssql/model/properties/MsObjectGrant;", "p", "columns", "Ljava/util/BitSet;", "typeNamesToQuote", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospectorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 NumberFun.kt\ncom/intellij/database/util/common/NumberFun\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,2781:1\n1#2:2782\n295#3,2:2783\n41#4:2785\n36#4:2786\n41#4:2787\n36#4:2788\n41#4:2789\n36#4:2790\n19#5:2791\n*S KotlinDebug\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospectorKt\n*L\n2539#1:2783,2\n2544#1:2785\n2544#1:2786\n2545#1:2787\n2545#1:2788\n2546#1:2789\n2546#1:2790\n2742#1:2791\n*E\n"})
public final class MsIntrospectorKt {
    private static final byte ALIAS_TYPE_KIND = 1;
    private static final byte TABLE_TYPE_KIND = 2;
    private static final Pattern SURROGATE_NAME_PATTERN = Pattern.compile("^\\s*\\w{2}\\S{2,18}__[\\dA-F]{8,16}\\s*$", 2);
    @NotNull
    private static final ImmutableSet<String> VARIABLE_TYPES;
    private static final short FULLTEXT_INDEX_POSITION = Short.MAX_VALUE;
    @NotNull
    private static final Set<String> typeNamesToQuote;

    private static final void setExtProps(MsExtendedPropertiesHolder $this$setExtProps, List<MsIntroQueries.OneProperty> props) {
        List<MsIntroQueries.OneProperty> list = props;
        $this$setExtProps.setComment(list != null ? MsIntrospectorKt.comment(list) : null);
        List<Object> list2 = props;
        if (list2 == null || (list2 = MsIntrospectorKt.properties(list2)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        $this$setExtProps.setExtendedProperties(list2);
    }

    private static final String comment(List<MsIntroQueries.OneProperty> $this$comment) {
        Object v0;
        block1: {
            Iterable iterable = $this$comment;
            for (Object t : iterable) {
                MsIntroQueries.OneProperty it = (MsIntroQueries.OneProperty)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.property_name, (Object)"MS_Description")) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        MsIntroQueries.OneProperty oneProperty = v0;
        return oneProperty != null ? oneProperty.value : null;
    }

    private static final List<NameValueType> properties(List<MsIntroQueries.OneProperty> $this$properties) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$properties), MsIntrospectorKt::properties$lambda$1), MsIntrospectorKt::properties$lambda$2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String asLiteral(MsIntroQueries.OneProperty $this$asLiteral) {
        Object object;
        String string;
        String sqlString;
        String string2 = $this$asLiteral.value;
        if (string2 == null || (string2 = ScriptGeneratorHelperKt.getSqlString(string2)) == null) {
            string2 = sqlString = "null";
        }
        if ((string = $this$asLiteral.type) != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -2000413939: {
                    if (!string.equals("numeric")) break;
                    n = 1;
                    break;
                }
                case -1312398097: {
                    if (!string.equals("tinyint")) break;
                    n = 1;
                    break;
                }
                case 1242798105: {
                    if (!string.equals("smallmoney")) break;
                    n = 1;
                    break;
                }
                case 3496350: {
                    if (!string.equals("real")) break;
                    n = 1;
                    break;
                }
                case 97526364: {
                    if (!string.equals("float")) break;
                    n = 1;
                    break;
                }
                case 104431: {
                    if (!string.equals("int")) break;
                    n = 1;
                    break;
                }
                case -275146264: {
                    if (!string.equals("varbinary")) break;
                    n = 2;
                    break;
                }
                case -606531192: {
                    if (!string.equals("smallint")) break;
                    n = 1;
                    break;
                }
                case -1327778097: {
                    if (!string.equals("nvarchar")) break;
                    n = 3;
                    break;
                }
                case 104079552: {
                    if (!string.equals("money")) break;
                    n = 1;
                    break;
                }
                case -1388966911: {
                    if (!string.equals("binary")) break;
                    n = 2;
                    break;
                }
                case 104639684: {
                    if (!string.equals("nchar")) break;
                    n = 3;
                    break;
                }
                case 1542263633: {
                    if (!string.equals("decimal")) break;
                    n = 1;
                    break;
                }
                case -1389167889: {
                    if (!string.equals("bigint")) break;
                    n = 1;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    object = sqlString;
                    return object;
                }
                case 3: {
                    String string3 = $this$asLiteral.value;
                    object = string3;
                    if (string3 == null) return "null";
                    String it = object;
                    boolean bl = false;
                    String string4 = "N" + sqlString;
                    object = string4;
                    if (string4 != null) return object;
                    return "null";
                }
                case 1: {
                    String string5 = $this$asLiteral.value;
                    object = string5;
                    if (string5 != null) return object;
                    return "null";
                }
            }
        }
        object = sqlString;
        return object;
    }

    private static final <T extends MsCustomType> T renewType(ModNamingFamily<? extends T> family, int typeId, String name2) {
        MsCustomType type = null;
        type = family.find(arg_0 -> MsIntrospectorKt.renewType$lambda$4(typeId, arg_0));
        if (type != null) {
            ((BasicModNamedElement)type).setName(name2);
            ((BasicModMixinElement)type).resetSyncPending();
            return (T)type;
        }
        type = (MsCustomType)family.get(name2);
        if (type != null && type.getTypeId() == 0) {
            type.setTypeId(typeId);
            ((BasicModMixinElement)type).resetSyncPending();
            return (T)type;
        }
        type = (MsCustomType)family.createNewOne();
        type.setTypeId(typeId);
        ((BasicModNamedElement)type).setName(name2);
        return (T)type;
    }

    private static final MsKey findKeyByColumns(MsTable $this$findKeyByColumns, List<String> names) {
        Object v1;
        block1: {
            NamingFamily<? extends BasicKey> namingFamily = $this$findKeyByColumns.getKeys();
            Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getKeys(...)");
            Iterable $this$firstOrNull$iv = namingFamily;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MsKey it = (MsKey)element$iv;
                boolean bl = false;
                if (!BasicMixinColumniation.areColNames(it, names)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final Set<TrigEvent> unpackEvents(byte e) {
        byte $this$and$iv;
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        byte by = e;
        byte that$iv = 1;
        boolean $i$f$and = false;
        byte $this$toUnsignedInt$iv$iv = $this$and$iv;
        boolean $i$f$toUnsignedInt = false;
        int n = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        $i$f$toUnsignedInt = false;
        if ((byte)(n & Byte.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0) {
            events.add(TrigEvent.INSERT);
        }
        $this$and$iv = e;
        that$iv = 2;
        $i$f$and = false;
        $this$toUnsignedInt$iv$iv = $this$and$iv;
        $i$f$toUnsignedInt = false;
        int n2 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        $i$f$toUnsignedInt = false;
        if ((byte)(n2 & Byte.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0) {
            events.add(TrigEvent.UPDATE);
        }
        $this$and$iv = e;
        that$iv = 4;
        $i$f$and = false;
        $this$toUnsignedInt$iv$iv = $this$and$iv;
        $i$f$toUnsignedInt = false;
        int n3 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        $i$f$toUnsignedInt = false;
        if ((byte)(n3 & Byte.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0) {
            events.add(TrigEvent.DELETE);
        }
        Intrinsics.checkNotNull(events);
        return events;
    }

    private static final void setCreatedAndModifiedTimestamps(MsSchemaObject $this$setCreatedAndModifiedTimestamps, Date createdTimestamp, Date modifiedTimestamp) {
        $this$setCreatedAndModifiedTimestamps.setCreatedTimestamp(createdTimestamp);
        $this$setCreatedAndModifiedTimestamps.setModifiedTimestamp(modifiedTimestamp);
    }

    private static final byte getExtendedPropertyClassCode(BasicElement $this$extendedPropertyClassCode) {
        ObjectKind objectKind = $this$extendedPropertyClassCode.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLUMN) ? ($this$extendedPropertyClassCode instanceof MsTableTypeColumn ? PropertyClass.TableTypeColumn.getCode() : PropertyClass.ObjectOrColumn.getCode()) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DATABASE) ? PropertyClass.Database.getCode() : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA) ? PropertyClass.Schema.getCode() : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ARGUMENT) ? PropertyClass.Parameter.getCode() : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.USER) ? PropertyClass.Principal.getCode() : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROLE) ? PropertyClass.Principal.getCode() : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ALIAS_TYPE) ? PropertyClass.Type.getCode() : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE_TYPE) ? PropertyClass.Type.getCode() : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.INDEX) ? PropertyClass.Index.getCode() : PropertyClass.ObjectOrColumn.getCode()))))))));
    }

    private static final ExtPropId getExtendedPropertyId(BasicElement $this$extendedPropertyId) {
        ExtPropId extPropId;
        BasicElement basicElement = $this$extendedPropertyId;
        if (basicElement instanceof MsCustomType) {
            extPropId = new ExtPropId(PropertyClass.Type.getCode(), ((MsCustomType)$this$extendedPropertyId).getTypeId(), 0);
        } else if (basicElement instanceof MsSchemaObject) {
            extPropId = new ExtPropId(MsIntrospectorKt.getExtendedPropertyClassCode($this$extendedPropertyId), ((MsSchemaObject)$this$extendedPropertyId).getObjectId(), 0);
        } else if (basicElement instanceof MsLikeColumn) {
            BasicElement basicElement2 = ((MsLikeColumn)$this$extendedPropertyId).getParent();
            MsSchemaObject msSchemaObject = basicElement2 instanceof MsSchemaObject ? (MsSchemaObject)basicElement2 : null;
            extPropId = new ExtPropId(MsIntrospectorKt.getExtendedPropertyClassCode($this$extendedPropertyId), msSchemaObject != null ? msSchemaObject.getObjectId() : 0L, ((MsLikeColumn)$this$extendedPropertyId).getPosition());
        } else if (basicElement instanceof MsIndex) {
            MsLikeTable msLikeTable = ((MsIndex)$this$extendedPropertyId).getLikeTable();
            extPropId = new ExtPropId(MsIntrospectorKt.getExtendedPropertyClassCode($this$extendedPropertyId), msLikeTable != null ? msLikeTable.getObjectId() : 0L, ((MsIndex)$this$extendedPropertyId).getPosition());
        } else if (basicElement instanceof MsArgument) {
            MsRoutine msRoutine = ((MsArgument)$this$extendedPropertyId).getRoutine();
            extPropId = new ExtPropId(MsIntrospectorKt.getExtendedPropertyClassCode($this$extendedPropertyId), msRoutine != null ? msRoutine.getObjectId() : 0L, ((MsArgument)$this$extendedPropertyId).getPosition());
        } else {
            extPropId = basicElement instanceof MsSchema ? new ExtPropId(PropertyClass.Schema.getCode(), ((MsSchema)$this$extendedPropertyId).getObjectId(), 0) : (basicElement instanceof MsPrincipal ? new ExtPropId(MsIntrospectorKt.getExtendedPropertyClassCode($this$extendedPropertyId), ((MsPrincipal)$this$extendedPropertyId).getObjectId(), 0) : new ExtPropId(MsIntrospectorKt.getExtendedPropertyClassCode($this$extendedPropertyId), 0, 0));
        }
        return extPropId;
    }

    private static final boolean detectSurrogateName(String name2) {
        if (name2 == null) {
            return false;
        }
        return SURROGATE_NAME_PATTERN.matcher(name2).matches();
    }

    private static final DasType makeDasType(String type_name, int max_length, int precision, byte scale) {
        DataType dt = null;
        if (type_name != null) {
            if (VARIABLE_TYPES.contains((Object)type_name)) {
                if (Intrinsics.areEqual((Object)type_name, (Object)"time") || Intrinsics.areEqual((Object)type_name, (Object)"datetime2") || Intrinsics.areEqual((Object)type_name, (Object)"datetimeoffset")) {
                    int n = scale;
                    int size = (0 <= n ? n < 7 : false) ? scale : -1;
                    LengthUnit units = size >= 0 ? LengthUnit.DIGIT : null;
                    DataType dataType = DataTypeFactory.of(null, type_name, size, 0, units, null, false, false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    dt = dataType;
                } else if (precision > 0) {
                    DataType dataType = DataTypeFactory.of(null, type_name, precision, scale, null, null, false, false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    dt = dataType;
                } else if (Intrinsics.areEqual((Object)type_name, (Object)"char") || Intrinsics.areEqual((Object)type_name, (Object)"nchar") || Intrinsics.areEqual((Object)type_name, (Object)"varchar") || Intrinsics.areEqual((Object)type_name, (Object)"nvarchar") || Intrinsics.areEqual((Object)type_name, (Object)"varbinary")) {
                    boolean national;
                    boolean bl = national = type_name.charAt(0) == 'n';
                    int length = max_length == -1 ? Integer.MAX_VALUE : (national ? max_length >> 1 : max_length);
                    DataType dataType = DataTypeFactory.of(null, type_name, length, 0, LengthUnit.CHAR, null, false, false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    dt = dataType;
                } else if (max_length > 0) {
                    DataType dataType = DataTypeFactory.of(null, type_name, max_length, scale, null, null, false, false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    dt = dataType;
                } else {
                    DataType dataType = DataTypeFactory.of(type_name);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    dt = dataType;
                }
            } else {
                DataType dataType = DataTypeFactory.of(type_name);
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                dt = dataType;
            }
        } else {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"UNKNOWN");
            dt = dataType;
        }
        return DasUnresolvedTypeReference.Companion.of(dt);
    }

    private static final CascadeRule makeCascadeRule(byte code) {
        byte by = code;
        return by == 1 ? CascadeRule.cascade : (by == 2 ? CascadeRule.set_null : (by == 3 ? CascadeRule.set_default : CascadeRule.no_action));
    }

    private static final boolean canCheckOutdated(BasicElement e) {
        return e == null || e instanceof MsSchemaObject && !(e instanceof MsTableType) && ((MsSchemaObject)e).getModifiedTimestamp() != null;
    }

    private static final void retrievePermissions(IntrospectionQueryContext $this$retrievePermissions, MsGrantsHolder obj2, DBTransaction tran, SqlQuery<Long> checkSumQuery, SqlQuery<List<MsIntroQueries.OnePermission>> grantsQuery) {
        MsIntroQueries.OnePermission onePermission;
        long checksum = 0L;
        try {
            Long checksumOrNull;
            Long l = checksumOrNull = checkSumQuery != null ? $this$retrievePermissions.performQuery(tran, checkSumQuery) : null;
            checksum = l != null ? l : 0L;
        }
        catch (Exception e) {
            String message = "Failed to calculate checksum of permissions in " + obj2.getKind().code() + " " + obj2.getName() + ": exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
            if ($this$retrievePermissions.log.isDebugEnabled()) {
                $this$retrievePermissions.log.warn(message, (Throwable)e);
            } else {
                $this$retrievePermissions.log.warn(message);
            }
            return;
        }
        if (checksum == obj2.getPermissionsCheckSum()) {
            return;
        }
        BitSet columns = new BitSet();
        Ref.ObjectRef last = new Ref.ObjectRef();
        ArrayList<MsObjectGrant> newGrants = new ArrayList<MsObjectGrant>();
        if (grantsQuery != null) {
            IntrospectionQueryContext.performQueryHandleEachRow$default($this$retrievePermissions, tran, grantsQuery, 0, arg_0 -> MsIntrospectorKt.retrievePermissions$lambda$6(last, newGrants, columns, obj2, arg_0), 2, null);
        }
        if ((onePermission = (MsIntroQueries.OnePermission)last.element) != null) {
            MsIntroQueries.OnePermission onePermission2;
            MsIntroQueries.OnePermission it = onePermission2 = onePermission;
            boolean bl = false;
            onePermission = !columns.isEmpty() ? onePermission2 : null;
            if (onePermission != null) {
                MsIntroQueries.OnePermission grant = onePermission;
                boolean bl2 = false;
                MsIntrospectorKt.addGrant((List<MsObjectGrant>)newGrants, grant, columns, obj2);
            }
        }
        ((BasicModModel)obj2.getModel()).modify((BasicElement)obj2, MsGrantsHolder.class, new ModelModifier(newGrants, checksum){
            final /* synthetic */ ArrayList<MsObjectGrant> $newGrants;
            final /* synthetic */ long $checksum;
            {
                this.$newGrants = $newGrants;
                this.$checksum = $checksum;
            }

            public final void perform(MsGrantsHolder g) {
                g.setGrants(g.getGrants().with((Iterable<MsObjectGrant>)this.$newGrants));
                g.setPermissionsCheckSum(this.$checksum);
            }
        });
    }

    private static final void addGrant(List<MsObjectGrant> $this$addGrant, MsIntroQueries.OnePermission p2, BitSet columns, MsGrantsHolder obj2) {
        Grants.State state;
        long l;
        Long l2 = p2.object_id;
        long l3 = ((Number)l2).longValue();
        List<MsObjectGrant> list = $this$addGrant;
        boolean bl = false;
        boolean bl2 = p2.kind != 0;
        Long l4 = bl2 ? l2 : null;
        if (l4 != null) {
            l = l4;
        } else {
            MsGrantsHolder $this$asSafely$iv = obj2;
            boolean $i$f$asSafely = false;
            MsGrantsHolder msGrantsHolder = $this$asSafely$iv;
            if (!(msGrantsHolder instanceof MsDatabase)) {
                msGrantsHolder = null;
            }
            MsDatabase msDatabase = (MsDatabase)msGrantsHolder;
            Long l5 = msDatabase != null ? Long.valueOf(msDatabase.getObjectId()) : null;
            l = l5 != null ? l5 : 0L;
        }
        char c2 = p2.kind;
        Comparable<ObjectKind> comparable = c2 == '\u0000' ? ObjectKind.DATABASE : (c2 == '\u0003' ? ObjectKind.SCHEMA : (c2 == '\u0004' ? ObjectKind.ROLE : (c2 == '\u0006' ? ObjectKind.ALIAS_TYPE : (c2 == 'd' ? ObjectKind.ROOT : (c2 == 'e' ? ObjectKind.LOGIN : ObjectKind.NONE)))));
        Intrinsics.checkNotNull((Object)comparable);
        ObjectKind objectKind = comparable;
        long l6 = p2.grantee_principal_id;
        String string = StringUtil.toLowerCase((String)p2.permission_name);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Comparable<ObjectKind> comparable2 = comparable = p2.state;
        c2 = 'G';
        if (comparable2 != null && ((Character)comparable2).charValue() == c2) {
            state = Grants.State.GRANT;
        } else {
            Comparable<ObjectKind> comparable3 = comparable;
            c2 = 'W';
            if (comparable3 != null && ((Character)comparable3).charValue() == c2) {
                state = Grants.State.GRANT_WITH_GRANT_OPTION;
            } else {
                Comparable<ObjectKind> comparable4 = comparable;
                c2 = 'D';
                state = comparable4 != null && ((Character)comparable4).charValue() == c2 ? Grants.State.DENY : Grants.State.REVOKE;
            }
        }
        Grants.State state2 = state;
        String string2 = string;
        long l7 = l6;
        BitSet bitSet = columns;
        ObjectKind objectKind2 = objectKind;
        long l8 = l;
        list.add(new MsObjectGrant(l8, objectKind2, bitSet, l7, string2, state2));
    }

    private static final boolean properties$lambda$1(MsIntroQueries.OneProperty it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.property_name != null && !Intrinsics.areEqual((Object)it.property_name, (Object)"MS_Description");
    }

    private static final NameValueType properties$lambda$2(MsIntroQueries.OneProperty it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.property_name;
        Intrinsics.checkNotNull((Object)string);
        String string2 = MsIntrospectorKt.asLiteral(it);
        String string3 = DbUtil.intern(it.type);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"intern(...)");
        return new NameValueType(string, string2, string3);
    }

    private static final boolean renewType$lambda$4(int $typeId, MsCustomType it) {
        return it.getTypeId() == $typeId;
    }

    private static final Unit retrievePermissions$lambda$6(Ref.ObjectRef $last, ArrayList $newGrants, BitSet $columns, MsGrantsHolder $obj, MsIntroQueries.OnePermission g) {
        boolean subObj;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        MsIntroQueries.OnePermission prev2 = (MsIntroQueries.OnePermission)$last.element;
        boolean bl = subObj = g.position > 0;
        if (!((prev2 != null ? g.object_id == prev2.object_id : false) && g.grantee_principal_id == prev2.grantee_principal_id && g.kind == prev2.kind && Intrinsics.areEqual((Object)g.permission_name, (Object)prev2.permission_name) && Intrinsics.areEqual((Object)g.state, (Object)prev2.state) && subObj)) {
            $last.element = g;
            if (prev2 != null) {
                MsIntrospectorKt.addGrant($newGrants, prev2, $columns, $obj);
                $columns.clear();
            }
        }
        if (!subObj) {
            MsIntrospectorKt.addGrant($newGrants, g, null, $obj);
            $last.element = null;
        } else {
            $columns.set(g.position);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$canCheckOutdated(BasicElement e) {
        return MsIntrospectorKt.canCheckOutdated(e);
    }

    public static final /* synthetic */ void access$retrievePermissions(IntrospectionQueryContext $receiver, MsGrantsHolder obj2, DBTransaction tran, SqlQuery checkSumQuery, SqlQuery grantsQuery) {
        MsIntrospectorKt.retrievePermissions($receiver, obj2, tran, (SqlQuery<Long>)checkSumQuery, (SqlQuery<List<MsIntroQueries.OnePermission>>)grantsQuery);
    }

    public static final /* synthetic */ MsCustomType access$renewType(ModNamingFamily family, int typeId, String name2) {
        return MsIntrospectorKt.renewType(family, typeId, name2);
    }

    public static final /* synthetic */ DasType access$makeDasType(String type_name, int max_length, int precision, byte scale) {
        return MsIntrospectorKt.makeDasType(type_name, max_length, precision, scale);
    }

    public static final /* synthetic */ boolean access$detectSurrogateName(String name2) {
        return MsIntrospectorKt.detectSurrogateName(name2);
    }

    public static final /* synthetic */ void access$setCreatedAndModifiedTimestamps(MsSchemaObject $receiver, Date createdTimestamp, Date modifiedTimestamp) {
        MsIntrospectorKt.setCreatedAndModifiedTimestamps($receiver, createdTimestamp, modifiedTimestamp);
    }

    public static final /* synthetic */ void access$setExtProps(MsExtendedPropertiesHolder $receiver, List props) {
        MsIntrospectorKt.setExtProps($receiver, props);
    }

    public static final /* synthetic */ ExtPropId access$getExtendedPropertyId(BasicElement $receiver) {
        return MsIntrospectorKt.getExtendedPropertyId($receiver);
    }

    public static final /* synthetic */ CascadeRule access$makeCascadeRule(byte code) {
        return MsIntrospectorKt.makeCascadeRule(code);
    }

    public static final /* synthetic */ Set access$unpackEvents(byte e) {
        return MsIntrospectorKt.unpackEvents(e);
    }

    static {
        Object[] objectArray = new String[]{"nvarchar", "nchar", "time", "datetime2", "datetimeoffset"};
        ImmutableSet immutableSet = ImmutableSet.of((Object)"decimal", (Object)"numeric", (Object)"varbinary", (Object)"varchar", (Object)"binary", (Object)"char", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of(...)");
        VARIABLE_TYPES = immutableSet;
        Object[] objectArray2 = new String[]{"char", "date", "datetime", "datetime2", "datetimeoffset", "nchar", "nvarchar", "smalldatetime", "time", "varchar"};
        typeNamesToQuote = SetsKt.setOf((Object[])objectArray2);
    }
}

