/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.introspector;

import com.google.common.collect.ImmutableList;
import com.intellij.database.Dbms;
import com.intellij.database.HSet;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IdCache;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.base.introspector.SchemaPortion;
import com.intellij.database.dialects.mssql.generator.MsNamingService;
import com.intellij.database.dialects.mssql.introspector.ExtPropId;
import com.intellij.database.dialects.mssql.introspector.ForeignKeyInfo;
import com.intellij.database.dialects.mssql.introspector.MsIntroFunctions;
import com.intellij.database.dialects.mssql.introspector.MsIntroQueries;
import com.intellij.database.dialects.mssql.introspector.MsIntrospector;
import com.intellij.database.dialects.mssql.introspector.MsIntrospector$MsSchemaRetriever$retrieveSources$1$1$invoke$;
import com.intellij.database.dialects.mssql.introspector.MsIntrospectorHelper;
import com.intellij.database.dialects.mssql.introspector.MsIntrospectorKt;
import com.intellij.database.dialects.mssql.introspector.MsMinorIdentity;
import com.intellij.database.dialects.mssql.introspector.MsPartitionHostKey;
import com.intellij.database.dialects.mssql.introspector.MsRoutineTypes;
import com.intellij.database.dialects.mssql.introspector.MsSchemaEffect;
import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsArgument;
import com.intellij.database.dialects.mssql.model.MsAssembly;
import com.intellij.database.dialects.mssql.model.MsCollation;
import com.intellij.database.dialects.mssql.model.MsColumnEncryptionKey;
import com.intellij.database.dialects.mssql.model.MsColumnMasterKey;
import com.intellij.database.dialects.mssql.model.MsCustomType;
import com.intellij.database.dialects.mssql.model.MsDatabase;
import com.intellij.database.dialects.mssql.model.MsDefaultConstraint;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsFileGroup;
import com.intellij.database.dialects.mssql.model.MsForeignKey;
import com.intellij.database.dialects.mssql.model.MsGeneratedModelUtil;
import com.intellij.database.dialects.mssql.model.MsGrantsHolder;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsIndexableTable;
import com.intellij.database.dialects.mssql.model.MsLikeColumn;
import com.intellij.database.dialects.mssql.model.MsLikeIndex;
import com.intellij.database.dialects.mssql.model.MsLikeTable;
import com.intellij.database.dialects.mssql.model.MsLinkedServer;
import com.intellij.database.dialects.mssql.model.MsLogin;
import com.intellij.database.dialects.mssql.model.MsMajorSchemaObject;
import com.intellij.database.dialects.mssql.model.MsPartition;
import com.intellij.database.dialects.mssql.model.MsPartitionFunction;
import com.intellij.database.dialects.mssql.model.MsPartitionScheme;
import com.intellij.database.dialects.mssql.model.MsRole;
import com.intellij.database.dialects.mssql.model.MsRoot;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsRule;
import com.intellij.database.dialects.mssql.model.MsSchema;
import com.intellij.database.dialects.mssql.model.MsSchemaObject;
import com.intellij.database.dialects.mssql.model.MsSecurityPolicy;
import com.intellij.database.dialects.mssql.model.MsSecurityPredicate;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.dialects.mssql.model.MsSourceAware;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsStoredTable;
import com.intellij.database.dialects.mssql.model.MsSynonym;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableColumn;
import com.intellij.database.dialects.mssql.model.MsTableOrView;
import com.intellij.database.dialects.mssql.model.MsTablePartition;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.dialects.mssql.model.MsView;
import com.intellij.database.dialects.mssql.model.properties.MsAuthType;
import com.intellij.database.dialects.mssql.model.properties.MsColumnEncryptionKind;
import com.intellij.database.dialects.mssql.model.properties.MsDataCompressionKind;
import com.intellij.database.dialects.mssql.model.properties.MsDataSpaceKind;
import com.intellij.database.dialects.mssql.model.properties.MsDatabasePrincipalType;
import com.intellij.database.dialects.mssql.model.properties.MsGeneratedColumnKind;
import com.intellij.database.dialects.mssql.model.properties.MsLedgerKind;
import com.intellij.database.dialects.mssql.model.properties.MsRoutineType;
import com.intellij.database.dialects.mssql.model.properties.MsSecurityPredicateOperationType;
import com.intellij.database.dialects.mssql.model.properties.MsSecurityPredicateType;
import com.intellij.database.dialects.mssql.model.properties.MsServerPrincipalType;
import com.intellij.database.dialects.mssql.model.properties.MsTemporalTableKind;
import com.intellij.database.dialects.mssql.model.properties.MsTimeUnit;
import com.intellij.database.introspection.CollectionAggregator;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.FamilyFragment;
import com.intellij.database.introspection.FamilyFragments;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.IntrospectionTaskHelperFun;
import com.intellij.database.introspection.SchemaFragmentIntrospectionTask;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModMultiLevelObject;
import com.intellij.database.model.basic.BasicModMultiLevelSchema;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.model.properties.references.BasicPositionReference;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import com.intellij.database.util.common.CalendarFun;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.util.common.Long2ObjectAutoMap;
import com.intellij.database.util.common.MapFun;
import com.intellij.database.util.common.StringFun;
import com.intellij.database.util.common.TextTable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 b2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0006abcdefB\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u001fH\u0014J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&H\u0014J!\u0010(\u001a\u00020\u001f2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*H\u0000\u00a2\u0006\u0002\b-J)\u0010(\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*H\u0000\u00a2\u0006\u0002\b-J\u0010\u00100\u001a\u00020+2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\bH\u0014J\u0014\u00103\u001a\u000604R\u00020\u00002\u0006\u00105\u001a\u00020$H\u0014J\u001c\u00106\u001a\u000607R\u00020\u00002\u0006\u00105\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0003H\u0014JJ\u00108\u001a(\u0012\u0006\b\u0001\u0012\u00020\u0003\u0012\u0006\b\u0001\u0012\u00020\u000409R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u00105\u001a\u00020$2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040;H\u0014J\u001c\u0010<\u001a\u00060=R\u00020\u00002\u0006\u00105\u001a\u00020$2\u0006\u0010>\u001a\u00020\u0004H\u0014J&\u0010?\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030@R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014J\u0010\u0010A\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0014J\"\u0010B\u001a\u000e\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020\u00100C2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020D0\"H\u0014J(\u0010F\u001a\u00020\u001f2\u0006\u00105\u001a\u00020$2\u0006\u0010G\u001a\u00020+2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0010H\u0014J(\u0010K\u001a\u00020\u001f2\u0006\u00105\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0010H\u0014J \u0010L\u001a\u00020\u001f2\u0006\u00105\u001a\u00020$2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u0004H\u0014J \u0010M\u001a\u00020\u001f2\u0006\u00105\u001a\u00020$2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u0004H\u0014J(\u0010N\u001a\u00020\u001f2\u0006\u00105\u001a\u00020$2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u00042\u0006\u0010O\u001a\u00020PH\u0014J\u0010\u0010Q\u001a\u00020\u00102\u0006\u0010>\u001a\u00020RH\u0014J0\u0010S\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040;0T2\u0006\u0010.\u001a\u00020\u00032\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00040TH\u0014J8\u0010V\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040;0W2\u0006\u0010.\u001a\u00020\u00032\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00040X2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0018\u0010[\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020]H\u0014J\b\u0010^\u001a\u00020\u001fH\u0014J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010_\u001a\u00020\u0010H\u0002J\b\u0010`\u001a\u00020\u0010H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/mssql/model/MsRoot;", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "Lcom/intellij/database/dialects/mssql/model/MsSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "myQueries", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries;", "isAzure", "", "isNotAzure", "isSynapse", "isClassic", "helper", "Lcom/intellij/database/dialects/mssql/introspector/MsIntrospectorHelper;", "currentSessionInfo", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$CurrentSessionInfo;", "hasTableTypes", "schemasWhereDroppedObjectsDetected", "", "majorEffects", "Lcom/intellij/database/util/common/Long2ObjectAutoMap;", "Lcom/intellij/database/dialects/mssql/introspector/MsSchemaEffect;", "initConnectionRelatedState", "", "deinitConnectionRelatedState", "getDatabasesToIntrospect", "", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "prepareQueryParameters", "parameters", "", "", "", "prepareQueryParameters$intellij_database_dialects_mssql", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "catalogPrefix", "validateDbms", "connectionDbms", "createServerObjectsRetriever", "Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsServerObjectsRetriever;", "transaction", "createDatabaseRetriever", "Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsDatabaseRetriever;", "createLevelOneRetrieverForPortion", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseSchemasRetriever;", "portion", "Lcom/intellij/database/dialects/base/introspector/SchemaPortion;", "createSchemaRetriever", "Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsSchemaRetriever;", "schema", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "introspectServerObjectsInner", "checkElementsUptodate", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "introspectRootFragments", "databaseName", "fragments", "Lcom/intellij/database/introspection/FamilyFragments;", "checkForDroppedObjects", "introspectDatabaseFragments", "detectAndRemoveDroppedObjects", "performFragmentIntrospectionPreceders", "performSchemaFragmentIntrospectionOnLevel1", "task", "Lcom/intellij/database/introspection/SchemaFragmentIntrospectionTask;", "isSchemaSystem", "Lcom/intellij/database/model/basic/BasicSchema;", "distributeSchemasForLevelOneIntrospection", "", "schemas", "makePortions", "Lkotlin/sequences/Sequence;", "Ljava/util/ArrayList;", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "markSchemaIntrospected", "processedLevel", "Lcom/intellij/database/model/properties/Level;", "dropSpecificSessionInfo", "isSynapseMaster", "isAnySynapse", "Factory", "Companion", "MsServerObjectsRetriever", "MsLevelOneRetriever", "MsDatabaseRetriever", "MsSchemaRetriever", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IntrospectionQueryContext.kt\ncom/intellij/database/dialects/base/introspector/IntrospectionQueryContext\n+ 4 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n*L\n1#1,2781:1\n1#2:2782\n411#3:2783\n412#3:2785\n14#4:2784\n1869#5,2:2786\n1761#5,3:2790\n1011#5,2:2793\n1869#5,2:2796\n216#6,2:2788\n303#7:2795\n*S KotlinDebug\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector\n*L\n124#1:2783\n124#1:2785\n128#1:2784\n224#1:2786,2\n276#1:2790,3\n305#1:2793,2\n240#1:2796,2\n233#1:2788,2\n313#1:2795\n*E\n"})
public final class MsIntrospector
extends BaseMultiDatabaseIntrospector<MsRoot, MsDatabase, MsSchema> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MsIntroQueries myQueries;
    private final boolean isAzure;
    private final boolean isNotAzure;
    private final boolean isSynapse;
    private final boolean isClassic;
    @NotNull
    private final MsIntrospectorHelper helper;
    @Nullable
    private MsIntroQueries.CurrentSessionInfo currentSessionInfo;
    private boolean hasTableTypes;
    @NotNull
    private final Set<MsSchema> schemasWhereDroppedObjectsDetected;
    @NotNull
    private final Long2ObjectAutoMap<MsSchemaEffect> majorEffects;
    @NotNull
    private static final Set<ObjectKind> supportFragmentKinds;
    private static final int ourMaxSchemasPerChunk = 16;

    public MsIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, Companion, dbms, modelFactory);
        this.myQueries = MsIntroQueries.INSTANCE;
        HSet hSet = Dbms.AZURE_LIKE;
        Intrinsics.checkNotNullExpressionValue((Object)hSet, (String)"AZURE_LIKE");
        this.isAzure = ModelFun.contains(hSet, dbms);
        this.isNotAzure = !this.isAzure;
        this.isSynapse = Intrinsics.areEqual((Object)dbms, (Object)Dbms.SYNAPSE);
        this.isClassic = !this.isAzure && !this.isSynapse;
        this.helper = new MsIntrospectorHelper(context.getProject(), dbms);
        this.schemasWhereDroppedObjectsDetected = new HashSet();
        this.majorEffects = new Long2ObjectAutoMap(MsIntrospector::majorEffects$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initConnectionRelatedState() {
        Object object;
        MsIntroQueries.CurrentSessionInfo csi;
        super.initConnectionRelatedState();
        MsIntroQueries.CurrentSessionInfo currentSessionInfo = csi = (MsIntroQueries.CurrentSessionInfo)BaseNativeIntrospector.performQuery$default(this, this.myQueries.getQueryCurrentSessionInfo(), null, 2, null);
        if (currentSessionInfo != null) {
            object = currentSessionInfo;
            MsIntroQueries.CurrentSessionInfo $this$initConnectionRelatedState_u24lambda_u241 = object;
            boolean bl = false;
            $this$initConnectionRelatedState_u24lambda_u241.now = CalendarFun.truncateToSeconds($this$initConnectionRelatedState_u24lambda_u241.now);
        }
        this.currentSessionInfo = csi;
        if (csi != null) {
            IntrospectionQueryContext this_$iv = this;
            boolean $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
                void _true_$iv;
                void $this$choose$iv;
                IntrospectionQueryContext introspectionQueryContext = this_$iv;
                boolean bl = false;
                boolean bl2 = csi.is_azure;
                String string = "yes";
                String _false_$iv = "no";
                boolean $i$f$choose = false;
                introspectionQueryContext.trace(StringsKt.trimMargin$default((String)("|CurrentSessionInfo:\n           |    current database: " + csi.db_name + " (" + csi.db_id + ")\n           |    current schema:   " + csi.schema_name + " (" + csi.schema_id + ")\n           |    is it Azure:      " + ($this$choose$iv != false ? _true_$iv : _false_$iv) + "\n           |    server time:      " + csi.now + "\n        "), null, (int)1, null));
            }
        } else {
            IntrospectionQueryContext.logWarn$default(this, "Failed to obtain CurrentSessionInfo.", null, 2, null);
        }
        object = new int[1];
        object[0] = 10;
        this.hasTableTypes = this.getServerVersion().isOrGreater((int[])object) && !this.isSynapse;
    }

    @Override
    protected void deinitConnectionRelatedState() {
        this.currentSessionInfo = null;
        super.deinitConnectionRelatedState();
    }

    @Override
    @NotNull
    protected Iterable<MsDatabase> getDatabasesToIntrospect(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces2) {
        Object theCurrentlyAccessibleDatabase;
        Object object;
        block6: {
            MsIntroQueries.CurrentSessionInfo csi;
            block5: {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                if (this.isNotAzure) {
                    return super.getDatabasesToIntrospect(tran, namespaces2);
                }
                MsIntroQueries.CurrentSessionInfo currentSessionInfo = this.currentSessionInfo;
                if (currentSessionInfo == null) {
                    return CollectionsKt.emptyList();
                }
                csi = currentSessionInfo;
                String dbName = csi.db_name;
                object = dbName;
                if (object == null) break block5;
                String it = object;
                boolean bl = false;
                MsDatabase msDatabase = (MsDatabase)((MsRoot)this.getRoot()).getDatabases().get(it);
                object = msDatabase;
                if (msDatabase != null) break block6;
            }
            object = (MsDatabase)((MsRoot)this.getRoot()).getDatabases().getByObjectId(csi.db_id);
        }
        Object object2 = theCurrentlyAccessibleDatabase = object;
        return object2 != null ? (Iterable)CollectionsKt.listOf((Object)object2) : (Iterable)CollectionsKt.emptyList();
    }

    public final void prepareQueryParameters$intellij_database_dialects_mssql(@NotNull Map<String, Object> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        if (this.isClassic) {
            parameters.put("CLASSIC", true);
        }
        if (this.isAzure) {
            parameters.put("AZURE", true);
        }
        if (this.isSynapse) {
            parameters.put("SYNAPSE", true);
        }
        if (this.hasTableTypes) {
            parameters.put("HASTABLETYPES", true);
        }
        parameters.put("ISTABLETYPE", this.hasTableTypes ? "is_table_type" : "0");
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 10, parameters);
    }

    public final void prepareQueryParameters$intellij_database_dialects_mssql(@NotNull BasicDatabase database, @NotNull Map<String, Object> parameters) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.prepareQueryParameters$intellij_database_dialects_mssql(parameters);
        parameters.put("CAT", this.catalogPrefix(database));
    }

    private final String catalogPrefix(BasicDatabase database) {
        MsIntroQueries.CurrentSessionInfo currentSessionInfo = this.currentSessionInfo;
        if (Intrinsics.areEqual((Object)database.getName(), (Object)(currentSessionInfo != null ? currentSessionInfo.db_name : null))) {
            return "sys";
        }
        String string = database.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.replace$default((String)MsNamingService.INSTANCE.catToScript(string, database.getKind()), (String)"#", (String)"\\#", (boolean)false, (int)4, null) + ".sys";
    }

    @Override
    protected void validateDbms(@NotNull Dbms connectionDbms) {
        Intrinsics.checkNotNullParameter((Object)connectionDbms, (String)"connectionDbms");
        if (Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.AZURE) && Intrinsics.areEqual((Object)connectionDbms, (Object)Dbms.SYNAPSE) || Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.SYNAPSE) && Intrinsics.areEqual((Object)connectionDbms, (Object)Dbms.AZURE)) {
            return;
        }
        super.validateDbms(connectionDbms);
    }

    @Override
    @NotNull
    protected MsServerObjectsRetriever createServerObjectsRetriever(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return new MsServerObjectsRetriever(transaction);
    }

    @NotNull
    protected MsDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull MsDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MsDatabaseRetriever(transaction, database);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.BaseDatabaseSchemasRetriever<? extends MsDatabase, ? extends MsSchema> createLevelOneRetrieverForPortion(@NotNull DBTransaction transaction, @NotNull SchemaPortion<? extends MsDatabase, ? extends MsSchema> portion) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(portion, (String)"portion");
        return new MsLevelOneRetriever(transaction, portion.getDatabase(), portion.getSchemas(), portion.getMode());
    }

    @NotNull
    protected MsSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull MsSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new MsSchemaRetriever(transaction, schema);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<MsIntroQueries.DbInfo, MsDatabase>(this){
            final /* synthetic */ MsIntrospector this$0;
            {
                this.this$0 = $receiver;
            }

            protected void prepareParameters() {
                this.this$0.prepareQueryParameters$intellij_database_dialects_mssql(MsIntrospector.access$getParametersMap(this.this$0));
            }

            protected List<MsIntroQueries.DbInfo> listDatabases(DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                List<MsIntroQueries.DbInfo> list = this.this$0.performQuery(tran, MsIntrospector.access$getMyQueries$p(this.this$0).getListDatabases());
                Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
                return list;
            }

            protected MsDatabase applyDatabase(ModNamingFamily<?> databases, MsIntroQueries.DbInfo db) {
                Intrinsics.checkNotNullParameter(databases, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                MD MD = this.renew(databases, db.id, db.name);
                MsDatabase $this$applyDatabase_u24lambda_u240 = (MsDatabase)MD;
                boolean bl = false;
                String string = db.collation_name;
                $this$applyDatabase_u24lambda_u240.setCollationRef(BasicNameReference.create(string != null ? ((Object)StringsKt.trimEnd((CharSequence)string)).toString() : null));
                $this$applyDatabase_u24lambda_u240.setOnline(db.state == 0);
                return (MsDatabase)MD;
            }
        };
    }

    @Override
    protected void introspectServerObjectsInner(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        MsServerObjectsRetriever serverRetriever = this.createServerObjectsRetriever(tran);
        serverRetriever.setupRegular();
        serverRetriever.introspectAllServerObjects();
    }

    @Override
    @NotNull
    protected Map<BasicElement, Boolean> checkElementsUptodate(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        LinkedHashMap res2 = new LinkedHashMap();
        for (BasicDatabase database : JBIterable.from(elements).transform(arg_0 -> MsIntrospector.checkElementsUptodate$lambda$5(MsIntrospector::checkElementsUptodate$lambda$4, arg_0)).toSet()) {
            Object element$iv;
            LinkedHashMap ids = new LinkedHashMap();
            Object $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                BasicElement it = element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDatabase(), (Object)database) || !MsIntrospectorKt.access$canCheckOutdated(it)) continue;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.database.dialects.mssql.model.MsSchemaObject");
                MsSchemaObject cfr_ignored_0 = (MsSchemaObject)it;
                ((Map)ids).put(((MsSchemaObject)it).getObjectId(), it);
            }
            if (ids.isEmpty()) continue;
            BasicDatabase basicDatabase = database;
            Intrinsics.checkNotNull((Object)basicDatabase);
            this.prepareQueryParameters$intellij_database_dialects_mssql(basicDatabase, this.getParametersMap());
            Set set = ids.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            this.setQueryParameter("OBJECT_IDS", CollectionsKt.toLongArray((Collection)set));
            $this$forEach$iv = ids;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object = element$iv = (Map.Entry)iterator.next();
                boolean bl = false;
                MsSchemaObject v = (MsSchemaObject)object.getValue();
                ((Map)res2).put(v, false);
            }
            BaseNativeIntrospector.performQueryHandleEachRow$default(this, MsIntroQueries.INSTANCE.getRetrieveStates(), 0, arg_0 -> MsIntrospector.checkElementsUptodate$lambda$8(ids, res2, arg_0), 2, null);
        }
        this.inModel(arg_0 -> MsIntrospector.checkElementsUptodate$lambda$10(res2, arg_0));
        return res2;
    }

    @Override
    protected void introspectRootFragments(@NotNull DBTransaction transaction, @NotNull String databaseName, @NotNull FamilyFragments fragments2, boolean checkForDroppedObjects) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)fragments2, (String)"fragments");
        this.introspectServerObjectsInTran(transaction);
        this.listAndApplyDatabasesIfNotYet(transaction);
    }

    @Override
    protected void introspectDatabaseFragments(@NotNull DBTransaction transaction, @NotNull BasicDatabase database, @NotNull FamilyFragments fragments2, boolean checkForDroppedObjects) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)fragments2, (String)"fragments");
        MsDatabaseRetriever retriever = new MsDatabaseRetriever(transaction, (MsDatabase)database);
        retriever.retrieveAuxiliaryObjects();
    }

    @Override
    protected void detectAndRemoveDroppedObjects(@NotNull DBTransaction transaction, @NotNull MsDatabase database, @NotNull MsSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if (this.schemasWhereDroppedObjectsDetected.contains(schema)) {
            return;
        }
        MsSchemaRetriever r = this.createSchemaRetriever(transaction, schema);
        r.prepareParameters();
        r.determineDroppedObjects$intellij_database_dialects_mssql();
    }

    @Override
    protected void performFragmentIntrospectionPreceders(@NotNull DBTransaction transaction, @NotNull MsDatabase database, @NotNull MsSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if (((MsRoot)this.getRoot()).getCollations().isEmpty()) {
            this.introspectServerObjectsInTran(transaction);
            this.listAndApplyDatabasesIfNotYet(transaction);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void performSchemaFragmentIntrospectionOnLevel1(@NotNull DBTransaction transaction, @NotNull MsDatabase database, @NotNull MsSchema schema, @NotNull SchemaFragmentIntrospectionTask task) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            fragments = task.getFragments();
            if (fragments == null) ** GOTO lbl-1000
            $this$any$iv = fragments;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (FamilyFragment)element$iv;
                    $i$a$-any-MsIntrospector$performSchemaFragmentIntrospectionOnLevel1$needsL1$1 = false;
                    if (!(Intrinsics.areEqual((Object)it.getKind(), (Object)ObjectKind.ALIAS_TYPE) != false || Intrinsics.areEqual((Object)it.getKind(), (Object)ObjectKind.SYNONYM) != false)) continue;
                    v0 = true;
                    break block8;
                }
                v0 = false;
            }
        }
        if (v0) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        needsL1 = v1;
        needsDrop = task.getCheckForDroppedObjects();
        if (needsL1 || needsDrop) {
            retriever = new MsLevelOneRetriever(transaction, database, CollectionsKt.listOf((Object)schema), IntrospectionMode.FRAGMENT);
            if (needsDrop) {
                retriever.detectAndRemoveDroppedObjects();
            }
            if (needsL1) {
                v2 = task.getFragments();
                Intrinsics.checkNotNull((Object)v2);
                retriever.processFragments(v2);
            }
        }
    }

    @Override
    protected boolean isSchemaSystem(@NotNull BasicSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        String string = schema.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.helper.isSchemaSystem(string);
    }

    @Override
    @NotNull
    protected List<SchemaPortion<MsDatabase, MsSchema>> distributeSchemasForLevelOneIntrospection(@NotNull MsDatabase database, @NotNull List<? extends MsSchema> schemas) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        ArrayList<MsSchema> p1 = new ArrayList<MsSchema>(0);
        ArrayList<MsSchema> p2 = new ArrayList<MsSchema>(0);
        for (MsSchema msSchema : schemas) {
            boolean inc = msSchema.hasChildren() && msSchema.getIntrospectionTimestamp() != null;
            boolean bl = inc ? p1.add(msSchema) : p2.add(msSchema);
        }
        SmartList portions = new SmartList();
        CollectionsKt.addAll((Collection)((Collection)portions), this.makePortions(database, p1, IntrospectionMode.INCREMENT));
        CollectionsKt.addAll((Collection)((Collection)portions), this.makePortions(database, p2, IntrospectionMode.FULL));
        return (List)portions;
    }

    private final Sequence<SchemaPortion<MsDatabase, MsSchema>> makePortions(MsDatabase database, ArrayList<MsSchema> schemas, IntrospectionMode mode) {
        int n = schemas.size();
        if (n == 0) {
            return SequencesKt.emptySequence();
        }
        if (n >= 2 && mode.increment) {
            List $this$sortBy$iv = schemas;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        MsSchema it = (MsSchema)a;
                        boolean bl = false;
                        Date date = it.getIntrospectionTimestamp();
                        if (date == null) {
                            date = BaseIntrospectionFunctions.AGES_AGO;
                        }
                        it = (MsSchema)b;
                        Comparable comparable = date;
                        bl = false;
                        Date date2 = it.getIntrospectionTimestamp();
                        if (date2 == null) {
                            date2 = BaseIntrospectionFunctions.AGES_AGO;
                        }
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)date2);
                    }
                });
            }
        }
        Object[] chunks = CollectionFun.splitIntoChunksOf((List)schemas, 16);
        return SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])chunks), arg_0 -> MsIntrospector.makePortions$lambda$13(database, mode, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void markSchemaIntrospected(@NotNull MsSchema schema, @NotNull Level processedLevel) {
        void schema$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)((Object)processedLevel), (String)"processedLevel");
        BaseIntrospector baseIntrospector = this;
        BasicModSchema basicModSchema = schema;
        Function1 modifier$iv = arg_0 -> MsIntrospector.markSchemaIntrospected$lambda$14(this, arg_0);
        boolean $i$f$inSchema = false;
        this_$iv.getModel().modify((BasicElement)schema$iv, MsSchema.class, new ModelModifier(modifier$iv, (BasicModSchema)schema$iv){
            final /* synthetic */ Function1 $modifier;
            final /* synthetic */ BasicModSchema $schema;
            {
                this.$modifier = $modifier;
                this.$schema = $schema;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void perform(BasicModSchema it) {
                this.$modifier.invoke((Object)this.$schema);
            }
        });
    }

    @Override
    protected void dropSpecificSessionInfo() {
        super.dropSpecificSessionInfo();
        this.schemasWhereDroppedObjectsDetected.clear();
        this.currentSessionInfo = null;
    }

    private final boolean isSynapse() {
        DatabaseConnectionCore databaseConnectionCore = this.getDbConnection();
        return Intrinsics.areEqual((Object)(databaseConnectionCore != null && (databaseConnectionCore = databaseConnectionCore.getRemoteConnection()) != null ? databaseConnectionCore.getDetectedDbmsName() : null), (Object)"SYNAPSE");
    }

    private final boolean isSynapseMaster() {
        DatabaseConnectionCore databaseConnectionCore = this.getDbConnection();
        return Intrinsics.areEqual((Object)(databaseConnectionCore != null && (databaseConnectionCore = databaseConnectionCore.getRemoteConnection()) != null ? databaseConnectionCore.getDetectedDbmsName() : null), (Object)"SYNAPSE_MASTER");
    }

    private final boolean isAnySynapse() {
        return this.isSynapse() || this.isSynapseMaster();
    }

    private static final MsSchemaEffect majorEffects$lambda$0(long it) {
        return new MsSchemaEffect();
    }

    private static final BasicDatabase checkElementsUptodate$lambda$4(BasicElement it) {
        return it.getDatabase();
    }

    private static final BasicDatabase checkElementsUptodate$lambda$5(Function1 $tmp0, Object p0) {
        return (BasicDatabase)$tmp0.invoke(p0);
    }

    private static final Unit checkElementsUptodate$lambda$8(LinkedHashMap $ids, LinkedHashMap $res, MsIntroQueries.OneState s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        MsSchemaObject msSchemaObject = (MsSchemaObject)$ids.get(s.object_id);
        if (msSchemaObject == null) {
            return Unit.INSTANCE;
        }
        MsSchemaObject obj2 = msSchemaObject;
        ((Map)$res).put(obj2, Intrinsics.areEqual((Object)obj2.getModifiedTimestamp(), (Object)s.modify_date));
        return Unit.INSTANCE;
    }

    private static final Unit checkElementsUptodate$lambda$10(LinkedHashMap $res, MsRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Set set = $res.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            BasicElement obj2 = (BasicElement)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Boolean ok2 = (Boolean)v;
            Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
            ((BasicModElement)obj2).setOutdated(ok2 == false);
        }
        return Unit.INSTANCE;
    }

    private static final SchemaPortion makePortions$lambda$13(MsDatabase $database, IntrospectionMode $mode, List chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        return new SchemaPortion($database, chunk, $mode);
    }

    private static final Unit markSchemaIntrospected$lambda$14(MsIntrospector this$0, MsSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        MsIntroQueries.CurrentSessionInfo currentSessionInfo = this$0.currentSessionInfo;
        Timestamp timestamp = BaseIntrospectionFunctions.nullize(currentSessionInfo != null ? currentSessionInfo.now : null, BaseIntrospectionFunctions.AGES_AGO);
        schema.setIntrospectionTimestamp(timestamp != null ? (Date)timestamp : (Date)BaseIntrospectionFunctions.AGES_AGO);
        schema.setLastIntrospectionLocalTimestamp(CalendarFun.currentInstantTruncatedToSeconds());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Map access$getParametersMap(MsIntrospector $this) {
        return $this.getParametersMap();
    }

    public static final /* synthetic */ MsRoot access$getRoot(MsIntrospector $this) {
        return (MsRoot)$this.getRoot();
    }

    public static final /* synthetic */ MsIntrospectorHelper access$getHelper$p(MsIntrospector $this) {
        return $this.helper;
    }

    static {
        Object[] objectArray = new ObjectKind[]{ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.ALIAS_TYPE, ObjectKind.TABLE_TYPE, ObjectKind.RULE, ObjectKind.SEQUENCE, ObjectKind.SYNONYM, ObjectKind.SECURITY_POLICY};
        supportFragmentKinds = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$Companion;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "<init>", "()V", "supportServerObjects", "", "getSupportServerObjects", "()Z", "supportLevelByLevelIntrospection", "getSupportLevelByLevelIntrospection", "supportFragmentIntrospection", "getSupportFragmentIntrospection", "supportFragmentKinds", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportFragmentKinds", "()Ljava/util/Set;", "ourMaxSchemasPerChunk", "", "intellij.database.dialects.mssql"})
    public static final class Companion
    implements BaseIntrospector.Nature {
        private Companion() {
        }

        @Override
        public boolean getSupportServerObjects() {
            return true;
        }

        @Override
        public boolean getSupportLevelByLevelIntrospection() {
            return true;
        }

        @Override
        public boolean getSupportFragmentIntrospection() {
            return true;
        }

        @Override
        @NotNull
        public Set<ObjectKind> getSupportFragmentKinds() {
            return supportFragmentKinds;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\r\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "isIncremental", "supportsMultilevelIntrospection", "getSupportsMultilevelIntrospection", "()Z", "supportsFragmentIntrospection", "getSupportsFragmentIntrospection", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.mssql"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @NotNull
        private final Dbms dbms;
        private final boolean supportsMultilevelIntrospection;
        private final boolean supportsFragmentIntrospection;

        public Factory(@NotNull Dbms dbms) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            this.dbms = dbms;
            this.supportsMultilevelIntrospection = true;
            this.supportsFragmentIntrospection = true;
        }

        @NotNull
        public final Dbms getDbms() {
            return this.dbms;
        }

        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{9};
            return version.isOrGreater(nArray);
        }

        @Override
        public boolean isIncremental() {
            return true;
        }

        public boolean getSupportsMultilevelIntrospection() {
            return this.supportsMultilevelIntrospection;
        }

        public boolean getSupportsFragmentIntrospection() {
            return this.supportsFragmentIntrospection;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new MsIntrospector(context, dbms, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return MsIntrospectorKt.access$canCheckOutdated(e);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.mssql"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u000f\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00032\b\u0012\u0004\u0012\u00020\u00020\u0006B\u0019\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\rJ\u0006\u0010\u0013\u001a\u00020\rJ\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002J\b\u0010\u001a\u001a\u00020\rH\u0002J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\rH\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\rH\u0002J\b\u0010\u001f\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010!\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\"\u001a\u00020\rH\u0002J\b\u0010#\u001a\u00020\rH\u0014J\b\u0010$\u001a\u00020\rH\u0002J\b\u0010%\u001a\u00020\rH\u0016\u00a8\u0006&"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/mssql/model/MsRoot;", "Lcom/intellij/database/dialects/mssql/model/MsSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$MultiLevelDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mssql/model/MsDatabase;)V", "processLevel1", "", "processLevel2", "processLevel3", "retrieveAuxiliaryObjects", "retrieveAuxiliaryObjectsLevel1", "retrieveAuxiliaryObjectsL1Inner", "retrieveAuxiliaryObjectsLevel2", "retrieveRoles", "db", "checksum", "", "retrieveColumnMasterKeys", "retrieveColumnEncryptionKeys", "retrieveColumnEncryptionKeyValues", "retrieveAssemblies", "retrievePartitionFunctions", "retrieveFileGroups", "retrievePartitionSchemes", "retrievePermissions", "retrieveSynapseCollations", "retrieveExtProperties", "checkFingerprint", "beforeSchemasRetrieval", "checkAzureDatabaseSelectedCorrectly", "retrieveSchemas", "intellij.database.dialects.mssql"})
    @SourceDebugExtension(value={"SMAP\nMsIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsDatabaseRetriever\n+ 2 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/IdCache\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 ModelFun.kt\ncom/intellij/database/model/ModelFun\n*L\n1#1,2781:1\n1084#2:2782\n1179#2,2:2783\n1085#2,5:2785\n1184#2,2:2790\n1090#2,2:2792\n178#3,8:2794\n178#3,8:2802\n178#3,8:2811\n178#3,8:2819\n336#3,4:2834\n340#3:2842\n198#3,11:2843\n341#3:2854\n178#3,8:2855\n178#3,8:2863\n1#4:2810\n432#5,3:2827\n1563#6:2830\n1634#6,3:2831\n1869#6:2873\n1870#6:2876\n37#7:2838\n36#7,3:2839\n435#8,2:2871\n437#8,2:2874\n439#8,3:2877\n*S KotlinDebug\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsDatabaseRetriever\n*L\n868#1:2782\n868#1:2783,2\n868#1:2785,5\n868#1:2790,2\n868#1:2792,2\n968#1:2794,8\n1011#1:2802,8\n916#1:2811,8\n933#1:2819,8\n947#1:2834,4\n947#1:2842\n947#1:2843,11\n947#1:2854\n982#1:2855,8\n1029#1:2863,8\n949#1:2827,3\n947#1:2830\n947#1:2831,3\n1153#1:2873\n1153#1:2876\n947#1:2838\n947#1:2839,3\n1153#1:2871,2\n1153#1:2874,2\n1153#1:2877,3\n*E\n"})
    protected final class MsDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<MsDatabase>
    implements BaseNativeIntrospector.MultiLevelDatabaseRetriever<MsDatabase> {
        public MsDatabaseRetriever(@NotNull DBTransaction transaction, MsDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)MsIntrospector.this, transaction, (BasicModMateDatabase)database);
            MsIntrospector.this.prepareQueryParameters$intellij_database_dialects_mssql((BasicDatabase)this.getDatabase(), this.getParametersMap());
        }

        @Override
        public void processLevel1() {
            this.retrieveAuxiliaryObjectsLevel1();
        }

        @Override
        public void processLevel2() {
            this.retrieveAuxiliaryObjectsLevel2();
        }

        @Override
        public void processLevel3() {
        }

        @Override
        public void retrieveAuxiliaryObjects() {
            this.retrieveAuxiliaryObjectsLevel1();
            this.retrieveAuxiliaryObjectsLevel2();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void retrieveAuxiliaryObjectsLevel1() {
            void this_$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv;
            void $this$iv$iv;
            void this_$iv;
            BaseIntrospector baseIntrospector = MsIntrospector.this;
            String name$iv = "Introspecting Database auxiliary objects on Level 1";
            boolean $i$f$doSection = false;
            void var4_4 = this_$iv;
            String name$iv$iv = name$iv;
            CharSequence message$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv);
            DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv) : null;
            try {
                boolean bl = false;
                this.retrieveAuxiliaryObjectsL1Inner();
                $this$iv$iv = this_$iv;
                sectionReference$iv$iv = ref$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv == null) return;
            }
            catch (Throwable throwable) {
                void this_$iv$iv2;
                sectionReference$iv$iv = this_$iv;
                DiagnosticSectionReference sectionReference$iv$iv2 = ref$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv, null, 2, null);
        }

        public final void retrieveAuxiliaryObjectsL1Inner() {
            this.checkFingerprint();
            if (MsIntrospector.this.isSynapseMaster()) {
                this.retrieveSynapseCollations(this.getTransaction());
            }
            MsIntroQueries.DatabaseObjectsChecksums databaseObjectsChecksums = this.performQuery(MsIntrospector.this.myQueries.getCalculateDatabaseObjectsChecksums());
            Intrinsics.checkNotNullExpressionValue((Object)databaseObjectsChecksums, (String)"performQuery(...)");
            MsIntroQueries.DatabaseObjectsChecksums checksums = databaseObjectsChecksums;
            this.inDatabase(arg_0 -> MsDatabaseRetriever.retrieveAuxiliaryObjectsL1Inner$lambda$0(this, checksums, arg_0));
        }

        public final void retrieveAuxiliaryObjectsLevel2() {
            this.retrievePermissions();
            this.retrieveColumnMasterKeys();
            this.retrieveColumnEncryptionKeys();
            this.retrieveColumnEncryptionKeyValues();
            this.retrievePartitionFunctions();
            this.retrievePartitionSchemes();
        }

        private final void retrieveRoles(MsDatabase db, long checksum) {
            if (db.getRolesChecksum() == checksum || !db.isOnline()) {
                return;
            }
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this, MsIntrospector.this.myQueries.getRetrieveRoles(), 0, arg_0 -> MsDatabaseRetriever.retrieveRoles$lambda$4(db, arg_0), 2, null);
            db.setRolesChecksum(checksum);
        }

        private final void retrieveColumnMasterKeys() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLUMN_MASTER_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN_MASTER_KEY");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase(arg_0 -> MsDatabaseRetriever.retrieveColumnMasterKeys$lambda$8(this, MsIntrospector.this, arg_0));
        }

        private final void retrieveColumnEncryptionKeys() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLUMN_ENCRYPTION_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN_ENCRYPTION_KEY");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase(arg_0 -> MsDatabaseRetriever.retrieveColumnEncryptionKeys$lambda$11(this, MsIntrospector.this, arg_0));
        }

        private final void retrieveColumnEncryptionKeyValues() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLUMN_ENCRYPTION_KEY_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN_ENCRYPTION_KEY_VALUE");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase(arg_0 -> MsDatabaseRetriever.retrieveColumnEncryptionKeyValues$lambda$17(this, MsIntrospector.this, arg_0));
        }

        private final void retrieveAssemblies(MsDatabase db, long checksum) {
            if (db.getAssembliesChecksum() == checksum) {
                return;
            }
            ObjectKind objectKind = ObjectKind.ASSEMBLY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ASSEMBLY");
            MsIntrospector.this.reportRetrieving(objectKind);
            List<MsIntroQueries.OneAssembly> ams = this.performQuery(MsIntrospector.this.myQueries.getRetrieveAssemblies());
            ModFamily $this$modifyAndCleanup_u24default$iv = db.getAssemblies();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily assemblies = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            for (MsIntroQueries.OneAssembly a : ams) {
                Object e;
                Intrinsics.checkNotNullExpressionValue(assemblies.renew(a.assembly_id, a.name), (String)"renew(...)");
                MsAssembly $this$retrieveAssemblies_u24lambda_u2419_u24lambda_u2418 = (MsAssembly)e;
                boolean bl2 = false;
                $this$retrieveAssemblies_u24lambda_u2419_u24lambda_u2418.setVisible(a.is_visible);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            db.setAssembliesChecksum(checksum);
        }

        private final void retrievePartitionFunctions() {
            ObjectKind objectKind = ObjectKind.PARTITION_FUNCTION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PARTITION_FUNCTION");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase(arg_0 -> MsDatabaseRetriever.retrievePartitionFunctions$lambda$25(this, MsIntrospector.this, arg_0));
        }

        private final void retrieveFileGroups(MsDatabase db, long checksum) {
            if (db.getFileGroupsChecksum() == checksum) {
                return;
            }
            boolean bl = db.isOnline();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ObjectKind objectKind = ObjectKind.FILEGROUP;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"FILEGROUP");
            MsIntrospector.this.reportRetrieving(objectKind);
            List fgs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveFileGroups(), null, 0, 6, null);
            ModFamily $this$modifyAndCleanup_u24default$iv = db.getFileGroups();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily fileGroups = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl2 = false;
            for (MsIntroQueries.OneFileGroup fg : fgs) {
                Object e;
                Intrinsics.checkNotNullExpressionValue(fileGroups.renew(fg.data_space_id, fg.name), (String)"renew(...)");
                MsFileGroup $this$retrieveFileGroups_u24lambda_u2427_u24lambda_u2426 = (MsFileGroup)e;
                boolean bl3 = false;
                $this$retrieveFileGroups_u24lambda_u2427_u24lambda_u2426.setDataSpaceKind(MsDataSpaceKind.Companion.valueFor(fg.type));
                $this$retrieveFileGroups_u24lambda_u2427_u24lambda_u2426.setDefaultGroup(fg.is_default);
                $this$retrieveFileGroups_u24lambda_u2427_u24lambda_u2426.setSystem(fg.is_system);
                $this$retrieveFileGroups_u24lambda_u2427_u24lambda_u2426.setReadOnly(fg.is_read_only);
                $this$retrieveFileGroups_u24lambda_u2427_u24lambda_u2426.setAutoGrowAllFiles(fg.is_autogrow_all_files);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            db.setFileGroupsChecksum(checksum);
        }

        private final void retrievePartitionSchemes() {
            ObjectKind objectKind = ObjectKind.PARTITION_SCHEME;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PARTITION_SCHEME");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase(arg_0 -> MsDatabaseRetriever.retrievePartitionSchemes$lambda$32(this, MsIntrospector.this, arg_0));
        }

        private final void retrievePermissions() {
            MsIntrospector.this.reportRetrieving("objects' permissions", "introspection.retrieve.objectPermissions");
            if (((MsDatabase)this.getDatabase()).isOnline()) {
                MsIntrospectorKt.access$retrievePermissions(this, (MsGrantsHolder)this.getDatabase(), this.getTransaction(), MsIntrospector.this.myQueries.getCalculateDbPermissionsChecksum(), MsIntrospector.this.myQueries.getRetrieveDbPermissions());
            } else {
                MsIntrospectorKt.access$retrievePermissions(this, (MsGrantsHolder)this.getDatabase(), this.getTransaction(), null, null);
            }
        }

        private final void retrieveSynapseCollations(DBTransaction transaction) {
            MsServerObjectsRetriever serverRetriever = MsIntrospector.this.createServerObjectsRetriever(transaction);
            serverRetriever.setupRegular();
            serverRetriever.retrieveCollations$intellij_database_dialects_mssql();
        }

        private final void retrieveExtProperties(MsDatabase db, long checksum) {
            if (db.getExtPropsChecksum() == checksum || !db.isOnline()) {
                return;
            }
            List<MsIntroQueries.OneProperty> props = this.performQuery(MsIntrospector.this.myQueries.getRetrieveDbExtendedProperties());
            MsIntrospectorKt.access$setExtProps(db, props);
            db.setExtPropsChecksum(checksum);
        }

        private final void checkFingerprint() {
            String oldFingerprint;
            String newFingerprint;
            String string;
            if (!((MsDatabase)this.getDatabase()).isOnline()) {
                this.inDatabase(MsDatabaseRetriever::checkFingerprint$lambda$33);
                return;
            }
            String string2 = ((MsDatabase)this.getDatabase()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String databaseName = string2;
            String calculatedFingerprint = this.performQuery(MsIntrospector.this.myQueries.getQueryFingerprint());
            if (calculatedFingerprint == null) {
                this.log.warn("Failed to calculate the fingerprint for the database " + databaseName);
            }
            if ((string = calculatedFingerprint) == null) {
                string = newFingerprint = "failed-to-calculate";
            }
            if ((oldFingerprint = ((MsDatabase)this.getDatabase()).getFingerprint()) == null) {
                this.log.info("Setting the fingerprint for the database " + databaseName + ": " + newFingerprint);
                this.inDatabase(arg_0 -> MsDatabaseRetriever.checkFingerprint$lambda$34(newFingerprint, arg_0));
                return;
            }
            if (!Intrinsics.areEqual((Object)newFingerprint, (Object)oldFingerprint)) {
                this.log.info("Database replacement for database " + databaseName + " detected: \n\told fingerprint: " + oldFingerprint + " \n\tnew fingerprint: " + newFingerprint + " ");
                this.inDatabase(arg_0 -> MsDatabaseRetriever.checkFingerprint$lambda$35(newFingerprint, arg_0));
            }
        }

        @Override
        protected void beforeSchemasRetrieval() {
            if (MsIntrospector.this.dbms.in(Dbms.AZURE_LIKE)) {
                this.checkAzureDatabaseSelectedCorrectly();
            }
            MsIntrospector.this.prepareQueryParameters$intellij_database_dialects_mssql((BasicDatabase)this.getDatabase(), this.getParametersMap());
        }

        private final void checkAzureDatabaseSelectedCorrectly() {
            String connectionDbName = ((MsIntrospector)MsIntrospector.this).getDbConnectionInfo().databaseName;
            String requestedDbName = ((MsDatabase)this.getDatabase()).getCatalogName();
            if (!Intrinsics.areEqual((Object)connectionDbName, (Object)requestedDbName)) {
                String message = "Azure limitation: Attempted to introspect database [" + requestedDbName + "] with connection to database [" + connectionDbName + "] might ends with Azure error [40515]";
                MsIntrospector.this.getErrorSink().accept(message, null);
            }
        }

        @Override
        public void retrieveSchemas() {
            this.trace("Listing schemas of database " + ((MsDatabase)this.getDatabase()).getName());
            super.retrieveSchemas();
            Ref.ObjectRef scs = new Ref.ObjectRef();
            try {
                List<MsIntroQueries.OneSchema> list;
                if (((MsDatabase)this.getDatabase()).isOnline()) {
                    List<MsIntroQueries.OneSchema> list2 = this.performQuery(MsIntrospector.this.myQueries.getListSchemas());
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"performQuery(...)");
                    list = list2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                scs.element = list;
            }
            catch (DBException e) {
                int vendorCode = e.vendorErrorCode;
                switch (vendorCode) {
                    case 916: 
                    case 40515: {
                        this.trace("Error " + vendorCode + ": " + e.getMessage());
                        scs.element = CollectionsKt.emptyList();
                        break;
                    }
                    default: {
                        MsIntrospector.this.getErrorSink().accept(null, e);
                        throw e;
                    }
                }
            }
            this.inDatabase(arg_0 -> MsDatabaseRetriever.retrieveSchemas$lambda$38(scs, arg_0));
        }

        private static final Unit retrieveAuxiliaryObjectsL1Inner$lambda$0(MsDatabaseRetriever this$0, MsIntroQueries.DatabaseObjectsChecksums $checksums, MsDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            this$0.retrieveExtProperties(db, $checksums.extprop_cs);
            this$0.retrieveFileGroups(db, $checksums.filegroups_cs);
            this$0.retrieveAssemblies(db, $checksums.assemblies_cs);
            this$0.retrieveRoles(db, $checksums.roles_cs);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoles$lambda$4(MsDatabase $db, MsIntroQueries.OneRole r) {
            MsAuthType msAuthType;
            Enum enum_;
            MsRole msRole;
            MsRole $this$retrieveRoles_u24lambda_u244_u24lambda_u243;
            block5: {
                MsDatabasePrincipalType msDatabasePrincipalType;
                MsDatabasePrincipalType msDatabasePrincipalType2;
                Enum it;
                Enum enum_2;
                int n;
                int n2;
                Enum[] enumArray;
                Enum[] enumArray2;
                block4: {
                    MsRole msRole2;
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    MsRole msRole3 = $db.getRoles().renew(r.principal_id, r.name);
                    Intrinsics.checkNotNullExpressionValue((Object)msRole3, (String)"renew(...)");
                    $this$retrieveRoles_u24lambda_u244_u24lambda_u243 = msRole2 = msRole3;
                    boolean bl = false;
                    $this$retrieveRoles_u24lambda_u244_u24lambda_u243.setDefaultSchema(r.default_schema_name);
                    enumArray2 = MsDatabasePrincipalType.values();
                    msRole = $this$retrieveRoles_u24lambda_u244_u24lambda_u243;
                    enumArray = enumArray2;
                    n2 = enumArray.length;
                    for (n = 0; n < n2; ++n) {
                        it = enum_2 = enumArray[n];
                        boolean bl2 = false;
                        if (!(((MsDatabasePrincipalType)it).getCode() == r.type)) continue;
                        msDatabasePrincipalType2 = enum_2;
                        break block4;
                    }
                    msDatabasePrincipalType2 = msDatabasePrincipalType = null;
                }
                if (msDatabasePrincipalType2 == null) {
                    msDatabasePrincipalType = MsDatabasePrincipalType.SQL_USER;
                }
                msRole.setType(msDatabasePrincipalType);
                enumArray2 = MsAuthType.values();
                msRole = $this$retrieveRoles_u24lambda_u244_u24lambda_u243;
                enumArray = enumArray2;
                n2 = enumArray.length;
                for (n = 0; n < n2; ++n) {
                    it = enum_2 = enumArray[n];
                    boolean bl = false;
                    if (!(((MsAuthType)it).getCode() == r.authentication_type)) continue;
                    enum_ = enum_2;
                    break block5;
                }
                enum_ = msAuthType = null;
            }
            if (enum_ == null) {
                msAuthType = MsAuthType.DATABASE;
            }
            msRole.setAuthType(msAuthType);
            $this$retrieveRoles_u24lambda_u244_u24lambda_u243.setOwnerRef(BasicIdReference.create(r.owning_principal_id));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveColumnMasterKeys$lambda$8$lambda$7$lambda$6(ModNamingIdentifyingFamily $mks, MsIntroQueries.OneColumnMasterKey k) {
            Intrinsics.checkNotNullParameter((Object)k, (String)"k");
            Object e = $mks.renew(k.column_master_key_id, k.name);
            Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
            Object e2 = e;
            MsColumnMasterKey $this$retrieveColumnMasterKeys_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245 = (MsColumnMasterKey)e2;
            boolean bl = false;
            $this$retrieveColumnMasterKeys_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setKeyStoreProviderName(k.key_store_provider_name);
            $this$retrieveColumnMasterKeys_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setKeyPath(k.key_path);
            $this$retrieveColumnMasterKeys_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setSignature(k.signature);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveColumnMasterKeys$lambda$8(MsDatabaseRetriever this$0, MsIntrospector this$1, MsDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = db.getColumnMasterKeys();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily mks = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.myQueries.getRetrieveColumnMasterKeys(), 0, arg_0 -> MsDatabaseRetriever.retrieveColumnMasterKeys$lambda$8$lambda$7$lambda$6(mks, arg_0), 2, null);
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveColumnEncryptionKeys$lambda$11$lambda$10$lambda$9(ModNamingIdentifyingFamily $eks, MsIntroQueries.OneColumnEncryptionKey k) {
            Intrinsics.checkNotNullParameter((Object)k, (String)"k");
            $eks.renew(k.column_encryption_key_id, k.name);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveColumnEncryptionKeys$lambda$11(MsDatabaseRetriever this$0, MsIntrospector this$1, MsDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = db.getColumnEncryptionKeys();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily eks = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.myQueries.getRetrieveColumnEncryptionKeys(), 0, arg_0 -> MsDatabaseRetriever.retrieveColumnEncryptionKeys$lambda$11$lambda$10$lambda$9(eks, arg_0), 2, null);
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveColumnEncryptionKeyValues$lambda$17$lambda$16$lambda$15(IdCache $keyCache, MsDatabase $db, MsIntroQueries.OneColumnEncryptionKeyValue v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            var5_3 = $keyCache;
            id$iv = v.column_encryption_key_id;
            $i$f$getOrCache = false;
            if (this_$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv.getV();
            Intrinsics.checkNotNull(v0);
            if (((BasicIdentifiedElement)v0).getObjectId() == id$iv) {
                v1 = this_$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var9_7 = id$iv;
                var11_8 = this_$iv;
                var13_9 = this_$iv;
                $i$a$-getOrCache-MsIntrospector$MsDatabaseRetriever$retrieveColumnEncryptionKeyValues$1$2$1$key$1 = false;
                var13_9.setV((BasicModIdentifiedElement)((MsColumnEncryptionKey)$db.getColumnEncryptionKeys().getByObjectId((long)it)));
                v1 = this_$iv.getV();
            }
            v2 = (MsColumnEncryptionKey)v1;
            if (v2 == null) {
                return Unit.INSTANCE;
            }
            key = v2;
            v3 = key.getValues().renew(v.column_master_key_id, "");
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"renew(...)");
            $this$retrieveColumnEncryptionKeyValues_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414 = var4_12 = v3;
            $i$a$-apply-MsIntrospector$MsDatabaseRetriever$retrieveColumnEncryptionKeyValues$1$2$1$1 = false;
            $this$retrieveColumnEncryptionKeyValues_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.setNameSurrogate(true);
            $this$retrieveColumnEncryptionKeyValues_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.setMasterKeyRef(BasicIdReference.create(v.column_master_key_id));
            $this$retrieveColumnEncryptionKeyValues_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.setEncryptedValue(v.encrypted_value);
            $this$retrieveColumnEncryptionKeyValues_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.setAlgorithm(v.encryption_algorithm_name);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveColumnEncryptionKeyValues$lambda$17(MsDatabaseRetriever this$0, MsIntrospector this$1, MsDatabase db) {
            void families$iv$iv;
            void families$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            IdCache keyCache = new IdCache();
            ModNamingIdentifyingFamily<? extends MsColumnEncryptionKey> modNamingIdentifyingFamily = db.getColumnEncryptionKeys();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getColumnEncryptionKeys(...)");
            Iterable $this$map$iv = modNamingIdentifyingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MsColumnEncryptionKey msColumnEncryptionKey = (MsColumnEncryptionKey)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getValues());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingIdentifyingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.myQueries.getRetrieveColumnEncryptionKeyValues(), 0, arg_0 -> MsDatabaseRetriever.retrieveColumnEncryptionKeyValues$lambda$17$lambda$16$lambda$15(keyCache, db, arg_0), 2, null);
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrievePartitionFunctions$lambda$25$lambda$24$lambda$21(ModNamingIdentifyingFamily $partitionFunctions, MsIntroQueries.OnePartitionFunction pf) {
            Intrinsics.checkNotNullParameter((Object)pf, (String)"pf");
            Object e = $partitionFunctions.renew(pf.function_id, pf.name);
            Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
            Object e2 = e;
            MsPartitionFunction $this$retrievePartitionFunctions_u24lambda_u2425_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420 = (MsPartitionFunction)e2;
            boolean bl = false;
            $this$retrievePartitionFunctions_u24lambda_u2425_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420.setParameterStoredType(MsIntrospectorKt.access$makeDasType(pf.type_name, pf.max_length, pf.precision, pf.scale));
            $this$retrievePartitionFunctions_u24lambda_u2425_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420.setRight(pf.boundary_value_on_right);
            return Unit.INSTANCE;
        }

        private static final Unit retrievePartitionFunctions$lambda$25$lambda$24$lambda$23(ModNamingIdentifyingFamily $partitionFunctions, MultiMap $rangeValues, MsIntroQueries.OnePartitionFunctionRange pfr) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)pfr, (String)"pfr");
                MsPartitionFunction msPartitionFunction = (MsPartitionFunction)$partitionFunctions.getByObjectId(pfr.function_id);
                if (msPartitionFunction == null) break block0;
                MsPartitionFunction it = msPartitionFunction;
                boolean bl = false;
                Object value = pfr.boundary_value;
                String text2 = value instanceof byte[] ? "0x" + StringUtil.toHexString((byte[])((byte[])value)) : String.valueOf(value);
                $rangeValues.putValue((Object)it, (Object)text2);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrievePartitionFunctions$lambda$25(MsDatabaseRetriever this$0, MsIntrospector this$1, MsDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = db.getPartitionFunctions();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily partitionFunctions = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.myQueries.getRetrievePartitionFunctions(), 0, arg_0 -> MsDatabaseRetriever.retrievePartitionFunctions$lambda$25$lambda$24$lambda$21(partitionFunctions, arg_0), 2, null);
            MultiMap rangeValues = new MultiMap();
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.myQueries.getRetrievePartitionFunctionRanges(), 0, arg_0 -> MsDatabaseRetriever.retrievePartitionFunctions$lambda$25$lambda$24$lambda$23(partitionFunctions, rangeValues, arg_0), 2, null);
            for (Map.Entry entry : rangeValues.entrySet()) {
                Intrinsics.checkNotNull((Object)entry);
                MsPartitionFunction pf = (MsPartitionFunction)entry.getKey();
                Collection v = (Collection)entry.getValue();
                Intrinsics.checkNotNull((Object)v);
                pf.setBoundaryValues(CollectionsKt.toList((Iterable)v));
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrievePartitionSchemes$lambda$32$lambda$31$lambda$29(ModNamingIdentifyingFamily $partitionSchemes, MsIntroQueries.OnePartitionScheme ps) {
            Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
            Object e = $partitionSchemes.renew(ps.data_space_id, ps.name);
            Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
            Object e2 = e;
            MsPartitionScheme $this$retrievePartitionSchemes_u24lambda_u2432_u24lambda_u2431_u24lambda_u2429_u24lambda_u2428 = (MsPartitionScheme)e2;
            boolean bl = false;
            $this$retrievePartitionSchemes_u24lambda_u2432_u24lambda_u2431_u24lambda_u2429_u24lambda_u2428.setDataSpaceKind(MsDataSpaceKind.PARTITION_SCHEME);
            $this$retrievePartitionSchemes_u24lambda_u2432_u24lambda_u2431_u24lambda_u2429_u24lambda_u2428.setPartitionFunctionRef(BasicIdReference.create(ps.function_id));
            return Unit.INSTANCE;
        }

        private static final Unit retrievePartitionSchemes$lambda$32$lambda$31$lambda$30(ModNamingIdentifyingFamily $partitionSchemes, MultiMap $fileGroupRefs, MsIntroQueries.OnePartitionSchemeMapping psm) {
            Intrinsics.checkNotNullParameter((Object)psm, (String)"psm");
            MsPartitionScheme msPartitionScheme = (MsPartitionScheme)$partitionSchemes.getByObjectId(psm.partition_scheme_id);
            if (msPartitionScheme == null) {
                return Unit.INSTANCE;
            }
            MsPartitionScheme partitionScheme = msPartitionScheme;
            $fileGroupRefs.putValue((Object)partitionScheme, (Object)BasicIdReference.create(psm.data_space_id));
            return Unit.INSTANCE;
        }

        private static final Unit retrievePartitionSchemes$lambda$32(MsDatabaseRetriever this$0, MsIntrospector this$1, MsDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = db.getPartitionSchemes();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily partitionSchemes = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.myQueries.getRetrievePartitionSchemes(), 0, arg_0 -> MsDatabaseRetriever.retrievePartitionSchemes$lambda$32$lambda$31$lambda$29(partitionSchemes, arg_0), 2, null);
            if (!this$1.isAnySynapse()) {
                MultiMap fileGroupRefs = new MultiMap();
                BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.myQueries.getRetrievePartitionSchemeMappings(), 0, arg_0 -> MsDatabaseRetriever.retrievePartitionSchemes$lambda$32$lambda$31$lambda$30(partitionSchemes, fileGroupRefs, arg_0), 2, null);
                for (Map.Entry entry : fileGroupRefs.entrySet()) {
                    Intrinsics.checkNotNull((Object)entry);
                    MsPartitionScheme ps = (MsPartitionScheme)entry.getKey();
                    Collection refs = (Collection)entry.getValue();
                    Intrinsics.checkNotNull((Object)refs);
                    ps.setFileGroupRefs(CollectionsKt.toList((Iterable)refs));
                }
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit checkFingerprint$lambda$33(MsDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            db.setFingerprint(null);
            return Unit.INSTANCE;
        }

        private static final Unit checkFingerprint$lambda$34(String $newFingerprint, MsDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            db.setFingerprint($newFingerprint);
            return Unit.INSTANCE;
        }

        private static final Unit checkFingerprint$lambda$35(String $newFingerprint, MsDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            for (MsSchema schema : db.getSchemas()) {
                schema.setIntrospectionTimestamp(null);
                schema.setComment(null);
                schema.setExtendedProperties(CollectionsKt.emptyList());
                schema.setAliasTypesCheckSum(0L);
                schema.setDescriptionsCheckSum(0L);
            }
            db.setFingerprint($newFingerprint);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveSchemas$lambda$38(Ref.ObjectRef $scs, MsDatabase db) {
            void $this$applySchemasImpl$iv;
            ModNamingFamily schemas;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModNamingFamily modNamingFamily = db.getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)modNamingFamily, (String)"getSchemas(...)");
            ModNamingFamily modNamingFamily2 = schemas = modNamingFamily;
            List scs$iv = (List)$scs.element;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv = scs$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object e;
                void sc;
                Object element$iv$iv;
                Object sc$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                MsIntroQueries.OneSchema oneSchema = (MsIntroQueries.OneSchema)sc$iv;
                void $this$retrieveSchemas_u24lambda_u2438_u24lambda_u2437 = $this$applySchemasImpl$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue(schemas.renew(sc.id, sc.name), (String)"renew(...)");
                MsSchema $this$retrieveSchemas_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436 = (MsSchema)e;
                boolean bl3 = false;
                $this$retrieveSchemas_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436.setCurrent(sc.curr);
            }
            $this$applySchemasImpl$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv.sort();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002$\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001R\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004B/\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u001b\u001a\u00020\u00162\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u001dH\u0002J\b\u0010\"\u001a\u00020\u001dH\u0016J\u0018\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&H\u0002J \u0010*\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J \u0010*\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020.2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J\b\u0010/\u001a\u00020\u001dH\u0002J\u001e\u00100\u001a\u00020\u001d2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\u001dH\u0002J\b\u00104\u001a\u00020\u001dH\u0002J.\u00105\u001a\u000206*\n\u0012\u0006\b\u0001\u0012\u000206072\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020=H\u0002J\b\u0010>\u001a\u00020\u001dH\u0002J\b\u0010?\u001a\u00020\u001dH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsLevelOneRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseSchemasRetriever;", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "Lcom/intellij/database/dialects/mssql/model/MsSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/mssql/model/MsRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "schemas", "", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "<init>", "(Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mssql/model/MsDatabase;Ljava/util/List;Lcom/intellij/database/introspection/IntrospectionMode;)V", "myQueries", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$L1;", "mySchemasById", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "introspectionLocalTimestamp", "Ljava/time/Instant;", "myFromTimestamp", "Ljava/sql/Timestamp;", "schemasAreEmpty", "", "affectedMajorObjects", "Lcom/intellij/database/dialects/mssql/model/MsSchemaObject;", "findTheFromTimestamp", "process", "", "processFragments", "fragments", "Lcom/intellij/database/introspection/FamilyFragments;", "prepareDatabaseCommonParameters", "detectAndRemoveDroppedObjects", "removeUnexistentSchemaObjects", "schema", "existentObjectIds", "Lit/unimi/dsi/fastutil/ints/AbstractIntSet;", "detachUnexistentDefaultConstraints", "table", "Lcom/intellij/database/dialects/mssql/model/MsTable;", "removeUnexistentIndices", "existentIndicesCombies", "Lit/unimi/dsi/fastutil/longs/LongSet;", "tablesWithFulltextIndices", "Lcom/intellij/database/dialects/mssql/model/MsStoredTable;", "retrieveAliases", "retrieveAliasesForSchemas", "csMap", "Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "retrieveMajorNames", "retrieveMinorNames", "reuseArgument", "Lcom/intellij/database/dialects/mssql/model/MsArgument;", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "pos", "", "name", "", "dir", "Lcom/intellij/database/model/ArgumentDirection;", "finalizeLevel1", "traceEffects", "intellij.database.dialects.mssql"})
    @SourceDebugExtension(value={"SMAP\nMsIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsLevelOneRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SequenceFun.kt\ncom/intellij/database/util/common/SequenceFun\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 IntrospectionQueryContext.kt\ncom/intellij/database/dialects/base/introspector/IntrospectionQueryContext\n+ 8 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n*L\n1#1,2781:1\n1740#2,3:2782\n1761#2,3:2786\n1761#2,3:2789\n1563#2:2792\n1634#2,3:2793\n774#2:2796\n865#2,2:2797\n1761#2,3:2804\n774#2:2807\n865#2,2:2808\n774#2:2810\n865#2,2:2811\n1563#2:2813\n1634#2,3:2814\n1491#2:2817\n1516#2,3:2818\n1519#2,3:2828\n1491#2:2831\n1516#2,3:2832\n1519#2,3:2842\n1#3:2785\n9#4:2799\n37#5:2800\n36#5,3:2801\n382#6,7:2821\n382#6,7:2835\n411#7,2:2845\n178#8,8:2847\n178#8,8:2855\n178#8,8:2863\n*S KotlinDebug\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsLevelOneRetriever\n*L\n477#1:2782,3\n510#1:2786,3\n513#1:2789,3\n522#1:2792\n522#1:2793,3\n530#1:2796\n530#1:2797,2\n556#1:2804,3\n614#1:2807\n614#1:2808,2\n631#1:2810\n631#1:2811,2\n644#1:2813\n644#1:2814,3\n648#1:2817\n648#1:2818,3\n648#1:2828,3\n754#1:2831\n754#1:2832,3\n754#1:2842,3\n539#1:2799\n539#1:2800\n539#1:2801,3\n648#1:2821,7\n754#1:2835,7\n820#1:2845,2\n656#1:2847,8\n764#1:2855,8\n774#1:2863,8\n*E\n"})
    protected final class MsLevelOneRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseSchemasRetriever<MsDatabase, MsSchema> {
        @NotNull
        private final MsIntroQueries.L1 myQueries;
        @NotNull
        private final Long2ObjectOpenHashMap<MsSchema> mySchemasById;
        @NotNull
        private final Instant introspectionLocalTimestamp;
        @NotNull
        private final Timestamp myFromTimestamp;
        private final boolean schemasAreEmpty;
        @NotNull
        private IntrospectionMode mode;
        @NotNull
        private final Long2ObjectOpenHashMap<MsSchemaObject> affectedMajorObjects;

        /*
         * WARNING - void declaration
         */
        public MsLevelOneRetriever(@NotNull DBTransaction transaction, @NotNull MsDatabase database, @NotNull List<? extends MsSchema> schemas, IntrospectionMode mode) {
            boolean bl;
            boolean bl2;
            block4: {
                void $this$all$iv;
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                Intrinsics.checkNotNullParameter((Object)database, (String)"database");
                Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
                Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
                super((BaseMultiDatabaseIntrospector)MsIntrospector.this, transaction, (BasicModMateDatabase)database, schemas);
                this.myQueries = MsIntroQueries.L1.INSTANCE;
                this.mySchemasById = new Long2ObjectOpenHashMap();
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
                this.introspectionLocalTimestamp = instant;
                this.affectedMajorObjects = new Long2ObjectOpenHashMap();
                for (MsSchema msSchema : schemas) {
                    ((Map)this.mySchemasById).put(msSchema.getObjectId(), msSchema);
                }
                Iterable iterable = schemas;
                MsLevelOneRetriever msLevelOneRetriever = this;
                boolean bl3 = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        MsSchema it = (MsSchema)element$iv;
                        boolean bl32 = false;
                        if (!ModelFun.isNotEmpty(it)) continue;
                        bl2 = false;
                        break block4;
                    }
                    bl2 = true;
                }
            }
            msLevelOneRetriever.schemasAreEmpty = bl = bl2;
            this.mode = mode;
            this.myFromTimestamp = WhenMappings.$EnumSwitchMapping$0[mode.ordinal()] == 1 ? this.findTheFromTimestamp(schemas) : BaseIntrospectionFunctions.AGES_AGO;
            this.prepareDatabaseCommonParameters();
            BaseIntrospectionFunctions.setupModeParameters(this.mode, this.getParametersMap());
            this.setQueryParameter("since", this.myFromTimestamp);
            MsIntrospector.this.traceParameters("Database schemas retriever parameters (not cascading):", this.getParametersMap());
        }

        private final Timestamp findTheFromTimestamp(List<? extends MsSchema> schemas) {
            Iterator iterator = ((Iterable)schemas).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            MsSchema it = (MsSchema)iterator.next();
            boolean bl = false;
            Date date = it.getIntrospectionTimestamp();
            if (date == null || (date = CalendarFun.toTimestamp(date)) == null) {
                date = BaseIntrospectionFunctions.AGES_AGO;
            }
            Comparable comparable = date;
            while (iterator.hasNext()) {
                Comparable comparable2;
                MsSchema it2 = (MsSchema)iterator.next();
                $i$a$-minOf-MsIntrospector$MsLevelOneRetriever$findTheFromTimestamp$1 = false;
                Date date2 = it2.getIntrospectionTimestamp();
                if (date2 == null || (date2 = CalendarFun.toTimestamp(date2)) == null) {
                    date2 = BaseIntrospectionFunctions.AGES_AGO;
                }
                if (comparable.compareTo(comparable2 = (Comparable)date2) <= 0) continue;
                comparable = comparable2;
            }
            return (Timestamp)comparable;
        }

        @Override
        public void process() {
            MsIntrospector.this.majorEffects.removeAll();
            if (this.getSchemas().isEmpty()) {
                return;
            }
            this.detectAndRemoveDroppedObjects();
            this.retrieveAliases();
            this.retrieveMajorNames();
            this.retrieveMinorNames();
            this.finalizeLevel1();
        }

        public final void processFragments(@NotNull FamilyFragments fragments2) {
            boolean bl;
            block10: {
                FamilyFragment it;
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block9: {
                    Intrinsics.checkNotNullParameter((Object)fragments2, (String)"fragments");
                    if (this.getSchemas().isEmpty()) {
                        return;
                    }
                    this.prepareDatabaseCommonParameters();
                    $this$any$iv = fragments2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (FamilyFragment)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getKind(), (Object)ObjectKind.ALIAS_TYPE)) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    this.retrieveAliases();
                }
                $this$any$iv = fragments2;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (FamilyFragment)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getKind(), (Object)ObjectKind.SYNONYM)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.retrieveMajorNames();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void prepareDatabaseCommonParameters() {
            void $this$mapTo$iv$iv;
            MsIntrospector.this.prepareQueryParameters$intellij_database_dialects_mssql((BasicDatabase)this.getDatabase(), this.getParametersMap());
            Iterable $this$map$iv = this.getSchemas();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MsSchema msSchema = (MsSchema)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getObjectId());
            }
            long[] schemaIds = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
            this.setQueryParameter("schema_ids", schemaIds);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void detectAndRemoveDroppedObjects() {
            boolean canHaveIndices;
            List actualSchemas;
            block8: {
                void $this$filterTo$iv$iv;
                if (this.schemasAreEmpty) {
                    return;
                }
                Iterable $this$filter$iv = this.getSchemas();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    MsSchema it = (MsSchema)element$iv$iv;
                    boolean bl = false;
                    if (!ModelFun.isNotEmpty(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                actualSchemas = CollectionsKt.minus((Iterable)((List)destination$iv$iv), (Iterable)MsIntrospector.this.schemasWhereDroppedObjectsDetected);
                if (actualSchemas.isEmpty()) {
                    this.trace("Dropped objects in these schemas are already determined.");
                    return;
                }
                MsIntrospector.this.reportStatusDetails("Determining dropped objects in the schemas: " + CollectionsKt.joinToString$default((Iterable)actualSchemas, null, null, null, (int)0, null, null, (int)63, null), "introspection.retrieve.droppedObjects");
                Sequence $this$toArray$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)actualSchemas), MsLevelOneRetriever::detectAndRemoveDroppedObjects$lambda$6);
                boolean $i$f$toArray = false;
                Collection $this$toTypedArray$iv$iv = SequencesKt.toList((Sequence)$this$toArray$iv);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                Long[] actualSchemaIds = thisCollection$iv$iv.toArray(new Long[0]);
                int[] existentObjectsArray = this.performQuery(this.myQueries.getListExistentObjects(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"schema_ids", (Object)actualSchemaIds)), new Object[0]);
                int n = existentObjectsArray.length;
                this.trace("Found " + n + " regular major object identifiers");
                IntOpenHashSet existentObjectIds = new IntOpenHashSet(existentObjectsArray);
                int n1 = existentObjectIds.size();
                if (n1 != n) {
                    IntrospectionQueryContext.logWarn$default(this, "It's strange: got " + n + " regular major identifiers, but there are " + n1 + " unique of them", null, 2, null);
                }
                this.inDatabase(arg_0 -> MsLevelOneRetriever.detectAndRemoveDroppedObjects$lambda$7(actualSchemas, this, existentObjectIds, arg_0));
                Iterable $this$any$iv = actualSchemas;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MsSchema s = (MsSchema)element$iv;
                        boolean bl = false;
                        if (!(s.getTableTypes().isNotEmpty() || s.getTables().isNotEmpty())) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = canHaveIndices = false;
                }
            }
            if (canHaveIndices) {
                long[] existentIndicesArray = this.performQuery(this.myQueries.getListExistentIndices());
                LongOpenHashSet existentIndicesCombies = new LongOpenHashSet(existentIndicesArray);
                long[] tablesWithFulltextIndicesArray = MsIntrospector.this.isSynapse() ? ArrayUtil.EMPTY_LONG_ARRAY : this.performQuery(this.myQueries.getListExistentFulltextIndices());
                LongOpenHashSet tablesWithFulltextIndices = new LongOpenHashSet(tablesWithFulltextIndicesArray);
                this.inDatabase(arg_0 -> MsLevelOneRetriever.detectAndRemoveDroppedObjects$lambda$9(actualSchemas, this, existentIndicesCombies, tablesWithFulltextIndices, arg_0));
            }
            CollectionsKt.addAll((Collection)MsIntrospector.this.schemasWhereDroppedObjectsDetected, (Iterable)actualSchemas);
        }

        private final void removeUnexistentSchemaObjects(MsSchema schema, AbstractIntSet existentObjectIds) {
            ModNamingIdentifyingFamily<? extends MsSynonym> modNamingIdentifyingFamily = schema.getSynonyms();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSynonyms(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsRoutine> modNamingIdentifyingFamily2 = schema.getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getRoutines(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily2, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsView> modNamingIdentifyingFamily3 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getViews(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily3, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsTable> modNamingIdentifyingFamily4 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getTables(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily4, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsRule> modNamingIdentifyingFamily5 = schema.getRules();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getRules(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily5, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsSequence> modNamingIdentifyingFamily6 = schema.getSequences();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"getSequences(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily6, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsTableType> modNamingIdentifyingFamily7 = schema.getTableTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"getTableTypes(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily7, existentObjectIds);
            for (MsTable msTable : schema.getTables()) {
                NamingFamily<? extends BasicKey> namingFamily = msTable.getKeys();
                Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getKeys(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingFamily)), existentObjectIds);
                NamingFamily namingFamily2 = msTable.getForeignKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily2, (String)"getForeignKeys(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingFamily2)), existentObjectIds);
                NamingFamily<? extends BasicCheck> namingFamily3 = msTable.getChecks();
                Intrinsics.checkNotNullExpressionValue(namingFamily3, (String)"getChecks(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingFamily3)), existentObjectIds);
                ModNamingIdentifyingFamily<? extends MsDefaultConstraint> modNamingIdentifyingFamily8 = msTable.getDefaultConstraints();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily8, (String)"getDefaultConstraints(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily8, existentObjectIds);
                ModNamingIdentifyingFamily<? extends MsTrigger> modNamingIdentifyingFamily9 = msTable.getTriggers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily9, (String)"getTriggers(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily9, existentObjectIds);
                Intrinsics.checkNotNull((Object)msTable);
                this.detachUnexistentDefaultConstraints(msTable, existentObjectIds);
            }
            for (MsView msView : schema.getViews()) {
                ModNamingIdentifyingFamily<? extends MsTrigger> modNamingIdentifyingFamily10 = msView.getTriggers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily10, (String)"getTriggers(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily10, existentObjectIds);
            }
        }

        private final void detachUnexistentDefaultConstraints(MsTable table, AbstractIntSet existentObjectIds) {
            for (MsTableColumn column2 : table.getColumns()) {
                BasicReferenceInfo<? extends MsDefaultConstraint> info2;
                int defId;
                if (column2.isComputed() || column2.getDefaultConstraintRefInfo() == null || existentObjectIds.contains(defId = (int)info2.getReference().getObjectId())) continue;
                column2.setDefaultConstraintRef(null);
            }
        }

        private final void removeUnexistentIndices(MsSchema schema, LongSet existentIndicesCombies, LongSet tablesWithFulltextIndices) {
            for (MsTableType msTableType : schema.getTableTypes()) {
                Intrinsics.checkNotNull((Object)msTableType);
                this.removeUnexistentIndices(msTableType, existentIndicesCombies, tablesWithFulltextIndices);
            }
            for (MsTable msTable : schema.getTables()) {
                Intrinsics.checkNotNull((Object)msTable);
                this.removeUnexistentIndices(msTable, existentIndicesCombies, tablesWithFulltextIndices);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void removeUnexistentIndices(MsStoredTable table, LongSet existentIndicesCombies, LongSet tablesWithFulltextIndices) {
            void $this$filterTo$iv$iv;
            ModPositioningNamingFamily<? extends MsLikeIndex> modPositioningNamingFamily = table.getIndices();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getIndices(...)");
            Iterable $this$filter$iv = modPositioningNamingFamily;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MsLikeIndex it = (MsLikeIndex)element$iv$iv;
                boolean bl = false;
                boolean bl2 = it.isFulltext() ? !tablesWithFulltextIndices.contains(table.getObjectId()) : !existentIndicesCombies.contains(table.getObjectId() * 100000L + (long)it.getPosition());
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List droppedIndices = (List)destination$iv$iv;
            for (int i2 = droppedIndices.size() - 1; -1 < i2; --i2) {
                ((MsLikeIndex)droppedIndices.get(i2)).drop();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveAliases() {
            void $this$filterTo$iv$iv;
            ObjectKind objectKind = ObjectKind.ALIAS_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ALIAS_TYPE");
            MsIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<MsIntroQueries.L1.OneSchemaAliasesChecksum>> query = this.myQueries.getCalculateAliasesChecksum();
            List<MsIntroQueries.L1.OneSchemaAliasesChecksum> csEntries = this.performQuery(query);
            Long2LongOpenHashMap csMap = new Long2LongOpenHashMap(csEntries.size());
            for (MsIntroQueries.L1.OneSchemaAliasesChecksum cse : csEntries) {
                csMap.put(cse.schema_id, cse.checksum);
            }
            Iterable $this$filter$iv = this.getSchemas();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MsSchema it = (MsSchema)element$iv$iv;
                boolean bl = false;
                if (!(it.getAliasTypesCheckSum() != csMap.getOrDefault(it.getObjectId(), 0L))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List schemasToRetrieveAliases = (List)destination$iv$iv;
            if (IntrospectionTaskHelperFun.isNotEmpty(schemasToRetrieveAliases)) {
                this.retrieveAliasesForSchemas(schemasToRetrieveAliases, csMap);
            } else {
                this.trace("No needs to retrieve alias types.");
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveAliasesForSchemas(List<? extends MsSchema> schemas, Long2LongOpenHashMap csMap) {
            void $this$groupByTo$iv$iv;
            void $this$mapTo$iv$iv;
            this.trace("Retrieving alias types for " + schemas.size() + " schemas");
            SqlQuery<List<MsIntroQueries.L1.OneAliasType>> query = this.myQueries.getRetrieveAliasTypes();
            Iterable $this$map$iv = schemas;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MsSchema msSchema = (MsSchema)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getObjectId());
            }
            long[] schemaIds = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
            List ats = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, query, MapsKt.mapOf((Pair)TuplesKt.to((Object)"schema_ids", (Object)schemaIds)), 0, 4, null);
            this.trace("Received " + ats.size() + " alias type entries");
            Iterable $this$groupBy$iv = ats;
            boolean $i$f$groupBy = false;
            Iterable $i$f$mapTo22 = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                MsIntroQueries.L1.OneAliasType it = (MsIntroQueries.L1.OneAliasType)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.schema_id;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map atsBySchemas = destination$iv$iv2;
            this.inDatabase(arg_0 -> MsLevelOneRetriever.retrieveAliasesForSchemas$lambda$15(schemas, MsIntrospector.this, csMap, atsBySchemas, arg_0));
        }

        private final void retrieveMajorNames() {
            MsIntrospector.this.reportRetrieving("Major names", "introspection.retrieve.majorObjectNames");
            SqlQuery<List<MsIntroQueries.L1.OneMajorName>> query = this.myQueries.getRetrieveMajorNames();
            Ref.ObjectRef currSchema = new Ref.ObjectRef();
            currSchema.element = CollectionsKt.first(this.getSchemas());
            Ref.ObjectRef currEffect = new Ref.ObjectRef();
            currEffect.element = MsIntrospector.this.majorEffects.get(((MsSchema)currSchema.element).getObjectId());
            this.inDatabase(arg_0 -> MsLevelOneRetriever.retrieveMajorNames$lambda$17(this, query, MsIntrospector.this, currSchema, currEffect, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveMinorNames() {
            void $this$groupByTo$iv$iv;
            Collection collection = this.affectedMajorObjects.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            long[] reducedSchemaIds = MapFun.toOpenHashSet((Sequence<Long>)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), MsLevelOneRetriever::retrieveMinorNames$lambda$18), MsLevelOneRetriever::retrieveMinorNames$lambda$19)).toLongArray();
            Intrinsics.checkNotNull((Object)reducedSchemaIds);
            if (reducedSchemaIds.length == 0) {
                return;
            }
            MsIntrospector.this.reportRetrieving("Minor names", "introspection.retrieve.minorObjectNames");
            SqlQuery<List<MsIntroQueries.L1.OneMinorName>> query = this.myQueries.getRetrieveMinorNames();
            List minors = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, query, MapsKt.mapOf((Pair)TuplesKt.to((Object)"schema_ids", (Object)reducedSchemaIds)), 0, 4, null);
            Iterable $this$groupBy$iv = minors;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                MsIntroQueries.L1.OneMinorName it = (MsIntroQueries.L1.OneMinorName)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.object_id;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map objectMinors = destination$iv$iv;
            this.trace("Retrieved " + minors.size() + " minor names for " + objectMinors.size() + " objects");
            LongOpenHashSet missedObjectIds = new LongOpenHashSet(0);
            this.inDatabase(arg_0 -> MsLevelOneRetriever.retrieveMinorNames$lambda$23(objectMinors, this, missedObjectIds, arg_0));
            if (!((Collection)missedObjectIds).isEmpty()) {
                IntrospectionQueryContext.logWarn$default(this, "Missed " + missedObjectIds.size() + " objects: " + CollectionsKt.joinToString$default((Iterable)((Iterable)missedObjectIds), null, null, null, (int)0, null, null, (int)63, null), null, 2, null);
            }
        }

        private final MsArgument reuseArgument(ModPositioningNamingFamily<? extends MsArgument> $this$reuseArgument, short pos, String name2, ArgumentDirection dir) {
            BasicModMixinElement arg = null;
            if (dir == ArgumentDirection.RETURN) {
                arg = (MsArgument)$this$reuseArgument.find(arg_0 -> MsLevelOneRetriever.reuseArgument$lambda$24(reuseArgument.1.INSTANCE, arg_0));
            }
            if (arg == null && name2 != null) {
                MsArgument msArgument = (MsArgument)$this$reuseArgument.get(name2);
                if (msArgument != null) {
                    MsArgument msArgument2;
                    MsArgument $this$reuseArgument_u24lambda_u2425 = msArgument2 = msArgument;
                    boolean bl = false;
                    $this$reuseArgument_u24lambda_u2425.setPosition(pos);
                    v1 = msArgument2;
                } else {
                    v1 = arg = null;
                }
            }
            if (arg == null) {
                Object object = name2;
                if (object == null) {
                    object = "unnamed_" + pos;
                }
                arg = $this$reuseArgument.renewAt(pos, (String)object);
            }
            arg.resetSyncPending();
            arg.setArgumentDirection(dir);
            BasicModMixinElement basicModMixinElement = arg;
            Intrinsics.checkNotNull((Object)basicModMixinElement);
            return basicModMixinElement;
        }

        private final void finalizeLevel1() {
            MsIntrospector.this.reportStatusMessage("Finalizing level 1", "introspection.report.status.finishingTheSchema.L1");
            for (MsSchema schema : this.getSchemas()) {
                MsSchemaEffect effect = (MsSchemaEffect)MsIntrospector.this.majorEffects.get(schema.getObjectId());
                if (effect != null && effect.getSomething() || MsIntrospector.this.schemasWhereDroppedObjectsDetected.contains(schema)) {
                    schema.setLastIntrospectionLevel(Level.L1);
                }
                schema.setLastIntrospectionLocalTimestamp(this.introspectionLocalTimestamp);
            }
            this.traceEffects();
        }

        /*
         * WARNING - void declaration
         */
        private final void traceEffects() {
            void this_$iv;
            IntrospectionQueryContext introspectionQueryContext = this;
            MsIntrospector msIntrospector = MsIntrospector.this;
            boolean $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing((IntrospectionQueryContext)this_$iv)) {
                StringBuilder stringBuilder;
                void var10_4 = this_$iv;
                boolean bl = false;
                TextTable.Column[] columnArray = new TextTable.Column[]{new TextTable.Column("Schema", null, traceEffects.1.tt.1.INSTANCE, 2, null), new TextTable.Column("Tables", null, (Function1)new Function1<MsSchema, CharSequence>(msIntrospector){
                    final /* synthetic */ MsIntrospector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(MsSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        MsSchemaEffect msSchemaEffect = (MsSchemaEffect)MsIntrospector.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (msSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = msSchemaEffect.getTables();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("Views", null, (Function1)new Function1<MsSchema, CharSequence>(msIntrospector){
                    final /* synthetic */ MsIntrospector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(MsSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        MsSchemaEffect msSchemaEffect = (MsSchemaEffect)MsIntrospector.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (msSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = msSchemaEffect.getViews();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("AliasTypes", null, (Function1)new Function1<MsSchema, CharSequence>(msIntrospector){
                    final /* synthetic */ MsIntrospector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(MsSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        MsSchemaEffect msSchemaEffect = (MsSchemaEffect)MsIntrospector.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (msSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = msSchemaEffect.getAliasTypes();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("TableTypes", null, (Function1)new Function1<MsSchema, CharSequence>(msIntrospector){
                    final /* synthetic */ MsIntrospector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(MsSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        MsSchemaEffect msSchemaEffect = (MsSchemaEffect)MsIntrospector.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (msSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = msSchemaEffect.getTableTypes();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("Rules", null, (Function1)new Function1<MsSchema, CharSequence>(msIntrospector){
                    final /* synthetic */ MsIntrospector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(MsSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        MsSchemaEffect msSchemaEffect = (MsSchemaEffect)MsIntrospector.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (msSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = msSchemaEffect.getRules();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("Routines", null, (Function1)new Function1<MsSchema, CharSequence>(msIntrospector){
                    final /* synthetic */ MsIntrospector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(MsSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        MsSchemaEffect msSchemaEffect = (MsSchemaEffect)MsIntrospector.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (msSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = msSchemaEffect.getRoutines();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("Sequences", null, (Function1)new Function1<MsSchema, CharSequence>(msIntrospector){
                    final /* synthetic */ MsIntrospector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(MsSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        MsSchemaEffect msSchemaEffect = (MsSchemaEffect)MsIntrospector.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (msSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = msSchemaEffect.getSequences();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("Synonyms", null, (Function1)new Function1<MsSchema, CharSequence>(msIntrospector){
                    final /* synthetic */ MsIntrospector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(MsSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        MsSchemaEffect msSchemaEffect = (MsSchemaEffect)MsIntrospector.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (msSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = msSchemaEffect.getSynonyms();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null)};
                TextTable tt2 = new TextTable(columnArray);
                CharSequence text2 = tt2.processContent(this.getSchemas());
                StringBuilder $this$traceEffects_u24lambda_u2427_u24lambda_u2426 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                $this$traceEffects_u24lambda_u2427_u24lambda_u2426.append("Level 1 affected major objects:\n");
                $this$traceEffects_u24lambda_u2427_u24lambda_u2426.append(text2);
                var10_4.trace(stringBuilder.toString());
            }
        }

        private static final long detectAndRemoveDroppedObjects$lambda$6(MsSchema s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return s.getObjectId();
        }

        private static final Unit detectAndRemoveDroppedObjects$lambda$7(List $actualSchemas, MsLevelOneRetriever this$0, IntOpenHashSet $existentObjectIds, MsDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            for (MsSchema schema : $actualSchemas) {
                this$0.removeUnexistentSchemaObjects(schema, (AbstractIntSet)$existentObjectIds);
            }
            return Unit.INSTANCE;
        }

        private static final Unit detectAndRemoveDroppedObjects$lambda$9(List $actualSchemas, MsLevelOneRetriever this$0, LongOpenHashSet $existentIndicesCombies, LongOpenHashSet $tablesWithFulltextIndices, MsDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            for (MsSchema schema : $actualSchemas) {
                this$0.removeUnexistentIndices(schema, (LongSet)$existentIndicesCombies, (LongSet)$tablesWithFulltextIndices);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveAliasesForSchemas$lambda$15(List $schemas, MsIntrospector this$0, Long2LongOpenHashMap $csMap, Map $atsBySchemas, MsDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            for (MsSchema schema : $schemas) {
                long schemaId = schema.getObjectId();
                MsSchemaEffect effect = (MsSchemaEffect)this$0.majorEffects.get(schemaId);
                schema.setAliasTypesCheckSum($csMap.getOrDefault(schemaId, 0L));
                List ate = (List)$atsBySchemas.get(schemaId);
                ModFamily $this$modifyAndCleanup_u24default$iv = schema.getAliasTypes();
                boolean removeUnaffected$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModNamingFamily aliasTypes = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl = false;
                if (ate != null) {
                    for (MsIntroQueries.L1.OneAliasType a : ate) {
                        String baseTypeName;
                        String name2;
                        if (a.name == null) continue;
                        Intrinsics.checkNotNull((Object)aliasTypes);
                        MsAliasType aliasType = (MsAliasType)MsIntrospectorKt.access$renewType(aliasTypes, a.type_id, name2);
                        String string = baseTypeName = a.base_name;
                        DasType dasType = string != null ? MsIntrospectorKt.access$makeDasType(string, a.max_length, a.precision, a.scale) : (DasType)DasTypeSystemBase.UNKNOWN;
                        aliasType.setStoredType(dasType);
                        aliasType.setNotNull(!a.is_nullable);
                        aliasType.setDetailsLevel(Level.L1);
                        Intrinsics.checkNotNull((Object)aliasType);
                        MsSchemaEffect.include$default(effect, aliasType, false, 2, null);
                    }
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveMajorNames$lambda$17$lambda$16(Ref.ObjectRef $currSchema, MsLevelOneRetriever this$0, Ref.ObjectRef $currEffect, MsIntrospector this$1, MsIntroQueries.L1.OneMajorName r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            if (((MsSchema)$currSchema.element).getObjectId() != r.schema_id) {
                v0 = (MsSchema)this$0.mySchemasById.get(r.schema_id);
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                $currSchema.element = v0;
                $currEffect.element = MsIntrospector.access$getMajorEffects$p(this$1).get(((MsSchema)$currSchema.element).getObjectId());
            }
            obj = null;
            name = r.name;
            nameIsSurrogate = MsIntrospectorKt.access$detectSurrogateName(name);
            type = ModelSerializationFun.safeRTrim(r.type);
            var9_9 = type;
            if (var9_9 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var9_9.hashCode()) {
                case 2688: {
                    if (var9_9.equals("TT")) {
                        tmp = 1;
                    }
                    break;
                }
                case 2248: {
                    if (var9_9.equals("FN")) {
                        tmp = 2;
                    }
                    break;
                }
                case 2347: {
                    if (var9_9.equals("IT")) {
                        tmp = 3;
                    }
                    break;
                }
                case 80: {
                    if (var9_9.equals("P")) {
                        tmp = 2;
                    }
                    break;
                }
                case 82: {
                    if (var9_9.equals("R")) {
                        tmp = 4;
                    }
                    break;
                }
                case 2674: {
                    if (var9_9.equals("TF")) {
                        tmp = 2;
                    }
                    break;
                }
                case 83: {
                    if (var9_9.equals("S")) {
                        tmp = 3;
                    }
                    break;
                }
                case 2547: {
                    if (var9_9.equals("PC")) {
                        tmp = 2;
                    }
                    break;
                }
                case 85: {
                    if (var9_9.equals("U")) {
                        tmp = 3;
                    }
                    break;
                }
                case 86: {
                    if (var9_9.equals("V")) {
                        tmp = 5;
                    }
                    break;
                }
                case 88: {
                    if (var9_9.equals("X")) {
                        tmp = 2;
                    }
                    break;
                }
                case 2651: {
                    if (var9_9.equals("SN")) {
                        tmp = 6;
                    }
                    break;
                }
                case 2652: {
                    if (var9_9.equals("SO")) {
                        tmp = 7;
                    }
                    break;
                }
                case 2333: {
                    if (var9_9.equals("IF")) {
                        tmp = 2;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 3: {
                    v1 = ((MsSchema)$currSchema.element).getTables().renew(r.object_id, name);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"renew(...)");
                    obj = v1;
                    break;
                }
                case 5: {
                    v2 = ((MsSchema)$currSchema.element).getViews().renew(r.object_id, name);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"renew(...)");
                    obj = v2;
                    break;
                }
                case 1: {
                    v3 = ((MsSchema)$currSchema.element).getTableTypes().renew(r.object_id, name);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"renew(...)");
                    obj = v3;
                    break;
                }
                case 4: {
                    v4 = ((MsSchema)$currSchema.element).getRules().renew(r.object_id, name);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"renew(...)");
                    obj = v4;
                    break;
                }
                case 2: {
                    v5 = ((MsSchema)$currSchema.element).getRoutines().renew(r.object_id, name);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"renew(...)");
                    routine = v5;
                    routine.setRoutineType(MsRoutineTypes.MS_ROUTINE_TYPES.get(type));
                    obj = routine;
                    break;
                }
                case 7: {
                    v6 = ((MsSchema)$currSchema.element).getSequences().renew(r.object_id, name);
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"renew(...)");
                    obj = v6;
                    break;
                }
                case 6: {
                    v7 = ((MsSchema)$currSchema.element).getSynonyms().renew(r.object_id, name);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"renew(...)");
                    obj = v7;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    IntrospectionQueryContext.logWarn$default(this$0, "Unknown major object type [" + type + "]", null, 2, null);
                    return Unit.INSTANCE;
                }
            }
            obj.setNameSurrogate(nameIsSurrogate);
            obj.setDetailsLevel(Level.L1);
            MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(obj, r.create_date, r.modify_date);
            this$0.affectedMajorObjects.put(r.object_id, (Object)obj);
            MsSchemaEffect.include$default((MsSchemaEffect)$currEffect.element, obj, false, 2, null);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveMajorNames$lambda$17(MsLevelOneRetriever this$0, SqlQuery $query, MsIntrospector this$1, Ref.ObjectRef $currSchema, Ref.ObjectRef $currEffect, MsDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.performQueryHandleEachRow($query, 4000, arg_0 -> MsLevelOneRetriever.retrieveMajorNames$lambda$17$lambda$16($currSchema, this$0, $currEffect, this$1, arg_0));
            for (MsSchema schema : this$0.getSchemas()) {
                MsSchemaEffect effect;
                if ((MsSchemaEffect)this$1.majorEffects.get(schema.getObjectId()) == null) continue;
                if (effect.getTables()) {
                    schema.getTables().sort();
                }
                if (effect.getViews()) {
                    schema.getViews().sort();
                }
                if (effect.getRules()) {
                    schema.getRules().sort();
                }
                if (effect.getTableTypes()) {
                    schema.getTableTypes().sort();
                }
                if (effect.getSequences()) {
                    schema.getSequences().sort();
                }
                if (effect.getRoutines()) {
                    schema.getRoutines().sort();
                }
                if (!effect.getSynonyms()) continue;
                schema.getSynonyms().sort();
            }
            return Unit.INSTANCE;
        }

        private static final long retrieveMinorNames$lambda$18(MsSchemaObject it) {
            Intrinsics.checkNotNull((Object)it);
            return MsIntroFunctions.getSchemaId(it);
        }

        private static final boolean retrieveMinorNames$lambda$19(long it) {
            return it != Long.MIN_VALUE;
        }

        private static final Unit retrieveMinorNames$lambda$23(Map $objectMinors, MsLevelOneRetriever this$0, LongOpenHashSet $missedObjectIds, MsDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            for (Map.Entry entry : $objectMinors.entrySet()) {
                short pos;
                boolean $i$f$modifyAndCleanup;
                boolean removeUnaffected$iv;
                ModFamily $this$modifyAndCleanup_u24default$iv;
                long objectId = ((Number)entry.getKey()).longValue();
                List minors = (List)entry.getValue();
                MsSchemaObject obj2 = (MsSchemaObject)this$0.affectedMajorObjects.get(objectId);
                if (obj2 == null) {
                    $missedObjectIds.add(objectId);
                    continue;
                }
                if (obj2 instanceof MsLikeTable) {
                    $this$modifyAndCleanup_u24default$iv = (ModFamily)((Object)((MsLikeTable)obj2).getColumns());
                    removeUnaffected$iv = true;
                    $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModPositioningNamingFamily columns = (ModPositioningNamingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    for (MsIntroQueries.L1.OneMinorName c2 : minors) {
                        String name2;
                        if (c2.category != 'C') continue;
                        pos = c2.position;
                        if (c2.name == null) continue;
                        columns.renewAt(pos, name2);
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
                if (!(obj2 instanceof MsRoutine)) continue;
                $this$modifyAndCleanup_u24default$iv = (ModFamily)((Object)((MsRoutine)obj2).getArguments());
                removeUnaffected$iv = true;
                $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModPositioningNamingFamily arguments = (ModPositioningNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl = false;
                for (MsIntroQueries.L1.OneMinorName a : minors) {
                    Object object;
                    ArgumentDirection direction;
                    if (a.category != 'R' || (pos = a.position) == -1) continue;
                    ArgumentDirection argumentDirection = ArgumentDirection.of(a.direction);
                    if (argumentDirection == null) {
                        argumentDirection = direction = ArgumentDirection.IN;
                    }
                    if ((object = a.name) == null) {
                        object = direction == ArgumentDirection.RETURN ? "return" : "unnamed_" + pos;
                    }
                    String name3 = object;
                    Intrinsics.checkNotNull((Object)arguments);
                    MsArgument msArgument = this$0.reuseArgument(arguments, pos, name3, direction);
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final boolean reuseArgument$lambda$24(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IntrospectionMode.values().length];
                try {
                    nArray[IntrospectionMode.INCREMENT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0019\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020!H\u0016J\u0018\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014JH\u0010,\u001a\b\u0012\u0004\u0012\u0002H.0-\"\u0004\b\u0000\u0010.2\u0014\u0010/\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H.01002\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0018\u0001032\u0006\u00106\u001a\u000207H\u0014J\b\u00108\u001a\u00020!H\u0014J\b\u00109\u001a\u00020!H\u0014J\r\u0010:\u001a\u00020!H\u0000\u00a2\u0006\u0002\b;J\u0018\u0010<\u001a\u00020!2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010=\u001a\u00020>H\u0002J \u0010?\u001a\u00020!2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0002J \u0010?\u001a\u00020!2\u0006\u0010C\u001a\u00020D2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0002J\b\u0010E\u001a\u00020!H\u0014J\b\u0010F\u001a\u00020!H\u0014J\b\u0010G\u001a\u00020!H\u0002J\b\u0010H\u001a\u00020!H\u0014J\b\u0010I\u001a\u00020!H\u0002J\u0006\u0010J\u001a\u00020!J#\u0010K\u001a\u00020!2\u0006\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u0002040OH\u0016\u00a2\u0006\u0002\u0010PJ\b\u0010Q\u001a\u00020!H\u0002J\b\u0010R\u001a\u00020!H\u0002J\b\u0010S\u001a\u00020!H\u0002J\b\u0010T\u001a\u00020!H\u0002J\b\u0010U\u001a\u00020!H\u0002J\b\u0010V\u001a\u00020!H\u0002J\b\u0010W\u001a\u00020!H\u0002J\b\u0010X\u001a\u00020!H\u0002J\u0016\u0010Y\u001a\u00020!2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0-H\u0002J\b\u0010\\\u001a\u00020!H\u0002J\b\u0010]\u001a\u00020!H\u0002J\b\u0010^\u001a\u00020!H\u0002J$\u0010_\u001a\u00020!2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020a0-2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020c0-H\u0002J$\u0010d\u001a\u00020!2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020e0-2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020f0-H\u0002J\b\u0010g\u001a\u00020!H\u0002J\b\u0010h\u001a\u00020!H\u0002J\u0016\u0010i\u001a\u00020!2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020k0-H\u0002J\b\u0010l\u001a\u00020!H\u0002J\b\u0010m\u001a\u00020!H\u0002J\b\u0010n\u001a\u00020!H\u0002J\u0016\u0010o\u001a\u00020!2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020q0-H\u0002J\b\u0010r\u001a\u00020!H\u0002J\b\u0010s\u001a\u00020!H\u0002J\b\u0010t\u001a\u00020!H\u0002J\b\u0010u\u001a\u00020!H\u0002J\u000e\u0010v\u001a\u0004\u0018\u00010w*\u000205H\u0002J\u0014\u0010x\u001a\u00020y*\u00020z2\u0006\u0010{\u001a\u00020#H\u0002J\u0012\u0010|\u001a\u0004\u0018\u00010w2\u0006\u0010}\u001a\u00020yH\u0002J\u0012\u0010~\u001a\u0004\u0018\u00010w2\u0006\u0010}\u001a\u00020yH\u0002J\b\u0010\u007f\u001a\u00020!H\u0002J\t\u0010\u0080\u0001\u001a\u00020!H\u0002J\t\u0010\u0081\u0001\u001a\u00020!H\u0002J\t\u0010\u0082\u0001\u001a\u00020!H\u0002Ja\u0010\u0083\u0001\u001a\u00020!\"\n\b\u0000\u0010\u0084\u0001*\u00030\u0085\u0001\"\u0004\b\u0001\u0010.2\u000f\u0010\u0086\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0084\u00010\u0087\u00012\u0014\u0010\u0088\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u0089\u0001\u0012\u0004\u0012\u0002H.032\u001d\u0010\u008a\u0001\u001a\u0018\u0012\u0005\u0012\u00030\u008c\u0001\u0012\u0006\u0012\u0004\u0018\u0001H.\u0012\u0004\u0012\u00020!0\u008b\u0001H\u0002J_\u0010\u008d\u0001\u001a\u00020!\"\n\b\u0000\u0010\u0084\u0001*\u00030\u008e\u0001\"\u0004\b\u0001\u0010.2\u0007\u0010}\u001a\u0003H\u0084\u00012\u0014\u0010\u0088\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u0089\u0001\u0012\u0004\u0012\u0002H.032\u001d\u0010\u008a\u0001\u001a\u0018\u0012\u0005\u0012\u00030\u008c\u0001\u0012\u0006\u0012\u0004\u0018\u0001H.\u0012\u0004\u0012\u00020!0\u008b\u0001H\u0002\u00a2\u0006\u0003\u0010\u008f\u0001J`\u0010\u0083\u0001\u001a\u00020!\"\n\b\u0000\u0010\u0084\u0001*\u00030\u0085\u0001\"\u0004\b\u0001\u0010.2\b\u0010\u0090\u0001\u001a\u0003H\u0084\u00012\u0014\u0010\u0088\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u0089\u0001\u0012\u0004\u0012\u0002H.032\u001d\u0010\u008a\u0001\u001a\u0018\u0012\u0005\u0012\u00030\u008c\u0001\u0012\u0006\u0012\u0004\u0018\u0001H.\u0012\u0004\u0012\u00020!0\u008b\u0001H\u0002\u00a2\u0006\u0003\u0010\u0091\u0001J\t\u0010\u0092\u0001\u001a\u00020!H\u0002J\u001d\u0010\u0093\u0001\u001a\u00020!2\u0007\u0010\u0094\u0001\u001a\u00020\u00192\t\u0010\u0095\u0001\u001a\u0004\u0018\u000104H\u0002J$\u0010\u0096\u0001\u001a\u0012\u0012\u0004\u0012\u000204\u0012\u0006\u0012\u0004\u0018\u000104\u0018\u0001032\t\u0010\u0095\u0001\u001a\u0004\u0018\u000104H\u0002J\t\u0010\u0097\u0001\u001a\u00020!H\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0098\u0001"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractMultiLevelSchemaRetriever;", "Lcom/intellij/database/dialects/mssql/model/MsSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/mssql/model/MsRoot;", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mssql/model/MsSchema;)V", "myFromTimestamp", "Ljava/sql/Timestamp;", "myIntrospectionBeginTimestamp", "effect", "Lcom/intellij/database/dialects/mssql/introspector/MsSchemaEffect;", "myTouchedTables", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/mssql/model/MsLikeTable;", "myTouchedMajorSourceAware", "Lcom/intellij/database/dialects/mssql/model/MsSourceAware;", "myTouchedRules", "Lcom/intellij/database/dialects/mssql/model/MsRule;", "myTouchedRoutines", "Ljava/util/HashSet;", "Lcom/intellij/database/dialects/mssql/model/MsRoutine;", "myTouchedTableWithTriggers", "Lcom/intellij/database/dialects/mssql/model/MsTableOrView;", "myTouchedSequences", "Lcom/intellij/database/dialects/mssql/model/MsSequence;", "myTouchedSynonyms", "Lcom/intellij/database/dialects/mssql/model/MsSynonym;", "setup", "", "majorModificationsFound", "", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "setupForFragments", "task", "Lcom/intellij/database/introspection/SchemaFragmentIntrospectionTask;", "prepareParameters", "isPossibleToIntrospectSchemaIncrementally", "tran", "performQueryForList", "", "X", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "namedParameters", "", "", "", "packSize", "", "analyzeBriefInfo", "analyzeCurrentContent", "determineDroppedObjects", "determineDroppedObjects$intellij_database_dialects_mssql", "removeUnexistentSchemaObjects", "existentObjectIds", "Lit/unimi/dsi/fastutil/ints/AbstractIntSet;", "removeUnexistentIndices", "existentIndicesCombies", "Lit/unimi/dsi/fastutil/longs/LongSet;", "tablesWithFulltextIndices", "table", "Lcom/intellij/database/dialects/mssql/model/MsStoredTable;", "retrieveMainContent", "processLevel2Imp", "finalizeLevel2", "processLevel3Imp", "finalizeLevel3", "finalizeIntrospection", "retrieveNamedFragments", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "fragmentNames", "", "(Lcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "retrieveMajorFragmentEntities", "retrieveTables", "retrieveViews", "retrieveRules", "retrieveTableTypes", "retrieveColumns", "retrievePartitions", "retrieveTypeColumns", "processColumns", "cols", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneColumn;", "retrieveIndices", "retrieveFulltextIndices", "retrieveTypeIndices", "processIndices", "inds", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneIndex;", "ics", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneIndexColumn;", "processFulltextIndices", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneFulltextIndex;", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneFulltextIndexColumn;", "retrieveKeys", "retrieveTypeKeys", "processKeys", "ks", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneKey;", "retrieveForeignKeys", "retrieveCheckConstraints", "retrieveTypeCheckConstraints", "processCheckConstraints", "cs", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneCheckConstraints;", "retrieveSynonyms", "retrieveSecurityPolicies", "retrieveSecurityPredicates", "retrieveSequences", "asBigInteger", "Ljava/math/BigInteger;", "getDasType", "Lcom/intellij/database/types/DasType;", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneSequence;", "isUnderlying", "sequenceUnlimitedMinimumDefault", "type", "sequenceUnlimitedMaximumDefault", "retrieveArguments", "retrieveTriggers", "retrievePermissions", "retrieveDescriptions", "processExtendedPropertiesForObjects", "T", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "family", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "values", "Lcom/intellij/database/dialects/mssql/introspector/ExtPropId;", "processor", "Lkotlin/Function2;", "Lcom/intellij/database/model/basic/BasicModElement;", "processExtendedPropertiesForType", "Lcom/intellij/database/dialects/mssql/model/MsCustomType;", "(Lcom/intellij/database/dialects/mssql/model/MsCustomType;Ljava/util/Map;Lkotlin/jvm/functions/Function2;)V", "obj", "(Lcom/intellij/database/model/basic/BasicModIdentifiedElement;Ljava/util/Map;Lkotlin/jvm/functions/Function2;)V", "retrieveSources", "extractAndApplyDefaults", "r", "text", "extractDefaults", "finishSchema", "intellij.database.dialects.mssql"})
    @SourceDebugExtension(value={"SMAP\nMsIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsSchemaRetriever\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 IntrospectionQueryContext.kt\ncom/intellij/database/dialects/base/introspector/IntrospectionQueryContext\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 8 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 9 IntrospectorSqlHelper.kt\ncom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper\n+ 10 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 11 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 12 StringFun.kt\ncom/intellij/database/util/common/StringFun\n+ 13 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 14 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/IdCache\n+ 15 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,2781:1\n14#2:2782\n14#2:2783\n1869#3,2:2784\n774#3:2789\n865#3,2:2790\n1491#3:2798\n1516#3,3:2799\n1519#3,3:2809\n1491#3:2812\n1516#3,3:2813\n1519#3,3:2823\n1491#3:2828\n1516#3,3:2829\n1519#3,3:2839\n1869#3,2:2842\n1869#3,2:2844\n1869#3,2:2859\n1252#3,4:2862\n295#3,2:2893\n1563#3:2905\n1634#3,3:2906\n808#3,11:2940\n774#3:2951\n865#3,2:2952\n774#3:2954\n865#3,2:2955\n1869#3,2:2957\n1#4:2786\n411#5,2:2787\n411#5,2:2792\n411#5,2:2794\n411#5,2:2796\n411#5,2:2826\n411#5,2:2959\n382#6,7:2802\n382#6,7:2816\n382#6,7:2832\n398#7:2846\n399#7,2:2852\n1084#8:2847\n1179#8,2:2848\n1085#8,2:2850\n1089#8:2854\n1184#8,2:2855\n1090#8,2:2857\n26#9:2861\n178#10,8:2866\n178#10,8:2876\n178#10,8:2897\n336#10,4:2909\n340#10:2917\n198#10,5:2918\n204#10,5:2926\n341#10:2931\n178#10,8:2932\n212#11:2874\n205#11:2875\n212#11:2884\n205#11:2885\n212#11:2887\n205#11:2888\n212#11:2889\n205#11:2890\n212#11:2891\n205#11:2892\n212#11:2895\n205#11:2896\n212#11:2961\n205#11:2962\n148#12:2886\n37#13:2913\n36#13,3:2914\n432#14,3:2923\n19#15:2963\n*S KotlinDebug\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsSchemaRetriever\n*L\n1190#1:2782\n1196#1:2783\n1208#1:2784,2\n1329#1:2789\n1329#1:2790,2\n1686#1:2798\n1686#1:2799,3\n1686#1:2809,3\n2246#1:2812\n2246#1:2813,3\n2246#1:2823,3\n2335#1:2828\n2335#1:2829,3\n2335#1:2839,3\n2365#1:2842,2\n2366#1:2844,2\n2431#1:2859,2\n2440#1:2862,4\n1985#1:2893,2\n2161#1:2905\n2161#1:2906,3\n2269#1:2940,11\n2270#1:2951\n2270#1:2952,2\n2271#1:2954\n2271#1:2955,2\n2272#1:2957,2\n1252#1:2787,2\n1561#1:2792,2\n1589#1:2794,2\n1647#1:2796,2\n2247#1:2826,2\n2273#1:2959,2\n1686#1:2802,7\n2246#1:2816,7\n2335#1:2832,7\n2402#1:2846\n2402#1:2852,2\n2402#1:2847\n2402#1:2848,2\n2402#1:2850,2\n2402#1:2854\n2402#1:2855,2\n2402#1:2857,2\n2438#1:2861\n1631#1:2866,8\n1694#1:2876,8\n2141#1:2897,8\n2161#1:2909,4\n2161#1:2917\n2161#1:2918,5\n2161#1:2926,5\n2161#1:2931\n2252#1:2932,8\n1690#1:2874\n1690#1:2875\n1726#1:2884\n1726#1:2885\n1863#1:2887\n1863#1:2888\n1930#1:2889\n1930#1:2890\n1979#1:2891\n1979#1:2892\n2088#1:2895\n2088#1:2896\n2290#1:2961\n2290#1:2962\n1768#1:2886\n2161#1:2913\n2161#1:2914,3\n2163#1:2923,3\n2339#1:2963\n*E\n"})
    protected final class MsSchemaRetriever
    extends BaseNativeIntrospector.AbstractMultiLevelSchemaRetriever<MsSchema> {
        @NotNull
        private Timestamp myFromTimestamp;
        @NotNull
        private Timestamp myIntrospectionBeginTimestamp;
        @NotNull
        private final MsSchemaEffect effect;
        @NotNull
        private final ArrayList<MsLikeTable> myTouchedTables;
        @NotNull
        private final ArrayList<MsSourceAware> myTouchedMajorSourceAware;
        @NotNull
        private final ArrayList<MsRule> myTouchedRules;
        @NotNull
        private final HashSet<MsRoutine> myTouchedRoutines;
        @NotNull
        private final HashSet<MsTableOrView> myTouchedTableWithTriggers;
        @NotNull
        private final HashSet<MsSequence> myTouchedSequences;
        @NotNull
        private final HashSet<MsSynonym> myTouchedSynonyms;

        public MsSchemaRetriever(@NotNull DBTransaction transaction, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)MsIntrospector.this, transaction, (BasicModMultiLevelSchema)schema);
            this.myFromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.myIntrospectionBeginTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.myTouchedTables = new ArrayList();
            this.myTouchedMajorSourceAware = new ArrayList();
            this.myTouchedRules = new ArrayList();
            this.myTouchedRoutines = new HashSet();
            this.myTouchedTableWithTriggers = new HashSet();
            this.myTouchedSequences = new HashSet();
            this.myTouchedSynonyms = new HashSet();
            long schemaId = schema.getObjectId();
            this.effect = (MsSchemaEffect)MsIntrospector.this.majorEffects.get(schemaId);
            int[] nArray = new int[]{916};
            this.setIgnoreQueryErrors(nArray);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setup(boolean majorModificationsFound, @Nullable IntrospectionMode mode) {
            if (mode != null) {
                Date date;
                void _true_$iv;
                void $this$choose$iv;
                boolean bl = majorModificationsFound;
                String string = "major modifications exists";
                String _false_$iv = "no major modifications";
                boolean $i$f$choose = false;
                this.trace("Set up for mode " + mode + ", " + ($this$choose$iv != false ? _true_$iv : _false_$iv));
                super.setup(majorModificationsFound, mode);
                if (this.getMode() == IntrospectionMode.INCREMENT) {
                    date = ((MsSchema)this.getSchema()).getIntrospectionTimestamp();
                    if (date == null || (date = CalendarFun.toTimestamp(date)) == null) {
                        date = BaseIntrospectionFunctions.AGES_AGO;
                    }
                } else {
                    date = BaseIntrospectionFunctions.AGES_AGO;
                }
                this.myIntrospectionBeginTimestamp = this.myFromTimestamp = date;
            } else {
                boolean $this$choose$iv = majorModificationsFound;
                String _true_$iv = "major modifications exists";
                String _false_$iv = "no major modifications";
                boolean $i$f$choose = false;
                this.trace("Set up without the mode, " + ($this$choose$iv ? _true_$iv : _false_$iv));
                super.setup(majorModificationsFound, mode);
                this.myFromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
                this.myIntrospectionBeginTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            }
            this.prepareParameters();
            MsIntrospector.this.traceParameters("Schema retriever parameters (not cascading)", this.getParametersMap());
        }

        @Override
        public void setupForFragments(@NotNull SchemaFragmentIntrospectionTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            this.trace("Set up for FRAGMENT mode");
            super.setupForFragments(task);
            FamilyFragments familyFragments = task.getFragments();
            if (familyFragments != null) {
                Iterable $this$forEach$iv = familyFragments;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FamilyFragment f = (FamilyFragment)element$iv;
                    boolean bl = false;
                    this.effect.includeKind(f.getKind());
                }
            }
            this.myFromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.prepareParameters();
            this.setQueryParameter("since", this.myFromTimestamp);
            this.setQueryParameter("src_since", BaseIntrospectionFunctions.AGES_AGO);
            MsIntrospector.this.traceParameters("Schema retriever parameters (not cascading)", this.getParametersMap());
        }

        @Override
        public void prepareParameters() {
            boolean bl;
            MsDatabase database = ((MsSchema)this.getSchema()).getDatabase();
            boolean bl2 = bl = database != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            MsDatabase msDatabase = database;
            Intrinsics.checkNotNull((Object)msDatabase);
            MsIntrospector.this.prepareQueryParameters$intellij_database_dialects_mssql(msDatabase, this.getParametersMap());
            super.prepareParameters();
            this.setQueryParameter("since", this.myFromTimestamp);
            this.setQueryParameter("src_since", this.myIntrospectionBeginTimestamp);
        }

        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return schema.hasChildren() && schema.getLastIntrospectionLocalTimestamp() != null;
        }

        @NotNull
        protected <X> List<X> performQueryForList(@NotNull SqlQuery<? extends Iterable<? extends X>> query, @Nullable Map<String, ? extends Object> namedParameters, int packSize) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            try {
                return super.performQueryForList(query, namedParameters, packSize);
            }
            catch (DBException e) {
                IntrospectionQueryContext.logError$default(this, "Error occurred during introspection, query " + query.getDisplayName() + ":\n" + e.getMessage() + "\nSQL statement:\n" + e.statementText, null, 2, null);
                return CollectionsKt.emptyList();
            }
        }

        @Override
        protected void analyzeBriefInfo() {
            Date lastIntrospectionTimestamp = ((MsSchema)this.getSchema()).getIntrospectionTimestamp();
            boolean schemaHasObjects = ModelFun.isNotEmpty((BasicSchema)this.getSchema());
            Date it = lastIntrospectionTimestamp;
            boolean bl = false;
            boolean schemaWasIntrospected = it != null && it.compareTo(BaseIntrospectionFunctions.AGES_AGO) > 0;
            if (this.getMode() != IntrospectionMode.FRAGMENT) {
                this.setMode(schemaHasObjects && schemaWasIntrospected ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL);
            }
            this.myFromTimestamp = this.getMode().increment && lastIntrospectionTimestamp != null ? CalendarFun.toTimestamp(lastIntrospectionTimestamp) : BaseIntrospectionFunctions.AGES_AGO;
            Long existentSourcesVersion = this.getModel().getSchemaSourcesVersion((BasicSchema)this.getSchema());
            Timestamp existentSourcesTimestamp = existentSourcesVersion != null && existentSourcesVersion > 0L ? new Timestamp(existentSourcesVersion) : null;
            Timestamp sourcesSince = this.getMode().increment && existentSourcesTimestamp != null ? existentSourcesTimestamp : BaseIntrospectionFunctions.AGES_AGO;
            IntrospectionQueryContext this_$iv = this;
            boolean $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
                IntrospectionQueryContext introspectionQueryContext = this_$iv;
                boolean bl2 = false;
                introspectionQueryContext.trace(StringsKt.trimMargin$default((String)("|Analysing schema briefly:\n           |\\tSchema has objects:      " + schemaHasObjects + "\n           |\\tLast introspection time: " + lastIntrospectionTimestamp + "\n           |\\tExistent sources time:   " + existentSourcesTimestamp + "\n           |\\tDecided mode:            " + this.getMode() + "\n        "), null, (int)1, null));
            }
            this.setQueryParameter("since", this.myFromTimestamp);
            this.setQueryParameter("src_since", sourcesSince);
        }

        @Override
        protected void analyzeCurrentContent() {
            super.analyzeCurrentContent();
            this.determineDroppedObjects$intellij_database_dialects_mssql();
        }

        public final void determineDroppedObjects$intellij_database_dialects_mssql() {
            if (MsIntrospector.this.schemasWhereDroppedObjectsDetected.contains(this.getSchema())) {
                this.trace("Dropped objects are already determined.");
                return;
            }
            MsIntrospector.this.reportStatusDetails("Determining dropped objects", "introspection.retrieve.droppedObjects");
            int[] existentObjectsArray = this.performQuery(MsIntrospector.this.myQueries.getListExistentObjects());
            int n = existentObjectsArray.length;
            this.trace("The schema on the server contains " + n + " regular major object identifiers");
            IntOpenHashSet existentObjectIds = new IntOpenHashSet(existentObjectsArray);
            int n1 = existentObjectIds.size();
            if (n1 != n) {
                IntrospectionQueryContext.logWarn$default(this, "It's strange: got " + n + " regular major identifiers, but there are " + n1 + " unique of them", null, 2, null);
            }
            this.inSchema(arg_0 -> MsSchemaRetriever.determineDroppedObjects$lambda$3(this, existentObjectIds, arg_0));
            if (((MsSchema)this.getSchema()).getTableTypes().isEmpty() && ((MsSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            long[] existentIndicesArray = this.performQuery(MsIntrospector.this.myQueries.getListExistentIndices());
            long[] tablesWithFulltextIndicesArray = MsIntrospector.this.isSynapse() ? ArrayUtil.EMPTY_LONG_ARRAY : this.performQuery(MsIntrospector.this.myQueries.getListExistentFulltextIndices());
            LongOpenHashSet existentIndicesCombies = new LongOpenHashSet(existentIndicesArray);
            LongOpenHashSet tablesWithFulltextIndices = new LongOpenHashSet(tablesWithFulltextIndicesArray);
            this.inSchema(arg_0 -> MsSchemaRetriever.determineDroppedObjects$lambda$4(this, existentIndicesCombies, tablesWithFulltextIndices, arg_0));
            ((Collection)MsIntrospector.this.schemasWhereDroppedObjectsDetected).add(this.getSchema());
        }

        private final void removeUnexistentSchemaObjects(MsSchema schema, AbstractIntSet existentObjectIds) {
            ModNamingIdentifyingFamily<? extends MsSynonym> modNamingIdentifyingFamily = schema.getSynonyms();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSynonyms(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsRoutine> modNamingIdentifyingFamily2 = schema.getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getRoutines(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily2, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsView> modNamingIdentifyingFamily3 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getViews(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily3, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsTable> modNamingIdentifyingFamily4 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getTables(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily4, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsRule> modNamingIdentifyingFamily5 = schema.getRules();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getRules(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily5, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsSequence> modNamingIdentifyingFamily6 = schema.getSequences();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"getSequences(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily6, existentObjectIds);
            for (MsTable msTable : schema.getTables()) {
                NamingFamily<? extends BasicKey> namingFamily = msTable.getKeys();
                Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getKeys(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingFamily)), existentObjectIds);
                NamingFamily namingFamily2 = msTable.getForeignKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily2, (String)"getForeignKeys(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingFamily2)), existentObjectIds);
                NamingFamily<? extends BasicCheck> namingFamily3 = msTable.getChecks();
                Intrinsics.checkNotNullExpressionValue(namingFamily3, (String)"getChecks(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingFamily3)), existentObjectIds);
                ModNamingIdentifyingFamily<? extends MsDefaultConstraint> modNamingIdentifyingFamily7 = msTable.getDefaultConstraints();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"getDefaultConstraints(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily7, existentObjectIds);
                ModNamingIdentifyingFamily<? extends MsTrigger> modNamingIdentifyingFamily8 = msTable.getTriggers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily8, (String)"getTriggers(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily8, existentObjectIds);
                ModNamingIdentifyingFamily<? extends MsTablePartition> modNamingIdentifyingFamily9 = msTable.getPartitions();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily9, (String)"getPartitions(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily9, existentObjectIds);
            }
            for (MsView msView : schema.getViews()) {
                ModNamingIdentifyingFamily<? extends MsTrigger> modNamingIdentifyingFamily10 = msView.getTriggers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily10, (String)"getTriggers(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily10, existentObjectIds);
            }
        }

        private final void removeUnexistentIndices(MsSchema schema, LongSet existentIndicesCombies, LongSet tablesWithFulltextIndices) {
            for (MsTableType msTableType : schema.getTableTypes()) {
                Intrinsics.checkNotNull((Object)msTableType);
                this.removeUnexistentIndices(msTableType, existentIndicesCombies, tablesWithFulltextIndices);
            }
            for (MsTable msTable : schema.getTables()) {
                Intrinsics.checkNotNull((Object)msTable);
                this.removeUnexistentIndices(msTable, existentIndicesCombies, tablesWithFulltextIndices);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void removeUnexistentIndices(MsStoredTable table, LongSet existentIndicesCombies, LongSet tablesWithFulltextIndices) {
            void $this$filterTo$iv$iv;
            ModPositioningNamingFamily<? extends MsLikeIndex> modPositioningNamingFamily = table.getIndices();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getIndices(...)");
            Iterable $this$filter$iv = modPositioningNamingFamily;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MsLikeIndex it = (MsLikeIndex)element$iv$iv;
                boolean bl = false;
                boolean bl2 = it.isFulltext() ? !tablesWithFulltextIndices.contains(table.getObjectId()) : !existentIndicesCombies.contains(table.getObjectId() * 100000L + (long)it.getPosition());
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List droppedIndices = (List)destination$iv$iv;
            for (int i2 = droppedIndices.size() - 1; -1 < i2; --i2) {
                ((MsLikeIndex)droppedIndices.get(i2)).drop();
            }
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveTableTypes();
            this.retrieveTables();
            this.retrieveViews();
            this.retrieveRules();
            this.retrieveColumns();
            this.retrieveIndices();
            this.retrievePartitions();
            this.retrieveFulltextIndices();
            this.retrieveKeys();
            this.retrieveForeignKeys();
            this.retrieveCheckConstraints();
            this.retrieveArguments();
            this.retrieveTriggers();
            this.retrieveSynonyms();
            this.retrieveSequences();
            this.retrievePermissions();
            this.retrieveSecurityPolicies();
            this.retrieveSecurityPredicates();
            this.retrieveDescriptions();
            this.retrieveSources();
        }

        @Override
        protected void processLevel2Imp() {
            this.retrieveTables();
            this.retrieveViews();
            this.retrieveTableTypes();
            this.retrieveRules();
            this.retrieveColumns();
            this.retrieveSequences();
            this.retrieveIndices();
            this.retrievePartitions();
            this.retrieveFulltextIndices();
            this.retrieveKeys();
            this.retrieveForeignKeys();
            this.retrieveCheckConstraints();
            this.retrieveArguments();
            this.retrieveTriggers();
            this.retrievePermissions();
            this.retrieveSecurityPolicies();
            this.retrieveSecurityPredicates();
            this.retrieveDescriptions();
            this.retrieveSynonyms();
            this.finalizeLevel2();
        }

        private final void finalizeLevel2() {
            ((MsSchema)this.getSchema()).setLastIntrospectionLevel(Level.L2);
            ((MsSchema)this.getSchema()).setLastIntrospectionLocalTimestamp(this.getIntrospectionBeginLocalTimestamp());
        }

        @Override
        protected void processLevel3Imp() {
            this.retrieveSources();
            this.finalizeLevel3();
        }

        private final void finalizeLevel3() {
            ((MsSchema)this.getSchema()).setLastIntrospectionLevel(Level.L3);
        }

        public final void finalizeIntrospection() {
            this.inSchema(arg_0 -> MsSchemaRetriever.finalizeIntrospection$lambda$6(this, arg_0));
        }

        @Override
        public void retrieveNamedFragments(@NotNull ObjectKind fragmentKind, @NotNull String[] fragmentNames) {
            Intrinsics.checkNotNullParameter((Object)fragmentKind, (String)"fragmentKind");
            Intrinsics.checkNotNullParameter((Object)fragmentNames, (String)"fragmentNames");
            this.setMode(IntrospectionMode.FRAGMENT);
            this.setFragmentKind(fragmentKind);
            this.setFragmentNames(fragmentNames);
            this.setWithSources(true);
            BaseIntrospectionFunctions.setupModeParameters(this.getMode(), this.getParametersMap());
            this.getParametersMap().put("f_names", fragmentNames);
            this.retrieveMajorFragmentEntities();
            ObjectKind objectKind = fragmentKind;
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                this.retrieveTables();
                this.retrieveViews();
                this.retrieveColumns();
                this.retrieveIndices();
                this.retrievePartitions();
                this.retrieveFulltextIndices();
                this.retrieveKeys();
                this.retrieveForeignKeys();
                this.retrieveCheckConstraints();
                this.retrieveTriggers();
                this.retrieveDescriptions();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                this.retrieveTables();
                this.retrieveViews();
                this.retrieveColumns();
                this.retrieveIndices();
                this.retrievePartitions();
                this.retrieveTriggers();
                this.retrieveDescriptions();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
                this.retrieveArguments();
                this.retrieveColumns();
                this.retrieveSources();
            } else if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ALIAS_TYPE)) {
                if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE_TYPE)) {
                    this.retrieveTableTypes();
                    this.retrieveColumns();
                    this.retrieveIndices();
                    this.retrieveFulltextIndices();
                    this.retrieveKeys();
                    this.retrieveForeignKeys();
                    this.retrieveCheckConstraints();
                    this.retrieveTriggers();
                } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.RULE)) {
                    this.retrieveRules();
                    this.retrieveSources();
                } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE)) {
                    this.retrieveSequences();
                } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SYNONYM)) {
                    this.retrieveSynonyms();
                } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SECURITY_POLICY)) {
                    this.retrievePermissions();
                    this.retrieveSecurityPolicies();
                    this.retrieveSecurityPredicates();
                }
            }
        }

        private final void retrieveMajorFragmentEntities() {
            MsIntrospector.this.reportRetrieving("major entity names (kind=" + this.getFragmentKind() + ")", "introspection.retrieve.majorEntityNames");
            SqlQuery<List<MsIntroQueries.OneMajorObjectName>> query = Intrinsics.areEqual((Object)this.getFragmentKind(), (Object)ObjectKind.TABLE_TYPE) ? MsIntrospector.this.myQueries.getRetrieveFragmentMajorTableTypeNames() : MsIntrospector.this.myQueries.getRetrieveFragmentMajorNames();
            List mns = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, query, null, 0, 6, null);
            if (mns.isEmpty()) {
                return;
            }
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveMajorFragmentEntities$lambda$7(mns, this, arg_0));
        }

        private final void retrieveTables() {
            IntrospectionQueryContext introspectionQueryContext;
            if (!this.effect.getTables()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            MsIntrospector.this.reportRetrieving(objectKind);
            List tabs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTables(), null, 0, 6, null);
            IntrospectionQueryContext this_$iv = this;
            boolean $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
                introspectionQueryContext = this_$iv;
                boolean bl = false;
                introspectionQueryContext.trace("Retrieved brief info for " + tabs.size() + " tables");
            }
            if (tabs.isEmpty()) {
                return;
            }
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveTables$lambda$9(tabs, MsIntrospector.this, this, arg_0));
            this_$iv = this;
            $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
                introspectionQueryContext = this_$iv;
                boolean bl = false;
                introspectionQueryContext.trace("Applied brief info for tables");
            }
        }

        private final void retrieveViews() {
            if (!this.effect.getViews()) {
                return;
            }
            int[] nArray = new int[]{16};
            if (MsIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                ObjectKind objectKind = ObjectKind.VIEW;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"VIEW");
                MsIntrospector.this.reportRetrieving(objectKind);
                List views = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveViewsExtra(), null, 0, 6, null);
                this.inSchema(arg_0 -> MsSchemaRetriever.retrieveViews$lambda$11(views, this, arg_0));
            } else {
                this.inSchema(arg_0 -> MsSchemaRetriever.retrieveViews$lambda$12(this, arg_0));
            }
        }

        private final void retrieveRules() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            if (this.myTouchedRules.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.RULE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"RULE");
            MsIntrospector.this.reportRetrieving(objectKind);
            List rs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveRules(), null, 0, 6, null);
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveRules$lambda$15(rs, arg_0));
        }

        private final void retrieveTableTypes() {
            if (!this.effect.getTableTypes()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.TABLE_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE_TYPE");
            MsIntrospector.this.reportRetrieving(objectKind);
            List tts = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTableTypes(), null, 0, 6, null);
            IntrospectionQueryContext this_$iv = this;
            boolean $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
                IntrospectionQueryContext introspectionQueryContext = this_$iv;
                boolean bl = false;
                introspectionQueryContext.trace("Retrieved brief info for " + tts.size() + " table types");
            }
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveTableTypes$lambda$17(tts, this, arg_0));
            this.retrieveTypeColumns();
            this.retrieveTypeIndices();
            this.retrieveTypeKeys();
            this.retrieveTypeCheckConstraints();
            this.inSchema(MsSchemaRetriever::retrieveTableTypes$lambda$18);
        }

        private final void retrieveColumns() {
            if (!(this.effect.getTables() || this.effect.getViews() || this.effect.getRoutines())) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            MsIntrospector.this.reportRetrieving(objectKind);
            List cols = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveColumns(), null, 0, 6, null);
            this.processColumns(cols);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrievePartitions() {
            void $this$groupByTo$iv$iv;
            if (!this.effect.getTables()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.PARTITION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PARTITION");
            MsIntrospector.this.reportRetrieving(objectKind);
            List allPs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrievePartitions(), null, 0, 6, null);
            Iterable $this$groupBy$iv = allPs;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                MsIntroQueries.OnePartition it = (MsIntroQueries.OnePartition)element$iv$iv;
                boolean bl = false;
                MsPartitionHostKey key$iv$iv = new MsPartitionHostKey(it.object_id, it.index_id);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map hostedPs = destination$iv$iv;
            this.inSchema(arg_0 -> MsSchemaRetriever.retrievePartitions$lambda$21(hostedPs, arg_0));
        }

        private final void retrieveTypeColumns() {
            MsIntrospector.this.reportRetrieving("columns of custom table types", "introspection.retrieve.columnsOfCustomTableTypes");
            List cols = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTypeColumns(), null, 0, 6, null);
            this.processColumns(cols);
        }

        private final void processColumns(List<MsIntroQueries.OneColumn> cols) {
            ObjectOpenHashSet affectedCursors = new ObjectOpenHashSet(cols.size() / 3);
            this.inSchema(arg_0 -> MsSchemaRetriever.processColumns$lambda$23(cols, affectedCursors, this, MsIntrospector.this, arg_0));
        }

        private final void retrieveIndices() {
            if (!this.effect.getTables() && !this.effect.getViews()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            MsIntrospector.this.reportRetrieving(objectKind);
            List inds = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveIndices(), null, 0, 6, null);
            List ics = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveIndexColumns(), null, 0, 6, null);
            this.processIndices(inds, ics);
        }

        private final void retrieveFulltextIndices() {
            if (MsIntrospector.this.isSynapse()) {
                return;
            }
            if (!this.effect.getTables()) {
                return;
            }
            MsIntrospector.this.reportRetrieving("fulltext indices", "introspection.retrieve.fulltextIndices");
            List inds = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveFulltextIndices(), null, 0, 6, null);
            List ics = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveFulltextIndexColumns(), null, 0, 6, null);
            this.processFulltextIndices(inds, ics);
        }

        private final void retrieveTypeIndices() {
            MsIntrospector.this.reportRetrieving("indices of custom table types", "introspection.retrieve.customTableTypeIndices");
            List inds = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTypeIndices(), null, 0, 6, null);
            List ics = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTypeIndexColumns(), null, 0, 6, null);
            this.processIndices(inds, ics);
        }

        private final void processIndices(List<MsIntroQueries.OneIndex> inds, List<MsIntroQueries.OneIndexColumn> ics) {
            HashMap indices = new HashMap(inds.size());
            HashMap tableByHeapIndex = new HashMap();
            this.inSchema(arg_0 -> MsSchemaRetriever.processIndices$lambda$24(inds, tableByHeapIndex, MsIntrospector.this, indices, arg_0));
            CollectionAggregator colsA = new CollectionAggregator(MsSchemaRetriever::processIndices$lambda$25);
            CollectionAggregator colsI = new CollectionAggregator(MsSchemaRetriever::processIndices$lambda$26);
            CollectionAggregator colsR = new CollectionAggregator(MsSchemaRetriever::processIndices$lambda$27);
            for (MsIntroQueries.OneIndexColumn ic : ics) {
                String indexName;
                Object object;
                MsMinorIdentity key2 = new MsMinorIdentity(ic.object_id, ic.index_position);
                if (ic.partition_ordinal > 0) {
                    BasicPositionReference columnRef = BasicPositionReference.create((short)ic.column_id);
                    MsTable table = (MsTable)tableByHeapIndex.get(key2);
                    if (table != null) {
                        table.setPartitionColumnRef(columnRef);
                    } else {
                        MsLikeIndex msLikeIndex = (MsLikeIndex)indices.get(key2);
                        if (msLikeIndex != null) {
                            msLikeIndex.setPartitionColumnRef(columnRef);
                        }
                    }
                }
                if ((object = ic.name) == null) {
                    object = indexName = "<unnamed_" + ic.object_id + ">";
                }
                if (!ic.is_included_column) {
                    colsA.add(key2, indexName);
                    if (!ic.is_desc) continue;
                    colsR.add(key2, indexName);
                    continue;
                }
                colsI.add(key2, indexName);
            }
            this.inSchema(arg_0 -> MsSchemaRetriever.processIndices$lambda$28(colsA, indices, colsI, colsR, arg_0));
        }

        private final void processFulltextIndices(List<MsIntroQueries.OneFulltextIndex> inds, List<MsIntroQueries.OneFulltextIndexColumn> ics) {
            HashMap indices = new HashMap(inds.size());
            this.inSchema(arg_0 -> MsSchemaRetriever.processFulltextIndices$lambda$29(inds, indices, arg_0));
            CollectionAggregator cols = new CollectionAggregator(MsSchemaRetriever::processFulltextIndices$lambda$30);
            for (MsIntroQueries.OneFulltextIndexColumn ic : ics) {
                int objectId = ic.object_id;
                Object object = ic.name;
                if (object == null) {
                    object = "<unnamed_" + objectId + ">";
                }
                String indexName = object;
                cols.add(objectId, indexName);
            }
            this.inSchema(arg_0 -> MsSchemaRetriever.processFulltextIndices$lambda$31(cols, indices, arg_0));
        }

        private final void retrieveKeys() {
            if (!this.effect.getTables()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"KEY");
            MsIntrospector.this.reportRetrieving(objectKind);
            List ks = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveKeys(), null, 0, 6, null);
            this.processKeys(ks);
        }

        private final void retrieveTypeKeys() {
            MsIntrospector.this.reportRetrieving("of custom table types", "introspection.retrieve.customTableTypeKeys");
            List ks = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTypeKeys(), null, 0, 6, null);
            this.processKeys(ks);
        }

        private final void processKeys(List<MsIntroQueries.OneKey> ks) {
            this.inSchema(arg_0 -> MsSchemaRetriever.processKeys$lambda$33(ks, arg_0));
        }

        private final void retrieveForeignKeys() {
            if (!this.effect.getTables()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"FOREIGN_KEY");
            MsIntrospector.this.reportRetrieving(objectKind);
            List fks = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveForeignKeys(), null, 0, 6, null);
            if (fks.isEmpty()) {
                return;
            }
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveForeignKeys$lambda$34(fks, this, MsIntrospector.this, arg_0));
        }

        private final void retrieveCheckConstraints() {
            if (!this.effect.getTables()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.CHECK;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CHECK");
            MsIntrospector.this.reportRetrieving(objectKind);
            List cs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveCheckConstraints(), null, 0, 6, null);
            this.processCheckConstraints(cs);
        }

        private final void retrieveTypeCheckConstraints() {
            ObjectKind objectKind = ObjectKind.CHECK;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CHECK");
            MsIntrospector.this.reportRetrieving(objectKind);
            List cs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTypeCheckConstraints(), null, 0, 6, null);
            this.processCheckConstraints(cs);
        }

        private final void processCheckConstraints(List<MsIntroQueries.OneCheckConstraints> cs) {
            this.inSchema(arg_0 -> MsSchemaRetriever.processCheckConstraints$lambda$35(cs, MsIntrospector.this, arg_0));
        }

        private final void retrieveSynonyms() {
            if (!this.effect.getSynonyms()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SYNONYM;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SYNONYM");
            MsIntrospector.this.reportRetrieving(objectKind);
            List ss = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveSynonyms(), null, 0, 6, null);
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveSynonyms$lambda$36(ss, arg_0));
        }

        private final void retrieveSecurityPolicies() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SECURITY_POLICY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SECURITY_POLICY");
            MsIntrospector.this.reportRetrieving(objectKind);
            List infos = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveSecurityPolicies(), null, 0, 6, null);
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveSecurityPolicies$lambda$39(infos, arg_0));
        }

        private final void retrieveSecurityPredicates() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SECURITY_PREDICATE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SECURITY_PREDICATE");
            MsIntrospector.this.reportRetrieving(objectKind);
            List infos = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveSecurityPredicates(), null, 0, 6, null);
            IdCache policyCache = new IdCache();
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveSecurityPredicates$lambda$44(infos, policyCache, MsIntrospector.this, arg_0));
        }

        private final void retrieveSequences() {
            block5: {
                block4: {
                    if (MsIntrospector.this.isSynapse()) break block4;
                    int[] nArray = new int[]{11};
                    if (!MsIntrospector.this.getServerVersion().less(nArray)) break block5;
                }
                return;
            }
            if (!this.effect.getSequences()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SEQUENCE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SEQUENCE");
            MsIntrospector.this.reportRetrieving(objectKind);
            List sequences = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveSequences(), null, 0, 6, null);
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveSequences$lambda$46(sequences, this, arg_0));
        }

        private final BigInteger asBigInteger(Object $this$asBigInteger) {
            BigInteger bigInteger;
            Object object = $this$asBigInteger;
            if (object instanceof BigInteger) {
                bigInteger = (BigInteger)$this$asBigInteger;
            } else if (object instanceof BigDecimal) {
                bigInteger = ((BigDecimal)$this$asBigInteger).toBigInteger();
            } else if (object instanceof Number) {
                BigInteger bigInteger2 = BigInteger.valueOf(((Number)$this$asBigInteger).longValue());
                bigInteger = bigInteger2;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
            } else {
                bigInteger = null;
            }
            return bigInteger;
        }

        private final DasType getDasType(MsIntroQueries.OneSequence $this$getDasType, boolean isUnderlying) {
            String typeName;
            String string;
            String schemaName;
            if (isUnderlying) {
                String string2 = $this$getDasType.type_schema_name;
                if (string2 != null) {
                    String string3;
                    String it = string3 = string2;
                    boolean bl = false;
                    v1 = !StringsKt.equals((String)it, (String)"sys", (boolean)true) ? string3 : null;
                } else {
                    v1 = null;
                }
            } else {
                v1 = schemaName = null;
            }
            if ((string = isUnderlying ? $this$getDasType.system_type_name : $this$getDasType.type_name) == null) {
                string = "bigint";
            }
            int length = StringsKt.equals((String)(typeName = string), (String)"numeric", (boolean)true) || StringsKt.equals((String)typeName, (String)"decimal", (boolean)true) ? $this$getDasType.precision : -1;
            DataType dataType = DataTypeFactory.of(schemaName, typeName, length, 0, null, null, false, false);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            DataType dataType2 = dataType;
            return DasUnresolvedTypeReference.Companion.of(dataType2);
        }

        private final BigInteger sequenceUnlimitedMinimumDefault(DasType type) {
            return DasTypeUtilsKt.getMinValue(type);
        }

        private final BigInteger sequenceUnlimitedMaximumDefault(DasType type) {
            return DasTypeUtilsKt.getMaxValue(type);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveArguments() {
            void $this$groupByTo$iv$iv;
            if (!this.effect.getRoutines()) {
                return;
            }
            MsIntrospector.this.reportRetrieving("procedures' and functions' parameters", "introspection.retrieve.singleRoutinesArguments");
            List allArgs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveArguments(), null, 0, 6, null);
            Iterable $this$groupBy$iv = allArgs;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                MsIntroQueries.OneArguments it = (MsIntroQueries.OneArguments)element$iv$iv;
                boolean bl = false;
                Integer key$iv$iv = it.object_id;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map tableArgs = destination$iv$iv;
            IntrospectionQueryContext this_$iv = this;
            boolean $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
                IntrospectionQueryContext introspectionQueryContext = this_$iv;
                boolean bl = false;
                introspectionQueryContext.trace("Retrieved " + allArgs.size() + " arguments for " + tableArgs.size() + " routines");
            }
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveArguments$lambda$55(tableArgs, this, arg_0));
        }

        private final void retrieveTriggers() {
            if (((MsSchema)this.getSchema()).getTables().isEmpty() & ((MsSchema)this.getSchema()).getViews().isEmpty()) {
                return;
            }
            if (MsIntrospector.this.isSynapse()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            MsIntrospector.this.reportRetrieving(objectKind);
            List ts2 = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTriggers(), null, 0, 6, null);
            if (ts2.isEmpty()) {
                return;
            }
            HashSet affectedTables = new HashSet(ts2.size());
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveTriggers$lambda$56(ts2, this, affectedTables, arg_0));
        }

        private final void retrievePermissions() {
            MsIntrospector.this.reportRetrieving("objects' permissions", "introspection.retrieve.objectPermissions");
            MsIntrospectorKt.access$retrievePermissions(this, (MsGrantsHolder)this.getSchema(), this.getTransaction(), MsIntrospector.this.myQueries.getCalculateSchemaPermissionsChecksum(), MsIntrospector.this.myQueries.getRetrieveSchemaPermissions());
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDescriptions() {
            void $this$groupByTo$iv$iv;
            MsIntrospector.this.reportRetrieving("table descriptions", "introspection.retrieve.tableDescriptions");
            long checksum = 0L;
            try {
                Long checksumOrNull;
                Long l = checksumOrNull = this.performQuery(MsIntrospector.this.myQueries.getCalculateExtendedPropertiesChecksum());
                checksum = l != null ? l : 0L;
            }
            catch (Exception e) {
                String message = "Failed to calculate checksum of descriptions in schema " + ((MsSchema)this.getSchema()).getName() + ": exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
                if (this.log.isDebugEnabled()) {
                    this.log.warn(message, (Throwable)e);
                } else {
                    this.log.warn(message);
                }
                return;
            }
            if (checksum == ((MsSchema)this.getSchema()).getDescriptionsCheckSum()) {
                return;
            }
            List ds = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveExtendedProperties(), null, 0, 6, null);
            Iterable $this$groupBy$iv = ds;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                MsIntroQueries.OneProperty d = (MsIntroQueries.OneProperty)element$iv$iv;
                boolean bl = false;
                ExtPropId key$iv$iv = new ExtPropId(d.object_class, d.object_id, d.position);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map descriptions = destination$iv$iv;
            this.inSchema(arg_0 -> MsSchemaRetriever.retrieveDescriptions$lambda$59(this, descriptions, checksum, arg_0));
        }

        private final <T extends BasicModIdentifiedElement, X> void processExtendedPropertiesForObjects(ModIdentifyingFamily<T> family, Map<ExtPropId, ? extends X> values, Function2<? super BasicModElement, ? super X, Unit> processor2) {
            for (BasicModIdentifiedElement obj2 : family) {
                Intrinsics.checkNotNull((Object)obj2);
                this.processExtendedPropertiesForObjects(obj2, values, processor2);
            }
        }

        private final <T extends MsCustomType, X> void processExtendedPropertiesForType(T type, Map<ExtPropId, ? extends X> values, Function2<? super BasicModElement, ? super X, Unit> processor2) {
            processor2.invoke(type, values.get(MsIntrospectorKt.access$getExtendedPropertyId(type)));
        }

        private final <T extends BasicModIdentifiedElement, X> void processExtendedPropertiesForObjects(T obj2, Map<ExtPropId, ? extends X> values, Function2<? super BasicModElement, ? super X, Unit> processor2) {
            processor2.invoke(obj2, values.get(MsIntrospectorKt.access$getExtendedPropertyId(obj2)));
            if (obj2 instanceof MsLikeTable) {
                for (MsLikeColumn column2 : ((MsLikeTable)obj2).getColumns()) {
                    Intrinsics.checkNotNull((Object)column2);
                    processor2.invoke((Object)column2, values.get(MsIntrospectorKt.access$getExtendedPropertyId(column2)));
                }
            }
            if (obj2 instanceof MsSchema) {
                MsCustomType it;
                ModNamingIdentifyingFamily<? extends MsSequence> modNamingIdentifyingFamily = ((MsSchema)obj2).getSequences();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSequences(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily), (Map<ExtPropId, ? extends X>)values, processor2);
                ModNamingFamily<? extends MsAliasType> modNamingFamily = ((MsSchema)obj2).getAliasTypes();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getAliasTypes(...)");
                Iterable $this$forEach$iv = modNamingFamily;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (MsAliasType)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    this.processExtendedPropertiesForType((MsCustomType)it, values, processor2);
                }
                ModNamingIdentifyingFamily<? extends MsTableType> modNamingIdentifyingFamily2 = ((MsSchema)obj2).getTableTypes();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTableTypes(...)");
                $this$forEach$iv = modNamingIdentifyingFamily2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (MsTableType)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    this.processExtendedPropertiesForType((MsCustomType)it, values, processor2);
                }
                ModNamingIdentifyingFamily<? extends MsRoutine> modNamingIdentifyingFamily3 = ((MsSchema)obj2).getRoutines();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getRoutines(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily3), (Map<ExtPropId, ? extends X>)values, processor2);
                ModNamingIdentifyingFamily<? extends MsSynonym> modNamingIdentifyingFamily4 = ((MsSchema)obj2).getSynonyms();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getSynonyms(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily4), (Map<ExtPropId, ? extends X>)values, processor2);
                ModNamingIdentifyingFamily<? extends MsTable> modNamingIdentifyingFamily5 = ((MsSchema)obj2).getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getTables(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily5), (Map<ExtPropId, ? extends X>)values, processor2);
                ModNamingIdentifyingFamily<? extends MsView> modNamingIdentifyingFamily6 = ((MsSchema)obj2).getViews();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"getViews(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily6), (Map<ExtPropId, ? extends X>)values, processor2);
                ModNamingIdentifyingFamily<? extends MsRule> modNamingIdentifyingFamily7 = ((MsSchema)obj2).getRules();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"getRules(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily7), (Map<ExtPropId, ? extends X>)values, processor2);
                processor2.invoke(obj2, values.get(MsIntrospectorKt.access$getExtendedPropertyId((BasicElement)this.getSchema())));
            }
            if (obj2 instanceof MsTable) {
                for (MsIndex index : ((MsTable)obj2).getIndices()) {
                    Intrinsics.checkNotNull((Object)index);
                    processor2.invoke((Object)index, values.get(MsIntrospectorKt.access$getExtendedPropertyId(index)));
                }
                NamingFamily<? extends BasicCheck> namingFamily = ((MsTable)obj2).getChecks();
                Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getChecks(...)");
                this.processExtendedPropertiesForObjects((T)((Object)((ModIdentifyingFamily)((Object)namingFamily))), (Map<ExtPropId, ? extends X>)values, processor2);
                NamingFamily<? extends BasicKey> namingFamily2 = ((MsTable)obj2).getKeys();
                Intrinsics.checkNotNullExpressionValue(namingFamily2, (String)"getKeys(...)");
                this.processExtendedPropertiesForObjects((T)((Object)((ModIdentifyingFamily)((Object)namingFamily2))), (Map<ExtPropId, ? extends X>)values, processor2);
                NamingFamily namingFamily3 = ((MsTable)obj2).getForeignKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily3, (String)"getForeignKeys(...)");
                this.processExtendedPropertiesForObjects((T)((Object)((ModIdentifyingFamily)((Object)namingFamily3))), (Map<ExtPropId, ? extends X>)values, processor2);
                ModNamingIdentifyingFamily<? extends MsTrigger> modNamingIdentifyingFamily = ((MsTableOrView)obj2).getTriggers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTriggers(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily), (Map<ExtPropId, ? extends X>)values, processor2);
            }
            if (obj2 instanceof MsRoutine) {
                for (MsArgument argument : ((MsRoutine)obj2).getArguments()) {
                    Intrinsics.checkNotNull((Object)argument);
                    processor2.invoke((Object)argument, values.get(MsIntrospectorKt.access$getExtendedPropertyId(argument)));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void retrieveSources() {
            void this_$iv$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv$iv;
            void $this$iv$iv$iv;
            void this_$iv$iv;
            if (this.effect.getSourceAwareObjects().isEmpty() && !this.effect.getTriggers()) {
                return;
            }
            MsIntrospector.this.reportRetrieving("source texts", "introspection.retrieve.sources");
            boolean isSys = StringsKt.equals((String)((MsSchema)this.getSchema()).getName(), (String)"sys", (boolean)true);
            SqlQuery<List<MsIntroQueries.OneSource>> query = isSys ? MsIntrospector.this.myQueries.getRetrieveSourcesWithSys() : MsIntrospector.this.myQueries.getRetrieveSources();
            List ss = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, query, null, 0, 6, null);
            if (ss.isEmpty()) {
                return;
            }
            BaseNativeIntrospector this_$iv = MsIntrospector.this;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            void var9_9 = this_$iv$iv;
            String name$iv$iv$iv = name$iv$iv;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this, ss){
                    final /* synthetic */ MsSchemaRetriever this$0;
                    final /* synthetic */ List $ss$inlined;
                    {
                        this.this$0 = msSchemaRetriever;
                        this.$ss$inlined = list;
                    }

                    public final void run() {
                        boolean bl = false;
                        MsSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneSource>)this.$ss$inlined, this.this$0){
                            final /* synthetic */ List<MsIntroQueries.OneSource> $ss;
                            final /* synthetic */ MsSchemaRetriever this$0;
                            {
                                this.$ss = $ss;
                                this.this$0 = $receiver;
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final void invoke(MsSchema schema) {
                                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                                for (MsIntroQueries.OneSource s : this.$ss) {
                                    block8: {
                                        if (s.object_id == 0L || s.text == null) continue;
                                        if (s.is_trigger) break block8;
                                        var5_6 = schema;
                                        objectId$iv = s.object_id;
                                        $i$f$findById = false;
                                        v0 = $this$findById$iv.getDatabase();
                                        if (v0 == null) ** GOTO lbl-1000
                                        var9_12 = v0;
                                        objectId$iv$iv = objectId$iv;
                                        $i$f$findAllById = false;
                                        v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv$iv)).filter(BasicModIdentifiedElement.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                                        v0 = v1;
                                        if (v1 != null && (v0 = v0.filter(new Condition(var13_18 = (Function1)new Function1<BasicModIdentifiedElement, Boolean>((BasicSchema)$this$findById$iv){
                                            final /* synthetic */ BasicSchema $this_findById;
                                            {
                                                this.$this_findById = $receiver;
                                            }

                                            /*
                                             * Ignored method signature, as it can't be verified against descriptor
                                             */
                                            public final Boolean invoke(BasicIdentifiedElement it) {
                                                return Intrinsics.areEqual((Object)((BasicMixinElement)it).getSchema(), (Object)this.$this_findById);
                                            }
                                        }){
                                            private final /* synthetic */ Function1 function;
                                            {
                                                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                                                this.function = function;
                                            }

                                            public final /* synthetic */ boolean value(Object p0) {
                                                return (Boolean)this.function.invoke(p0);
                                            }
                                        })) != null) {
                                            v2 = (BasicIdentifiedElement)v0.first();
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v2 = null;
                                        }
                                        if (!((element = (BasicModIdentifiedElement)v2) instanceof MsSourceAware)) continue;
                                        v3 = s.text;
                                        ((BasicModSourceAware)element).setSourceText(v3 != null ? BaseIntrospectionFunctions.toCompositeText(v3, CompositeText.Kind.ORIGINAL_TEXT) : null);
                                        if (element instanceof BasicModMultiLevelObject) {
                                            ((BasicModMultiLevelObject)element).setDetailsLevel(Level.L3);
                                        }
                                        if (element instanceof MsRoutine) {
                                            MsSchemaRetriever.access$extractAndApplyDefaults(this.this$0, (MsRoutine)element, s.text);
                                        }
                                        MsSchemaRetriever.access$getEffect$p(this.this$0).include(element);
                                        continue;
                                    }
                                    objectId$iv = schema;
                                    objectId$iv = s.parent_id;
                                    $i$f$findById = false;
                                    v4 = $this$findById$iv.getDatabase();
                                    if (v4 == null) ** GOTO lbl-1000
                                    objectId$iv$iv = v4;
                                    objectId$iv$iv = objectId$iv;
                                    $i$f$findAllById = false;
                                    v5 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv$iv)).filter(MsTableOrView.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"filter(...)");
                                    v4 = v5;
                                    if (v5 != null && (v4 = v4.filter(new /* invalid duplicate definition of identical inner class */)) != null) {
                                        v6 = (BasicIdentifiedElement)v4.first();
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v6 = null;
                                    }
                                    if ((MsTableOrView)v6 == null || (MsTrigger)table.getTriggers().getByObjectId(s.object_id) == null) continue;
                                    v7 = s.text;
                                    trigger.setSourceText(v7 != null ? BaseIntrospectionFunctions.toCompositeText(v7, CompositeText.Kind.ORIGINAL_TEXT) : null);
                                    MsSchemaRetriever.access$getEffect$p(this.this$0).include(table, true);
                                }
                                this_$iv = MsSchemaRetriever.access$getEffect$p(this.this$0);
                                $i$f$majorObjects = false;
                                $this$filterIsInstance$iv$iv = CollectionsKt.asSequence((Iterable)((Iterable)this_$iv.getMajorObjects()));
                                $i$f$filterIsInstance = false;
                                v8 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)MsSchemaRetriever$retrieveSources$1$1$invoke$$inlined$majorObjects$1.INSTANCE);
                                Intrinsics.checkNotNull((Object)v8, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                                for (MsTableOrView tab : v8) {
                                    tab.setDetailsLevel(Level.L3);
                                }
                            }
                        });
                    }
                });
                $this$iv$iv$iv = this_$iv$iv;
                sectionReference$iv$iv$iv = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv == null) return;
            }
            catch (Throwable throwable) {
                void this_$iv$iv$iv2;
                sectionReference$iv$iv$iv = this_$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv$iv, null, 2, null);
        }

        private final void extractAndApplyDefaults(MsRoutine r, String text2) {
            Map map2 = this.extractDefaults(text2);
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map defs = map2;
            PositioningNamingFamily positioningNamingFamily = r.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
            Iterable $this$forEach$iv = positioningNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MsArgument it = (MsArgument)element$iv;
                boolean bl = false;
                it.setDefaultExpression((String)defs.get(it.getName()));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, String> extractDefaults(String text2) {
            Map map2;
            try {
                Map map3;
                SqlProcedureDefinitionImpl stmt;
                Object object;
                Object object2;
                String string = text2;
                if (string != null) {
                    void this_$iv;
                    object2 = string;
                    object = MsIntrospector.this;
                    String it = object2;
                    boolean bl = false;
                    IntrospectorSqlHelper introspectorSqlHelper = ((MsIntrospector)object).getSqlHelper();
                    String src$iv = it;
                    boolean $i$f$statements = false;
                    v1 = (SqlProcedureDefinitionImpl)this_$iv.statements(src$iv, SqlProcedureDefinitionImpl.class).first();
                } else {
                    v1 = stmt = null;
                }
                if (stmt != null && (object2 = stmt.getArguments()) != null) {
                    void $this$associateByTo$iv;
                    object = object2;
                    Map map4 = CollectionFactory.createCaseInsensitiveStringMap();
                    Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"createCaseInsensitiveStringMap(...)");
                    Map destination$iv = map4;
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv : $this$associateByTo$iv) {
                        SqlParameterDefinition $i$f$statements = (SqlParameterDefinition)element$iv;
                        Map map5 = destination$iv;
                        boolean bl = false;
                        SqlParameterDefinition it = (SqlParameterDefinition)element$iv;
                        String string2 = it.getName();
                        boolean bl2 = false;
                        String string3 = it.getDefault();
                        map5.put(string2, string3);
                    }
                    map3 = destination$iv;
                } else {
                    map3 = null;
                }
                map2 = map3;
            }
            catch (Throwable th) {
                this.log.warn(th);
                map2 = null;
            }
            return map2;
        }

        @Override
        protected void finishSchema() {
            super.finishSchema();
            ((MsSchema)this.getSchema()).setIntrospectionTimestamp(this.myIntrospectionBeginTimestamp);
        }

        private static final Unit determineDroppedObjects$lambda$3(MsSchemaRetriever this$0, IntOpenHashSet $existentObjectIds, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.removeUnexistentSchemaObjects(schema, (AbstractIntSet)$existentObjectIds);
            return Unit.INSTANCE;
        }

        private static final Unit determineDroppedObjects$lambda$4(MsSchemaRetriever this$0, LongOpenHashSet $existentIndicesCombies, LongOpenHashSet $tablesWithFulltextIndices, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.removeUnexistentIndices(schema, (LongSet)$existentIndicesCombies, (LongSet)$tablesWithFulltextIndices);
            return Unit.INSTANCE;
        }

        private static final Unit finalizeIntrospection$lambda$6(MsSchemaRetriever this$0, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            schema.setIntrospectionTimestamp(BaseIntrospectionFunctions.nullize(this$0.myIntrospectionBeginTimestamp, BaseIntrospectionFunctions.AGES_AGO));
            schema.setLastIntrospectionLocalTimestamp(this$0.getIntrospectionBeginLocalTimestamp());
            return Unit.INSTANCE;
        }

        private static final Unit retrieveMajorFragmentEntities$lambda$7(List $mns, MsSchemaRetriever this$0, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            block25: for (MsIntroQueries.OneMajorObjectName o : $mns) {
                String type;
                MsSchemaObject obj2 = null;
                String string = o.type;
                if (string == null || (string = StringFun.trimOrNull(string)) == null) continue;
                switch (type = string) {
                    case "IT": 
                    case "S": 
                    case "U": {
                        MsTable msTable = schema.getTables().renew(o.object_id, o.name);
                        Intrinsics.checkNotNullExpressionValue((Object)msTable, (String)"renew(...)");
                        obj2 = msTable;
                        break;
                    }
                    case "V": {
                        MsView msView = schema.getViews().renew(o.object_id, o.name);
                        Intrinsics.checkNotNullExpressionValue((Object)msView, (String)"renew(...)");
                        obj2 = msView;
                        break;
                    }
                    case "TT": {
                        MsTableType msTableType = schema.getTableTypes().renew(o.object_id, o.name);
                        Intrinsics.checkNotNullExpressionValue((Object)msTableType, (String)"renew(...)");
                        obj2 = msTableType;
                        break;
                    }
                    case "R": {
                        MsRule msRule = schema.getRules().renew(o.object_id, o.name);
                        Intrinsics.checkNotNullExpressionValue((Object)msRule, (String)"renew(...)");
                        obj2 = msRule;
                        ((Collection)this$0.myTouchedRules).add(obj2);
                        ((Collection)this$0.myTouchedMajorSourceAware).add(obj2);
                        break;
                    }
                    case "FN": 
                    case "P": 
                    case "TF": 
                    case "PC": 
                    case "X": 
                    case "IF": {
                        MsRoutine routine2;
                        Intrinsics.checkNotNullExpressionValue((Object)schema.getRoutines().renew(o.object_id, o.name), (String)"renew(...)");
                        MsRoutineType routineType = MsRoutineTypes.MS_ROUTINE_TYPES.get(type);
                        routine2.setRoutineType(routineType);
                        obj2 = routine2;
                        routine2.getArguments().markChildrenAsSyncPending();
                        ((Collection)this$0.myTouchedRoutines).add(routine2);
                        break;
                    }
                    case "SO": {
                        MsSequence sequence;
                        Intrinsics.checkNotNullExpressionValue((Object)schema.getSequences().renew(o.object_id, o.name), (String)"renew(...)");
                        ((Collection)this$0.myTouchedSequences).add(sequence);
                        obj2 = sequence;
                        break;
                    }
                    case "SN": {
                        MsSynonym synonym2;
                        Intrinsics.checkNotNullExpressionValue((Object)schema.getSynonyms().renew(o.object_id, o.name), (String)"renew(...)");
                        ((Collection)this$0.myTouchedSynonyms).add(synonym2);
                        obj2 = synonym2;
                        break;
                    }
                    default: {
                        continue block25;
                    }
                }
                boolean nameIsSurrogate = MsIntrospectorKt.access$detectSurrogateName(o.name);
                ((MsMajorSchemaObject)obj2).setNameSurrogate(nameIsSurrogate);
                MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(obj2, o.create_date, o.modify_date);
                if (obj2 instanceof MsLikeTable) {
                    this$0.myTouchedTables.add((MsLikeTable)obj2);
                    ((MsLikeTable)obj2).getColumns().markChildrenAsSyncPending();
                }
                if (obj2 instanceof MsSourceAware) {
                    ((Collection)this$0.myTouchedMajorSourceAware).add(obj2);
                }
                MsSchemaEffect.include$default(this$0.effect, (BasicMajorObject)((Object)obj2), false, 2, null);
            }
            if (this$0.effect.getTables()) {
                schema.getTables().sort();
            }
            if (this$0.effect.getViews()) {
                schema.getViews().sort();
            }
            if (this$0.effect.getRules()) {
                schema.getRules().sort();
            }
            if (this$0.effect.getTableTypes()) {
                schema.getTableTypes().sort();
            }
            if (this$0.effect.getSequences()) {
                schema.getSequences().sort();
            }
            if (this$0.effect.getRoutines()) {
                schema.getRoutines().sort();
            }
            if (this$0.effect.getSynonyms()) {
                schema.getSynonyms().sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveTables$lambda$9(List $tabs, MsIntrospector this$0, MsSchemaRetriever this$1, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (MsIntroQueries.OneTable t : $tabs) {
                block5: {
                    if (t.name == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)schema.getTables().renew(t.object_id, tableName), (String)"renew(...)");
                    table.setTemporalKind(MsTemporalTableKind.Companion.valueFor(t.temporal_type));
                    table.setPeriodStartColumnRef(BasicPositionReference.create(t.start_column_id));
                    table.setPeriodEndColumnRef(BasicPositionReference.create(t.end_column_id));
                    table.setHistoryTableRef(BasicIdReference.create(t.history_table_id));
                    table.setDataRetentionPeriod(t.history_retention_period);
                    table.setDataRetentionUnit(MsTimeUnit.Companion.valueFor(t.history_retention_period_unit));
                    v0 = table.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
                    if (StringsKt.startsWith$default((String)v0, (String)"MSSQL_DroppedLedgerHistory_", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                    if (table.getTemporalKind() != MsTemporalTableKind.HISTORY_TABLE) break block5;
                    v1 = table.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
                    if (StringsKt.startsWith$default((String)v1, (String)"MSSQL_TemporalHistoryFor_", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                }
                if (table.getLedgerKind() == MsLedgerKind.HISTORY_TABLE) {
                    v2 = table.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
                    ** if (!StringsKt.startsWith$default((String)v2, (String)"MSSQL_LedgerHistoryFor_", (boolean)false, (int)2, null)) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 3 sources

                {
                    v3 = true;
                    ** GOTO lbl27
                }
lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
lbl27:
                // 2 sources

                table.setNameSurrogate(v3);
                table.setLobDataSpaceRef(BasicIdReference.create(t.lob_data_space_id));
                table.setFileStreamDataSpaceRef(BasicIdReference.create(t.filestream_data_space_id));
                var8_8 = new int[]{16};
                if (MsIntrospector.access$getServerVersion(this$0).isOrGreater(var8_8)) {
                    table.setLedgerKind(MsLedgerKind.Companion.valueFor(t.ledger_type));
                    table.setLedgerViewRef(BasicIdReference.create(t.ledger_view_id));
                    table.setDroppedLedger(t.ledger_is_dropped_table);
                }
                table.setDetailsLevel(Level.L2);
                MsSchemaEffect.include$default(this$1.effect, table, false, 2, null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveViews$lambda$11(List $views, MsSchemaRetriever this$0, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (MsIntroQueries.OneView v : $views) {
                MsView view;
                if ((MsView)schema.getViews().getByObjectId(v.object_id) == null) continue;
                view.setLedgerView(v.is_ledger_view);
                view.setDroppedLedger(v.is_dropped_ledger_view);
                view.setDetailsLevel(Level.L2);
                ((Collection)this$0.myTouchedMajorSourceAware).add(view);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveViews$lambda$12(MsSchemaRetriever this$0, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (MsView msView : schema.getViews()) {
                if (msView.getDetailsLevel() == Level.L1) {
                    msView.setDetailsLevel(Level.L2);
                }
                ((Collection)this$0.myTouchedMajorSourceAware).add(msView);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRules$lambda$15(List $rs, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModFamily $this$modifyAndCleanup_u24default$iv = schema.getRules();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily rules = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            for (MsIntroQueries.OneRule r : $rs) {
                Object e;
                Intrinsics.checkNotNullExpressionValue(rules.renew(r.object_id, r.name), (String)"renew(...)");
                MsRule it = (MsRule)e;
                boolean bl2 = false;
                MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(it, r.create_date, r.modify_date);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTableTypes$lambda$17(List $tts, MsSchemaRetriever this$0, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (MsIntroQueries.OneTableType tt2 : $tts) {
                MsTableType tableType2;
                Intrinsics.checkNotNullExpressionValue((Object)schema.getTableTypes().renew(tt2.object_id, tt2.name), (String)"renew(...)");
                tableType2.setTypeId(tt2.type_id);
                MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(tableType2, tt2.create_date, tt2.modify_date);
                MsSchemaEffect.include$default(this$0.effect, tableType2, false, 2, null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTableTypes$lambda$18(MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (MsTableType msTableType : schema.getTableTypes()) {
                if (msTableType.getDetailsLevel() != Level.L1) continue;
                msTableType.setDetailsLevel(Level.L2);
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrievePartitions$lambda$21(Map $hostedPs, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (Map.Entry<K, V> var3_3 : $hostedPs.entrySet()) {
                host = (MsPartitionHostKey)var3_3.getKey();
                ps = (List)var3_3.getValue();
                var8_8 = schema;
                objectId$iv = host.getTableId();
                $i$f$findById = false;
                v0 = $this$findById$iv.getDatabase();
                if (v0 == null) ** GOTO lbl-1000
                var12_14 = v0;
                objectId$iv$iv = objectId$iv;
                $i$f$findAllById = false;
                v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv$iv)).filter(MsTable.class);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                v0 = v1;
                if (v1 != null && (v0 = v0.filter(new Condition(var16_21 = (Function1)new Function1<MsTable, Boolean>((BasicSchema)$this$findById$iv){
                    final /* synthetic */ BasicSchema $this_findById;
                    {
                        this.$this_findById = $receiver;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final Boolean invoke(BasicIdentifiedElement it) {
                        return Intrinsics.areEqual((Object)((BasicMixinElement)it).getSchema(), (Object)this.$this_findById);
                    }
                }){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ boolean value(Object p0) {
                        return (Boolean)this.function.invoke(p0);
                    }
                })) != null) {
                    v2 = (BasicIdentifiedElement)v0.first();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                if ((MsTable)v2 == null) continue;
                if (host.getIndexId() == 0) {
                    v3 = table;
                } else {
                    v4 = (MsIndex)table.getIndices().getByNaturalPosition(host.getIndexId());
                    if (v4 == null) continue;
                    v3 = v4;
                }
                host = v3;
                $this$modifyAndCleanup_u24default$iv = host.getPartitions();
                removeUnaffected$iv = true;
                $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                partitions = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                $i$a$-modifyAndCleanup$default-MsIntrospector$MsSchemaRetriever$retrievePartitions$1$1 = false;
                for (MsIntroQueries.OnePartition p : ps) {
                    v5 = partitions.createOrGet(p.partition_id);
                    Intrinsics.checkNotNullExpressionValue(v5, (String)"createOrGet(...)");
                    partition = (MsPartition)v5;
                    partition.setPosition(p.partition_number);
                    partition.setCompression(MsDataCompressionKind.Companion.valueFor(p.data_compression));
                    partition.setXmlCompression(p.xml_compression);
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit processColumns$lambda$23(List $cols, ObjectOpenHashSet $affectedCursors, MsSchemaRetriever this$0, MsIntrospector this$1, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            cursor = null;
            object_id = 0;
            v0 = schema.getDatabase();
            defaultCollation = v0 != null && (v0 = v0.getCollationRef()) != null ? v0.getName() : null;
            for (MsIntroQueries.OneColumn col : $cols) {
                block20: {
                    if (object_id == col.object_id && cursor != null) break block20;
                    object_id = col.object_id;
                    var10_10 = schema;
                    objectId$iv = object_id;
                    $i$f$findById = false;
                    v1 = $this$findById$iv.getDatabase();
                    if (v1 == null) ** GOTO lbl-1000
                    var14_18 = v1;
                    objectId$iv$iv = objectId$iv;
                    $i$f$findAllById = false;
                    v2 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv$iv)).filter(MsLikeTable.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"filter(...)");
                    v1 = v2;
                    if (v2 != null && (v1 = v1.filter(new /* invalid duplicate definition of identical inner class */)) != null) {
                        v3 = (BasicIdentifiedElement)v1.first();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = null;
                    }
                    if ((cursor = (MsLikeTable)v3) == null) continue;
                    itsNew = $affectedCursors.add((Object)cursor);
                    if (itsNew) {
                        cursor.getColumns().markChildrenAsSyncPending();
                        if (cursor instanceof MsStoredTable) {
                            ((MsStoredTable)cursor).getDefaultConstraints().markChildrenAsSyncPending();
                        }
                        MsSchemaEffect.include$default(this$0.effect, cursor, false, 2, null);
                    }
                }
                if ((v4 = col.name) == null) {
                    v4 = "<unnamed_" + col.column_position + ">";
                }
                columnName = v4;
                column = (MsLikeColumn)cursor.getColumns().createOrGet(columnName);
                column.setPosition((short)col.column_position);
                column.setNotNull(col.is_nullable == false);
                column.setStoredType(MsIntrospectorKt.access$makeDasType(col.type_name, col.max_length, col.precision, col.scale));
                isTimestamp = Intrinsics.areEqual((Object)col.type_name, (Object)"timestamp");
                defaultExpression = MsIntrospectorHelper.normalizeExpression$default(MsIntrospector.access$getHelper$p(this$1), col.default_expression, false, 2, null);
                if (column instanceof MsStoredColumn) {
                    ((MsStoredColumn)column).setComputed(col.is_computed != false || isTimestamp != false);
                    if (column instanceof MsTableColumn) {
                        ((MsTableColumn)column).setHidden(col.is_hidden);
                        ((MsTableColumn)column).setSparse(col.is_sparse);
                        ((MsTableColumn)column).setColumnSet(col.is_column_set);
                        if (col.is_data_deletion_filter_column) {
                            v5 = ((MsTableColumn)column).getTable();
                            if (v5 != null) {
                                v5.setDataRetentionFilterColumnRef(BasicPositionReference.create(((MsTableColumn)column).getPosition()));
                            }
                        }
                    }
                    v6 = col.identity_seed_value;
                    identitySeed = v6 != null ? this$0.asBigInteger(v6) : null;
                    v7 = col.identity_increment_value;
                    identityIncrement = v7 != null ? this$0.asBigInteger(v7) : null;
                    v8 = col.identity_last_value;
                    v9 = identityLastValue = v8 != null ? this$0.asBigInteger(v8) : null;
                    if (identitySeed != null || identityIncrement != null || identityLastValue != null) {
                        if (identityLastValue != null) {
                            v10 = BigInteger.ONE;
                            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"ONE");
                            v11 = var18_27.add(v10);
                            v12 = v11;
                            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"add(...)");
                        } else {
                            v12 = null;
                        }
                        next = v12;
                        ((MsStoredColumn)column).setSequenceIdentity(SequenceIdentity.of(identitySeed, next, identityIncrement, null));
                    } else {
                        ((MsStoredColumn)column).setSequenceIdentity(null);
                    }
                    collationName = col.collation_name;
                    $this$isNotNullOrEmpty$iv = collationName;
                    $i$f$isNotNullOrEmpty = false;
                    ((MsStoredColumn)column).setCollationRef(($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0 != false) != false && Intrinsics.areEqual((Object)collationName, (Object)defaultCollation) == false ? (BasicReference)BasicNameReference.create(collationName) : null);
                } else {
                    column.setDefaultExpression(defaultExpression);
                }
                collationName = col.default_constraint_object_id;
                it = ((Number)collationName).longValue();
                $i$a$-takeIf-MsIntrospector$MsSchemaRetriever$processColumns$1$defaultConstraintObjectId$1 = false;
                v13 = it != 0L != false ? collationName : null;
                defaultConstraintObjectId = v13 != null ? v13 : -9223372036854775808L;
                defaultConstraintName = col.default_constraint_name;
                if (defaultConstraintName != null && defaultConstraintObjectId != -9223372036854775808L && cursor instanceof MsStoredTable) {
                    Intrinsics.checkNotNullExpressionValue((Object)((MsStoredTable)cursor).getDefaultConstraints().renew(defaultConstraintObjectId, defaultConstraintName), (String)"renew(...)");
                    dc.setModifiedTimestamp(col.default_constraint_modify_date);
                    dc.setNameSurrogate(col.default_constraint_name_is_surrogate);
                    dc.setDefaultExpression(defaultExpression);
                    dc.setColNames(Collections.singletonList(column.getName()));
                }
                if (column instanceof MsStoredColumn) {
                    if (defaultConstraintObjectId != -9223372036854775808L) {
                        ((MsStoredColumn)column).setDefaultConstraintRef(BasicIdOrNameReference.create(defaultConstraintObjectId, defaultConstraintName));
                    } else {
                        MsGeneratedModelUtil.setDefaultExpressionInline((MsStoredColumn)column, defaultExpression);
                    }
                }
                if (!(column instanceof MsTableColumn)) continue;
                ((MsTableColumn)column).setGeneratedKind(MsGeneratedColumnKind.Companion.valueFor(col.generated_always_type));
                ((MsTableColumn)column).setFilestream(col.is_filestream);
                ((MsTableColumn)column).setRowGuid(col.is_rowguidcol);
                ((MsTableColumn)column).setMaskFunction(col.masking_function);
                ((MsTableColumn)column).setEncryptionKind(MsColumnEncryptionKind.Companion.valueFor(col.encryption_type));
                ((MsTableColumn)column).setEncryptionAlgorithm(col.encryption_algorithm_name);
                ((MsTableColumn)column).setEncryptionKeyRef(BasicParentReference.create(col.column_encryption_key_database_name, BasicIdReference.create(col.column_encryption_key_id)));
            }
            v14 = $affectedCursors.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"iterator(...)");
            var8_8 = v14;
            while (var8_8.hasNext()) {
                t = (MsLikeTable)var8_8.next();
                t.getColumns().removeSyncPendingChildren();
                t.getColumns().sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit processIndices$lambda$24(List $inds, HashMap $tableByHeapIndex, MsIntrospector this$0, HashMap $indices, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (MsIntroQueries.OneIndex ind : $inds) {
                var9_9 = schema;
                objectId$iv = ind.object_id;
                $i$f$findById = false;
                v0 = $this$findById$iv.getDatabase();
                if (v0 == null) ** GOTO lbl-1000
                var13_12 = v0;
                objectId$iv$iv = objectId$iv;
                $i$f$findAllById = false;
                v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv$iv)).filter(MsIndexableTable.class);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                v0 = v1;
                if (v1 != null && (v0 = v0.filter(new /* invalid duplicate definition of identical inner class */)) != null) {
                    v2 = (BasicIdentifiedElement)v0.first();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                if ((MsIndexableTable)v2 == null) continue;
                identity = new MsMinorIdentity(ind.object_id, ind.position);
                if (ind.type == 0 && table instanceof MsTable) {
                    ((Map)$tableByHeapIndex).put(identity, table);
                    ((MsTable)table).setPartitionDataSpaceRef(BasicIdReference.create(ind.data_space_id));
                    continue;
                }
                v3 = table.getIndices().createOrGetAt(ind.position);
                Intrinsics.checkNotNullExpressionValue(v3, (String)"createOrGetAt(...)");
                index = (MsLikeIndex)v3;
                v4 = ind.name;
                if (v4 == null) {
                    v4 = "<unnamed_" + ind.position + ">";
                }
                index.setName((String)v4);
                index.setNameSurrogate(table.isNameSurrogate() != false || MsIntrospectorKt.access$detectSurrogateName(ind.name) != false);
                index.setClustering(ind.type == 1);
                index.setUnique(ind.is_unique);
                index.setOptionPad(ind.is_padded);
                index.setOptionIgnoreDup(ind.ignore_dup_key);
                if (index instanceof MsIndex) {
                    ((MsIndex)index).setOptionAllowRowLocks(ind.allow_row_locks);
                    ((MsIndex)index).setOptionAllowPageLocks(ind.allow_page_locks);
                    ((MsIndex)index).setDisabled(ind.is_disabled);
                }
                index.setFillFactor(ind.fill_factor);
                index.setCondition(MsIntrospectorHelper.normalizeExpression$default(MsIntrospector.access$getHelper$p(this$0), ind.filter_definition, false, 2, null));
                index.setPartitionDataSpaceRef(BasicIdReference.create(ind.data_space_id));
                ((Map)$indices).put(identity, index);
            }
            return Unit.INSTANCE;
        }

        private static final List processIndices$lambda$25() {
            return new ArrayList();
        }

        private static final List processIndices$lambda$26() {
            return new ArrayList();
        }

        private static final Set processIndices$lambda$27() {
            return new TreeSet();
        }

        private static final Unit processIndices$lambda$28(CollectionAggregator $colsA, HashMap $indices, CollectionAggregator $colsI, CollectionAggregator $colsR, MsSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            for (Map.Entry entry : $colsA.getResult().entrySet()) {
                MsLikeIndex index;
                MsMinorIdentity key2 = (MsMinorIdentity)entry.getKey();
                List names = (List)entry.getValue();
                if ((MsLikeIndex)$indices.get(key2) == null) continue;
                index.setColNames(names);
                List list = (List)$colsI.get(key2);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                index.setIncludedColNames(list);
                Set set = (Set)$colsR.get(key2);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                index.setReverseColNames(set);
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit processFulltextIndices$lambda$29(List $inds, HashMap $indices, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (MsIntroQueries.OneFulltextIndex ind : $inds) {
                var7_7 = schema;
                objectId$iv = ind.object_id;
                $i$f$findById = false;
                v0 = $this$findById$iv.getDatabase();
                if (v0 == null) ** GOTO lbl-1000
                var11_10 = v0;
                objectId$iv$iv = objectId$iv;
                $i$f$findAllById = false;
                v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv$iv)).filter(MsStoredTable.class);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                v0 = v1;
                if (v1 != null && (v0 = v0.filter(new /* invalid duplicate definition of identical inner class */)) != null) {
                    v2 = (BasicIdentifiedElement)v0.first();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                if ((MsStoredTable)v2 == null) continue;
                index = (MsLikeIndex)t.getIndices().createOrGetAt((short)32767);
                index.setName("");
                index.setFulltext(true);
                index.setFulltextUniqueIndexRef(BasicPositionReference.create((short)ind.unique_index_id));
                ((Map)$indices).put(ind.object_id, index);
            }
            return Unit.INSTANCE;
        }

        private static final List processFulltextIndices$lambda$30() {
            return new ArrayList();
        }

        private static final Unit processFulltextIndices$lambda$31(CollectionAggregator $cols, HashMap $indices, MsSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            for (Map.Entry entry : $cols.getResult().entrySet()) {
                MsLikeIndex index;
                int key2 = ((Number)entry.getKey()).intValue();
                List names = (List)entry.getValue();
                if ((MsLikeIndex)$indices.get(key2) == null) continue;
                index.setColNames(names);
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit processKeys$lambda$33(List $ks, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            tables = new HashSet<MsStoredTable>($ks.size());
            for (MsIntroQueries.OneKey k : $ks) {
                block7: {
                    var7_7 = schema;
                    objectId$iv = k.table_id;
                    $i$f$findById = false;
                    v0 = $this$findById$iv.getDatabase();
                    if (v0 == null) ** GOTO lbl-1000
                    var11_13 = v0;
                    objectId$iv$iv = objectId$iv;
                    $i$f$findAllById = false;
                    v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv$iv)).filter(MsStoredTable.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                    v0 = v1;
                    if (v1 != null && (v0 = v0.filter(new /* invalid duplicate definition of identical inner class */)) != null) {
                        v2 = (BasicIdentifiedElement)v0.first();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = null;
                    }
                    if ((MsStoredTable)v2 == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)table.getKeys().renew(k.key_id, k.name), (String)"renew(...)");
                    key.setNameSurrogate(k.is_system_named);
                    key.setPrimary(k.is_primary);
                    MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(key, k.create_date, k.modify_date);
                    v3 = table.getIndices();
                    Intrinsics.checkNotNullExpressionValue(v3, (String)"getIndices(...)");
                    $this$firstOrNull$iv = v3;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        ind = (MsLikeIndex)element$iv;
                        $i$a$-firstOrNull-MsIntrospector$MsSchemaRetriever$processKeys$1$index$1 = false;
                        if (!(ind.getPosition() == k.index_position)) continue;
                        v4 = element$iv;
                        break block7;
                    }
                    v4 = null;
                }
                index = v4;
                if (index != null) {
                    key.setUnderlyingIndexRef(BasicNameReference.create(index.getRealName()));
                    index.setNameSurrogate(k.is_system_named);
                } else {
                    key.setUnderlyingIndexRef(null);
                    key.setColNames(CollectionsKt.emptyList());
                }
                tables.add(table);
            }
            v5 = tables.iterator();
            Intrinsics.checkNotNullExpressionValue(v5, (String)"iterator(...)");
            var3_3 = v5;
            while (var3_3.hasNext()) {
                v6 = var3_3.next();
                Intrinsics.checkNotNullExpressionValue(v6, (String)"next(...)");
                table = (MsStoredTable)v6;
                table.getKeys().sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveForeignKeys$lambda$34(List $fks, MsSchemaRetriever this$0, MsIntrospector this$1, MsSchema schema) {
            ForeignKeyInfo fki;
            MsTable table;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            HashSet<MsTable> affectedTables = new HashSet<MsTable>($fks.size());
            Long2ObjectOpenHashMap infos = new Long2ObjectOpenHashMap($fks.size());
            for (MsIntroQueries.OneForeignKey fk : $fks) {
                if ((MsTable)schema.getTables().getByObjectId(fk.table_id) == null) continue;
                Object e = table.getForeignKeys().renew(fk.constraint_id, fk.name);
                Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
                MsForeignKey fkey = (MsForeignKey)e;
                Family family = schema.getParentFamily();
                Intrinsics.checkNotNull((Object)family);
                MsSchema refSchema = (MsSchema)family.getByObjectId(fk.referenced_schema_id);
                fkey.setNameSurrogate(fk.is_system_named);
                fkey.setDisabled(fk.is_disabled);
                MsSchema msSchema = refSchema;
                fkey.setRefTableRef(BasicIdOrNameReference.create(BasicIdReference.create(fk.referenced_object_id), BasicParentReference.create(msSchema != null ? msSchema.getName() : null, BasicNameReference.create(fk.referenced_object_name))));
                MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(fkey, fk.create_date, fk.modify_date);
                fkey.setOnUpdate(MsIntrospectorKt.access$makeCascadeRule(fk.update_referential_action));
                fkey.setOnDelete(MsIntrospectorKt.access$makeCascadeRule(fk.delete_referential_action));
                ForeignKeyInfo fki2 = new ForeignKeyInfo(fkey, refSchema);
                fki2.setDomTableId(fk.table_id);
                fki2.setRefTableId(fk.referenced_object_id);
                infos.put(fk.constraint_id, (Object)fki2);
                affectedTables.add(table);
            }
            List fcs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this$0, this$1.myQueries.getRetrieveForeignKeyColumns(), null, 0, 6, null);
            for (MsIntroQueries.OneForeignKeyColumn fc : fcs) {
                String referenceColumnName;
                String domesticColumnName;
                fki = (ForeignKeyInfo)infos.get(fc.constraint_id);
                if (fc.domestic_column_name == null || fc.reference_column_name == null || fki == null) continue;
                fki.getDomColumnNames().add((Object)domesticColumnName);
                fki.getRefColumnNames().add((Object)referenceColumnName);
            }
            ObjectIterator objectIterator = ((ObjectCollection)infos.values()).iterator();
            Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
            Object object = objectIterator;
            while (object.hasNext()) {
                ForeignKeyInfo o = (ForeignKeyInfo)object.next();
                Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type com.intellij.database.dialects.mssql.introspector.ForeignKeyInfo");
                fki = o;
                fki.getFkey().setColNames((List)ImmutableList.copyOf((Collection)((Collection)fki.getDomColumnNames())));
                fki.getFkey().setRefColNames((List)ImmutableList.copyOf((Collection)((Collection)fki.getRefColumnNames())));
            }
            Iterator iterator = affectedTables.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            object = iterator;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                table = (MsTable)e;
                table.getForeignKeys().sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit processCheckConstraints$lambda$35(List $cs, MsIntrospector this$0, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            affectedTables = new HashSet<MsStoredTable>($cs.size());
            for (MsIntroQueries.OneCheckConstraints c : $cs) {
                var8_8 = schema;
                objectId$iv = c.table_id;
                $i$f$findById = false;
                v0 = $this$findById$iv.getDatabase();
                if (v0 == null) ** GOTO lbl-1000
                var12_11 = v0;
                objectId$iv$iv = objectId$iv;
                $i$f$findAllById = false;
                v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv$iv)).filter(MsStoredTable.class);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                v0 = v1;
                if (v1 != null && (v0 = v0.filter(new /* invalid duplicate definition of identical inner class */)) != null) {
                    v2 = (BasicIdentifiedElement)v0.first();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                if ((MsStoredTable)v2 == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)table.getChecks().renew(c.constraint_id, c.name), (String)"renew(...)");
                check.setNameSurrogate(c.is_system_named);
                check.setDisabled(c.is_disabled);
                MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(check, c.create_date, c.modify_date);
                if (c.column_name != null) {
                    check.setColNames(Collections.singletonList(c.column_name));
                } else {
                    check.setColNames(CollectionsKt.emptyList());
                }
                check.setPredicate(MsIntrospectorHelper.normalizeExpression$default(MsIntrospector.access$getHelper$p(this$0), c.definition, false, 2, null));
                affectedTables.add(table);
            }
            v3 = affectedTables.iterator();
            Intrinsics.checkNotNullExpressionValue(v3, (String)"iterator(...)");
            var4_4 = v3;
            while (var4_4.hasNext()) {
                v4 = var4_4.next();
                Intrinsics.checkNotNullExpressionValue(v4, (String)"next(...)");
                table = (MsStoredTable)v4;
                table.getChecks().sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveSynonyms$lambda$36(List $ss, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (MsIntroQueries.OneSynonym s : $ss) {
                MsSynonym synonym2;
                Intrinsics.checkNotNullExpressionValue((Object)schema.getSynonyms().renew(s.object_id, s.name), (String)"renew(...)");
                synonym2.setTargetObjectRef(BasicParentReference.create(s.origin_db_name, BasicParentReference.create(s.origin_schema_name, BasicNameReference.create(s.origin_object_name))));
                MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(synonym2, s.create_date, s.modify_date);
            }
            schema.getSynonyms().sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveSecurityPolicies$lambda$39(List $infos, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModFamily $this$modifyAndCleanup_u24default$iv = schema.getSecurityPolicies();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily securityPolicies = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            for (MsIntroQueries.OneSecurityPolicy info2 : $infos) {
                Object e;
                Intrinsics.checkNotNullExpressionValue(securityPolicies.renew(info2.object_id, info2.name), (String)"renew(...)");
                MsSecurityPolicy $this$retrieveSecurityPolicies_u24lambda_u2439_u24lambda_u2438_u24lambda_u2437 = (MsSecurityPolicy)e;
                boolean bl2 = false;
                $this$retrieveSecurityPolicies_u24lambda_u2439_u24lambda_u2438_u24lambda_u2437.setEnabled(info2.is_enabled);
                $this$retrieveSecurityPolicies_u24lambda_u2439_u24lambda_u2438_u24lambda_u2437.setNotForReplication(info2.is_not_for_replication);
                $this$retrieveSecurityPolicies_u24lambda_u2439_u24lambda_u2438_u24lambda_u2437.setSchemaBinding(info2.is_schema_bound);
                MsIntrospectorKt.access$setCreatedAndModifiedTimestamps($this$retrieveSecurityPolicies_u24lambda_u2439_u24lambda_u2438_u24lambda_u2437, info2.create_date, info2.modify_date);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveSecurityPredicates$lambda$44(List $infos, IdCache $policyCache, MsIntrospector this$0, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            v0 = schema.getSecurityPolicies();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"getSecurityPolicies(...)");
            $this$map$iv = v0;
            $i$f$map = false;
            var6_6 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var11_13 = (MsSecurityPolicy)item$iv$iv;
                var29_16 = destination$iv$iv;
                $i$a$-map-MsIntrospector$MsSchemaRetriever$retrieveSecurityPredicates$1$1 = false;
                var29_16.add(it.getPredicates());
            }
            $this$map$iv = (List)destination$iv$iv;
            removeUnaffected$iv = true;
            $i$f$modifyFamiliesAndCleanup = false;
            $this$toTypedArray$iv$iv = families$iv;
            $i$f$toTypedArray = false;
            thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            fs$iv = thisCollection$iv$iv.toArray(new ModNamingIdentifyingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            removeUnaffected$iv$iv = removeUnaffected$iv;
            $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            $i$a$-modifyFamiliesAndCleanup$default-MsIntrospector$MsSchemaRetriever$retrieveSecurityPredicates$1$2 = false;
            for (MsIntroQueries.OneSecurityPredicate info : $infos) {
                var17_21 = $policyCache;
                id$iv = info.object_id;
                $i$f$getOrCache = false;
                if (this_$iv.getV() == null) ** GOTO lbl-1000
                v1 = this_$iv.getV();
                Intrinsics.checkNotNull(v1);
                if (((BasicIdentifiedElement)v1).getObjectId() == id$iv) {
                    v2 = this_$iv.getV();
                } else lbl-1000:
                // 2 sources

                {
                    var21_24 = id$iv;
                    var23_25 = this_$iv;
                    var24_26 = this_$iv;
                    $i$a$-getOrCache-MsIntrospector$MsSchemaRetriever$retrieveSecurityPredicates$1$2$policy$1 = false;
                    var24_26.setV((BasicModIdentifiedElement)((MsSecurityPolicy)schema.getSecurityPolicies().getByObjectId((long)id)));
                    v2 = this_$iv.getV();
                }
                if ((MsSecurityPolicy)v2 == null) continue;
                Intrinsics.checkNotNullExpressionValue(policy.getPredicates().createOrGet(info.security_predicate_id), (String)"createOrGet(...)");
                $this$retrieveSecurityPredicates_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442 = (MsSecurityPredicate)var27_29;
                $i$a$-apply-MsIntrospector$MsSchemaRetriever$retrieveSecurityPredicates$1$2$1 = false;
                switch (info.predicate_type) {
                    case 0: {
                        v3 = MsSecurityPredicateType.FILTER;
                        break;
                    }
                    case 1: {
                        v3 = MsSecurityPredicateType.BLOCK;
                        break;
                    }
                    default: {
                        v3 = null;
                    }
                }
                $this$retrieveSecurityPredicates_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442.setPredicateType(v3);
                switch (info.operation) {
                    case 1: {
                        v4 = MsSecurityPredicateOperationType.AFTER_INSERT;
                        break;
                    }
                    case 2: {
                        v4 = MsSecurityPredicateOperationType.AFTER_UPDATE;
                        break;
                    }
                    case 3: {
                        v4 = MsSecurityPredicateOperationType.BEFORE_UPDATE;
                        break;
                    }
                    case 4: {
                        v4 = MsSecurityPredicateOperationType.BEFORE_DELETE;
                        break;
                    }
                    default: {
                        v4 = MsSecurityPredicateOperationType.ALL;
                    }
                }
                $this$retrieveSecurityPredicates_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442.setOperationType(v4);
                $this$retrieveSecurityPredicates_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442.setDefinition(MsIntrospector.access$getHelper$p(this$0).normalizeExpression(info.predicate_definition, true));
                $this$retrieveSecurityPredicates_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442.setTargetTableRef(BasicIdReference.create(info.target_object_id));
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveSequences$lambda$46(List $sequences, MsSchemaRetriever this$0, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (MsIntroQueries.OneSequence s : $sequences) {
                long l;
                MsSequence sequence;
                MsSequence msSequence;
                Intrinsics.checkNotNullExpressionValue((Object)schema.getSequences().renew(s.object_id, s.name), (String)"renew(...)");
                Object object = s.start_value;
                BigInteger start2 = object != null ? this$0.asBigInteger(object) : null;
                Object object2 = s.last_value;
                BigInteger last = object2 != null ? this$0.asBigInteger(object2) : null;
                Object object3 = s.minimum_value;
                BigInteger minimum = object3 != null ? this$0.asBigInteger(object3) : null;
                Object object4 = s.maximum_value;
                BigInteger maximum = object4 != null ? this$0.asBigInteger(object4) : null;
                Object object5 = s.increment;
                BigInteger increment = object5 != null ? this$0.asBigInteger(object5) : null;
                MsSequence $this$retrieveSequences_u24lambda_u2446_u24lambda_u2445 = msSequence = sequence;
                boolean bl = false;
                $this$retrieveSequences_u24lambda_u2446_u24lambda_u2445.setStoredType(this$0.getDasType(s, false));
                $this$retrieveSequences_u24lambda_u2446_u24lambda_u2445.setUnderlyingStoredType(this$0.getDasType(s, true));
                $this$retrieveSequences_u24lambda_u2446_u24lambda_u2445.setStartValue(start2);
                DasType dasType = $this$retrieveSequences_u24lambda_u2446_u24lambda_u2445.getUnderlyingStoredType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getUnderlyingStoredType(...)");
                BigInteger bigInteger = BaseIntrospectionFunctions.nextByLast(last, increment, start2);
                DasType dasType2 = $this$retrieveSequences_u24lambda_u2446_u24lambda_u2445.getUnderlyingStoredType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getUnderlyingStoredType(...)");
                $this$retrieveSequences_u24lambda_u2446_u24lambda_u2445.setSequenceIdentity(SequenceIdentity.of(BaseIntrospectionFunctions.nullize(minimum, this$0.sequenceUnlimitedMinimumDefault(dasType)), bigInteger, increment, BaseIntrospectionFunctions.nullize(maximum, this$0.sequenceUnlimitedMaximumDefault(dasType2))));
                if (s.is_cached) {
                    Long l2 = s.cache_size;
                    l = l2 != null ? l2 : 0L;
                } else {
                    l = -1L;
                }
                $this$retrieveSequences_u24lambda_u2446_u24lambda_u2445.setCacheSize(l);
                $this$retrieveSequences_u24lambda_u2446_u24lambda_u2445.setCycled(s.is_cycling);
                MsIntrospectorKt.access$setCreatedAndModifiedTimestamps($this$retrieveSequences_u24lambda_u2446_u24lambda_u2445, s.create_date, s.modify_date);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveArguments$lambda$55(Map $tableArgs, MsSchemaRetriever this$0, MsSchema schema) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            boolean bl;
            BasicNode it;
            Iterable args2;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (Map.Entry object2 : $tableArgs.entrySet()) {
                MsRoutine routine2;
                int routineId = ((Number)object2.getKey()).intValue();
                args2 = (List)object2.getValue();
                if ((MsRoutine)schema.getRoutines().getByObjectId((long)routineId) == null) continue;
                ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)((Object)routine2.getArguments());
                boolean removeUnaffected$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                it = (ModPositioningNamingFamily)$this$modifyAndCleanup_u24default$iv;
                bl = false;
                for (MsIntroQueries.OneArguments a : args2) {
                    ArgumentDirection d;
                    Object object = a.name;
                    if (object == null) {
                        object = "unnamed_" + a.position;
                    }
                    String argName = object;
                    MsArgument argument = (MsArgument)routine2.getArguments().createOrGet(argName);
                    argument.setPosition(a.position);
                    ArgumentDirection argumentDirection = a.is_cursor_ref ? ArgumentDirection.RESULT : (d = a.is_output ? ArgumentDirection.OUT : ArgumentDirection.IN);
                    if (d == ArgumentDirection.OUT && (a.name == null || ((CharSequence)argName).length() == 0)) {
                        d = ArgumentDirection.RETURN;
                    }
                    argument.setArgumentDirection(d);
                    argument.setStoredType(MsIntrospectorKt.access$makeDasType(a.type_name, a.max_length, a.precision, a.scale));
                    argument.resetSyncPending();
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
                MsSchemaEffect.include$default(this$0.effect, routine2, false, 2, null);
            }
            int routinesWithDroppedArguments = 0;
            Iterable iterable = (Iterable)this$0.effect.getMajorObjects();
            boolean $i$f$filterIsInstance = false;
            args2 = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MsRoutine)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = iterable2;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator removeUnaffected$iv = $this$filterTo$iv$iv.iterator();
            while (removeUnaffected$iv.hasNext()) {
                Object element$iv$iv = removeUnaffected$iv.next();
                it = (MsRoutine)element$iv$iv;
                bl = false;
                if (!(!$tableArgs.keySet().contains((int)it.getObjectId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable3 = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = iterable3;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            removeUnaffected$iv = $this$filterTo$iv$iv.iterator();
            while (removeUnaffected$iv.hasNext()) {
                Object element$iv$iv = removeUnaffected$iv.next();
                it = (MsRoutine)element$iv$iv;
                bl = false;
                if (!it.getArguments().isNotEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable4 = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : iterable4) {
                MsRoutine it2 = (MsRoutine)element$iv;
                boolean bl2 = false;
                it2.getArguments().clear();
                ++routinesWithDroppedArguments;
            }
            if (routinesWithDroppedArguments > 0) {
                IntrospectionQueryContext introspectionQueryContext = this$0;
                boolean $i$f$trace = false;
                if (IntrospectionQueryContext.access$getTracing(introspectionQueryContext)) {
                    IntrospectionQueryContext introspectionQueryContext2 = introspectionQueryContext;
                    boolean bl3 = false;
                    introspectionQueryContext2.trace("Dropped arguments from " + routinesWithDroppedArguments + " routines");
                }
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveTriggers$lambda$56(List $ts, MsSchemaRetriever this$0, HashSet $affectedTables, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (MsIntroQueries.OneTrigger t : $ts) {
                var8_8 = schema;
                objectId$iv = t.table_id;
                $i$f$findById = false;
                v0 = $this$findById$iv.getDatabase();
                if (v0 == null) ** GOTO lbl-1000
                var12_11 = v0;
                objectId$iv$iv = objectId$iv;
                $i$f$findAllById = false;
                v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv$iv)).filter(MsTableOrView.class);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                v0 = v1;
                if (v1 != null && (v0 = v0.filter(new /* invalid duplicate definition of identical inner class */)) != null) {
                    v2 = (BasicIdentifiedElement)v0.first();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                if ((MsTableOrView)v2 == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)table.getTriggers().renew(t.trigger_id, t.name), (String)"renew(...)");
                trigger.setEvents(MsIntrospectorKt.access$unpackEvents(t.events));
                trigger.setFirstEvents(MsIntrospectorKt.access$unpackEvents(t.first_events));
                trigger.setLastEvents(MsIntrospectorKt.access$unpackEvents(t.last_events));
                trigger.setTurn(t.is_instead_of_trigger != false ? TrigTurn.INSTEAD_OF : TrigTurn.AFTER_STMT);
                trigger.setNotForReplication(t.is_not_for_replication);
                trigger.setDisabled(t.is_disabled);
                trigger.setEncrypted(t.encrypted);
                trigger.setCreatedTimestamp(t.create_date);
                trigger.setModifiedTimestamp(t.modify_date);
                this$0.effect.include(table, true);
                ((Collection)$affectedTables).add(table);
            }
            v3 = $affectedTables.iterator();
            Intrinsics.checkNotNullExpressionValue(v3, (String)"iterator(...)");
            var4_4 = v3;
            while (var4_4.hasNext()) {
                v4 = var4_4.next();
                Intrinsics.checkNotNullExpressionValue(v4, (String)"next(...)");
                table = (MsTableOrView)v4;
                table.getTriggers().sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDescriptions$lambda$59$lambda$58(BasicModElement obj2, List props) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
                BasicModElement $this$asSafely$iv = obj2;
                boolean $i$f$asSafely = false;
                BasicModElement basicModElement = $this$asSafely$iv;
                if (!(basicModElement instanceof MsExtendedPropertiesHolder)) {
                    basicModElement = null;
                }
                MsExtendedPropertiesHolder msExtendedPropertiesHolder = (MsExtendedPropertiesHolder)basicModElement;
                if (msExtendedPropertiesHolder == null) break block1;
                MsIntrospectorKt.access$setExtProps(msExtendedPropertiesHolder, props);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDescriptions$lambda$59(MsSchemaRetriever this$0, Map $descriptions, long $checksum, MsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.processExtendedPropertiesForObjects((BasicModIdentifiedElement)schema, $descriptions, MsSchemaRetriever::retrieveDescriptions$lambda$59$lambda$58);
            if (this$0.getMode().full || this$0.getMode().increment) {
                schema.setDescriptionsCheckSum($checksum);
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$inSchema(MsSchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }

        public static final /* synthetic */ void access$extractAndApplyDefaults(MsSchemaRetriever $this, MsRoutine r, String text2) {
            $this.extractAndApplyDefaults(r, text2);
        }

        public static final /* synthetic */ MsSchemaEffect access$getEffect$p(MsSchemaRetriever $this) {
            return $this.effect;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\f\b\u0084\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u0006\u0010\u0017\u001a\u00020\u0013J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\r\u0010\u001c\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u0013H\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0002J\b\u0010 \u001a\u00020\u0013H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsServerObjectsRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseServerObjectsRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/mssql/model/MsRoot;", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "Lcom/intellij/database/dialects/mssql/model/MsSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "fragmentNames", "", "", "[Ljava/lang/String;", "setupRegular", "", "setupFragment", "", "prepareParametersForServerObjects", "introspectAllServerObjects", "retrieveLogins", "retrieveLoginsInner", "retrievePermissions", "retrievePermissionsInner", "retrieveCollations", "retrieveCollations$intellij_database_dialects_mssql", "retrieveCollationsInner", "retrieveLinkedServers", "retrieveLinkedServersInner", "intellij.database.dialects.mssql"})
    @SourceDebugExtension(value={"SMAP\nMsIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsServerObjectsRetriever\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n*L\n1#1,2781:1\n37#2:2782\n36#2,3:2783\n1084#3:2786\n1179#3,2:2787\n1085#3,5:2789\n1184#3,2:2794\n1090#3,2:2796\n1084#3:2798\n1179#3,2:2799\n1085#3,5:2801\n1184#3,2:2806\n1090#3,2:2808\n1084#3:2810\n1179#3,2:2811\n1085#3,5:2813\n1184#3,2:2818\n1090#3,2:2820\n1084#3:2822\n1179#3,2:2823\n1085#3,5:2825\n1184#3,2:2830\n1090#3,2:2832\n1#4:2834\n178#5,8:2835\n178#5,8:2843\n*S KotlinDebug\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsServerObjectsRetriever\n*L\n353#1:2782\n353#1:2783,3\n378#1:2786\n378#1:2787,2\n378#1:2789,5\n378#1:2794,2\n378#1:2796,2\n396#1:2798\n396#1:2799,2\n396#1:2801,5\n396#1:2806,2\n396#1:2808,2\n415#1:2810\n415#1:2811,2\n415#1:2813,5\n415#1:2818,2\n415#1:2820,2\n434#1:2822\n434#1:2823,2\n434#1:2825,5\n434#1:2830,2\n434#1:2832,2\n422#1:2835,8\n440#1:2843,8\n*E\n"})
    protected final class MsServerObjectsRetriever
    extends BaseMultiDatabaseIntrospector.BaseServerObjectsRetriever {
        private IntrospectionMode mode;
        @NotNull
        private ObjectKind fragmentKind;
        @NotNull
        private String[] fragmentNames;

        public MsServerObjectsRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(transaction);
            ObjectKind objectKind = ObjectKind.NONE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"NONE");
            this.fragmentKind = objectKind;
            this.fragmentNames = new String[0];
        }

        @Override
        public void setupRegular() {
            this.mode = IntrospectionMode.FULL;
            ObjectKind objectKind = ObjectKind.NONE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"NONE");
            this.fragmentKind = objectKind;
            this.fragmentNames = new String[0];
            this.prepareParametersForServerObjects();
        }

        @Override
        public void setupFragment(@NotNull ObjectKind fragmentKind, @NotNull Set<String> fragmentNames) {
            Intrinsics.checkNotNullParameter((Object)fragmentKind, (String)"fragmentKind");
            Intrinsics.checkNotNullParameter(fragmentNames, (String)"fragmentNames");
            this.mode = IntrospectionMode.FRAGMENT;
            this.fragmentKind = fragmentKind;
            Collection $this$toTypedArray$iv = fragmentNames;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.fragmentNames = thisCollection$iv.toArray(new String[0]);
            this.prepareParametersForServerObjects();
        }

        private final void prepareParametersForServerObjects() {
            IntrospectionMode introspectionMode = this.mode;
            if (introspectionMode == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mode");
                introspectionMode = null;
            }
            BaseIntrospectionFunctions.setupModeParameters(introspectionMode, this.getParametersMap());
            if (!(this.fragmentNames.length == 0)) {
                this.setQueryParameter("fragment_names", this.fragmentNames);
            } else {
                this.setQueryParameter("fragment_names", null);
            }
        }

        public final void introspectAllServerObjects() {
            this.trace("Introspecting server objects");
            this.retrieveCollations$intellij_database_dialects_mssql();
            this.retrieveLogins();
            this.retrievePermissions();
            if (Intrinsics.areEqual((Object)MsIntrospector.this.dbms, (Object)Dbms.MSSQL)) {
                this.retrieveLinkedServers();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void retrieveLogins() {
            void this_$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv;
            void $this$iv$iv;
            void this_$iv;
            BaseIntrospector baseIntrospector = MsIntrospector.this;
            String name$iv = "RetrieveLogins";
            boolean $i$f$doSection = false;
            void var4_4 = this_$iv;
            String name$iv$iv = name$iv;
            CharSequence message$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv);
            DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv) : null;
            try {
                boolean bl = false;
                this.retrieveLoginsInner();
                $this$iv$iv = this_$iv;
                sectionReference$iv$iv = ref$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv == null) return;
            }
            catch (Throwable throwable) {
                void this_$iv$iv2;
                sectionReference$iv$iv = this_$iv;
                DiagnosticSectionReference sectionReference$iv$iv2 = ref$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv, null, 2, null);
        }

        private final void retrieveLoginsInner() {
            ObjectKind objectKind = ObjectKind.LOGIN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"LOGIN");
            MsIntrospector.this.reportRetrieving(objectKind);
            MsIntrospector.this.inModel(arg_0 -> MsServerObjectsRetriever.retrieveLoginsInner$lambda$3(this, MsIntrospector.this, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void retrievePermissions() {
            void this_$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv;
            void $this$iv$iv;
            void this_$iv;
            BaseIntrospector baseIntrospector = MsIntrospector.this;
            String name$iv = "RetrievePermissions";
            boolean $i$f$doSection = false;
            void var4_4 = this_$iv;
            String name$iv$iv = name$iv;
            CharSequence message$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv);
            DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv) : null;
            try {
                boolean bl = false;
                this.retrievePermissionsInner();
                $this$iv$iv = this_$iv;
                sectionReference$iv$iv = ref$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv == null) return;
            }
            catch (Throwable throwable) {
                void this_$iv$iv2;
                sectionReference$iv$iv = this_$iv;
                DiagnosticSectionReference sectionReference$iv$iv2 = ref$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv, null, 2, null);
        }

        private final void retrievePermissionsInner() {
            MsIntrospector.this.reportRetrieving("objects' permissions", "introspection.retrieve.objectPermissions");
            MsIntrospector.this.inModel(arg_0 -> MsServerObjectsRetriever.retrievePermissionsInner$lambda$7(this, MsIntrospector.this, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void retrieveCollations$intellij_database_dialects_mssql() {
            void this_$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv;
            void $this$iv$iv;
            void this_$iv;
            if (!MsIntrospector.access$getRoot(MsIntrospector.this).getCollations().isEmpty() || MsIntrospector.this.isSynapse()) return;
            BaseIntrospector baseIntrospector = MsIntrospector.this;
            String name$iv = "RetrieveCollations";
            boolean $i$f$doSection = false;
            void var4_4 = this_$iv;
            String name$iv$iv = name$iv;
            CharSequence message$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv);
            DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv) : null;
            try {
                boolean bl = false;
                this.retrieveCollationsInner();
                $this$iv$iv = this_$iv;
                sectionReference$iv$iv = ref$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv == null) return;
            }
            catch (Throwable throwable) {
                void this_$iv$iv2;
                sectionReference$iv$iv = this_$iv;
                DiagnosticSectionReference sectionReference$iv$iv2 = ref$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv, null, 2, null);
        }

        private final void retrieveCollationsInner() {
            ObjectKind objectKind = ObjectKind.COLLATION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLLATION");
            MsIntrospector.this.reportRetrieving(objectKind);
            MsIntrospector.this.inModel(arg_0 -> MsServerObjectsRetriever.retrieveCollationsInner$lambda$11(this, MsIntrospector.this, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void retrieveLinkedServers() {
            void this_$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv;
            void $this$iv$iv;
            void this_$iv;
            BaseIntrospector baseIntrospector = MsIntrospector.this;
            String name$iv = "RetrieveLinkedServers";
            boolean $i$f$doSection = false;
            void var4_4 = this_$iv;
            String name$iv$iv = name$iv;
            CharSequence message$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv);
            DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv) : null;
            try {
                boolean bl = false;
                this.retrieveLinkedServersInner();
                $this$iv$iv = this_$iv;
                sectionReference$iv$iv = ref$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv == null) return;
            }
            catch (Throwable throwable) {
                void this_$iv$iv2;
                sectionReference$iv$iv = this_$iv;
                DiagnosticSectionReference sectionReference$iv$iv2 = ref$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv, null, 2, null);
        }

        private final void retrieveLinkedServersInner() {
            ObjectKind objectKind = ObjectKind.LINKED_SERVER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"LINKED_SERVER");
            MsIntrospector.this.reportRetrieving(objectKind);
            MsIntrospector.this.inModel(arg_0 -> MsServerObjectsRetriever.retrieveLinkedServersInner$lambda$16(this, MsIntrospector.this, arg_0));
        }

        private static final Unit retrieveLoginsInner$lambda$3$lambda$2(MsRoot $r, MsIntroQueries.OneLogin l) {
            MsServerPrincipalType msServerPrincipalType;
            MsServerPrincipalType msServerPrincipalType2;
            MsLogin msLogin;
            block2: {
                MsLogin msLogin2;
                Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                MsLogin msLogin3 = $r.getLogins().renew(l.principal_id, l.name);
                Intrinsics.checkNotNullExpressionValue((Object)msLogin3, (String)"renew(...)");
                MsLogin $this$retrieveLoginsInner_u24lambda_u243_u24lambda_u242_u24lambda_u241 = msLogin2 = msLogin3;
                boolean bl = false;
                $this$retrieveLoginsInner_u24lambda_u243_u24lambda_u242_u24lambda_u241.setDefaultDatabase(l.default_database_name);
                $this$retrieveLoginsInner_u24lambda_u243_u24lambda_u242_u24lambda_u241.setOwnerRef(BasicIdReference.create(l.owning_principal_id));
                $this$retrieveLoginsInner_u24lambda_u243_u24lambda_u242_u24lambda_u241.setEnabled(!l.is_disabled);
                MsServerPrincipalType[] msServerPrincipalTypeArray = MsServerPrincipalType.values();
                msLogin = $this$retrieveLoginsInner_u24lambda_u243_u24lambda_u242_u24lambda_u241;
                MsServerPrincipalType[] msServerPrincipalTypeArray2 = msServerPrincipalTypeArray;
                int n = msServerPrincipalTypeArray2.length;
                for (int j = 0; j < n; ++j) {
                    MsServerPrincipalType msServerPrincipalType3;
                    MsServerPrincipalType it = msServerPrincipalType3 = msServerPrincipalTypeArray2[j];
                    boolean bl2 = false;
                    if (!(it.getCode() == l.type)) continue;
                    msServerPrincipalType2 = msServerPrincipalType3;
                    break block2;
                }
                msServerPrincipalType2 = msServerPrincipalType = null;
            }
            if (msServerPrincipalType2 == null) {
                msServerPrincipalType = MsServerPrincipalType.SQL_LOGIN;
            }
            msLogin.setType(msServerPrincipalType);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveLoginsInner$lambda$3(MsServerObjectsRetriever this$0, MsIntrospector this$1, MsRoot r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.myQueries.getRetrieveLogins(), 0, arg_0 -> MsServerObjectsRetriever.retrieveLoginsInner$lambda$3$lambda$2(r, arg_0), 2, null);
            return Unit.INSTANCE;
        }

        private static final Unit retrievePermissionsInner$lambda$7(MsServerObjectsRetriever this$0, MsIntrospector this$1, MsRoot r) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            this$0.setQueryParameter("CAT", "sys");
            boolean isAzure = this$1.dbms.in(Dbms.AZURE_LIKE);
            SqlQuery<Long> sqlQuery = object = this$1.myQueries.getCalculateServerPermissionsChecksum();
            DBTransaction dBTransaction = this$0.getTransaction();
            MsGrantsHolder msGrantsHolder = r;
            IntrospectionQueryContext introspectionQueryContext = this$0;
            boolean bl = false;
            boolean bl2 = isAzure;
            Object object2 = !bl2 ? object : null;
            Object it = object = this$1.myQueries.getRetrieveServerPermissions();
            SqlQuery<Long> sqlQuery2 = object2;
            boolean bl3 = false;
            boolean bl4 = isAzure;
            MsIntrospectorKt.access$retrievePermissions(introspectionQueryContext, msGrantsHolder, dBTransaction, sqlQuery2, !bl4 ? object : null);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveCollationsInner$lambda$11$lambda$10$lambda$9(ModNamingFamily $collations, MsIntroQueries.OneCollation collation) {
            Intrinsics.checkNotNullParameter((Object)collation, (String)"collation");
            String collationName = collation.name;
            if (collationName != null) {
                ((MsCollation)$collations.createOrGet(collationName)).setDescription(collation.description);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveCollationsInner$lambda$11(MsServerObjectsRetriever this$0, MsIntrospector this$1, MsRoot root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            ModFamily $this$modifyAndCleanup_u24default$iv = root.getCollations();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily collations = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.myQueries.getRetrieveCollations(), 0, arg_0 -> MsServerObjectsRetriever.retrieveCollationsInner$lambda$11$lambda$10$lambda$9(collations, arg_0), 2, null);
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveLinkedServersInner$lambda$16$lambda$15$lambda$14(ModNamingFamily $linkedServers, MsIntroQueries.OneLinkedServer ls) {
            Intrinsics.checkNotNullParameter((Object)ls, (String)"ls");
            String string = ls.srv_name;
            if (string == null) {
                return Unit.INSTANCE;
            }
            String srvName = string;
            Object e = $linkedServers.createOrGet(srvName);
            MsLinkedServer $this$retrieveLinkedServersInner_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413 = (MsLinkedServer)e;
            boolean bl = false;
            $this$retrieveLinkedServersInner_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setProviderName(ls.srv_providername);
            $this$retrieveLinkedServersInner_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setProduct(ls.srv_product);
            $this$retrieveLinkedServersInner_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setDataSource(ls.srv_datasource);
            $this$retrieveLinkedServersInner_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setProviderString(ls.srv_providerstring);
            $this$retrieveLinkedServersInner_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setLocation(ls.srv_location);
            $this$retrieveLinkedServersInner_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setCatalog(ls.srv_cat);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveLinkedServersInner$lambda$16(MsServerObjectsRetriever this$0, MsIntrospector this$1, MsRoot root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            ModFamily $this$modifyAndCleanup_u24default$iv = root.getLinkedServers();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily linkedServers = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.myQueries.getRetrieveLinkedServers(), 0, arg_0 -> MsServerObjectsRetriever.retrieveLinkedServersInner$lambda$16$lambda$15$lambda$14(linkedServers, arg_0), 2, null);
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }
    }
}

