/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.mongo.types.MongoArrayType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J&\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/mongo/types/MongoTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "<init>", "()V", "doCreateArrayType", "Lcom/intellij/database/dialects/mongo/types/MongoArrayType;", "componentType", "Lcom/intellij/database/types/DasType;", "getDasType", "ref", "Lcom/intellij/sql/psi/SqlReference;", "resolved", "Lcom/intellij/psi/PsiElement;", "symbol", "Lcom/intellij/database/symbols/DasSymbol;", "intellij.database.dialects.mongo"})
public final class MongoTypeSystem
extends DasTypeSystemImpl {
    public MongoTypeSystem() {
        Dbms dbms = Dbms.MONGO;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"MONGO");
        super(dbms);
    }

    @Override
    @NotNull
    protected MongoArrayType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new MongoArrayType(componentType);
    }

    @Override
    @NotNull
    public DasType getDasType(@Nullable SqlReference ref2, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        if (symbol == null) {
            return super.getDasType(ref2, resolved, null);
        }
        ObjectKind objectKind = symbol.getKind();
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLUMN)) {
            DasObject obj2 = symbol.getDasObject();
            DasObject dasObject = obj2;
            if (dasObject == null || (dasObject = dasObject.getDasParent()) == null) {
                return super.getDasType(ref2, resolved, symbol);
            }
            DasObject table = dasObject;
            JBIterable jBIterable = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable allColumns = jBIterable;
            String prefix = symbol.getName() + ".";
            JBIterable jBIterable2 = allColumns.filter(arg_0 -> MongoTypeSystem.getDasType$lambda$1(arg_0 -> MongoTypeSystem.getDasType$lambda$0(prefix, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
            JBIterable children2 = jBIterable2;
            if (!children2.isEmpty()) {
                SqlTableType sqlTableType = SqlImplUtil.createTableTypeWithColumns(this.getSqlDialect(), (JBIterable<DasColumn>)children2, resolved, symbol);
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createTableTypeWithColumns(...)");
                return sqlTableType;
            }
            if (obj2 instanceof DasColumn && !(obj2 instanceof SqlTypedDefinition)) {
                DasType dasType = ((DasColumn)obj2).getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                return dasType;
            }
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
            DasTable table = (DasTable)((Object)symbol);
            JBIterable jBIterable = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable columns = jBIterable;
            SqlTableType sqlTableType = SqlImplUtil.createTableTypeWithColumns(this.getSqlDialect(), (JBIterable<DasColumn>)columns, resolved, symbol);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createTableTypeWithColumns(...)");
            return sqlTableType;
        }
        return super.getDasType(ref2, resolved, symbol);
    }

    private static final boolean getDasType$lambda$0(String $prefix, DasColumn col) {
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        String string = col.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)$prefix, (boolean)false, (int)2, null);
    }

    private static final boolean getDasType$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

