/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.datagrid.HookUpHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.MongoJSCodeFragment;
import com.intellij.sql.dialects.mongo.js.MongoJSFile;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSCallExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSExpressionStatement;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSReferenceExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J6\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0017\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0018\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0019\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J6\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J>\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/mongo/MongoHookUpHelper;", "Lcom/intellij/database/datagrid/HookUpHelper;", "<init>", "()V", "getFilterSortLanguage", "Lcom/intellij/database/script/MongoJSLanguage;", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "isFilterApplicable", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "getFilterPrefix", "", "table", "Lcom/intellij/database/model/DasObject;", "getFilterEmptyText", "createFilterCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "project", "Lcom/intellij/openapi/project/Project;", "filterText", "queryText", "isSortingApplicable", "getSortingPrefix", "getSortingEmptyText", "createSortingCodeFragment", "sortingText", "createCodeFragment", "text", "codeFragmentType", "Lcom/intellij/sql/dialects/mongo/js/MongoJSCodeFragment$Companion$CodeFragmentType;", "intellij.database.dialects.mongo"})
public final class MongoHookUpHelper
implements HookUpHelper {
    @Override
    @NotNull
    public MongoJSLanguage getFilterSortLanguage(@NotNull DbDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return MongoJSLanguage.INSTANCE;
    }

    @Override
    public boolean isFilterApplicable(@Nullable ObjectKind kind) {
        return true;
    }

    @Override
    @NotNull
    public String getFilterPrefix(@Nullable DasObject table) {
        return "find";
    }

    @Override
    @NotNull
    public String getFilterEmptyText(@Nullable DasObject table) {
        return "{}";
    }

    @Override
    @Nullable
    public PsiCodeFragment createFilterCodeFragment(@NotNull Project project, @NotNull String filterText, @Nullable String queryText, @NotNull DbDataSource dataSource, @Nullable DasObject table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filterText, (String)"filterText");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return this.createCodeFragment(project, filterText, queryText, dataSource, table, MongoJSCodeFragment.Companion.CodeFragmentType.FILTER);
    }

    @Override
    public boolean isSortingApplicable(@Nullable ObjectKind kind) {
        return true;
    }

    @Override
    @NotNull
    public String getSortingPrefix(@Nullable DasObject table) {
        return "sort";
    }

    @Override
    @NotNull
    public String getSortingEmptyText(@Nullable DasObject table) {
        return "{}";
    }

    @Override
    @Nullable
    public PsiCodeFragment createSortingCodeFragment(@NotNull Project project, @NotNull String sortingText, @Nullable String queryText, @NotNull DbDataSource dataSource, @Nullable DasObject table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sortingText, (String)"sortingText");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return this.createCodeFragment(project, sortingText, queryText, dataSource, table, MongoJSCodeFragment.Companion.CodeFragmentType.SORT);
    }

    private final PsiCodeFragment createCodeFragment(Project project, String text2, String queryText, DbDataSource dataSource, DasObject table, MongoJSCodeFragment.Companion.CodeFragmentType codeFragmentType) {
        if (queryText == null) {
            return null;
        }
        IElementType iElementType = JSElementTypes.ARGUMENT_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"ARGUMENT_LIST");
        MongoJSCodeFragment codeFragment = MongoJSCodeFragment.Companion.create(iElementType, project, "dummy.js", text2, true, codeFragmentType);
        codeFragment.putUserData(DatabaseDataKeysCore.DATA_SOURCE_KEY, dataSource);
        SearchPath searchPath = DbImplUtilCore.getSearchPath(dataSource, table);
        codeFragment.putUserData(DatabaseDataKeysCore.SEARCH_PATH_KEY, searchPath);
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("a.js", (Language)MongoJSLanguage.INSTANCE, (CharSequence)queryText);
        file.putUserData(DatabaseDataKeysCore.DATA_SOURCE_KEY, (Object)dataSource);
        file.putUserData(DatabaseDataKeysCore.SEARCH_PATH_KEY, (Object)searchPath);
        Ref ref2 = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"create(...)");
        Ref ref3 = ref2;
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Ref<MongoJSCallExpression>)ref3){
            final /* synthetic */ Ref<MongoJSCallExpression> $ref;
            {
                this.$ref = $ref;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element;
                if (psiElement instanceof MongoJSFile || psiElement instanceof MongoJSExpressionStatement || psiElement instanceof MongoJSReferenceExpression) {
                    super.visitElement(element);
                } else if (psiElement instanceof MongoJSCallExpression) {
                    this.$ref.set((Object)element);
                    super.visitElement(element);
                }
            }
        });
        if (!ref3.isNull()) {
            codeFragment.setContext((PsiElement)ref3.get());
        }
        return codeFragment;
    }
}

