/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateLikeColumn;
import com.intellij.database.dialects.base.generator.producers.ProducerUtilsKt;
import com.intellij.database.dialects.h2.generator.producers.H2CreateSequence;
import com.intellij.database.dialects.h2.model.H2Sequence;
import com.intellij.database.dialects.h2.model.H2TableColumn;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.types.DasType;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\rH\u0014J\b\u0010\u0012\u001a\u00020\u000bH\u0014J\n\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/h2/generator/producers/H2CreateTableColumn;", "Lcom/intellij/database/dialects/base/generator/producers/CreateLikeColumn;", "Lcom/intellij/database/dialects/h2/model/H2TableColumn;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/h2/model/H2TableColumn;)V", "produceComment", "", "exists", "", "comment", "", "isConditional", "id", "Lcom/intellij/database/model/meta/BasicMetaId;", "makeComputedColumnSpecification", "isComputed", "makeColumnSpecification", "canCreateWith", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "prop", "intellij.database.dialects.h2"})
@SourceDebugExtension(value={"SMAP\nH2TableColumnProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2TableColumnProducers.kt\ncom/intellij/database/dialects/h2/generator/producers/H2CreateTableColumn\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class H2CreateTableColumn
extends CreateLikeColumn<H2TableColumn> {
    public H2CreateTableColumn(@NotNull ScriptingContext context, @NotNull H2TableColumn element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(context, (BasicLikeColumn)element);
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        ProducerUtilsKt.commentStatement$default(this, "column", comment, null, 4, null);
    }

    @Override
    public boolean isConditional(@NotNull BasicMetaId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Intrinsics.areEqual((Object)id, H2TableColumn.ON_UPDATE) || Intrinsics.areEqual((Object)id, H2TableColumn.COLUMN_KIND) || super.isConditional(id);
    }

    @Override
    @NotNull
    protected String makeComputedColumnSpecification() {
        DasType dasType = ((H2TableColumn)this.getElement()).getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        return this.script(dasType) + (String)(((H2TableColumn)this.getElement()).getSequenceRef() != null ? "" : (((H2TableColumn)this.getElement()).getColumnKind() == ColumnKind.GENERATED_VIRTUAL ? " generated always as " + ((H2TableColumn)this.getElement()).getDefault() : (((H2TableColumn)this.getElement()).getColumnKind() == ColumnKind.GENERATED_STORED ? " generated by default as " + ((H2TableColumn)this.getElement()).getDefault() : "")));
    }

    @Override
    protected boolean isComputed() {
        return super.isComputed() && ((H2TableColumn)this.getElement()).getDefaultExpression() != null;
    }

    @Override
    @Nullable
    public String makeColumnSpecification() {
        BasicReferenceInfo<? extends H2Sequence> seqInfo;
        Object spec = null;
        spec = super.makeColumnSpecification();
        if (((H2TableColumn)this.getElement()).isHidden()) {
            spec = spec + " invisible";
        }
        if ((seqInfo = ((H2TableColumn)this.getElement()).getSequenceRefInfo()) == null) {
            String string = ((H2TableColumn)this.getElement()).getOnUpdate();
            if (string != null) {
                String it = string;
                boolean bl = false;
                spec = spec + " on update " + it;
            }
            return spec;
        }
        ArrayList params = new ArrayList();
        H2Sequence h2Sequence = seqInfo.getTargetOrInlineData();
        if (h2Sequence != null) {
            H2Sequence seq = h2Sequence;
            boolean bl = false;
            H2CreateSequence sequenceGen = new H2CreateSequence(this.getContext(), seq);
            sequenceGen.gatherSequenceIdentityParameters(seq, false, params);
        }
        if (params.isEmpty() && ((H2TableColumn)this.getElement()).getColumnKind() != ColumnKind.GENERATED_VIRTUAL) {
            spec = spec + " auto_increment";
        } else {
            spec = spec + " generated " + (((H2TableColumn)this.getElement()).getColumnKind() == ColumnKind.GENERATED_VIRTUAL ? "always" : "by default") + " as identity";
            if (!((Collection)params).isEmpty()) {
                spec = spec + "(" + CollectionsKt.joinToString$default((Iterable)params, null, null, null, (int)0, null, null, (int)63, null) + ")";
            }
        }
        return spec;
    }

    @Override
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canCreateWith(@NotNull BasicMetaId prop) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        return Intrinsics.areEqual((Object)prop, BasicModTableColumn.SEQUENCE_IDENTITY) ? AbstractScriptGeneratorKt.getSUPPORTED() : super.canCreateWith(prop);
    }
}

