/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IdCache;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.greenplum.introspector.GPlumIntroQueries;
import com.intellij.database.dialects.greenplum.model.GPlumDatabase;
import com.intellij.database.dialects.greenplum.model.GPlumExternalTable;
import com.intellij.database.dialects.greenplum.model.GPlumLocalTable;
import com.intellij.database.dialects.greenplum.model.GPlumMatView;
import com.intellij.database.dialects.greenplum.model.GPlumModelHelper;
import com.intellij.database.dialects.greenplum.model.GPlumPartition;
import com.intellij.database.dialects.greenplum.model.GPlumRoot;
import com.intellij.database.dialects.greenplum.model.GPlumSchema;
import com.intellij.database.dialects.greenplum.model.GPlumTable;
import com.intellij.database.dialects.greenplum.model.GPlumTablespace;
import com.intellij.database.dialects.greenplum.model.properties.GPlumExternalTableFormat;
import com.intellij.database.dialects.greenplum.model.properties.GPlumExternalTableRejectLimitType;
import com.intellij.database.dialects.greenplum.model.properties.GPlumPartitionKind;
import com.intellij.database.dialects.greenplum.model.properties.GPlumPartitionTree;
import com.intellij.database.dialects.postgresbase.introspector.IntroGuidance;
import com.intellij.database.dialects.postgresbase.introspector.IntroModeCtx;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospector;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospectorKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntroQueries;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntrospector;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDatabase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLikeStoredTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.Scriptum;
import com.intellij.database.util.Version;
import com.intellij.util.text.StringKt;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0005*+,-.B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0010H\u0014J6\u0010\u001e\u001a \u0012\u0006\b\u0001\u0012\u00020\u00040\u001fR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0004H\u0014J4\u0010$\u001a\u001e\u0012\u0004\u0012\u00020\u00030%R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0003H\u0014J4\u0010(\u001a\u001e\u0012\u0004\u0012\u00020\u00030)R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0003H\u0014R\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006/"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoot;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;", "Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "factory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "isFifth", "", "()Z", "isSixth", "isSeventh", "queries", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries;", "generateDbAge", "", "tx", "initConnectionRelatedState", "", "isItPossibleToRetrieveCurrentXid", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "createDatabaseRetriever", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "database", "createNativeRetriever", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$NativeRetriever;", "Companion", "Factory", "MyDatabaseRetriever", "MyNativeRetriever", "MySchemaRetriever", "intellij.database.dialects.greenplum"})
public final class GPlumIntrospector
extends PgGPlumBaseIntrospector<GPlumRoot, GPlumDatabase, GPlumSchema> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final GPlumIntroQueries QUERIES;

    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        return GPlumModelHelper.INSTANCE;
    }

    public GPlumIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory factory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.GREENPLUM;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"GREENPLUM");
        super(context, nature, dbms, factory);
    }

    private final boolean isFifth() {
        int[] nArray = new int[]{5};
        return this.getServerVersion().isOrGreater(nArray);
    }

    private final boolean isSixth() {
        int[] nArray = new int[]{6};
        return this.getServerVersion().isOrGreater(nArray);
    }

    private final boolean isSeventh() {
        int[] nArray = new int[]{7};
        return this.getServerVersion().isOrGreater(nArray);
    }

    @Override
    @NotNull
    protected PgGPlumBaseIntroQueries getQueries() {
        return QUERIES;
    }

    @Override
    @NotNull
    public String generateDbAge(@NotNull String tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        return "pg_catalog.age(pg_catalog.xidin(pg_catalog.int8out(" + tx + ")))";
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), 7, new IntRange(0, 0), this.getParametersMap());
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), 6, new IntRange(0, 1), this.getParametersMap());
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), 5, new IntRange(0, 23), this.getParametersMap());
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), 4, new IntRange(0, 3), this.getParametersMap());
    }

    @Override
    protected boolean isItPossibleToRetrieveCurrentXid() {
        int[] nArray = new int[]{5};
        return this.getServerVersion().isOrGreater(nArray);
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<? extends GPlumSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull GPlumSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new MySchemaRetriever(transaction, schema);
    }

    @Override
    @NotNull
    protected PgBaseIntrospector.DatabaseRetriever<GPlumDatabase> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull GPlumDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyDatabaseRetriever(transaction, database);
    }

    @Override
    @NotNull
    protected PgBaseIntrospector.NativeRetriever<GPlumDatabase> createNativeRetriever(@NotNull DBTransaction transaction, @NotNull GPlumDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyNativeRetriever(transaction, database);
    }

    public static final /* synthetic */ List access$parseList(GPlumIntrospector $this, String str, Function1 converter) {
        return $this.parseList(str, converter);
    }

    static {
        Scriptum scriptum = Scriptum.of(GPlumIntroQueries.class);
        Intrinsics.checkNotNullExpressionValue((Object)scriptum, (String)"of(...)");
        QUERIES = new GPlumIntroQueries(scriptum);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$Companion;", "", "<init>", "()V", "QUERIES", "Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntroQueries;", "intellij.database.dialects.greenplum"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "isIncremental", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.greenplum"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        @Override
        public boolean isIncremental() {
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new GPlumIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return !(e instanceof GPlumTablespace) && PgBaseIntrospectorKt.canCheckOutdated(e);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.greenplum"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MyDatabaseRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoot;", "Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;)V", "beforeServerAndDatabaseObjectsRetrieval", "", "introspectDatabaseObjects", "detectDropped", "", "loadNew", "retrieveForeignDataWrappers", "retrieveForeignServers", "introspectUserMappings", "intellij.database.dialects.greenplum"})
    private final class MyDatabaseRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseDatabaseRetriever<GPlumDatabase> {
        public MyDatabaseRetriever(@NotNull DBTransaction transaction, GPlumDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgGPlumBaseIntrospector)GPlumIntrospector.this, transaction, (PgGPlumBaseDatabase)database);
        }

        @Override
        protected void beforeServerAndDatabaseObjectsRetrieval() {
            super.beforeServerAndDatabaseObjectsRetrieval();
            this.setQueryParameter("umenabled", this.getMySuper() && GPlumIntrospector.this.isSixth());
        }

        @Override
        protected void introspectDatabaseObjects(boolean detectDropped, boolean loadNew) {
            super.introspectDatabaseObjects(detectDropped && GPlumIntrospector.this.isFifth(), loadNew && GPlumIntrospector.this.isFifth());
        }

        @Override
        protected void retrieveForeignDataWrappers(boolean detectDropped, boolean loadNew) {
            super.retrieveForeignDataWrappers(detectDropped && GPlumIntrospector.this.isSixth(), loadNew && GPlumIntrospector.this.isSixth());
        }

        @Override
        protected void retrieveForeignServers(boolean detectDropped, boolean loadNew) {
            super.retrieveForeignServers(detectDropped && GPlumIntrospector.this.isSixth(), loadNew && GPlumIntrospector.this.isSixth());
        }

        @Override
        protected void introspectUserMappings(boolean detectDropped, boolean loadNew) {
            super.introspectUserMappings(detectDropped && GPlumIntrospector.this.isSixth(), loadNew && GPlumIntrospector.this.isSixth());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MyNativeRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseNativeRetriever;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoot;", "Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;)V", "intellij.database.dialects.greenplum"})
    private final class MyNativeRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseNativeRetriever<GPlumDatabase> {
        public MyNativeRetriever(@NotNull DBTransaction transaction, GPlumDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgGPlumBaseIntrospector)GPlumIntrospector.this, transaction, (PgGPlumBaseDatabase)database);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0014J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0014J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0014J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0014J\b\u0010\u0018\u001a\u00020\u0011H\u0014J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J \u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0014J\b\u0010\u001d\u001a\u00020\u0011H\u0014J#\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020!0 0\u001f2\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\fH\u0014J\b\u0010$\u001a\u00020\fH\u0014J\u0018\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0014J\"\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014J\b\u00100\u001a\u00020\u0011H\u0014J!\u00101\u001a\b\u0012\u0004\u0012\u000203022\f\u00104\u001a\b\u0012\u0004\u0012\u0002030\u001fH\u0014\u00a2\u0006\u0002\u00105R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MySchemaRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever;", "Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoot;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;)V", "wasExternalTables", "", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "retrieveOperatorFamilies", "", "removeUnaffected", "detectDropped", "loadNew", "retrieveOperatorClasses", "retrieveAccessMethodOperators", "retrieveAccessMethodProcedures", "analyzeBriefInfo", "retrieveDistributedColumns", "retrievePartitions", "retrieveExternalTables", "retrieveCollations", "retrieveForeignTablesInfo", "getSchemaChildrenToDrop", "", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "(Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;)[Lcom/intellij/database/model/families/ModIdentifyingFamily;", "wasDataTables", "shouldIntrospectTableRelatedDataIncremental", "processModView", "table", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "getTableOrView", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseLikeStoredTable;", "relKind", "", "tableId", "", "retrieveEnumLabels", "fixLabelsOrder", "", "", "labels", "([Ljava/lang/String;)Ljava/util/List;", "intellij.database.dialects.greenplum"})
    @SourceDebugExtension(value={"SMAP\nGPlumIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GPlumIntrospector.kt\ncom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MySchemaRetriever\n+ 2 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/IdCache\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 9 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 10 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,302:1\n519#2:303\n500#2,18:304\n519#2:348\n500#2,2:349\n503#2,15:375\n519#2:401\n500#2,2:402\n503#2,15:406\n1#3:322\n428#4,7:323\n1563#5:330\n1634#5,3:331\n1869#5:351\n1869#5,2:352\n1870#5:354\n1491#5:355\n1516#5,3:356\n1519#5,3:366\n1563#5:370\n1634#5,3:371\n336#6,4:334\n340#6:342\n198#6,5:343\n204#6,5:390\n341#6:395\n178#6,5:396\n183#6,3:421\n37#7:338\n36#7,3:339\n382#8,7:359\n216#9:369\n217#9:374\n13500#10,2:404\n*S KotlinDebug\n*F\n+ 1 GPlumIntrospector.kt\ncom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MySchemaRetriever\n*L\n163#1:303\n163#1:304,18\n188#1:348\n188#1:349,2\n188#1:375,15\n230#1:401\n230#1:402,2\n230#1:406,15\n167#1:323,7\n187#1:330\n187#1:331,3\n191#1:351\n192#1:352,2\n191#1:354\n198#1:355\n198#1:356,3\n198#1:366,3\n206#1:370\n206#1:371,3\n187#1:334,4\n187#1:342\n187#1:343,5\n187#1:390,5\n187#1:395\n229#1:396,5\n229#1:421,3\n187#1:338\n187#1:339,3\n198#1:359,7\n199#1:369\n199#1:374\n232#1:404,2\n*E\n"})
    private final class MySchemaRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseSchemaRetriever<GPlumSchema> {
        private boolean wasExternalTables;

        public MySchemaRetriever(@NotNull DBTransaction transaction, GPlumSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((PgGPlumBaseIntrospector)GPlumIntrospector.this, transaction, (PgGPlumBaseSchema)schema);
        }

        @Override
        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(super.steps(), 21, null, null, arg_0 -> MySchemaRetriever.steps$lambda$1(this, GPlumIntrospector.this, arg_0), 6, null), 22, null, null, arg_0 -> MySchemaRetriever.steps$lambda$3(this, GPlumIntrospector.this, arg_0), 6, null), 71, null, null, arg_0 -> MySchemaRetriever.steps$lambda$4(this, arg_0), 6, null);
        }

        @Override
        protected void retrieveOperatorFamilies(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            super.retrieveOperatorFamilies(removeUnaffected, detectDropped && GPlumIntrospector.this.isFifth(), loadNew && GPlumIntrospector.this.isFifth());
        }

        @Override
        protected void retrieveOperatorClasses(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            super.retrieveOperatorClasses(removeUnaffected, detectDropped && GPlumIntrospector.this.isFifth(), loadNew && GPlumIntrospector.this.isFifth());
        }

        @Override
        protected void retrieveAccessMethodOperators(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            if (GPlumIntrospector.this.isFifth()) {
                super.retrieveAccessMethodOperators(removeUnaffected, detectDropped, loadNew);
            }
        }

        @Override
        protected void retrieveAccessMethodProcedures(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            if (GPlumIntrospector.this.isFifth()) {
                super.retrieveAccessMethodProcedures(removeUnaffected, detectDropped, loadNew);
            }
        }

        @Override
        protected void analyzeBriefInfo() {
            super.analyzeBriefInfo();
            Boolean bl = this.performQuery(GPlumIntrospector.this.getQueries().isSuperUser());
            boolean isSuper = bl != null ? bl : false;
            this.setQueryParameter("SUPER", isSuper);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDistributedColumns() {
            void this_$iv;
            GPlumIntrospector.this.reportRetrieving("distribution key columns", "introspection.retrieve.distributedKey.columns");
            BaseNativeIntrospector baseNativeIntrospector = GPlumIntrospector.this;
            GPlumIntrospector gPlumIntrospector = GPlumIntrospector.this;
            boolean $i$f$continueOnDbError = false;
            void var4_4 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                this.inSchema(arg_0 -> MySchemaRetriever.retrieveDistributedColumns$lambda$9$lambda$8(this, gPlumIntrospector, arg_0));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        private final void retrievePartitions(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.PARTITION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PARTITION");
            GPlumIntrospector.this.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> MySchemaRetriever.retrievePartitions$lambda$18(GPlumIntrospector.this, detectDropped, this, loadNew, arg_0));
        }

        private final void retrieveExternalTables(boolean detectDropped, boolean loadNew) {
            GPlumIntrospector.this.reportRetrieving("external tables", "introspection.retrieve.external.tables");
            this.inSchema(arg_0 -> MySchemaRetriever.retrieveExternalTables$lambda$23(GPlumIntrospector.this, detectDropped, this, loadNew, arg_0));
        }

        @Override
        protected void retrieveCollations(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            super.retrieveCollations(removeUnaffected, detectDropped && GPlumIntrospector.this.isSixth(), loadNew && GPlumIntrospector.this.isSixth());
        }

        @Override
        protected void retrieveForeignTablesInfo() {
            if (GPlumIntrospector.this.isSixth()) {
                super.retrieveForeignTablesInfo();
            }
        }

        @Override
        @NotNull
        protected ModIdentifyingFamily<? extends BasicModIdentifiedElement>[] getSchemaChildrenToDrop(@NotNull GPlumSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Object[] objectArray = new ModNamingIdentifyingFamily[]{schema.getExternalTables()};
            return (ModIdentifyingFamily[])ArraysKt.plus((Object[])super.getSchemaChildrenToDrop((PgGPlumBaseSchema)schema), (Object[])objectArray);
        }

        @Override
        protected boolean wasDataTables() {
            return super.wasDataTables() || this.wasExternalTables;
        }

        @Override
        protected boolean shouldIntrospectTableRelatedDataIncremental() {
            return super.shouldIntrospectTableRelatedDataIncremental() || ((GPlumSchema)this.getSchema()).getExternalTables().hasChildren();
        }

        @Override
        protected void processModView(@NotNull PgBaseLikeStoredTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        }

        @Override
        @Nullable
        protected PgGPlumBaseLikeStoredTable getTableOrView(@NotNull GPlumSchema schema, char relKind, long tableId) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            PgGPlumBaseLikeStoredTable pgGPlumBaseLikeStoredTable = super.getTableOrView((PgGPlumBaseSchema)schema, relKind, tableId);
            if (pgGPlumBaseLikeStoredTable == null) {
                switch (relKind) {
                    case 'e': {
                        pgGPlumBaseLikeStoredTable = (PgGPlumBaseLikeStoredTable)schema.getExternalTables().getByObjectId(tableId);
                        break;
                    }
                    case '\u0000': {
                        GPlumMatView gPlumMatView = (GPlumMatView)schema.getMatViews().getByObjectId(tableId);
                        if (gPlumMatView != null) {
                            pgGPlumBaseLikeStoredTable = gPlumMatView;
                            break;
                        }
                        pgGPlumBaseLikeStoredTable = (PgGPlumBaseLikeStoredTable)schema.getExternalTables().getByObjectId(tableId);
                        break;
                    }
                    default: {
                        pgGPlumBaseLikeStoredTable = null;
                    }
                }
            }
            return pgGPlumBaseLikeStoredTable;
        }

        @Override
        protected void retrieveEnumLabels() {
            if (GPlumIntrospector.this.isFifth()) {
                super.retrieveEnumLabels();
            }
        }

        @Override
        @NotNull
        protected List<String> fixLabelsOrder(@NotNull String[] labels) {
            Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
            return CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])Arrays.copyOf(labels, labels.length)));
        }

        private static final Unit steps$lambda$1(MySchemaRetriever this$0, GPlumIntrospector this$1, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u241_u24lambda_u240 = $this$add.getGuidanceForOthers();
            boolean bl = false;
            this$0.retrieveExternalTables($this$steps_u24lambda_u241_u24lambda_u240.getDetectDropped() && !this$1.isSeventh(), $this$steps_u24lambda_u241_u24lambda_u240.getLoadNew() && !this$1.isSeventh());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$3(MySchemaRetriever this$0, GPlumIntrospector this$1, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u243_u24lambda_u242 = $this$add.getGuidanceForOthers();
            boolean bl = false;
            this$0.retrievePartitions($this$steps_u24lambda_u243_u24lambda_u242.getDetectDropped() && !this$1.isSeventh(), $this$steps_u24lambda_u243_u24lambda_u242.getLoadNew() && !this$1.isSeventh());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$4(MySchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            this$0.retrieveDistributedColumns();
            return Unit.INSTANCE;
        }

        private static final int retrieveDistributedColumns$lambda$9$lambda$8$lambda$7$lambda$6(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Integer.parseInt(it);
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveDistributedColumns$lambda$9$lambda$8$lambda$7(IdCache $tableCache, GPlumIntrospector this$0, GPlumSchema $schema, GPlumIntroQueries.OneDistributionKeys keys) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            var6_4 = $tableCache;
            id$iv = keys.table_id;
            $i$f$get = false;
            var10_7 = this_$iv;
            id$iv$iv = id$iv;
            $i$f$getOrCache = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull(v0);
            if (((BasicIdentifiedElement)v0).getObjectId() == id$iv$iv) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var14_10 = id$iv$iv;
                var16_11 = this_$iv$iv;
                var17_12 = this_$iv$iv;
                $i$a$-getOrCache-IdCache$get$1$iv = false;
                var19_14 = (Function1)new Function1<ModIdentifyingFamily<? extends T>, T>(id$iv){
                    final /* synthetic */ long $id;
                    {
                        this.$id = $id;
                    }

                    public final T invoke(ModIdentifyingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)((BasicModIdentifiedElement)$this$family.getByObjectId(this.$id));
                    }
                };
                $this$retrieveDistributedColumns_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u245 = $this$get_u24lambda_u240$iv;
                $i$a$-get-GPlumIntrospector$MySchemaRetriever$retrieveDistributedColumns$1$1$1$table$1 = false;
                v2 = $schema.getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                v3 = (GPlumTable)it.invoke(v2);
                if (v3 == null) {
                    v4 = $schema.getExternalTables();
                    Intrinsics.checkNotNullExpressionValue(v4, (String)"getExternalTables(...)");
                    v3 = (GPlumTable)it.invoke(v4);
                }
                var17_12.setV((BasicModIdentifiedElement)v3);
                v1 = this_$iv$iv.getV();
            }
            v5 = (GPlumTable)v1;
            if (v5 == null) {
                return Unit.INSTANCE;
            }
            table = v5;
            distKeys = GPlumIntrospector.access$parseList(this$0, keys.distribution_keys, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, retrieveDistributedColumns$lambda$9$lambda$8$lambda$7$lambda$6(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Integer;)());
            if (distKeys.isEmpty()) {
                table.setDistributedRandomly(true);
                table.setDistributionKeys(CollectionsKt.emptyList());
            } else {
                table.setDistributedRandomly(false);
                table.setDistributionKeys(distKeys);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDistributedColumns$lambda$9$lambda$8(MySchemaRetriever this$0, GPlumIntrospector this$1, GPlumSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            IdCache tableCache = new IdCache();
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, QUERIES.getRetrieveDistributionKeys(), 0, arg_0 -> MySchemaRetriever.retrieveDistributedColumns$lambda$9$lambda$8$lambda$7(tableCache, this$1, schema, arg_0), 2, null);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrievePartitions$lambda$18(GPlumIntrospector this$0, boolean $detectDropped, MySchemaRetriever this$1, boolean $loadNew, GPlumSchema schema) {
            void families$iv$iv;
            void families$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends GPlumLocalTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingIdentifyingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GPlumLocalTable gPlumLocalTable = (GPlumLocalTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPartitions());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingIdentifyingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    LongOpenHashSet ids = new LongOpenHashSet(this$1.performQuery(QUERIES.getRetrieveExistentPartitions()));
                    ModNamingIdentifyingFamily<? extends GPlumLocalTable> modNamingIdentifyingFamily2 = schema.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
                    Iterable $this$forEach$iv = modNamingIdentifyingFamily2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        GPlumLocalTable t = (GPlumLocalTable)element$iv;
                        boolean bl3 = false;
                        ModNamingIdentifyingFamily<? extends GPlumPartition> modNamingIdentifyingFamily3 = t.getPartitions();
                        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getPartitions(...)");
                        Iterable $this$forEach$iv2 = modNamingIdentifyingFamily3;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            GPlumPartition it = (GPlumPartition)element$iv2;
                            boolean bl4 = false;
                            if (!ids.contains(it.getObjectId())) continue;
                            it.resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    void $this$forEach$iv;
                    Long key$iv$iv;
                    void $this$groupByTo$iv$iv;
                    Object $this$groupBy$iv = this$1.performQuery(QUERIES.getRetrievePartitions());
                    boolean $i$f$groupBy = false;
                    Iterable $i$f$forEach = $this$groupBy$iv;
                    Map destination$iv$iv2 = new LinkedHashMap();
                    boolean $i$f$groupByTo = false;
                    for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        GPlumIntroQueries.OnePartition it = (GPlumIntroQueries.OnePartition)element$iv$iv;
                        boolean bl5 = false;
                        key$iv$iv = it.table_id;
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl6 = false;
                            List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    $this$groupBy$iv = destination$iv$iv2;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = iterator.next();
                        boolean bl7 = false;
                        long table_id = ((Number)entry.getKey()).longValue();
                        List ps = (List)entry.getValue();
                        if ((GPlumLocalTable)schema.getTables().getByObjectId(table_id) == null) continue;
                        Intrinsics.checkNotNull((Object)key$iv$iv);
                        Long table = key$iv$iv;
                        GPlumPartitionTree gPlumPartitionTree = table.getPartitionsTree();
                        if (gPlumPartitionTree == null) {
                            gPlumPartitionTree = new GPlumPartitionTree();
                        }
                        GPlumPartitionTree tree2 = gPlumPartitionTree;
                        table.setPartitionsTree(tree2);
                        for (GPlumIntroQueries.OnePartition p2 : ps) {
                            void $this$mapTo$iv$iv2;
                            void $this$map$iv2;
                            GPlumPartition partition;
                            Intrinsics.checkNotNullExpressionValue((Object)table.getPartitions().renew(p2.id, p2.name), (String)"renew(...)");
                            partition.setPartitionKind(GPlumPartitionKind.of(p2.kind));
                            Iterable iterable2 = this$0.parseListOfLongs(p2.columns);
                            GPlumPartition gPlumPartition = partition;
                            boolean $i$f$map2 = false;
                            void var41_56 = $this$map$iv2;
                            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo2 = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                void it;
                                long l = ((Number)item$iv$iv).longValue();
                                Collection collection = destination$iv$iv3;
                                boolean bl8 = false;
                                collection.add((int)it);
                            }
                            gPlumPartition.setColumns((List)destination$iv$iv3);
                            partition.setValues(StringKt.nullize((String)p2.values_list, (boolean)true));
                            partition.setStartValue(StringKt.nullize((String)p2.start_value, (boolean)true));
                            partition.setEndValue(StringKt.nullize((String)p2.end_value, (boolean)true));
                            partition.setEveryValue(StringKt.nullize((String)p2.every_value, (boolean)true));
                            partition.setStartInclusive(p2.start_inclusive);
                            partition.setEndInclusive(p2.end_inclusive);
                            partition.setDefaultPartition(p2.is_default);
                            partition.setOrder(p2.order);
                            partition.setLevel(p2.level);
                            tree2.addEdge(p2.parent_id, p2.id);
                        }
                    }
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl9 = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveExternalTables$lambda$23$lambda$22$lambda$21$lambda$20(MySchemaRetriever this$0, GPlumSchema $schema, GPlumIntroQueries.OneExternalTable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            this$0.wasExternalTables = true;
            GPlumExternalTable gPlumExternalTable = $schema.getExternalTables().renew(t.id, t.name);
            Intrinsics.checkNotNullExpressionValue((Object)gPlumExternalTable, (String)"renew(...)");
            GPlumExternalTable table = gPlumExternalTable;
            table.setStateNumber(t.state_number);
            table.setWritable(t.writable);
            table.setLocations(ArraysKt.toList((Object[])t.locations));
            table.setCommand(t.command);
            table.setExecLocation(t.exec_location);
            table.setFormat(GPlumExternalTableFormat.of(t.format));
            String string = t.format_options;
            table.setFormatOptions(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null);
            table.setEncoding(t.encoding);
            table.setRejectLimit(t.reject_limit);
            table.setRejectLimitType(GPlumExternalTableRejectLimitType.of(t.reject_limit_type));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveExternalTables$lambda$23(GPlumIntrospector this$0, boolean $detectDropped, MySchemaRetriever this$1, boolean $loadNew, GPlumSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModFamily $this$modifyAndCleanup_u24default$iv = schema.getExternalTables();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = this$1.performQuery(QUERIES.getRetrieveExistentExternalTables());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it2 = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        GPlumExternalTable gPlumExternalTable = (GPlumExternalTable)schema.getExternalTables().getByObjectId(it2);
                        if (gPlumExternalTable != null) {
                            ((BasicModMixinElement)gPlumExternalTable).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$1, QUERIES.getRetrieveExternalTables(), 0, arg_0 -> MySchemaRetriever.retrieveExternalTables$lambda$23$lambda$22$lambda$21$lambda$20(this$1, schema, arg_0), 2, null);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }
    }
}

