/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.model;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.exasol.model.ExaIndex;
import com.intellij.database.dialects.exasol.model.ExaScript;
import com.intellij.database.dialects.exasol.model.ExaUser;
import com.intellij.database.dialects.exasol.model.ExaVirtualSchema;
import com.intellij.database.dialects.exasol.model.properties.ExaScriptType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J4\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J4\u0010\u001e\u001a\u00020\u0018\"\b\b\u0000\u0010\u001f*\u00020 2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u00162\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001f0#0\"H\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/exasol/model/ExaModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "<init>", "()V", "getCustomName", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/Nullable;", "kind", "Lcom/intellij/database/model/ObjectKind;", "plural", "", "getIcon", "Ljavax/swing/Icon;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "getVariant", "c", "Lcom/intellij/database/model/DasObject;", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "vars", "", "modifyParent", "reorderProperties", "E", "Lcom/intellij/database/model/basic/BasicElement;", "fields", "", "Lcom/intellij/database/model/meta/BasicMetaField;", "Companion", "intellij.database.dialects.exasol"})
@SourceDebugExtension(value={"SMAP\nExaModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExaModelHelper.kt\ncom/intellij/database/dialects/exasol/model/ExaModelHelper\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,104:1\n18#2:105\n18#2:106\n*S KotlinDebug\n*F\n+ 1 ExaModelHelper.kt\ncom/intellij/database/dialects/exasol/model/ExaModelHelper\n*L\n36#1:105\n37#1:106\n*E\n"})
public final class ExaModelHelper
extends ModelHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ModelHelper.ObjectKindVariant SCRIPTING_SCRIPT = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer("ObjectKindVariant.scripting.script", new Object[0]));
    @NotNull
    private static final ModelHelper.ObjectKindVariant UDF_SCRIPT = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer("ObjectKindVariant.udf.script", new Object[0]));
    @NotNull
    private static final ModelHelper.ObjectKindVariant ADAPTER_SCRIPT = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer("ObjectKindVariant.adapter.script", new Object[0]));

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getCustomName(@NotNull ObjectKind kind, boolean plural) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.EXTERNAL_SCHEMA)) {
            int _true_$iv;
            void $this$choose$iv;
            Object[] objectArray = new Object[1];
            boolean bl = plural;
            int n = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv != false ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message("CustomObjectKind.virtual.schema", objectArray);
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE)) {
            Object[] objectArray = new Object[1];
            boolean $this$choose$iv = plural;
            int _true_$iv = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message("CustomObjectKind.table", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull ObjectKind kind, @NotNull ModelHelper.ObjectKindVariant variant) {
        ModelHelper.ObjectKindVariant objectKindVariant;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.SCRIPT) ? (Intrinsics.areEqual((Object)(objectKindVariant = variant), (Object)ADAPTER_SCRIPT) ? DatabaseIcons.Adapter_script : (Intrinsics.areEqual((Object)objectKindVariant, (Object)SCRIPTING_SCRIPT) ? DatabaseIcons.Scripting_script : DatabaseIcons.Udf_script)) : super.getIcon(kind, variant);
    }

    @Override
    @NotNull
    public ModelHelper.ObjectKindVariant getVariant(@NotNull DasObject c2) {
        ModelHelper.ObjectKindVariant objectKindVariant;
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        ExaScript exaScript = c2 instanceof ExaScript ? (ExaScript)c2 : null;
        ExaScriptType exaScriptType = exaScript != null ? exaScript.getScriptType() : null;
        switch (exaScriptType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[exaScriptType.ordinal()]) {
            case 1: {
                objectKindVariant = UDF_SCRIPT;
                break;
            }
            case 2: {
                objectKindVariant = ADAPTER_SCRIPT;
                break;
            }
            case 3: {
                objectKindVariant = SCRIPTING_SCRIPT;
                break;
            }
            default: {
                ModelHelper.ObjectKindVariant objectKindVariant2 = super.getVariant(c2);
                objectKindVariant = objectKindVariant2;
                Intrinsics.checkNotNullExpressionValue((Object)objectKindVariant2, (String)"getVariant(...)");
            }
        }
        return objectKindVariant;
    }

    @Override
    @NotNull
    public JBIterable<ModelHelper.ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        ObjectKind objectKind = meta.kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
            JBIterable jBIterable2 = JBIterable.of((Object)ModelHelper.FUNCTION);
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCRIPT)) {
            Object[] objectArray = new ModelHelper.ObjectKindVariant[]{SCRIPTING_SCRIPT, UDF_SCRIPT, ADAPTER_SCRIPT};
            JBIterable jBIterable3 = JBIterable.of((Object[])objectArray);
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"of(...)");
        } else {
            JBIterable jBIterable4 = super.generationVariants(meta);
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue(jBIterable4, (String)"generationVariants(...)");
        }
        return jBIterable;
    }

    @Override
    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars, modifyParent);
        if (e instanceof ExaUser) {
            ((ExaUser)e).setPassword(new OneTimeString(""));
            vars.put("password", "\"\"");
        }
        if (e instanceof ExaScript) {
            ModelHelper.ObjectKindVariant objectKindVariant = variant;
            if (Intrinsics.areEqual((Object)objectKindVariant, (Object)ADAPTER_SCRIPT)) {
                ((ExaScript)e).setScriptType(ExaScriptType.ADAPTER);
            } else if (Intrinsics.areEqual((Object)objectKindVariant, (Object)UDF_SCRIPT)) {
                ((ExaScript)e).setScriptType(ExaScriptType.UDF);
                BasicModArgument basicModArgument = ((ExaScript)e).createOrGetReturnArgument();
                DataType dataType = DataTypeFactory.of("varchar");
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                basicModArgument.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                vars.put("scalar", "scalar");
                vars.put("return", "varchar");
            } else {
                ((ExaScript)e).setScriptType(ExaScriptType.SCRIPTING);
                vars.put("args", "arg1");
                vars.put("return", "table");
            }
        }
        if (e instanceof ExaVirtualSchema) {
            ((ExaVirtualSchema)e).setAdapterRef(BasicParentReference.create("MY_SCHEMA", BasicNameReference.create("MY_ADAPTER")));
            vars.put("adapter", "MY_SCHEMA.MY_ADAPTER");
        }
    }

    @Override
    public <E extends BasicElement> void reorderProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super.reorderProperties(meta, fields);
        if (meta.kindOf(ExaIndex.class)) {
            ModelHelper.moveTo(fields, 0, (BasicMetaId)ExaIndex.GLOBAL);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/exasol/model/ExaModelHelper$Companion;", "", "<init>", "()V", "SCRIPTING_SCRIPT", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "UDF_SCRIPT", "ADAPTER_SCRIPT", "intellij.database.dialects.exasol"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExaScriptType.values().length];
            try {
                nArray[ExaScriptType.UDF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExaScriptType.ADAPTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExaScriptType.SCRIPTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

