/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.dynamo.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.AlterUnknown;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.dynamo.DynamoDbms;
import com.intellij.database.dialects.dynamo.generator.producers.DynamoCreateIndex;
import com.intellij.database.dialects.dynamo.generator.producers.DynamoCreateTable;
import com.intellij.database.dialects.dynamo.generator.producers.DynamoDropTable;
import com.intellij.database.dialects.dynamo.model.DynamoIndex;
import com.intellij.database.dialects.dynamo.model.DynamoTable;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.basic.BasicElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/dynamo/generator/DynamoScriptGeneratorHelper;", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "<init>", "()V", "createProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createDropProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "createAlterProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducerBase;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "intellij.database.dialects.dynamo"})
public final class DynamoScriptGeneratorHelper
extends ScriptGeneratorHelper {
    public DynamoScriptGeneratorHelper() {
        Dbms dbms = DynamoDbms.DYNAMO;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"DYNAMO");
        super(dbms);
    }

    @Override
    @NotNull
    public CreateProducer<?> createProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof DynamoTable ? (CreateProducer)new DynamoCreateTable(context, (DynamoTable)element) : (basicElement instanceof DynamoIndex ? (CreateProducer)new DynamoCreateIndex(context, (DynamoIndex)element) : super.createProducerImpl(context, element));
    }

    @Override
    @NotNull
    public DropProducer<?> createDropProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof DynamoTable ? (DropProducer)new DynamoDropTable(context, (DynamoTable)element) : super.createDropProducerImpl(context, element);
    }

    @Override
    @NotNull
    public AlterProducerBase<?> createAlterProducerImpl(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return new AlterUnknown(context, elements);
    }
}

