/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.dynamo;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.base.BaseGridHelper;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J8\u0010\u000f\u001a\u00020\u00102\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J8\u0010\u0011\u001a\u00020\u00102\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/dynamo/DynamoGridHelper;", "Lcom/intellij/database/dialects/base/BaseGridHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getCellLanguage", "Lcom/intellij/lang/Language;", "grid", "Lcom/intellij/database/datagrid/CoreGrid;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "column", "isObjectCell", "", "isArrayCell", "intellij.database.dialects.dynamo"})
public final class DynamoGridHelper
extends BaseGridHelper {
    public DynamoGridHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @Nullable
    public Language getCellLanguage(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return this.isArrayCell(grid, row, column2) || this.isObjectCell(grid, row, column2) ? (Language)MongoJSLanguage.INSTANCE : null;
    }

    private final boolean isObjectCell(CoreGrid<GridRow, GridColumn> grid, ModelIndex<GridRow> row, ModelIndex<GridColumn> column2) {
        return StringUtil.equalsIgnoreCase((CharSequence)GridCellEditorsUtil.guessTypeNameForEditing(grid, row, column2), (CharSequence)"M");
    }

    private final boolean isArrayCell(CoreGrid<GridRow, GridColumn> grid, ModelIndex<GridRow> row, ModelIndex<GridColumn> column2) {
        return StringUtil.equalsIgnoreCase((CharSequence)GridCellEditorsUtil.guessTypeNameForEditing(grid, row, column2), (CharSequence)"L");
    }
}

