/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.sql.dialects.BuiltinFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/db2/types/Db2TypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getNormalizedTypeName", "", "name", "getDefaultTypeName", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "getTypeCategoryByName", "typeName", "supportsAsteriskArgument", "", "definition", "Lcom/intellij/sql/dialects/BuiltinFunction;", "intellij.database.dialects.db2"})
public final class Db2TypeSystem
extends DasTypeSystemImpl {
    public Db2TypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return switch (super.getNormalizedTypeName(name2)) {
            case "INT" -> "INTEGER";
            case "DEC" -> "DECIMAL";
            case "NUMERIC" -> "DECIMAL";
            case "NUM" -> "DECIMAL";
            case "FLOAT" -> "DOUBLE";
            case "DOUBLE PRECISION" -> "DOUBLE";
            case "CHARACTER" -> "CHAR";
            case "CHAR LARGE OBJECT" -> "CLOB";
            case "CHARACTER LARGE OBJECT" -> "CLOB";
            case "CHAR VARYING" -> "VARCHAR";
            case "CHARACTER VARYING" -> "VARCHAR";
            case "NCHAR" -> "GRAPHIC";
            case "NATIONAL CHAR" -> "GRAPHIC";
            case "NATIONAL CHARACTER" -> "GRAPHIC";
            case "NVARCHAR" -> "VARGRAPHIC";
            case "NATIONAL CHAR VARYING" -> "VARGRAPHIC";
            case "NATIONAL CHARACTER VARYING" -> "VARGRAPHIC";
            case "NCLOB" -> "DBCLOB";
            case "BINARY LARGE OBJECT" -> "BLOB";
            default -> {
                void var2_2;
                yield var2_2;
            }
        };
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)((Object)cat), (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "int";
            case 2 -> "decimal";
            case 3 -> "varchar";
            case 4 -> "boolean";
            case 5 -> "date";
            case 6 -> "date";
            case 7 -> "time";
            case 8 -> "timestamp";
            case 9 -> "int";
            case 10 -> "blob";
            default -> null;
        };
    }

    @Override
    @NotNull
    public DasTypeCategory getTypeCategoryByName(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return switch (typeName) {
            case "GRAPHIC" -> DasTypeCategory.STRING;
            case "VARGRAPHIC" -> DasTypeCategory.STRING;
            case "DBCLOB" -> DasTypeCategory.STRING;
            default -> super.getTypeCategoryByName(typeName);
        };
    }

    @Override
    protected boolean supportsAsteriskArgument(@NotNull BuiltinFunction definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        return StringsKt.equals((String)definition.getName(), (String)"count_big", (boolean)true) || super.supportsAsteriskArgument(definition);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIMESTAMP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTERVAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

