/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntroQueries;
import com.intellij.database.dialects.clickhouse.generator.CHouseNamingService;
import com.intellij.database.dialects.clickhouse.model.CHouseLikeTable;
import com.intellij.database.dialects.clickhouse.model.CHouseSchema;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.RowLayout;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.util.Version;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005#$%&'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ*\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eJ*\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eJ\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J*\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u000eJ\"\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\n0\u000eJ\"\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\n0\u000eJ\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\"\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\n0\u000eJ\u0016\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020!J\f\u0010\"\u001a\u00020\u0006*\u00020\fH\u0002J\f\u0010\"\u001a\u00020\u0006*\u00020!H\u0002\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries;", "Lcom/intellij/database/dialects/base/introspector/BaseIntroQueries;", "<init>", "()V", "retrieveSchemas", "", "", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "processTables", "", "sc", "Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;", "action", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$TableInfo;", "processMatViewEngines", "hasUuid", "", "Lcom/intellij/database/util/Version;", "processColumns", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$ColumnInfo;", "processFunctions", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$FunctionInfo;", "processUsers", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$UserInfo;", "tableIsInaccessible", "th", "Lcom/intellij/database/remote/jdba/exceptions/DBException;", "processRoles", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$RoleInfo;", "retrieveTableSource", "tab", "Lcom/intellij/database/dialects/clickhouse/model/CHouseLikeTable;", "fqName", "TableInfo", "ColumnInfo", "FunctionInfo", "UserInfo", "RoleInfo", "intellij.database.dialects.clickhouse"})
@SourceDebugExtension(value={"SMAP\nCHouseIntroQueries.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CHouseIntroQueries.kt\ncom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries\n+ 2 BaseIntroQueries.kt\ncom/intellij/database/dialects/base/introspector/BaseIntroQueries\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n55#2,3:122\n24#2,2:125\n43#2:127\n24#2,2:128\n44#2:130\n43#2:131\n24#2,2:132\n44#2:134\n43#2:135\n24#2,2:136\n44#2:138\n43#2:139\n24#2,2:140\n44#2:142\n52#2:143\n24#2,2:144\n53#2:146\n52#2:148\n24#2,2:149\n53#2:151\n62#2,3:152\n1#3:147\n*S KotlinDebug\n*F\n+ 1 CHouseIntroQueries.kt\ncom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries\n*L\n16#1:122,3\n16#1:125,2\n36#1:127\n36#1:128,2\n36#1:130\n48#1:131\n48#1:132,2\n48#1:134\n68#1:135\n68#1:136,2\n68#1:138\n81#1:139\n81#1:140,2\n81#1:142\n96#1:143\n96#1:144,2\n96#1:146\n112#1:148\n112#1:149,2\n112#1:151\n116#1:152,3\n*E\n"})
public final class CHouseIntroQueries
extends BaseIntroQueries {
    @NotNull
    public static final CHouseIntroQueries INSTANCE = new CHouseIntroQueries();

    private CHouseIntroQueries() {
        super(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> retrieveSchemas(@NotNull DBTransaction transaction) {
        void $receiver$iv;
        void $this$iv$iv;
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String query$iv = "select name from system.databases order by name != currentDatabase()";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        void var7_7 = $this$iv;
        String query$iv$iv = query$iv;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        return (List)BaseIntroQueries.access$retrieve((BaseIntroQueries)$this$iv, new SqlQuery(query$iv$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)$this$iv$iv, String.class, expandMaps$iv$iv))), (DBTransaction)$receiver$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTables(@NotNull DBTransaction transaction, @NotNull CHouseSchema sc, @NotNull Function1<? super TableInfo, Unit> action) {
        void action$iv;
        void parameters$iv;
        void $this$processList$iv;
        void $this$iv$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Object object = sc.getRoot();
        if (object == null || (object = object.getServerVersion()) == null) {
            object = Version.ZERO;
        }
        Object ver = object;
        Intrinsics.checkNotNull((Object)ver);
        boolean hasUuid = this.hasUuid((Version)ver);
        int[] nArray = new int[]{21, 6};
        boolean hasComments = ((Version)ver).isOrGreater(nArray);
        Object object2 = new int[]{1, 1, 54356};
        boolean hasTemp = ((Version)ver).isOrGreater((int)object2);
        object2 = this;
        DBTransaction dBTransaction = transaction;
        String string = "select " + (hasUuid ? "" : "null ") + "uuid, name, engine,\n          " + (hasTemp ? "" : "0 ") + "is_temporary,\n          " + (hasComments ? "" : "null ") + "comment\n        from system.tables t\n        where t.database = ?\n        ";
        String[] stringArray = new String[]{sc.getName()};
        Function1<? super TableInfo, Unit> function1 = action;
        boolean $i$f$processList = false;
        void var14_15 = this_$iv;
        void query$iv$iv = query$iv;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)$this$iv$iv, TableInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, (Function1)action$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processMatViewEngines(@NotNull DBTransaction transaction, @NotNull CHouseSchema sc, @NotNull Function1<? super TableInfo, Unit> action) {
        void action$iv;
        void parameters$iv;
        void $this$processList$iv;
        void $this$iv$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Object object = sc.getRoot();
        if (object == null || (object = object.getServerVersion()) == null) {
            object = Version.ZERO;
        }
        Object ver = object;
        Intrinsics.checkNotNull((Object)ver);
        boolean hasUuid = this.hasUuid((Version)ver);
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "select " + (hasUuid ? "if(startsWith(t.name, '.inner_id.'), substring(t.name, 11), null)" : "null") + " uuid, if(startsWith(t.name, '.inner.'), substring(t.name, 8), null) name, engine\n        from system.tables t\n        where (t.name like '.inner.%' or t.name like '.inner\\\\_id.%') and t.database = ?\n        ";
        String[] stringArray = new String[]{sc.getName()};
        Function1<? super TableInfo, Unit> function1 = action;
        boolean $i$f$processList = false;
        void var12_12 = this_$iv;
        void query$iv$iv = query$iv;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)$this$iv$iv, TableInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, (Function1)action$iv);
    }

    private final boolean hasUuid(Version $this$hasUuid) {
        int[] nArray = new int[]{20, 4};
        return $this$hasUuid.isOrGreater(nArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void processColumns(@NotNull DBTransaction transaction, @NotNull CHouseSchema sc, @NotNull Function1<? super ColumnInfo, Unit> action) {
        void action$iv;
        void parameters$iv;
        void $this$processList$iv;
        void $this$iv$iv;
        void query$iv;
        void this_$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Object object2 = sc.getRoot();
        boolean hasComments = !(object2 != null && (object2 = object2.getServerVersion()) != null ? !((Version)object2).isOrGreater((int)(object = new int[]{18, 16})) : false);
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        object = "select table, name, type, " + (hasComments ? "" : "null ") + "comment, default_kind, default_expression\n            from system.columns\n            where name not like '.inner.%' and name not like '.inner\\\\_id.%' and database = ?\n            ";
        String[] stringArray = new String[]{sc.getName()};
        Function1<? super ColumnInfo, Unit> function1 = action;
        boolean $i$f$processList = false;
        void var11_11 = this_$iv;
        void query$iv$iv = query$iv;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)$this$iv$iv, ColumnInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, (Function1)action$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processFunctions(@NotNull DBTransaction transaction, @NotNull Function1<? super FunctionInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void $this$iv$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "select name, is_aggregate from system.functions";
        Object var6_6 = null;
        Function1<? super FunctionInfo, Unit> action$iv = action;
        boolean $i$f$processList = false;
        void var9_9 = this_$iv;
        void query$iv$iv = query$iv;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)$this$iv$iv, FunctionInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processUsers(@NotNull DBTransaction transaction, @NotNull Function1<? super UserInfo, Unit> action) {
        void action$iv;
        void queryExtraHandler$iv;
        void exceptionHandler$iv;
        void parameters$iv;
        void $this$processList$iv;
        void $this$iv$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "select name, auth_type,\n         host_ip, host_names, host_names_regexp, host_names_like,\n         default_roles_all, default_roles_list, default_roles_except\n    from system.users";
        Object var6_6 = null;
        Function1 function1 = CHouseIntroQueries::processUsers$lambda$0;
        Object var8_8 = null;
        Function1<? super UserInfo, Unit> function12 = action;
        boolean $i$f$processList = false;
        void var11_11 = this_$iv;
        void query$iv$iv = query$iv;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)$this$iv$iv, UserInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, (Function1)exceptionHandler$iv, (Function1)queryExtraHandler$iv, (Function1)action$iv);
    }

    private final boolean tableIsInaccessible(DBException th) {
        boolean bl;
        if (th.vendorErrorCode == 497) {
            return true;
        }
        String string = th.getMessage();
        if (string != null) {
            String $this$tableIsInaccessible_u24lambda_u241 = string;
            boolean bl2 = false;
            bl = StringsKt.contains$default((CharSequence)$this$tableIsInaccessible_u24lambda_u241, (CharSequence)" doesn't exist", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$tableIsInaccessible_u24lambda_u241, (CharSequence)"SHOW USERS", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$tableIsInaccessible_u24lambda_u241, (CharSequence)"SHOW ROLES", (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoles(@NotNull DBTransaction transaction, @NotNull Function1<? super RoleInfo, Unit> action) {
        void action$iv;
        void queryExtraHandler$iv;
        void exceptionHandler$iv;
        void parameters$iv;
        void $this$processList$iv;
        void $this$iv$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "select name from system.roles";
        Object var6_6 = null;
        Function1 function1 = CHouseIntroQueries::processRoles$lambda$2;
        Object var8_8 = null;
        Function1<? super RoleInfo, Unit> function12 = action;
        boolean $i$f$processList = false;
        void var11_11 = this_$iv;
        void query$iv$iv = query$iv;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)$this$iv$iv, RoleInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, (Function1)exceptionHandler$iv, (Function1)queryExtraHandler$iv, (Function1)action$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String retrieveTableSource(@NotNull DBTransaction transaction, @NotNull CHouseLikeTable tab) {
        void $receiver$iv;
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String query$iv = "show create table " + this.fqName(tab);
        Object[] parameters$iv = null;
        boolean $i$f$retrieveOne = false;
        return (String)BaseIntroQueries.access$retrieveOne((BaseIntroQueries)$this$iv, (DBTransaction)$receiver$iv, String.class, query$iv, parameters$iv);
    }

    private final String fqName(CHouseSchema $this$fqName) {
        String string = $this$fqName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return CHouseNamingService.INSTANCE.enquote(string, $this$fqName.getKind());
    }

    private final String fqName(CHouseLikeTable $this$fqName) {
        BasicSchema basicSchema = $this$fqName.getSchema();
        Intrinsics.checkNotNull((Object)basicSchema, (String)"null cannot be cast to non-null type com.intellij.database.dialects.clickhouse.model.CHouseSchema");
        String string = this.fqName((CHouseSchema)basicSchema);
        String string2 = $this$fqName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return string + "." + CHouseNamingService.INSTANCE.enquote(string2, $this$fqName.getKind());
    }

    private static final boolean processUsers$lambda$0(DBException it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return INSTANCE.tableIsInaccessible(it);
    }

    private static final boolean processRoles$lambda$2(DBException it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return INSTANCE.tableIsInaccessible(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$ColumnInfo;", "", "<init>", "()V", "table", "", "name", "type", "comment", "default_kind", "default_expression", "intellij.database.dialects.clickhouse"})
    public static final class ColumnInfo {
        @JvmField
        @NotNull
        public String table = "";
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @NotNull
        public String type = "";
        @JvmField
        @NotNull
        public String comment = "";
        @JvmField
        @Nullable
        public String default_kind;
        @JvmField
        @Nullable
        public String default_expression;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$FunctionInfo;", "", "<init>", "()V", "name", "", "is_aggregate", "", "Ljava/lang/Boolean;", "intellij.database.dialects.clickhouse"})
    public static final class FunctionInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public Boolean is_aggregate;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$RoleInfo;", "", "<init>", "()V", "name", "", "intellij.database.dialects.clickhouse"})
    public static final class RoleInfo {
        @JvmField
        @NotNull
        public String name = "";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$TableInfo;", "", "<init>", "()V", "uuid", "", "name", "engine", "is_temporary", "", "comment", "intellij.database.dialects.clickhouse"})
    public static final class TableInfo {
        @JvmField
        @NotNull
        public String uuid = "";
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String engine;
        @JvmField
        public boolean is_temporary;
        @JvmField
        @Nullable
        public String comment;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$UserInfo;", "", "<init>", "()V", "name", "", "auth_type", "host_ip", "", "[Ljava/lang/String;", "host_names", "host_names_regexp", "host_names_like", "default_roles_all", "", "default_roles_list", "default_roles_except", "intellij.database.dialects.clickhouse"})
    public static final class UserInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @NotNull
        public String auth_type = "";
        @JvmField
        @NotNull
        public String[] host_ip = new String[0];
        @JvmField
        @NotNull
        public String[] host_names = new String[0];
        @JvmField
        @NotNull
        public String[] host_names_regexp = new String[0];
        @JvmField
        @NotNull
        public String[] host_names_like = new String[0];
        @JvmField
        public boolean default_roles_all;
        @JvmField
        @NotNull
        public String[] default_roles_list = new String[0];
        @JvmField
        @NotNull
        public String[] default_roles_except = new String[0];
    }
}

