/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospectorHelper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntroQueries;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospectionException;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospector;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospector$BigQuerySchemaRetriever$retrieveTableAndViewColumns$;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospectorKt;
import com.intellij.database.dialects.bigquery.model.BigQueryArgument;
import com.intellij.database.dialects.bigquery.model.BigQueryDatabase;
import com.intellij.database.dialects.bigquery.model.BigQueryLikeColumn;
import com.intellij.database.dialects.bigquery.model.BigQueryLikeTable;
import com.intellij.database.dialects.bigquery.model.BigQueryLikeView;
import com.intellij.database.dialects.bigquery.model.BigQueryMatView;
import com.intellij.database.dialects.bigquery.model.BigQueryRoot;
import com.intellij.database.dialects.bigquery.model.BigQueryRoutine;
import com.intellij.database.dialects.bigquery.model.BigQuerySchema;
import com.intellij.database.dialects.bigquery.model.BigQueryTable;
import com.intellij.database.dialects.bigquery.model.BigQueryTableColumn;
import com.intellij.database.dialects.bigquery.model.BigQueryView;
import com.intellij.database.dialects.bigquery.model.properties.BigQueryTableColumnType;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.util.containers.JBIterable;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003\u0017\u0018\u0019B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0014J&\u0010\u0012\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014J6\u0010\u0014\u001a \u0012\u0006\b\u0001\u0012\u00020\u00030\u0015R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0003H\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryRoot;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;", "Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "createMeta", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper;", "createSchemaRetriever", "Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQuerySchemaRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "database", "Factory", "BigQuerySchemaRetriever", "BigQueryDatabaseRetriever", "intellij.database.dialects.bigquery"})
public class BigQueryIntrospector
extends BaseMultiDatabaseIntrospector<BigQueryRoot, BigQueryDatabase, BigQuerySchema> {
    public BigQueryIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.BIGQUERY;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"BIGQUERY");
        super(context, nature, dbms, modelFactory);
    }

    private final DatabaseMetaDataWrapper createMeta() {
        DatabaseConnectionCore connection2;
        DatabaseConnectionCore databaseConnectionCore = connection2 = this.getDbConnection();
        if (databaseConnectionCore != null) {
            DatabaseMetaDataWrapper databaseMetaDataWrapper;
            DatabaseConnectionCore it = databaseConnectionCore;
            boolean bl = false;
            try {
                RemoteDatabaseMetaData remoteDatabaseMetaData = connection2.getRemoteMetaData();
                if (remoteDatabaseMetaData == null) {
                    throw new BigQueryIntrospectionException("Connection#getMetaData() returns null. No introspection could be performed", null, 2, null);
                }
                RemoteDatabaseMetaData metaData = remoteDatabaseMetaData;
                databaseMetaDataWrapper = DatabaseMetaDataWrapper.create(connection2, metaData).withErrorSink(this.getErrorSink());
                Intrinsics.checkNotNull((Object)databaseMetaDataWrapper);
            }
            catch (SQLException e) {
                throw new BigQueryIntrospectionException("Failed to retrieve meta data", e);
            }
            return databaseMetaDataWrapper;
        }
        throw new BigQueryIntrospectionException("Failed to get connection", null, 2, null);
    }

    @NotNull
    protected BigQuerySchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull BigQuerySchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new BigQuerySchemaRetriever(transaction, schema);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<BigQueryIntroQueries.Database, BigQueryDatabase>(this){
            final /* synthetic */ BigQueryIntrospector this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<BigQueryIntroQueries.Database> listDatabases(DBTransaction tran) {
                List list;
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                Closeable closeable = BigQueryIntrospector.access$createMeta(this.this$0).databases();
                Throwable throwable = null;
                try {
                    ClosableIt it = (ClosableIt)closeable;
                    boolean bl = false;
                    List list2 = it.map(arg_0 -> createDatabaseLister.1.listDatabases$lambda$3$lambda$2(createDatabaseLister.1::listDatabases$lambda$3$lambda$1, arg_0)).toList();
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"use(...)");
                return list;
            }

            protected boolean isCurrent(int idx, BigQueryIntroQueries.Database db) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                return Intrinsics.areEqual((Object)BigQueryIntrospector.access$getDbConnectionInfo((BigQueryIntrospector)this.this$0).databaseName, (Object)db.name);
            }

            protected BigQueryDatabase applyDatabase(ModNamingFamily<?> databases, BigQueryIntroQueries.Database db) {
                Intrinsics.checkNotNullParameter(databases, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                return (BigQueryDatabase)this.renew(databases, db.name);
            }

            private static final BigQueryIntroQueries.Database listDatabases$lambda$3$lambda$1(String databaseName) {
                BigQueryIntroQueries.Database database;
                BigQueryIntroQueries.Database $this$listDatabases_u24lambda_u243_u24lambda_u241_u24lambda_u240 = database = new BigQueryIntroQueries.Database();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)databaseName);
                $this$listDatabases_u24lambda_u243_u24lambda_u241_u24lambda_u240.name = databaseName;
                return database;
            }

            private static final BigQueryIntroQueries.Database listDatabases$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
                return (BigQueryIntroQueries.Database)$tmp0.invoke(p0);
            }
        };
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<? extends BigQueryDatabase> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull BigQueryDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new BigQueryDatabaseRetriever(transaction, database);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQueryDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryRoot;", "Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;)V", "retrieveSchemas", "", "retrieveSchemasSafe", "", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Schema;", "intellij.database.dialects.bigquery"})
    @SourceDebugExtension(value={"SMAP\nBigQueryIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQueryIntrospector.kt\ncom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQueryDatabaseRetriever\n+ 2 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,420:1\n435#2,2:421\n437#2,2:424\n439#2,3:427\n1869#3:423\n1870#3:426\n*S KotlinDebug\n*F\n+ 1 BigQueryIntrospector.kt\ncom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQueryDatabaseRetriever\n*L\n378#1:421,2\n378#1:424,2\n378#1:427,3\n378#1:423\n378#1:426\n*E\n"})
    protected final class BigQueryDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<BigQueryDatabase> {
        public BigQueryDatabaseRetriever(@NotNull DBTransaction transaction, BigQueryDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)BigQueryIntrospector.this, transaction, (BasicModMateDatabase)database);
        }

        @Override
        public void retrieveSchemas() {
            this.inDatabase(arg_0 -> BigQueryDatabaseRetriever.retrieveSchemas$lambda$2(this, BigQueryIntrospector.this, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final List<DatabaseMetaDataWrapper.Schema> retrieveSchemasSafe() {
            try {
                List list;
                Closeable closeable = BigQueryIntrospector.this.createMeta().schemas((JBIterable<String>)JBIterable.of((Object)((BigQueryDatabase)this.getDatabase()).getName()));
                Throwable throwable = null;
                try {
                    ClosableIt it = (ClosableIt)closeable;
                    boolean bl = false;
                    List list2 = it.filter(arg_0 -> BigQueryDatabaseRetriever.retrieveSchemasSafe$lambda$5$lambda$4(arg_0 -> BigQueryDatabaseRetriever.retrieveSchemasSafe$lambda$5$lambda$3(this, arg_0), arg_0)).toList();
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"use(...)");
                return list;
            }
            catch (Exception e) {
                BigQueryIntrospector.this.getErrorSink().accept("Error while introspecting " + this.getDatabase(), e);
                return CollectionsKt.emptyList();
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveSchemas$lambda$2(BigQueryDatabaseRetriever this$0, BigQueryIntrospector this$1, BigQueryDatabase db) {
            void $this$applySchemasImpl$iv;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            NamingFamily namingFamily = db.getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
            NamingFamily namingFamily2 = namingFamily;
            List<DatabaseMetaDataWrapper.Schema> scs$iv = this$0.retrieveSchemasSafe();
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv = scs$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                void schema;
                Object element$iv$iv;
                Object sc$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                DatabaseMetaDataWrapper.Schema schema2 = (DatabaseMetaDataWrapper.Schema)sc$iv;
                void $this$retrieveSchemas_u24lambda_u242_u24lambda_u241 = $this$applySchemasImpl$iv;
                boolean bl2 = false;
                Object e = db.getSchemas().createOrGet(schema.schema);
                BigQuerySchema $this$retrieveSchemas_u24lambda_u242_u24lambda_u241_u24lambda_u240 = (BigQuerySchema)e;
                boolean bl3 = false;
                $this$retrieveSchemas_u24lambda_u242_u24lambda_u241_u24lambda_u240.setCurrent(Intrinsics.areEqual((Object)((BigQueryIntrospector)this$1).getDbConnectionInfo().schemaName, (Object)schema.schema));
            }
            $this$applySchemasImpl$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv.sort();
            return Unit.INSTANCE;
        }

        private static final boolean retrieveSchemasSafe$lambda$5$lambda$3(BigQueryDatabaseRetriever this$0, DatabaseMetaDataWrapper.Schema schema) {
            return Intrinsics.areEqual((Object)schema.database, (Object)((BigQueryDatabase)this$0.getDatabase()).getName());
        }

        private static final boolean retrieveSchemasSafe$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0019\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0014J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010!\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J1\u0010#\u001a\u0004\u0018\u0001H$\"\u0004\b\u0000\u0010$2\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u0002H$0&H\u0002\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020-H\u0002J\b\u00100\u001a\u00020\u000fH\u0002J\u0018\u00101\u001a\u0002022\u0006\u0010+\u001a\u0002022\u0006\u0010,\u001a\u00020-H\u0002J\b\u00103\u001a\u00020\u000fH\u0002J\b\u00104\u001a\u00020\u000fH\u0002J\b\u00105\u001a\u00020\u000fH\u0002J\b\u00106\u001a\u00020\fH\u0002J\b\u00107\u001a\u00020\u000fH\u0002J\b\u00108\u001a\u00020\u000fH\u0002J\b\u00109\u001a\u00020\u000fH\u0002\u00a8\u0006:"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQuerySchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryRoot;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "processPreliminaryPhase", "", "process", "retrieveMainContent", "retrieveTablesAndViews", "retrieveTablesAndViewsInfo", "retrieveViewsDefinitions", "retrieveTablesAndViewsOptions", "processLikeTableOption", "likeTable", "Lcom/intellij/database/dialects/bigquery/model/BigQueryLikeTable;", "tableOrViewOption", "Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntroQueries$TableOrViewOption;", "processTableOption", "table", "Lcom/intellij/database/dialects/bigquery/model/BigQueryTable;", "processViewOption", "view", "Lcom/intellij/database/dialects/bigquery/model/BigQueryView;", "processMatViewOption", "Lcom/intellij/database/dialects/bigquery/model/BigQueryMatView;", "parseTableOption", "T", "parse", "Lkotlin/Function1;", "", "(Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntroQueries$TableOrViewOption;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "processTableColumn", "Lcom/intellij/database/dialects/bigquery/model/BigQueryTableColumn;", "column", "columnInfo", "Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntroQueries$ColumnInfo;", "getColumnType", "Lcom/intellij/database/dialects/bigquery/model/properties/BigQueryTableColumnType;", "retrieveTableAndViewColumns", "processViewColumn", "Lcom/intellij/database/dialects/bigquery/model/BigQueryLikeColumn;", "retrieveColumnComments", "retrieveRoutines", "retrieveRoutinesInfoFromMetaData", "retrieveRoutinesInfo", "retrieveRoutineArguments", "retrieveRoutineSources", "retrieveRoutineOptions", "intellij.database.dialects.bigquery"})
    @SourceDebugExtension(value={"SMAP\nBigQueryIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQueryIntrospector.kt\ncom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQuerySchemaRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/NameCache\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,420:1\n1563#2:421\n1634#2,3:422\n1869#2,2:461\n336#3,4:425\n340#3:433\n198#3,11:434\n341#3:445\n195#3,14:446\n355#3:460\n358#3,6:463\n178#3,8:469\n37#4:429\n36#4,3:430\n442#5,6:477\n1#6:483\n*S KotlinDebug\n*F\n+ 1 BigQueryIntrospector.kt\ncom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQuerySchemaRetriever\n*L\n95#1:421\n95#1:422,3\n224#1:461,2\n95#1:425,4\n95#1:433\n95#1:434,11\n95#1:445\n104#1:446,14\n224#1:460\n224#1:463,6\n281#1:469,8\n95#1:429\n95#1:430,3\n238#1:477,6\n*E\n"})
    protected final class BigQuerySchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<BigQuerySchema> {
        public BigQuerySchemaRetriever(@NotNull DBTransaction transaction, BigQuerySchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)BigQueryIntrospector.this, transaction, (BasicModSchema)schema);
        }

        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull BigQuerySchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return false;
        }

        @Override
        public void processPreliminaryPhase() {
            if (this.getMode().fragment) {
                return;
            }
            if (this.getMode().increment) {
                this.analyzeCurrentContent();
            }
        }

        @Override
        public void process() {
            BaseIntrospector baseIntrospector = BigQueryIntrospector.this;
            String string = ((BigQuerySchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            BaseIntrospector.reportIntrospectingSchema$default(baseIntrospector, string, null, null, 6, null);
            this.prepareParameters();
            this.processMainPhase();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void retrieveMainContent() {
            void families$iv$iv;
            void $this$mapTo$iv$iv;
            this.retrieveTablesAndViews();
            this.retrieveTableAndViewColumns();
            this.retrieveColumnComments();
            ModNamingFamily<? extends BigQueryRoutine> modNamingFamily = ((BigQuerySchema)this.getSchema()).getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BigQueryRoutine bigQueryRoutine = (BigQueryRoutine)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getArguments());
            }
            ModFamily[] families$iv = (ModFamily[])((List)destination$iv$iv);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            ModFamily[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            this.retrieveRoutines();
            this.retrieveRoutineArguments();
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
            this.retrieveRoutineSources();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTablesAndViews() {
            void families$iv;
            BigQueryIntrospector.this.reportRetrieving("tables and views", "introspection.retrieve.tablesViews");
            ModFamily[] modFamilyArray = new ModFamily[3];
            Intrinsics.checkNotNullExpressionValue(((BigQuerySchema)this.getSchema()).getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(((BigQuerySchema)this.getSchema()).getViews(), (String)"getViews(...)");
            Intrinsics.checkNotNullExpressionValue(((BigQuerySchema)this.getSchema()).getMatViews(), (String)"getMatViews(...)");
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            this.retrieveTablesAndViewsInfo();
            for (void f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
            this.retrieveTablesAndViewsOptions();
            this.retrieveViewsDefinitions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void retrieveTablesAndViewsInfo() {
            BigQueryDatabase bigQueryDatabase = ((BigQuerySchema)this.getSchema()).getParent();
            Closeable closeable = BigQueryIntrospector.this.createMeta().tables(new DatabaseMetaDataWrapper.Schema(((BigQuerySchema)this.getSchema()).getName(), bigQueryDatabase != null ? bigQueryDatabase.getName() : null), null, null);
            Throwable throwable = null;
            try {
                ClosableIt it = (ClosableIt)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                ClosableIt closableIt = it;
                while (((Iterator)((Object)closableIt)).hasNext()) {
                    ModNamingFamily tables;
                    ObjectKind kind;
                    DatabaseMetaDataWrapper.Table t = (DatabaseMetaDataWrapper.Table)closableIt.next();
                    Intrinsics.checkNotNullExpressionValue((Object)JdbcIntrospectorHelper.JdbcTableType.findByName(t.type).getKind(), (String)"getKind(...)");
                    ModFamily modFamily = DbImplUtilCore.familyOf((BasicModElement)this.getSchema(), kind);
                    if ((modFamily instanceof ModNamingFamily ? (ModNamingFamily)modFamily : null) == null) continue;
                    tables = tables;
                    tables.createOrGet(t.name);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final void retrieveViewsDefinitions() {
            BigQueryIntroQueries.INSTANCE.processViewDefinitions(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.ViewDefinition, Unit>)((Function1)arg_0 -> BigQuerySchemaRetriever.retrieveViewsDefinitions$lambda$6(this, arg_0)));
        }

        private final void retrieveTablesAndViewsOptions() {
            BigQueryIntroQueries.INSTANCE.processViewAndTablesOptions(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.TableOrViewOption, Unit>)((Function1)arg_0 -> BigQuerySchemaRetriever.retrieveTablesAndViewsOptions$lambda$10(this, arg_0)));
        }

        private final void processLikeTableOption(BigQueryLikeTable likeTable, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            block16: {
                String string = tableOrViewOption.name;
                if (string == null) break block16;
                int n = -1;
                switch (string.hashCode()) {
                    case 1451097503: {
                        if (string.equals("friendly_name")) {
                            n = 1;
                        }
                        break;
                    }
                    case -2040455290: {
                        if (string.equals("expiration_timestamp")) {
                            n = 2;
                        }
                        break;
                    }
                    case -1724546052: {
                        if (string.equals("description")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1110417409: {
                        if (string.equals("labels")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        likeTable.setExpirationTimestamp(tableOrViewOption.value);
                        break;
                    }
                    case 1: {
                        String string2 = tableOrViewOption.value;
                        likeTable.setFriendlyName(string2 != null ? StringsKt.removeSurrounding((String)string2, (CharSequence)"\"") : null);
                        break;
                    }
                    case 3: {
                        String string3 = tableOrViewOption.value;
                        likeTable.setComment(string3 != null ? StringsKt.removeSurrounding((String)string3, (CharSequence)"\"") : null);
                        break;
                    }
                    case 4: {
                        likeTable.setLabels(tableOrViewOption.value);
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void processTableOption(BigQueryTable table, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            block6: {
                this.processLikeTableOption(table, tableOrViewOption);
                String string = tableOrViewOption.name;
                if (string == null) return;
                switch (string.hashCode()) {
                    case 749023751: {
                        if (string.equals("require_partition_filter")) break;
                        return;
                    }
                    case 2094986649: {
                        if (!string.equals("kms_key_name")) {
                            return;
                        }
                        break block6;
                    }
                    case -1838282606: {
                        if (!string.equals("partition_expiration_days")) return;
                        Double d = (Double)this.parseTableOption(tableOrViewOption, processTableOption.1.INSTANCE);
                        if (d == null) return;
                        double it = ((Number)d).doubleValue();
                        boolean bl = false;
                        table.setPartitionExpirationDays(it);
                        return;
                    }
                }
                Boolean bl = (Boolean)this.parseTableOption(tableOrViewOption, processTableOption.3.INSTANCE);
                if (bl == null) return;
                boolean it = bl;
                boolean bl2 = false;
                table.setRequirePartitionFilter(it);
                return;
            }
            table.setKmsKeyName(tableOrViewOption.value);
        }

        private final void processViewOption(BigQueryView view, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            this.processLikeTableOption(view, tableOrViewOption);
        }

        private final void processMatViewOption(BigQueryMatView view, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            block2: {
                String string;
                block1: {
                    this.processLikeTableOption(view, tableOrViewOption);
                    string = tableOrViewOption.name;
                    if (!Intrinsics.areEqual((Object)string, (Object)"enable_refresh")) break block1;
                    Boolean bl = (Boolean)this.parseTableOption(tableOrViewOption, processMatViewOption.1.INSTANCE);
                    if (bl == null) break block2;
                    boolean it = bl;
                    boolean bl2 = false;
                    view.setEnableRefresh(it);
                    break block2;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"refresh_interval_minutes")) break block2;
                Double d = (Double)this.parseTableOption(tableOrViewOption, processMatViewOption.3.INSTANCE);
                if (d != null) {
                    double it = ((Number)d).doubleValue();
                    boolean bl = false;
                    view.setRefreshIntervalMinutes(it);
                }
            }
        }

        private final <T> T parseTableOption(BigQueryIntroQueries.TableOrViewOption tableOrViewOption, Function1<? super String, ? extends T> parse) {
            try {
                Object object;
                String optionValue;
                String string = optionValue = tableOrViewOption.value;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    object = parse.invoke((Object)optionValue);
                } else {
                    object = null;
                }
                return (T)object;
            }
            catch (Exception e) {
                this.log.warn("Invalid table option " + tableOrViewOption.name + ": '" + tableOrViewOption.value + "', expected type: " + tableOrViewOption.type);
                return null;
            }
        }

        /*
         * Unable to fully structure code
         */
        private final BigQueryTableColumn processTableColumn(BigQueryTableColumn column, BigQueryIntroQueries.ColumnInfo columnInfo) {
            $this$processTableColumn_u24lambda_u2416 = var3_3 = column;
            $i$a$-apply-BigQueryIntrospector$BigQuerySchemaRetriever$processTableColumn$1 = false;
            $this$processTableColumn_u24lambda_u2416.setPosition(columnInfo.ordinal_position);
            v0 = DataTypeFactory.of(columnInfo.data_type);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"of(...)");
            $this$processTableColumn_u24lambda_u2416.setStoredType(DasUnresolvedTypeReference.Companion.of(v0));
            if (!Intrinsics.areEqual((Object)columnInfo.is_nullable, (Object)"NO")) ** GOTO lbl-1000
            var6_6 = columnInfo.data_type;
            v1 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDefault(...)");
            v2 = var6_6.toLowerCase(v1);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
            if (!StringsKt.startsWith$default((String)v2, (String)"array", (boolean)false, (int)2, null)) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            $this$processTableColumn_u24lambda_u2416.setNotNull(v3);
            $this$processTableColumn_u24lambda_u2416.setAutoCreated(Intrinsics.areEqual((Object)columnInfo.is_hidden, (Object)"YES"));
            $this$processTableColumn_u24lambda_u2416.setType(this.getColumnType(columnInfo));
            $this$processTableColumn_u24lambda_u2416.setClusteringOrdinalPosition(columnInfo.clustering_ordinal_position);
            return var3_3;
        }

        private final BigQueryTableColumnType getColumnType(BigQueryIntroQueries.ColumnInfo column2) {
            return Intrinsics.areEqual((Object)column2.is_partitioning, (Object)"YES") ? BigQueryTableColumnType.PARTITIONING : (column2.clustering_ordinal_position != 0 ? BigQueryTableColumnType.CLUSTERING : BigQueryTableColumnType.REGULAR);
        }

        private final void retrieveTableAndViewColumns() {
            boolean bl;
            boolean bl2;
            boolean bl3;
            BigQueryLikeTable t;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            BigQueryIntrospector.this.reportRetrieving(objectKind);
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it = BigQuerySchemaRetriever$retrieveTableAndViewColumns$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean bl4 = false;
            ModNamingFamily<? extends BigQueryTable> modNamingFamily = ((BigQuerySchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryTable)element$iv;
                bl3 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryView> modNamingFamily2 = ((BigQuerySchema)this.getSchema()).getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getViews(...)");
            $this$forEach$iv = modNamingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryView)element$iv;
                bl2 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryMatView> modNamingFamily3 = ((BigQuerySchema)this.getSchema()).getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getMatViews(...)");
            $this$forEach$iv = modNamingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryMatView)element$iv;
                bl = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            boolean bl5 = false;
            List colsWithoutPosition = new ArrayList();
            NameCache tableCache = new NameCache();
            Ref.IntRef counter = new Ref.IntRef();
            BigQueryIntroQueries.INSTANCE.processColumns(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.ColumnInfo, Unit>)((Function1)arg_0 -> BigQuerySchemaRetriever.retrieveTableAndViewColumns$lambda$23$lambda$22(tableCache, this, colsWithoutPosition, counter, arg_0)));
            BigQuerySchemaRetriever.retrieveTableAndViewColumns$lambda$23$tableChanged(colsWithoutPosition, counter);
            it = BigQuerySchemaRetriever$retrieveTableAndViewColumns$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            $i$a$-modifyFamiliesAndCleanup-BigQueryIntrospector$BigQuerySchemaRetriever$retrieveTableAndViewColumns$1 = false;
            ModNamingFamily<? extends BigQueryTable> modNamingFamily4 = ((BigQuerySchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"getTables(...)");
            $this$forEach$iv = modNamingFamily4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryTable)element$iv;
                bl3 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryView> modNamingFamily5 = ((BigQuerySchema)this.getSchema()).getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily5, (String)"getViews(...)");
            $this$forEach$iv = modNamingFamily5;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryView)element$iv;
                bl2 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryMatView> modNamingFamily6 = ((BigQuerySchema)this.getSchema()).getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily6, (String)"getMatViews(...)");
            $this$forEach$iv = modNamingFamily6;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryMatView)element$iv;
                bl = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final BigQueryLikeColumn processViewColumn(BigQueryLikeColumn column, BigQueryIntroQueries.ColumnInfo columnInfo) {
            $this$processViewColumn_u24lambda_u2424 = var3_3 = column;
            $i$a$-apply-BigQueryIntrospector$BigQuerySchemaRetriever$processViewColumn$1 = false;
            $this$processViewColumn_u24lambda_u2424.setPosition(columnInfo.ordinal_position);
            $this$processViewColumn_u24lambda_u2424.setName(columnInfo.name);
            v0 = DataTypeFactory.of(columnInfo.data_type);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"of(...)");
            $this$processViewColumn_u24lambda_u2424.setStoredType(DasUnresolvedTypeReference.Companion.of(v0));
            if (!Intrinsics.areEqual((Object)columnInfo.is_nullable, (Object)"NO")) ** GOTO lbl-1000
            var6_6 = columnInfo.data_type;
            v1 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDefault(...)");
            v2 = var6_6.toLowerCase(v1);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
            if (!StringsKt.startsWith$default((String)v2, (String)"array", (boolean)false, (int)2, null)) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            $this$processViewColumn_u24lambda_u2424.setNotNull(v3);
            $this$processViewColumn_u24lambda_u2424.setAutoCreated(Intrinsics.areEqual((Object)columnInfo.is_hidden, (Object)"YES"));
            return var3_3;
        }

        private final void retrieveColumnComments() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            BigQueryIntrospector.this.reportRetrieving(objectKind);
            BigQueryIntroQueries.INSTANCE.processColumnComments(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.ColumnComment, Unit>)((Function1)arg_0 -> BigQuerySchemaRetriever.retrieveColumnComments$lambda$26(this, arg_0)));
        }

        private final void retrieveRoutines() {
            BigQueryIntrospector.this.reportRetrieving("Routines", "introspection.retrieve.routinesList");
            boolean accessDenied = false;
            ModFamily $this$modifyAndCleanup_u24default$iv = ((BigQuerySchema)this.getSchema()).getRoutines();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            boolean bl2 = accessDenied = !this.retrieveRoutinesInfo();
            if (accessDenied) {
                this.retrieveRoutinesInfoFromMetaData();
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            if (!accessDenied) {
                this.retrieveRoutineOptions();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void retrieveRoutinesInfoFromMetaData() {
            BigQueryDatabase bigQueryDatabase = ((BigQuerySchema)this.getSchema()).getParent();
            Closeable closeable = BigQueryIntrospector.this.createMeta().routines(new DatabaseMetaDataWrapper.Schema(((BigQuerySchema)this.getSchema()).getName(), bigQueryDatabase != null ? bigQueryDatabase.getName() : null), null, null);
            Throwable throwable = null;
            try {
                ClosableIt it = (ClosableIt)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                ClosableIt closableIt = it;
                while (((Iterator)((Object)closableIt)).hasNext()) {
                    BigQueryRoutine bigQueryRoutine;
                    DatabaseMetaDataWrapper.Routine routine2 = (DatabaseMetaDataWrapper.Routine)closableIt.next();
                    BigQueryRoutine $this$retrieveRoutinesInfoFromMetaData_u24lambda_u2429_u24lambda_u2428 = bigQueryRoutine = ((BigQuerySchema)this.getSchema()).getRoutines().createOrGet(routine2.name);
                    boolean bl2 = false;
                    $this$retrieveRoutinesInfoFromMetaData_u24lambda_u2429_u24lambda_u2428.setName(routine2.name);
                    $this$retrieveRoutinesInfoFromMetaData_u24lambda_u2429_u24lambda_u2428.setRoutineKind(routine2.kind);
                    $this$retrieveRoutinesInfoFromMetaData_u24lambda_u2429_u24lambda_u2428.setComment(routine2.comment);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final boolean retrieveRoutinesInfo() {
            BigQueryIntrospector.this.reportRetrieving("routine sources", "introspection.retrieve.routine.sources");
            return BigQueryIntroQueries.INSTANCE.processRoutines(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineInfo, Unit>)((Function1)arg_0 -> BigQuerySchemaRetriever.retrieveRoutinesInfo$lambda$32(this, arg_0)));
        }

        private final void retrieveRoutineArguments() {
            ObjectKind objectKind = ObjectKind.ARGUMENT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ARGUMENT");
            BigQueryIntrospector.this.reportRetrieving(objectKind);
            BigQueryIntroQueries.INSTANCE.processRoutineArguments(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineArgumentInfo, Unit>)((Function1)arg_0 -> BigQuerySchemaRetriever.retrieveRoutineArguments$lambda$37(this, arg_0)));
        }

        private final void retrieveRoutineSources() {
            BigQueryIntrospector.this.reportRetrieving("routine sources", "introspection.retrieve.routine.sources");
            BigQueryIntroQueries.INSTANCE.processRoutineSources(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineDefinition, Unit>)((Function1)arg_0 -> BigQuerySchemaRetriever.retrieveRoutineSources$lambda$40(this, arg_0)));
        }

        private final void retrieveRoutineOptions() {
            BigQueryIntrospector.this.reportRetrieving("routine sources", "introspection.retrieve.routine.options");
            BigQueryIntroQueries.INSTANCE.processRoutineOptions(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineOption, Unit>)((Function1)arg_0 -> BigQuerySchemaRetriever.retrieveRoutineOptions$lambda$42(this, arg_0)));
        }

        private static final void retrieveViewsDefinitions$lambda$6$lambda$5$lambda$4(BigQueryView $this_apply, BigQueryIntroQueries.ViewDefinition $viewDef) {
            $this_apply.setSourceText(BaseIntrospectionFunctions.toCompositeText($viewDef.view_definition, CompositeText.Kind.ORIGINAL_TEXT));
        }

        private static final Unit retrieveViewsDefinitions$lambda$6(BigQuerySchemaRetriever this$0, BigQueryIntroQueries.ViewDefinition viewDef) {
            block0: {
                BigQueryView bigQueryView;
                Intrinsics.checkNotNullParameter((Object)viewDef, (String)"viewDef");
                BigQueryView bigQueryView2 = (BigQueryView)((BigQuerySchema)this$0.getSchema()).getViews().get(viewDef.table_name);
                if (bigQueryView2 == null) break block0;
                BigQueryView $this$retrieveViewsDefinitions_u24lambda_u246_u24lambda_u245 = bigQueryView = bigQueryView2;
                boolean bl = false;
                ((BasicModModel)$this$retrieveViewsDefinitions_u24lambda_u246_u24lambda_u245.getModel()).writeSources(() -> BigQuerySchemaRetriever.retrieveViewsDefinitions$lambda$6$lambda$5$lambda$4($this$retrieveViewsDefinitions_u24lambda_u246_u24lambda_u245, viewDef));
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTablesAndViewsOptions$lambda$10(BigQuerySchemaRetriever this$0, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            Intrinsics.checkNotNullParameter((Object)tableOrViewOption, (String)"tableOrViewOption");
            ObjectKind objectKind = JdbcIntrospectorHelper.JdbcTableType.findByName(tableOrViewOption.table_type).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            ObjectKind kind = objectKind;
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW)) {
                BigQueryMatView bigQueryMatView = (BigQueryMatView)((BigQuerySchema)this$0.getSchema()).getMatViews().get(tableOrViewOption.table_name);
                if (bigQueryMatView != null) {
                    BigQueryMatView bigQueryMatView2;
                    BigQueryMatView $this$retrieveTablesAndViewsOptions_u24lambda_u2410_u24lambda_u247 = bigQueryMatView2 = bigQueryMatView;
                    boolean bl = false;
                    this$0.processMatViewOption($this$retrieveTablesAndViewsOptions_u24lambda_u2410_u24lambda_u247, tableOrViewOption);
                }
            } else if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW)) {
                BigQueryView bigQueryView = (BigQueryView)((BigQuerySchema)this$0.getSchema()).getViews().get(tableOrViewOption.table_name);
                if (bigQueryView != null) {
                    BigQueryView bigQueryView2;
                    BigQueryView $this$retrieveTablesAndViewsOptions_u24lambda_u2410_u24lambda_u248 = bigQueryView2 = bigQueryView;
                    boolean bl = false;
                    this$0.processViewOption($this$retrieveTablesAndViewsOptions_u24lambda_u2410_u24lambda_u248, tableOrViewOption);
                }
            } else if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE)) {
                BigQueryTable bigQueryTable = (BigQueryTable)((BigQuerySchema)this$0.getSchema()).getTables().get(tableOrViewOption.table_name);
                if (bigQueryTable != null) {
                    BigQueryTable bigQueryTable2;
                    BigQueryTable $this$retrieveTablesAndViewsOptions_u24lambda_u2410_u24lambda_u249 = bigQueryTable2 = bigQueryTable;
                    boolean bl = false;
                    this$0.processTableOption($this$retrieveTablesAndViewsOptions_u24lambda_u2410_u24lambda_u249, tableOrViewOption);
                }
            } else {
                this$0.log.warn("Incorrect table type: '" + tableOrViewOption.table_type + "'. Detected ObjectKind: '" + kind.name() + "'");
            }
            return Unit.INSTANCE;
        }

        private static final void retrieveTableAndViewColumns$lambda$23$tableChanged(List<BigQueryLikeColumn> colsWithoutPosition, Ref.IntRef counter) {
            Iterator iterator = ((Iterable)colsWithoutPosition).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                BigQueryLikeColumn col = (BigQueryLikeColumn)iterator.next();
                col.setPosition((short)(counter.element + index + 1));
            }
            colsWithoutPosition.clear();
            counter.element = 0;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveTableAndViewColumns$lambda$23$lambda$22(NameCache $tableCache, BigQuerySchemaRetriever this$0, List $colsWithoutPosition, Ref.IntRef $counter, BigQueryIntroQueries.ColumnInfo columnInfo) {
            Intrinsics.checkNotNullParameter((Object)columnInfo, (String)"columnInfo");
            var6_5 = $tableCache;
            name$iv = columnInfo.table_name;
            $i$f$get = false;
            var9_9 = this_$iv;
            var10_10 = name$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull(v0);
            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv$iv)) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var13_13 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                var14_14 = this_$iv$iv;
                var16_15 = this_$iv$iv;
                $i$a$-get-BigQueryIntrospector$BigQuerySchemaRetriever$retrieveTableAndViewColumns$2$1$table$1 = false;
                BigQuerySchemaRetriever.access$retrieveTableAndViewColumns$lambda$23$tableChanged($colsWithoutPosition, $counter);
                v2 = ((BigQuerySchema)this$0.getSchema()).getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                v3 = (BigQueryLikeTable)it.invoke(v2);
                if (v3 == null) {
                    v4 = ((BigQuerySchema)this$0.getSchema()).getViews();
                    Intrinsics.checkNotNullExpressionValue(v4, (String)"getViews(...)");
                    v3 = (BigQueryLikeTable)it.invoke(v4);
                    if (v3 == null) {
                        v5 = ((BigQuerySchema)this$0.getSchema()).getMatViews();
                        Intrinsics.checkNotNullExpressionValue(v5, (String)"getMatViews(...)");
                        v3 = (BigQueryLikeTable)it.invoke(v5);
                    }
                }
                var16_15.setV((BasicModNamedElement)v3);
                v1 = this_$iv$iv.getV();
            }
            var7_6 = table = (BigQueryLikeTable)v1;
            if (var7_6 instanceof BigQueryView || var7_6 instanceof BigQueryMatView) {
                v6 = ((ModPositioningNamingFamily)((BigQueryLikeView)table).getColumns()).createOrGet(columnInfo.name);
                Intrinsics.checkNotNull(v6, (String)"null cannot be cast to non-null type com.intellij.database.dialects.bigquery.model.BigQueryLikeColumn");
                v7 = this$0.processViewColumn((BigQueryLikeColumn)v6, columnInfo);
            } else if (var7_6 instanceof BigQueryTable) {
                v8 = ((BigQueryTable)table).getColumns().createOrGet(columnInfo.name);
                Intrinsics.checkNotNullExpressionValue(v8, (String)"createOrGet(...)");
                v7 = this$0.processTableColumn((BigQueryTableColumn)v8, columnInfo);
            } else {
                v7 = column = null;
            }
            if (column != null) {
                if (column.getPosition() == 0) {
                    $colsWithoutPosition.add(column);
                } else {
                    var7_7 = $counter.element;
                    $counter.element = var7_7 + 1;
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveColumnComments$lambda$26(BigQuerySchemaRetriever this$0, BigQueryIntroQueries.ColumnComment c2) {
            block2: {
                BasicNode basicNode;
                BigQueryLikeTable table;
                BasicNode basicNode2;
                BigQueryLikeTable bigQueryLikeTable;
                Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
                BigQueryTable bigQueryTable = (BigQueryTable)((BigQuerySchema)this$0.getSchema()).getTables().get(c2.table_name);
                if (bigQueryTable != null) {
                    bigQueryLikeTable = bigQueryTable;
                } else {
                    BigQueryView bigQueryView = (BigQueryView)((BigQuerySchema)this$0.getSchema()).getViews().get(c2.table_name);
                    bigQueryLikeTable = bigQueryView != null ? (BigQueryLikeTable)bigQueryView : (BigQueryLikeTable)((BigQuerySchema)this$0.getSchema()).getMatViews().get(c2.table_name);
                }
                if ((basicNode2 = (table = bigQueryLikeTable)) == null || (basicNode2 = basicNode2.getColumns()) == null || (basicNode2 = (BasicModTableOrViewColumn)basicNode2.get(c2.name)) == null) break block2;
                BasicNode $this$retrieveColumnComments_u24lambda_u2426_u24lambda_u2425 = basicNode = basicNode2;
                boolean bl = false;
                $this$retrieveColumnComments_u24lambda_u2426_u24lambda_u2425.setComment(c2.description);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutinesInfo$lambda$32(BigQuerySchemaRetriever this$0, BigQueryIntroQueries.RoutineInfo routine2) {
            block0: {
                BigQueryRoutine bigQueryRoutine;
                Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
                BigQueryRoutine $this$retrieveRoutinesInfo_u24lambda_u2432_u24lambda_u2431 = bigQueryRoutine = ((BigQuerySchema)this$0.getSchema()).getRoutines().createOrGet(routine2.name);
                boolean bl = false;
                $this$retrieveRoutinesInfo_u24lambda_u2432_u24lambda_u2431.setName(routine2.name);
                $this$retrieveRoutinesInfo_u24lambda_u2432_u24lambda_u2431.setRoutineKind(BigQueryIntrospectorKt.access$getRoutineKind(routine2.routine_kind));
                $this$retrieveRoutinesInfo_u24lambda_u2432_u24lambda_u2431.setLanguage(routine2.language);
                $this$retrieveRoutinesInfo_u24lambda_u2432_u24lambda_u2431.setDeterministic(Intrinsics.areEqual((Object)routine2.is_deterministic, (Object)"YES"));
                $this$retrieveRoutinesInfo_u24lambda_u2432_u24lambda_u2431.setTable(Intrinsics.areEqual((Object)routine2.routine_kind, (Object)"TABLE FUNCTION"));
                String string = routine2.data_type;
                if (string == null) break block0;
                String it = string;
                boolean bl2 = false;
                BasicModArgument basicModArgument = $this$retrieveRoutinesInfo_u24lambda_u2432_u24lambda_u2431.createOrGetReturnArgument();
                DataType dataType = DataTypeFactory.of(it);
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                basicModArgument.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutineArguments$lambda$37(BigQuerySchemaRetriever this$0, BigQueryIntroQueries.RoutineArgumentInfo argInfo) {
            block2: {
                String it;
                BigQueryArgument element;
                BigQueryArgument bigQueryArgument;
                Intrinsics.checkNotNullParameter((Object)argInfo, (String)"argInfo");
                String string = argInfo.routine_name;
                if (string == null) break block2;
                String routine_name = string;
                boolean bl = false;
                BigQueryRoutine routine2 = ((BigQuerySchema)this$0.getSchema()).getRoutines().createOrGet(routine_name);
                BigQueryArgument $this$retrieveRoutineArguments_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435 = bigQueryArgument = (element = (BigQueryArgument)routine2.getArguments().createOrGetAt(argInfo.ordinal_position));
                boolean bl2 = false;
                String string2 = argInfo.name;
                if (string2 != null) {
                    it = string2;
                    boolean bl3 = false;
                    $this$retrieveRoutineArguments_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435.setName(it);
                }
                String string3 = argInfo.data_type;
                if (string3 != null) {
                    it = string3;
                    boolean bl4 = false;
                    DataType dataType = DataTypeFactory.of(it);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    $this$retrieveRoutineArguments_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                }
                $this$retrieveRoutineArguments_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435.setArgumentDirection(BigQueryIntrospectorKt.access$getDirection(argInfo));
            }
            return Unit.INSTANCE;
        }

        private static final void retrieveRoutineSources$lambda$40$lambda$39$lambda$38(BigQueryRoutine $this_apply, BigQueryIntroQueries.RoutineDefinition $routine) {
            $this_apply.setSourceText(BaseIntrospectionFunctions.toCompositeText(((Object)StringsKt.trim((CharSequence)$routine.routine_definition)).toString(), CompositeText.Kind.ORIGINAL_TEXT));
        }

        private static final Unit retrieveRoutineSources$lambda$40(BigQuerySchemaRetriever this$0, BigQueryIntroQueries.RoutineDefinition routine2) {
            BigQueryRoutine bigQueryRoutine;
            Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
            BigQueryRoutine $this$retrieveRoutineSources_u24lambda_u2440_u24lambda_u2439 = bigQueryRoutine = ((BigQuerySchema)this$0.getSchema()).getRoutines().createOrGet(routine2.name);
            boolean bl = false;
            ((BasicModModel)$this$retrieveRoutineSources_u24lambda_u2440_u24lambda_u2439.getModel()).writeSources(() -> BigQuerySchemaRetriever.retrieveRoutineSources$lambda$40$lambda$39$lambda$38($this$retrieveRoutineSources_u24lambda_u2440_u24lambda_u2439, routine2));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutineOptions$lambda$42(BigQuerySchemaRetriever this$0, BigQueryIntroQueries.RoutineOption routineOption) {
            block0: {
                String string;
                BigQueryRoutine $this$retrieveRoutineOptions_u24lambda_u2442_u24lambda_u2441;
                block1: {
                    BigQueryRoutine bigQueryRoutine;
                    Intrinsics.checkNotNullParameter((Object)routineOption, (String)"routineOption");
                    BigQueryRoutine bigQueryRoutine2 = (BigQueryRoutine)((BigQuerySchema)this$0.getSchema()).getRoutines().get(routineOption.routine_name);
                    if (bigQueryRoutine2 == null) break block0;
                    $this$retrieveRoutineOptions_u24lambda_u2442_u24lambda_u2441 = bigQueryRoutine = bigQueryRoutine2;
                    boolean bl = false;
                    string = routineOption.name;
                    if (!Intrinsics.areEqual((Object)string, (Object)"description")) break block1;
                    String string2 = routineOption.value;
                    $this$retrieveRoutineOptions_u24lambda_u2442_u24lambda_u2441.setComment(string2 != null ? StringsKt.removeSurrounding((String)string2, (CharSequence)"\"") : null);
                    break block0;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"library")) break block0;
                String string3 = routineOption.value;
                $this$retrieveRoutineOptions_u24lambda_u2442_u24lambda_u2441.setLibrary(string3 != null ? StringsKt.removeSurrounding((String)string3, (CharSequence)"\"") : null);
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$retrieveTableAndViewColumns$lambda$23$tableChanged(List colsWithoutPosition, Ref.IntRef counter) {
            BigQuerySchemaRetriever.retrieveTableAndViewColumns$lambda$23$tableChanged(colsWithoutPosition, counter);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.bigquery"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{1, 0};
            return version.isOrGreater(nArray);
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new BigQueryIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.bigquery"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

