/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.bigquery.generator.dml.BigQuerySelectGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import java.io.Serializable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u0002H\b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\t\u0018\u00010\u0007\"\u0004\b\u0000\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\tH\u0014J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0016J&\u0010\u0017\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/bigquery/BigQueryDmlHelper;", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getGenerator", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "OUT", "Lcom/intellij/database/script/generator/dml/DmlTask;", "task", "appendFromTable", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "dasTable", "Lcom/intellij/database/model/DasObject;", "alias", "", "tableSamplingSize", "supportsOffset", "", "table", "isEditableTable", "dataProperties", "", "Ljava/io/Serializable;", "intellij.database.dialects.bigquery"})
public final class BigQueryDmlHelper
extends BaseDmlHelper {
    public BigQueryDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @Nullable
    protected <OUT> DmlGenerator<OUT, DmlTask<OUT>> getGenerator(@NotNull DmlTask<? extends OUT> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DmlGenerator dmlGenerator = task instanceof SelectTask ? (DmlGenerator)new BigQuerySelectGenerator((SelectTask)task, this.getDbms(), this) : super.getGenerator(task);
        return dmlGenerator instanceof DmlGenerator ? dmlGenerator : null;
    }

    @Override
    public void appendFromTable(@NotNull DdlBuilder builder, @NotNull DasObject dasTable, @NotNull String alias, @Nullable String tableSamplingSize) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dasTable, (String)"dasTable");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        builder.keyword("FROM").space().qualifiedRef(dasTable).space().alias(alias);
        if (tableSamplingSize != null && DbImplUtilCore.supportsTableSampling(dasTable, this.getDbms())) {
            String[] stringArray = new String[]{"TABLESAMPLE", "SYSTEM"};
            builder.space().keywords(stringArray).space().symbol("(").literal(tableSamplingSize).space().keyword("PERCENT").symbol(")");
        }
    }

    @Override
    public boolean supportsOffset(@Nullable DasObject table) {
        return true;
    }

    @Override
    public boolean isEditableTable(@Nullable DasObject table, @NotNull Map<String, ? extends Serializable> dataProperties) {
        Intrinsics.checkNotNullParameter(dataProperties, (String)"dataProperties");
        return super.isEditableTable(table, dataProperties) && !Intrinsics.areEqual((Object)DmlHelper.Companion.getCOLUMNS_CHANGED_DURING_FETCH().get(dataProperties), (Object)true) && !Intrinsics.areEqual((Object)DmlHelper.Companion.getMULTIPLE_ROWS_WITH_THE_SAME_NUMBER().get(dataProperties), (Object)true);
    }
}

