/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.AbstractCodeGeneratorKt;
import com.intellij.database.dialects.base.generator.AbstractScriptGenerator;
import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.AbstractTransitionCodeGenerator;
import com.intellij.database.dialects.base.generator.BaseAlterGenerator;
import com.intellij.database.dialects.base.generator.BaseCreateGenerator;
import com.intellij.database.dialects.base.generator.BaseDropGenerator;
import com.intellij.database.dialects.base.generator.BaseEnableDisableGenerator;
import com.intellij.database.dialects.base.generator.BaseNativeDefinitionsGenerator;
import com.intellij.database.dialects.base.generator.BaseRecompileGenerator;
import com.intellij.database.dialects.base.generator.BaseRefreshMatViewGenerator;
import com.intellij.database.dialects.base.generator.BaseTruncateGenerator;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.OrSupportedImpl;
import com.intellij.database.dialects.base.generator.ScriptGeneratorDiagnosticListener;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptingCapabilitiesImpl;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.SupportedSinceImpl;
import com.intellij.database.dialects.base.generator.producers.AlterProducer;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.base.generator.producers.RecompileProducer;
import com.intellij.database.dialects.base.generator.producers.TruncateProducer;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicMatView;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.CodeTextBuilder;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingInternalTask;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002QRB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0015\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&H\u0010\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020&H\u0002J\u0010\u0010-\u001a\u00020(2\u0006\u0010)\u001a\u00020&H\u0016J\u0010\u0010.\u001a\u00020(2\u0006\u0010)\u001a\u00020&H\u0016J\u0010\u0010/\u001a\u00020(2\u0006\u0010)\u001a\u00020&H\u0016J\u0010\u00100\u001a\u00020(2\u0006\u0010)\u001a\u00020&H\u0016J\u0010\u00101\u001a\u0002022\u0006\u0010)\u001a\u00020&H\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010)\u001a\u00020&H\u0016J\u0010\u00105\u001a\u0002062\u0006\u0010)\u001a\u00020&H\u0016J\b\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J \u0010=\u001a\u00020\u00132\u0006\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020AH\u0016J\"\u0010B\u001a\u0006\u0012\u0002\b\u00030C2\u0006\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020AJ\u0010\u0010D\u001a\u00020&2\u0006\u0010@\u001a\u00020AH\u0002J\u001a\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u0002082\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010J\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030L\u0018\u00010K2\u0006\u0010!\u001a\u00020\"H\u0016J\u0014\u0010M\u001a\u00020\u00132\n\u0010N\u001a\u0006\u0012\u0002\b\u00030LH\u0016J\u0010\u0010O\u001a\u00020P2\u0006\u0010;\u001a\u00020<H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006S"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator;", "Lcom/intellij/database/script/generator/ScriptGenerator;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "caps", "Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator$CapabilitiesCollector;", "createVersion", "Lcom/intellij/database/model/PerObjectVersion;", "getCreateVersion", "()Lcom/intellij/database/model/PerObjectVersion;", "generatorHelper", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "getGeneratorHelper", "()Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "isIndexExplicitFor", "", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "key", "Lcom/intellij/database/model/basic/BasicKey;", "isDefaultSize", "dt", "Lcom/intellij/database/model/DataType;", "version", "Lcom/intellij/database/util/Version;", "makeScript", "Lcom/intellij/database/script/generator/ScriptingResult;", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcom/intellij/database/script/generator/ScriptingTask;", "getDiagnosticTool", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticListener;", "createContext", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "createGenerator", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "context", "createGenerator$intellij_database_dialects_base", "createCreatingGenerator", "Lcom/intellij/database/dialects/base/generator/BaseCreateGenerator;", "createNativeDefinitionsGenerator", "createEnableDisableGenerator", "createRefreshingGenerator", "createExecuteGenerator", "createDropGenerator", "Lcom/intellij/database/dialects/base/generator/BaseDropGenerator;", "createTruncateGenerator", "Lcom/intellij/database/dialects/base/generator/BaseTruncateGenerator;", "createAlterGenerator", "Lcom/intellij/database/dialects/base/generator/BaseAlterGenerator;", "toString", "", "capabilities", "Lcom/intellij/database/script/generator/ScriptingCapabilities;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "isEqual", "e1", "e2", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "createAlterProducer", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducer;", "createFakeContext", "reviseSource", "Lcom/intellij/database/model/properties/CompositeText;", "e", "Lcom/intellij/database/model/basic/BasicSourceAware;", "prettyPrint", "availableOptions", "", "Lcom/intellij/database/script/generator/ScriptingOption;", "isOptionSupported", "option", "createCapsKey", "", "StupidGenerator", "CapabilitiesCollector", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nAbstractScriptGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractScriptGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractScriptGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
public abstract class AbstractScriptGenerator
implements ScriptGenerator {
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final CapabilitiesCollector caps;
    @NotNull
    private final PerObjectVersion createVersion;

    public AbstractScriptGenerator(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
        this.caps = new CapabilitiesCollector();
        this.createVersion = new PerObjectVersion();
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    @NotNull
    protected final PerObjectVersion getCreateVersion() {
        return this.createVersion;
    }

    @NotNull
    public abstract ScriptGeneratorHelper getGeneratorHelper();

    @Override
    public boolean isIndexExplicitFor(@NotNull BasicIndex index, @NotNull BasicKey key2) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return this.getGeneratorHelper().isIndexExplicitFor(this.createFakeContext(DefaultScriptingOptions.INSTANCE), index, key2);
    }

    @Override
    public boolean isDefaultSize(@NotNull DataType dt, @NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.getGeneratorHelper().isDefaultSize(dt, version);
    }

    @Override
    @NotNull
    public ScriptingResult makeScript(@NotNull Project project, @NotNull ScriptingTask task) {
        ScriptGeneratorDiagnosticListener diagnosticTool;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        boolean bl2 = bl = Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.UNKNOWN) || Intrinsics.areEqual((Object)ScriptingTaskKt.getDbms(task), (Object)this.dbms);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-AbstractScriptGenerator$makeScript$22 = false;
            String $i$a$-assert-AbstractScriptGenerator$makeScript$22 = "wrong model: " + ScriptingTaskKt.getDbms(task) + " vs " + this.dbms;
            throw new AssertionError((Object)$i$a$-assert-AbstractScriptGenerator$makeScript$22);
        }
        ScriptGeneratorDiagnosticListener scriptGeneratorDiagnosticListener = diagnosticTool = this.getDiagnosticTool(task, project);
        if (scriptGeneratorDiagnosticListener != null) {
            scriptGeneratorDiagnosticListener.onStart(task);
        }
        ScriptingContext context = this.createContext(project, task);
        AbstractCodeGenerator generator = this.createGenerator$intellij_database_dialects_base(context);
        if (!(generator instanceof AbstractTransitionCodeGenerator)) {
            generator.prepareScenario();
            ScriptGeneratorDiagnosticListener scriptGeneratorDiagnosticListener2 = diagnosticTool;
            if (scriptGeneratorDiagnosticListener2 != null) {
                scriptGeneratorDiagnosticListener2.onOperationsReady(task, generator.preparedOperations$intellij_database_dialects_base());
            }
            generator.resolve();
            generator.transform();
            ScriptGeneratorDiagnosticListener scriptGeneratorDiagnosticListener3 = diagnosticTool;
            if (scriptGeneratorDiagnosticListener3 != null) {
                scriptGeneratorDiagnosticListener3.onGraphReady(task, generator.getScenario$intellij_database_dialects_base());
            }
            generator.produce();
        } else {
            ((AbstractTransitionCodeGenerator)generator).generate();
        }
        generator.flush();
        ScriptingResult scriptingResult = context.getResult();
        if (scriptingResult == null) {
            scriptingResult = AbstractCodeGeneratorKt.createResult(context);
        }
        return scriptingResult;
    }

    private final ScriptGeneratorDiagnosticListener getDiagnosticTool(ScriptingTask task, Project project) {
        ScriptGeneratorDiagnosticListener scriptGeneratorDiagnosticListener;
        if (task.getOptions().get(ScriptingOptionStatic.RUN_DIAGNOSTIC).booleanValue() || task.getOptions().get(ScriptingOptionStatic.DUMP_TASK).booleanValue()) {
            MessageBus messageBus = project.getMessageBus();
            Topic<ScriptGeneratorDiagnosticListener> topic = ScriptGeneratorDiagnosticListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            scriptGeneratorDiagnosticListener = (ScriptGeneratorDiagnosticListener)messageBus.syncPublisher(topic);
        } else {
            scriptGeneratorDiagnosticListener = null;
        }
        return scriptGeneratorDiagnosticListener;
    }

    @NotNull
    public final ScriptingContext createContext(@NotNull Project project, @NotNull ScriptingTask task) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return new ScriptingContext(project, task, this.getGeneratorHelper());
    }

    @NotNull
    public AbstractCodeGenerator createGenerator$intellij_database_dialects_base(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return switch (WhenMappings.$EnumSwitchMapping$0[context.getTask().getCategory().ordinal()]) {
            case 1, 2 -> this.createCreatingGenerator(context);
            case 3 -> this.createNativeDefinitionsGenerator(context);
            case 4, 5 -> this.createEnableDisableGenerator(context);
            case 6 -> this.createRefreshingGenerator(context);
            case 7 -> this.createExecuteGenerator(context);
            case 8 -> this.createAlterGenerator(context);
            case 9 -> this.createDropGenerator(context);
            case 10 -> this.createTruncateGenerator(context);
            case 11 -> new BaseRecompileGenerator(context);
            default -> new StupidGenerator(context);
        };
    }

    private final BaseCreateGenerator createCreatingGenerator(ScriptingContext context) {
        return new BaseCreateGenerator(context, null, 2, null);
    }

    @NotNull
    public AbstractCodeGenerator createNativeDefinitionsGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new BaseNativeDefinitionsGenerator(context);
    }

    @NotNull
    public AbstractCodeGenerator createEnableDisableGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new BaseEnableDisableGenerator(context);
    }

    @NotNull
    public AbstractCodeGenerator createRefreshingGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new BaseRefreshMatViewGenerator(context);
    }

    @NotNull
    public AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new StupidGenerator(context);
    }

    private final BaseDropGenerator createDropGenerator(ScriptingContext context) {
        return new BaseDropGenerator(context, null, 2, null);
    }

    @NotNull
    public BaseTruncateGenerator createTruncateGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new BaseTruncateGenerator(context);
    }

    @NotNull
    public BaseAlterGenerator createAlterGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Operation it = AbstractCodeGeneratorKt.createRootOperation(context);
        boolean bl = false;
        return new BaseAlterGenerator(context, it, new BaseCreateGenerator(context, it), new BaseDropGenerator(context, it));
    }

    @NotNull
    public String toString() {
        return "ScriptingService for " + this.dbms + ".";
    }

    @Override
    @NotNull
    public ScriptingCapabilities capabilities(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.caps.get(element);
    }

    @Override
    public boolean isEqual(@NotNull BasicElement e1, @NotNull BasicElement e2, @NotNull ScriptingOptions options) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.createAlterProducer(e1, e2, options).isEmpty();
    }

    @NotNull
    public final AlterProducer<?> createAlterProducer(@NotNull BasicElement e1, @NotNull BasicElement e2, @NotNull ScriptingOptions options) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ScriptingContext context = this.createFakeContext(options);
        ElementAlteration<BasicElement> elements = new ElementAlteration<BasicElement>(e1, e2);
        ((Map)context.getBySource()).put(e1, elements);
        ((Map)context.getByTarget()).put(e2, elements);
        return this.getGeneratorHelper().createAlterProducer(context, elements);
    }

    private final ScriptingContext createFakeContext(ScriptingOptions options) {
        Project project = DbImplUtilCore.getAnyProject();
        if (project == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        Project project3 = project;
        return this.createContext(project3, new ScriptingInternalTask(this.dbms, ScriptCategory.CREATE_COMPLETE, options));
    }

    @Override
    @Nullable
    public CompositeText reviseSource(@NotNull Project project, @NotNull BasicSourceAware e) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ScriptingInternalTask task = new ScriptingInternalTask(this.dbms, ScriptCategory.CREATE_COMPLETE, null, 4, null);
        return this.getGeneratorHelper().createProducer(this.createContext(project, task), e).revisedSource();
    }

    @Override
    @NotNull
    public String prettyPrint(@NotNull DataType dt) {
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
        return this.getGeneratorHelper().script(dt, null, null);
    }

    @Override
    @Nullable
    public Set<ScriptingOption<?>> availableOptions(@NotNull ScriptingTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return this.getGeneratorHelper().availableOptions(task);
    }

    @Override
    public boolean isOptionSupported(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        return this.getGeneratorHelper().isOptionSupported(option);
    }

    @NotNull
    protected Object createCapsKey(@NotNull BasicElement element) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicMetaObject<?> it = element.getMetaObject();
        boolean bl = false;
        BasicElement basicElement = element;
        if (basicElement instanceof BasicRoutine) {
            object = TuplesKt.to(it, (Object)((Object)((BasicRoutine)element).getRoutineKind()));
        } else if (basicElement instanceof BasicKey) {
            object = TuplesKt.to(it, (Object)((BasicKey)element).isPrimary());
        } else {
            Intrinsics.checkNotNull(it);
            object = it;
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J/\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u001a\u0010\u0011\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012\"\u0006\u0012\u0002\b\u00030\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u000fH\u0002J3\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u001e\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0012\"\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator$CapabilitiesCollector;", "", "<init>", "(Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator;)V", "caps", "Ljava/util/HashMap;", "Lcom/intellij/database/script/generator/ScriptingCapabilities;", "get", "element", "Lcom/intellij/database/model/basic/BasicElement;", "getCaps", "Lcom/intellij/database/dialects/base/generator/ScriptingCapabilitiesImpl;", "project", "Lcom/intellij/openapi/project/Project;", "extractVersions", "", "Lcom/intellij/database/util/Version;", "vs", "", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "([Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;)Ljava/lang/Iterable;", "iter", "merge", "([Ljava/lang/Iterable;)Ljava/lang/Iterable;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nAbstractScriptGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractScriptGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractScriptGenerator$CapabilitiesCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,338:1\n1#2:339\n13472#3,2:340\n*S KotlinDebug\n*F\n+ 1 AbstractScriptGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractScriptGenerator$CapabilitiesCollector\n*L\n230#1:340,2\n*E\n"})
    private final class CapabilitiesCollector {
        @NotNull
        private final HashMap<Object, ScriptingCapabilities> caps = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ScriptingCapabilities get(@NotNull BasicElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Object key2 = AbstractScriptGenerator.this.createCapsKey(element);
            ScriptingCapabilities scriptingCapabilities = this.caps.get(key2);
            if (scriptingCapabilities != null) {
                ScriptingCapabilities it = scriptingCapabilities;
                boolean bl = false;
                return it;
            }
            Project project = DbImplUtilCore.getAnyProject();
            if (project == null) {
                Project project2 = ProjectManager.getInstance().getDefaultProject();
                project = project2;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
            }
            Project project3 = project;
            ScriptingCapabilitiesImpl cap = this.getCaps(project3, element);
            HashMap<Object, ScriptingCapabilities> hashMap = this.caps;
            synchronized (hashMap) {
                boolean bl = false;
                ((Map)this.caps).put(key2, cap);
                Unit unit = Unit.INSTANCE;
            }
            return cap;
        }

        private final ScriptingCapabilitiesImpl getCaps(Project project, BasicElement element) {
            ScriptingInternalTask task = new ScriptingInternalTask(AbstractScriptGenerator.this.getDbms(), ScriptCategory.CREATE_COMPLETE, null, 4, null);
            ScriptingContext context = AbstractScriptGenerator.this.createContext(project, task);
            CreateProducer<?> c2 = AbstractScriptGenerator.this.getGeneratorHelper().createProducer(context, element);
            DropProducer<?> d = AbstractScriptGenerator.this.getGeneratorHelper().createDropProducer(context, element);
            AlterProducer<?> a = AbstractScriptGenerator.this.getGeneratorHelper().createAlterProducer(context, new ElementAlteration<BasicElement>(element, element));
            TruncateProducer<?> t = AbstractScriptGenerator.this.getGeneratorHelper().createTruncateProducer(context, element);
            RecompileProducer<?> r = AbstractScriptGenerator.this.getGeneratorHelper().createRecompileProducer(context, element);
            ScriptingCapabilities.VersionedCapability<Boolean> create2 = c2.canCreate();
            ScriptingCapabilities.VersionedCapability<Boolean> createAlone = c2.canCreateAlone();
            ScriptingCapabilities.VersionedCapability<Boolean> drop = d.canDrop();
            ScriptingCapabilities.VersionedCapability<Boolean> alterAnything = a.canAlterAnything();
            ScriptingCapabilities.VersionedCapability<Boolean> truncate = t.canTruncate();
            ScriptingCapabilities.VersionedCapability<Boolean> refresh = ScriptCategory.REFRESH.getApplicableDbs().value((Object)AbstractScriptGenerator.this.getDbms()) && element instanceof BasicMatView ? AbstractScriptGeneratorKt.getSUPPORTED() : AbstractScriptGeneratorKt.getUNSUPPORTED();
            ScriptingCapabilities.VersionedCapability<Boolean> recompile = r.canRecompile();
            JBIterable jBIterable = element.getMetaObject().getAllProperties().map(arg_0 -> CapabilitiesCollector.getCaps$lambda$2(getCaps.properties.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
            Iterable iterable = (Iterable)jBIterable;
            ScriptGeneratorHelper scriptGeneratorHelper = AbstractScriptGenerator.this.getGeneratorHelper();
            BasicMetaObject<?> basicMetaObject = element.getMetaObject();
            Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
            List properties2 = CollectionsKt.plus((Iterable)iterable, (Iterable)scriptGeneratorHelper.extraProperties(basicMetaObject));
            Sequence props = CollectionsKt.asSequence((Iterable)properties2);
            Map createCaps = MapsKt.toMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)props, arg_0 -> CapabilitiesCollector.getCaps$lambda$3(c2, arg_0)), CapabilitiesCollector::getCaps$lambda$4));
            Map alterCaps = MapsKt.toMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)props, arg_0 -> CapabilitiesCollector.getCaps$lambda$5(a, arg_0)), CapabilitiesCollector::getCaps$lambda$6));
            HashSet conditionals = SequencesKt.toHashSet((Sequence)SequencesKt.filter((Sequence)props, arg_0 -> CapabilitiesCollector.getCaps$lambda$7(c2, arg_0)));
            Map supportedValues = MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)properties2), CapabilitiesCollector::getCaps$lambda$8), arg_0 -> CapabilitiesCollector.getCaps$lambda$10(c2, arg_0)));
            Iterable[] iterableArray = new Iterable[6];
            iterableArray[0] = c2.edgeVersions();
            iterableArray[1] = d.edgeVersions();
            iterableArray[2] = a.edgeVersions();
            ScriptingCapabilities.VersionedCapability[] versionedCapabilityArray = new ScriptingCapabilities.VersionedCapability[]{create2, createAlone, drop, truncate, refresh, recompile};
            iterableArray[3] = this.extractVersions(versionedCapabilityArray);
            iterableArray[4] = this.extractVersions(createCaps.values());
            iterableArray[5] = this.extractVersions(alterCaps.values());
            return new ScriptingCapabilitiesImpl(create2, createAlone, c2.createVersion(), drop, alterAnything, truncate, refresh, recompile, createCaps, alterCaps, conditionals, supportedValues, this.merge(iterableArray));
        }

        private final Iterable<Version> extractVersions(ScriptingCapabilities.VersionedCapability<?> ... vs) {
            JBIterable jBIterable = JBIterable.of((Object[])Arrays.copyOf(vs, vs.length));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            return this.extractVersions((Iterable)jBIterable);
        }

        private final Iterable<Version> extractVersions(Iterable<? extends ScriptingCapabilities.VersionedCapability<?>> iter) {
            JBIterable jBIterable = JBIterable.from(iter).flatMap(arg_0 -> CapabilitiesCollector.extractVersions$lambda$14(arg_0 -> CapabilitiesCollector.extractVersions$lambda$13(this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"flatMap(...)");
            return (Iterable)jBIterable;
        }

        private final Iterable<Version> merge(Iterable<Version> ... vs) {
            TreeSet res2 = new TreeSet();
            Iterable<Version>[] $this$forEach$iv = vs;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                Iterable<Version> element$iv;
                Iterable<Version> it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                CollectionsKt.toCollection(it, (Collection)res2);
            }
            return CollectionsKt.toList((Iterable)res2);
        }

        private static final BasicMetaPropertyId getCaps$lambda$2(Function1 $tmp0, Object p0) {
            return (BasicMetaPropertyId)$tmp0.invoke(p0);
        }

        private static final Pair getCaps$lambda$3(CreateProducer $c, BasicMetaId it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return TuplesKt.to((Object)it, $c.canCreateWith(it));
        }

        private static final boolean getCaps$lambda$4(Pair it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !Intrinsics.areEqual((Object)it.getSecond(), AbstractScriptGeneratorKt.getUNSUPPORTED());
        }

        private static final Pair getCaps$lambda$5(AlterProducer $a, BasicMetaId it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return TuplesKt.to((Object)it, $a.canAlter(it));
        }

        private static final boolean getCaps$lambda$6(Pair it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !Intrinsics.areEqual((Object)it.getSecond(), AbstractScriptGeneratorKt.getUNSUPPORTED());
        }

        private static final boolean getCaps$lambda$7(CreateProducer $c, BasicMetaId it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $c.isConditional(it);
        }

        private static final BasicMetaPropertyId getCaps$lambda$8(BasicMetaPropertyId it) {
            return it.tryCast(Enum.class);
        }

        private static final Pair getCaps$lambda$10(CreateProducer $c, BasicMetaPropertyId it) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            List<Enum<?>> list = $c.supportedValues(it);
            if (list != null) {
                List<Enum<?>> v = list;
                boolean bl = false;
                pair = TuplesKt.to((Object)it, v);
            } else {
                pair = null;
            }
            return pair;
        }

        private static final Iterable extractVersions$lambda$13$lambda$11(CapabilitiesCollector this$0, ScriptingCapabilities.VersionedCapability it) {
            ScriptingCapabilities.VersionedCapability[] versionedCapabilityArray = new ScriptingCapabilities.VersionedCapability[1];
            Intrinsics.checkNotNull((Object)it);
            versionedCapabilityArray[0] = it;
            return this$0.extractVersions(versionedCapabilityArray);
        }

        private static final Iterable extractVersions$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
            return (Iterable)$tmp0.invoke(p0);
        }

        private static final Iterable extractVersions$lambda$13(CapabilitiesCollector this$0, ScriptingCapabilities.VersionedCapability it) {
            JBIterable jBIterable;
            ScriptingCapabilities.VersionedCapability versionedCapability = it;
            if (versionedCapability instanceof SupportedSinceImpl) {
                JBIterable jBIterable2 = JBIterable.of((Object)((SupportedSinceImpl)it).getSince());
                jBIterable = jBIterable2;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
            } else if (versionedCapability instanceof OrSupportedImpl) {
                JBIterable jBIterable3 = JBIterable.from(((OrSupportedImpl)it).getTerms()).flatMap(arg_0 -> CapabilitiesCollector.extractVersions$lambda$13$lambda$12(arg_0 -> CapabilitiesCollector.extractVersions$lambda$13$lambda$11(this$0, arg_0), arg_0));
                jBIterable = jBIterable3;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"flatMap(...)");
            } else {
                JBIterable jBIterable4 = JBIterable.empty();
                jBIterable = jBIterable4;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"empty(...)");
            }
            return (Iterable)jBIterable;
        }

        private static final Iterable extractVersions$lambda$14(Function1 $tmp0, Object p0) {
            return (Iterable)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator$StupidGenerator;", "Lcom/intellij/database/dialects/base/generator/AbstractTransitionCodeGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "<init>", "(Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator;Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "prepareScenario", "", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "intellij.database.dialects.base"})
    protected final class StupidGenerator
    extends AbstractTransitionCodeGenerator {
        public StupidGenerator(ScriptingContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            AbstractCodeGenerator.coding$default(this, null, false, () -> StupidGenerator._init_$lambda$0(this), 3, null);
        }

        @Override
        public void prepareScenario() {
        }

        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            AbstractCodeGenerator.coding$default(this, null, false, () -> StupidGenerator.generateElement$lambda$1(this, element), 3, null);
        }

        private static final Unit _init_$lambda$0(StupidGenerator this$0) {
            CodeTextBuilder.append$default(this$0.getBuilder(), "-- We don't know how to generate " + this$0.getContext().getTask().getCategory().name() + " :(", null, false, null, 14, null);
            return Unit.INSTANCE;
        }

        private static final Unit generateElement$lambda$1(StupidGenerator this$0, BasicElement $element) {
            CodeTextBuilder.append$default(this$0.getBuilder(), "-- " + $element.getKind().code() + " " + $element.getName(), null, false, null, 14, null);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptCategory.values().length];
            try {
                nArray[ScriptCategory.CREATE_DEFINITION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.CREATE_COMPLETE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.NATIVE_DEFINITION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.ENABLE_CONSTRAINTS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.DISABLE_CONSTRAINTS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.REFRESH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.EXECUTE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.ALTER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.DROP_COMPLETE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.TRUNCATE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.RECOMPILE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

