/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.google.common.collect.ImmutableList;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.AbstractCodeGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.LinkedPriorityQueue;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.OperationType;
import com.intellij.database.dialects.base.generator.PreOrderComparator;
import com.intellij.database.dialects.base.generator.Producer;
import com.intellij.database.dialects.base.generator.Scenario;
import com.intellij.database.dialects.base.generator.ScenarioDot;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.ScriptingResultImpl;
import com.intellij.database.dialects.base.generator.SimpleProducer;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a0\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\r\u001a0\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\r\u001a\"\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0002\u001a\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002\u00a8\u0006\u0013"}, d2={"createResult", "Lcom/intellij/database/script/generator/ScriptingResult;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "createRootOperation", "Lcom/intellij/database/dialects/base/generator/Operation;", "createRootProducer", "Lcom/intellij/database/dialects/base/generator/Producer;", "processOperationsNoDeps", "", "operations", "", "processor", "Lkotlin/Function1;", "processOperations", "generateSuccessors", "Lcom/intellij/util/containers/MultiMap;", "createPreOrderComparator", "Ljava/util/Comparator;", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nAbstractCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCodeGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractCodeGeneratorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,523:1\n1563#2:524\n1634#2,3:525\n1869#2,2:528\n1869#2,2:530\n1869#2,2:532\n2423#2,14:534\n1869#2:549\n1869#2,2:550\n1870#2:552\n1#3:548\n*S KotlinDebug\n*F\n+ 1 AbstractCodeGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractCodeGeneratorKt\n*L\n385#1:524\n385#1:525,3\n409#1:528,2\n416#1:530,2\n426#1:532,2\n432#1:534,14\n460#1:549\n464#1:550,2\n460#1:552\n*E\n"})
public final class AbstractCodeGeneratorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ScriptingResult createResult(@NotNull ScriptingContext context) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getOptions().get(ScriptingOptionStatic.REFORMAT).booleanValue() && context.getSqlLang() != null && !AbstractCodeGenerator.Companion.getIgnoreFormatting()) {
            void $this$mapTo$iv$iv;
            $this$map$iv = context.getScript();
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CompositeText compositeText = (CompositeText)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Project project = context.getProject();
                SqlLanguageDialect sqlLanguageDialect = context.getSqlLang();
                Intrinsics.checkNotNull((Object)sqlLanguageDialect);
                collection.add(DbSrcUtilsCore.formatCompositeTextSafe(project, sqlLanguageDialect, null, (CompositeText)it, context.getOptions().get(ScriptingOptionStatic.CODE_STYLE)));
            }
            list = (List)destination$iv$iv;
        } else {
            $this$map$iv = ImmutableList.copyOf((Collection)context.getScript());
            Intrinsics.checkNotNull((Object)$this$map$iv);
            list = (List)$this$map$iv;
        }
        List script2 = list;
        context.getScript().clear();
        String stmtDelimiter = context.getOptions().get(ScriptingOptionStatic.USE_SEMICOLON) != false ? ";" : context.getHelper().getStatementDelimiterStr();
        boolean stmtDelimiterOwnsLine = !Intrinsics.areEqual((Object)stmtDelimiter, (Object)";") && context.getHelper().getStatementDelimiterOwnsLine() || Intrinsics.areEqual((Object)stmtDelimiter, (Object)";") && context.getCodeStyle().SCRIPT_STMT_SEMICOLON_WRAP == 1;
        return new ScriptingResultImpl(script2, stmtDelimiter, stmtDelimiterOwnsLine);
    }

    @NotNull
    public static final Operation createRootOperation(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Operation(AbstractCodeGeneratorKt.createRootProducer(context));
    }

    private static final Producer createRootProducer(ScriptingContext context) {
        return new SimpleProducer(AbstractCodeGenerator.Companion.getROOT(), (Function1<? super Producer, Unit>)((Function1)arg_0 -> AbstractCodeGeneratorKt.createRootProducer$lambda$2(context, arg_0)));
    }

    public static final void processOperationsNoDeps(@NotNull ScriptingContext context, @NotNull Iterable<Operation> operations, @NotNull Function1<? super Operation, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Comparator<Operation> cmp = AbstractCodeGeneratorKt.createPreOrderComparator();
        Iterable $this$forEach$iv = CollectionsKt.sortedWith(operations, cmp);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            processor2.invoke(element$iv);
        }
    }

    public static final void processOperations(@NotNull ScriptingContext context, @NotNull Iterable<Operation> operations, @NotNull Function1<? super Operation, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Comparator<Operation> cmp = AbstractCodeGeneratorKt.createPreOrderComparator();
        MultiMap<Operation, Operation> successors = AbstractCodeGeneratorKt.generateSuccessors(operations);
        LinkedPriorityQueue<Operation> queue = new LinkedPriorityQueue<Operation>(cmp);
        Iterable<Operation> $this$forEach$iv = operations;
        boolean $i$f$forEach = false;
        for (Operation element$iv : $this$forEach$iv) {
            Operation it = element$iv;
            boolean bl = false;
            if (it.getIncidence() != 0) continue;
            queue.add(it);
        }
        while (!successors.keySet().isEmpty()) {
            String string;
            boolean bl;
            Operation operation;
            while (!queue.isEmpty()) {
                Operation op;
                Intrinsics.checkNotNull((Object)queue.poll());
                Collection rev = successors.remove((Object)op);
                if (rev == null) continue;
                ProgressManager.checkCanceled();
                processor2.invoke((Object)op);
                Iterable $this$forEach$iv2 = rev;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Operation it = (Operation)element$iv;
                    boolean bl2 = false;
                    it.setIncidence(it.getIncidence() + -1);
                    it.getIncidence();
                    if (it.getIncidence() != 0) continue;
                    Intrinsics.checkNotNull((Object)it);
                    queue.add(it);
                }
            }
            if (successors.keySet().isEmpty()) continue;
            Object $this$minByOrNull$iv = operations;
            boolean $i$f$minByOrNull = false;
            Iterator<Operation> iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                operation = null;
            } else {
                Operation minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    operation = minElem$iv;
                } else {
                    Operation it = minElem$iv;
                    boolean bl3 = false;
                    int minValue$iv = successors.containsKey((Object)it) ? it.getIncidence() : Integer.MAX_VALUE;
                    do {
                        int v$iv;
                        Operation e$iv;
                        Operation it2 = e$iv = iterator$iv.next();
                        $i$a$-minByOrNull-AbstractCodeGeneratorKt$processOperations$breaker$1 = false;
                        int n = v$iv = successors.containsKey((Object)it2) ? it2.getIncidence() : Integer.MAX_VALUE;
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    operation = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(operation);
            Operation breaker = operation;
            queue.add(breaker);
            $this$minByOrNull$iv = AbstractCodeGenerator.Companion.getERROR();
            processor2.invoke((Object)new Operation(new BaseProducer(context, (OperationType)$this$minByOrNull$iv){
                private ScriptingOptions options;
                {
                    this.options = $context.getOptions();
                }

                public ScriptingOptions getOptions() {
                    return this.options;
                }

                public void setOptions(ScriptingOptions scriptingOptions) {
                    Intrinsics.checkNotNullParameter((Object)scriptingOptions, (String)"<set-?>");
                    this.options = scriptingOptions;
                }

                public void produce() {
                    this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)processOperations.3::produce$lambda$0));
                }

                private static final Unit produce$lambda$0(ScriptingContext.NewCodingAdapter $this$newCoding) {
                    Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
                    $this$newCoding.error("Cyclic dependencies found");
                    return Unit.INSTANCE;
                }
            }));
            if (context.getTask().getCategory() != ScriptCategory.CREATE_DEFINITION && context.getTask().getCategory() != ScriptCategory.CREATE_COMPLETE) continue;
            Object object = JBIterable.generate((Object)CollectionsKt.first(operations), arg_0 -> AbstractCodeGeneratorKt.processOperations$lambda$7(AbstractCodeGeneratorKt::processOperations$lambda$6, arg_0)).first();
            Intrinsics.checkNotNull((Object)object);
            Operation root = (Operation)object;
            long mark2 = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            TimeSource.Monotonic.ValueTimeMark valueTimeMark = AbstractCodeGenerator.Companion.getLastReportedCycle-LFT3Okc();
            if (valueTimeMark != null) {
                long it = valueTimeMark.unbox-impl();
                boolean bl4 = false;
                bl = Duration.compareTo-LRDsOJo((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)mark2, (long)it), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)) < 0;
            } else {
                bl = false;
            }
            if (bl) {
                string = "<no dump: rate limit>";
            } else {
                AbstractCodeGenerator.Companion.setLastReportedCycle-rEXM0dE(TimeSource.Monotonic.ValueTimeMark.box-impl((long)mark2));
                String string2 = ScenarioDot.build$default(new ScenarioDot(new Scenario(root)), null, 1, null).toString();
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            }
            String cycleDesc = string;
            AbstractCodeGenerator.Companion.getLOG().warn("Found cycle\n" + cycleDesc);
        }
    }

    private static final MultiMap<Operation, Operation> generateSuccessors(Iterable<Operation> operations) {
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet(...)");
        MultiMap successors = multiMap;
        Iterable<Operation> $this$forEach$iv = operations;
        boolean $i$f$forEach = false;
        Iterator<Operation> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Operation element$iv;
            Operation op = element$iv = iterator.next();
            boolean bl = false;
            Set<Operation> flatPreceders = op.getFlatPreceders();
            successors.getModifiable((Object)op);
            int incidence = 0;
            Iterable $this$forEach$iv2 = flatPreceders;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Operation p2 = (Operation)element$iv2;
                boolean bl2 = false;
                if (!CollectionsKt.contains(operations, (Object)p2)) continue;
                successors.putValue((Object)p2, (Object)op);
                ++incidence;
            }
            op.setIncidence(incidence);
        }
        return successors;
    }

    private static final Comparator<Operation> createPreOrderComparator() {
        return new PreOrderComparator();
    }

    private static final Unit createRootProducer$lambda$2$lambda$1(Operation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.getProducer().produce();
        return Unit.INSTANCE;
    }

    private static final Unit createRootProducer$lambda$2(ScriptingContext $context, Producer $this$SimpleProducer) {
        Intrinsics.checkNotNullParameter((Object)$this$SimpleProducer, (String)"$this$SimpleProducer");
        AbstractCodeGeneratorKt.processOperations($context, (Iterable<Operation>)$this$SimpleProducer.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)AbstractCodeGeneratorKt::createRootProducer$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }

    private static final Operation processOperations$lambda$6(Operation it) {
        return (Operation)it.getParent();
    }

    private static final Operation processOperations$lambda$7(Function1 $tmp0, Object p0) {
        return (Operation)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Comparator access$createPreOrderComparator() {
        return AbstractCodeGeneratorKt.createPreOrderComparator();
    }
}

