/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram.actions;

import com.intellij.database.actions.ddl.CreateObjectAction;
import com.intellij.database.actions.ddl.DbModifyObjectDialog;
import com.intellij.database.dbimport.editor.DbImportDialog;
import com.intellij.database.diagram.actions.DbDiagramRefresher;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DbContextDataSourceElements;
import com.intellij.database.view.DbContextElementsKt;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/diagram/actions/DbDiagramCreateAction;", "Lcom/intellij/database/actions/ddl/CreateObjectAction;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "<init>", "(Lcom/intellij/database/model/meta/BasicMetaObject;Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;)V", "getContextElement", "Lcom/intellij/database/psi/DbElement;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "", "intellij.database.diagrams"})
@SourceDebugExtension(value={"SMAP\nDbDiagramCreateObjects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbDiagramCreateObjects.kt\ncom/intellij/database/diagram/actions/DbDiagramCreateAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class DbDiagramCreateAction
extends CreateObjectAction {
    public DbDiagramCreateAction(@NotNull BasicMetaObject<?> meta, @NotNull ModelHelper.ObjectKindVariant variant) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        super(meta, variant);
    }

    private final DbElement getContextElement(AnActionEvent e) {
        DbContextDataSourceElements<?> dbContextDataSourceElements = DbContextElementsKt.getSingleDsContextElements(e);
        return (DbElement)(dbContextDataSourceElements != null && (dbContextDataSourceElements = dbContextDataSourceElements.asIterable()) != null ? dbContextDataSourceElements.first() : null);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        SearchPath searchPath;
        BasicSchema schema;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DbElement dbElement = this.getContextElement(e);
        if (dbElement == null) {
            return;
        }
        DbElement contextElement = dbElement;
        Object object = contextElement.getDelegate();
        BasicElement basicElement = object instanceof BasicElement ? (BasicElement)object : null;
        if (basicElement == null) {
            return;
        }
        BasicElement context = basicElement;
        BasicObjectNode basicObjectNode = CreateObjectAction.getParent(context, this.myMeta);
        if (basicObjectNode == null) {
            return;
        }
        BasicObjectNode parent = basicObjectNode;
        BasicSchema basicSchema = schema = context instanceof BasicSchema ? (BasicSchema)context : context.getSchema();
        if (basicSchema != null) {
            BasicSchema it = basicSchema;
            boolean bl = false;
            searchPath = SearchPath.of(ObjectPaths.of(it));
        } else {
            searchPath = null;
        }
        SearchPath searchPath2 = searchPath;
        RawDataSource rawDataSource = contextElement.getDataSource().getDelegateDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)rawDataSource, (String)"getDelegateDataSource(...)");
        RawDataSource dataSource = rawDataSource;
        DasModel dasModel = dataSource.getModel();
        BasicModel basicModel = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (basicModel == null) {
            return;
        }
        BasicModel model = basicModel;
        DiagramBuilder diagramBuilder = DiagramAction.getBuilder((AnActionEvent)e);
        if (diagramBuilder == null) {
            return;
        }
        DiagramBuilder builder = diagramBuilder;
        CreateObjectAction.CreateBootstrapper bootstrapper = new CreateObjectAction.CreateBootstrapper(this, project2, dataSource, model, searchPath2, parent, this.myMeta, this.myVariant, SetsKt.setOf((Object)context), new DbDiagramRefresher(builder, model));
        DbImportDialog.Companion.withCoroutineScopeBoundToDialog((Function1<? super CoroutineScope, ? extends DialogWrapper>)((Function1)arg_0 -> DbDiagramCreateAction.actionPerformed$lambda$2(bootstrapper, arg_0)));
    }

    private static final DialogWrapper actionPerformed$lambda$2(CreateObjectAction.CreateBootstrapper $bootstrapper, CoroutineScope cs) {
        DbModifyObjectDialog dbModifyObjectDialog;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        DbModifyObjectDialog $this$actionPerformed_u24lambda_u242_u24lambda_u241 = dbModifyObjectDialog = new DbModifyObjectDialog(cs, $bootstrapper, null);
        boolean bl = false;
        $this$actionPerformed_u24lambda_u242_u24lambda_u241.initAndShow();
        return dbModifyObjectDialog;
    }
}

