/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor;

import com.intellij.database.dbimport.editor.data.CsvSourceData;
import com.intellij.database.dbimport.editor.data.DbQuerySourceData;
import com.intellij.database.dbimport.editor.data.DbTableSourceData;
import com.intellij.database.dbimport.editor.data.DetectedColumnsData;
import com.intellij.database.dbimport.editor.data.MappingData;
import com.intellij.database.dbimport.editor.data.ScriptedSourceData;
import com.intellij.database.dbimport.editor.editor.DbAutoDefinitionEditor;
import com.intellij.database.dbimport.editor.editor.DbAutoReferenceEditor;
import com.intellij.database.dbimport.editor.editor.DbCharsetEditor;
import com.intellij.database.dbimport.editor.editor.DbCrossDsReferenceEditor;
import com.intellij.database.dbimport.editor.editor.DbCsvColumnsEditor;
import com.intellij.database.dbimport.editor.editor.DbCsvFormatEditor;
import com.intellij.database.dbimport.editor.editor.DbErrorsPathEditor;
import com.intellij.database.dbimport.editor.editor.DbMappingColumnsEditor;
import com.intellij.database.dbimport.editor.editor.DbPathEditor;
import com.intellij.database.dbimport.editor.editor.DbScriptLoaderEditor;
import com.intellij.database.dbimport.editor.model.state.DbAutoDefinitionState;
import com.intellij.database.dbimport.editor.model.state.DbAutoReferenceModelState;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.schemaEditor.DbObjectEditorFactoryBroker;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.database.schemaEditor.model.state.DbDirectReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.database.schemaEditor.model.state.DbTextModelState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u0005\"\b\b\u0000\u0010\u0006*\u00020\b\"\b\b\u0001\u0010\u0007*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\rH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00100\rH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dbimport/editor/DbImportEditorFactory;", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactoryBroker;", "<init>", "()V", "createObjectEditor", "Lcom/intellij/database/schemaEditor/ui/DbEditor;", "E", "S", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/schemaEditor/model/state/DbModelState;", "controller", "Lcom/intellij/database/schemaEditor/ui/DbEditorController;", "model", "Lcom/intellij/database/schemaEditor/model/DbModelRef;", "isBigSqlEditor", "", "Lcom/intellij/database/schemaEditor/model/state/DbTextModelState;", "intellij.database.impl"})
public final class DbImportEditorFactory
extends DbObjectEditorFactoryBroker {
    @Override
    @Nullable
    public <E extends BasicElement, S extends DbModelState> DbEditor<E, S> createObjectEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> model) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        S s = model.getState();
        Intrinsics.checkNotNullExpressionValue(s, (String)"getState(...)");
        S state = s;
        if (state instanceof DbAutoDefinitionState) {
            return new DbAutoDefinitionEditor<E>(controller, model.castState(state));
        }
        BasicMetaId basicMetaId = model.getModelInternalKey();
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaId, (String)"getModelInternalKey(...)");
        BasicMetaId key2 = basicMetaId;
        if (key2 == MappingData.COLUMN_MAPPINGS && state instanceof DbCollectionModelState) {
            DbModelRef<E, DbModelState> dbModelRef = model.castState((DbModelState)((DbCollectionModelState)state).tryCast(MappingData.COLUMN_MAPPINGS));
            Intrinsics.checkNotNullExpressionValue(dbModelRef, (String)"castState(...)");
            return new DbMappingColumnsEditor<E>(controller, dbModelRef);
        }
        if (key2 == DetectedColumnsData.COLUMNS && state instanceof DbCollectionModelState) {
            return new DbCsvColumnsEditor<E>(controller, model.castState((DbModelState)((DbCollectionModelState)state).tryCast(DetectedColumnsData.COLUMNS)));
        }
        if (key2 == MappingData.TABLE_REF && state instanceof DbAutoReferenceModelState) {
            DbModelRef<E, S> dbModelRef = model.castState(state);
            Intrinsics.checkNotNullExpressionValue(dbModelRef, (String)"castState(...)");
            return new DbAutoReferenceEditor(controller, dbModelRef);
        }
        if (key2 == MappingData.SCHEMA_REF && state instanceof DbDirectReferenceModelState) {
            DbDirectReferenceModelState cfr_ignored_0 = (DbDirectReferenceModelState)state;
            return new DbCrossDsReferenceEditor(controller, model.castState(state));
        }
        if (key2 == DbTableSourceData.TABLE_REF && state instanceof DbDirectReferenceModelState) {
            DbDirectReferenceModelState cfr_ignored_1 = (DbDirectReferenceModelState)state;
            return new DbCrossDsReferenceEditor(controller, model.castState(state));
        }
        if (key2 == DbQuerySourceData.TARGET_REF && state instanceof DbDirectReferenceModelState) {
            DbDirectReferenceModelState cfr_ignored_2 = (DbDirectReferenceModelState)state;
            return new DbCrossDsReferenceEditor(controller, model.castState(state));
        }
        if (key2 == CsvSourceData.PATH && state instanceof DbTextModelState) {
            return new DbPathEditor<E>(controller, model.castState(state));
        }
        if (key2 == MappingData.ERRORS_PATH && state instanceof DbTextModelState) {
            return new DbErrorsPathEditor<E>(controller, model.castState(state));
        }
        if (key2 == CsvSourceData.CHARSET && state instanceof DbSingleValueModelState) {
            DbSingleValueModelState cfr_ignored_3 = (DbSingleValueModelState)state;
            return new DbCharsetEditor<E>(controller, model.castState(state));
        }
        if (key2 == CsvSourceData.CSV_FORMAT && state instanceof DbSingleValueModelState) {
            DbSingleValueModelState cfr_ignored_4 = (DbSingleValueModelState)state;
            return new DbCsvFormatEditor<E>(controller, model.castState(state));
        }
        if (key2 == ScriptedSourceData.LOADER && state instanceof DbSingleValueModelState) {
            DbSingleValueModelState cfr_ignored_5 = (DbSingleValueModelState)state;
            return new DbScriptLoaderEditor<E>(controller, model.castState(state));
        }
        return super.createObjectEditor(controller, model);
    }

    @Override
    public boolean isBigSqlEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<?, DbTextModelState> model) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return super.isBigSqlEditor(controller, model) || model.getModelInternalKey() == DbQuerySourceData.QUERY;
    }
}

