/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.editor.DbImportAutoTableManager;
import com.intellij.database.dbimport.editor.DbImportCachedDataManager;
import com.intellij.database.dbimport.editor.DbImportDataPreviewManager;
import com.intellij.database.dbimport.editor.DbImportDdlPreviewManager;
import com.intellij.database.dbimport.editor.DbImportDialog;
import com.intellij.database.dbimport.editor.DbImportDialogPanel;
import com.intellij.database.dbimport.editor.DbImportEditorBuilder;
import com.intellij.database.dbimport.editor.DbImportRunner;
import com.intellij.database.dbimport.editor.data.DataSourceData;
import com.intellij.database.dbimport.editor.data.FakeRootData;
import com.intellij.database.dbimport.editor.data.MappingData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.WrapperElement;
import com.intellij.database.schemaEditor.DbEditorDialogBase;
import com.intellij.database.schemaEditor.DbEditorDialogModel;
import com.intellij.database.schemaEditor.DbEditorDialogUi;
import com.intellij.database.schemaEditor.DbEditorModality;
import com.intellij.database.schemaEditor.DbModelTransactionManager;
import com.intellij.database.schemaEditor.DbObjectEditorBuilder;
import com.intellij.database.schemaEditor.DbObjectEditorDialogPanelBase;
import com.intellij.database.schemaEditor.DbObjectEditorDialogPanelBaseKt;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.state.DbReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorUtilsKt;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditor;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.grid.scripting.impl.DataLoaderManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Dimension;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExceptionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 V2\u00020\u0001:\u0003TUVB\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020\u001b2\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0!H\u0002J$\u0010\u001c\u001a\u00020\u001b2\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u001c\u0010$\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010'\u001a\u00020%H\u0002J\u001c\u0010(\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010'\u001a\u00020%H\u0002J\u001c\u0010)\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010'\u001a\u00020%H\u0002J \u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0+2\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002J\u001e\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0-2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002J\u000e\u0010.\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\u000201H\u0082@\u00a2\u0006\u0002\u0010/J\u000e\u00102\u001a\u000201H\u0082@\u00a2\u0006\u0002\u0010/J4\u00103\u001a\u0002012\"\u00104\u001a\u001e\b\u0001\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020107\u0012\u0006\u0012\u0004\u0018\u00010805H\u0080@\u00a2\u0006\u0004\b9\u0010:J\u000e\u0010;\u001a\u000201H\u0082@\u00a2\u0006\u0002\u0010/J\u001c\u0010<\u001a\u0002012\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u001eH\u0082@\u00a2\u0006\u0002\u0010?J\u0017\u0010@\u001a\u00020\u001b2\r\u0010A\u001a\t\u0018\u00010B\u00a2\u0006\u0002\bCH\u0002J&\u0010D\u001a\u0012\u0012\u0004\u0012\u00020F\u0012\u0006\u0012\u0004\u0018\u00010G\u0018\u00010E2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u001eH\u0002J(\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002J,\u0010O\u001a\u0002012\f\u0010P\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001e2\f\u0010Q\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001e2\u0006\u0010R\u001a\u000201H\u0002J2\u0010S\u001a\u0002012\"\u00104\u001a\u001e\b\u0001\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020107\u0012\u0006\u0012\u0004\u0018\u00010805H\u0082@\u00a2\u0006\u0002\u0010:R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006W"}, d2={"Lcom/intellij/database/dbimport/editor/DbImportDialogPanel;", "Lcom/intellij/database/schemaEditor/DbEditorDialogBase$DbEditorDialogPanel;", "editorDialogUi", "Lcom/intellij/database/schemaEditor/DbEditorDialogUi;", "<init>", "(Lcom/intellij/database/schemaEditor/DbEditorDialogUi;)V", "getEditorDialogUi", "()Lcom/intellij/database/schemaEditor/DbEditorDialogUi;", "mySplitter", "Lcom/intellij/openapi/ui/Splitter;", "myErrorWrapper", "Lcom/intellij/database/schemaEditor/DbObjectEditorDialogPanelBase$ErrorWrapperPanel;", "myTabs", "Lcom/intellij/ui/tabs/impl/JBEditorTabs;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "dialogModel", "Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogModel;", "getDialogModel", "()Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogModel;", "editor", "Lcom/intellij/database/schemaEditor/ui/DbStructureEditor;", "getEditor", "()Lcom/intellij/database/schemaEditor/ui/DbStructureEditor;", "addPreviewListeners", "", "updatePreviews", "identity", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "removeUndesiredAndUnorderedPreviews", "desired", "", "prevSelection", "Lcom/intellij/ui/tabs/TabInfo;", "addPreview", "", "id", "index", "addDataPreview", "addDdlPreview", "collectPreviewIds", "", "extraPreviews", "Lcom/intellij/util/containers/JBIterable;", "updateFromEditor", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitManagers", "", "joinManagers", "performOperations", "importExecutor", "Lkotlin/Function2;", "Lcom/intellij/database/dbimport/editor/DbImportRunner;", "Lkotlin/coroutines/Continuation;", "", "performOperations$intellij_database_impl", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runScripts", "runScript", "dsRootId", "Lcom/intellij/database/model/basic/BasicRoot;", "(Lcom/intellij/database/schemaEditor/ElementIdentity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showErrorNotification", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "generateScript", "Lkotlin/Pair;", "Lcom/intellij/database/script/generator/ScriptingResult;", "Lcom/intellij/database/util/SearchPath;", "getSearchPathObject", "Lcom/intellij/database/model/basic/BasicNamespace;", "controller", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "owner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "exampleId", "isAncestor", "ancestor", "it", "strict", "runImport", "ImportDialogBootstrapper", "ImportDialogModel", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbImportDialogPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbImportDialogPanel.kt\ncom/intellij/database/dbimport/editor/DbImportDialogPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n1878#2,3:395\n1878#2,3:398\n1869#2,2:402\n1#3:401\n*S KotlinDebug\n*F\n+ 1 DbImportDialogPanel.kt\ncom/intellij/database/dbimport/editor/DbImportDialogPanel\n*L\n106#1:395,3\n122#1:398,3\n213#1:402,2\n*E\n"})
public final class DbImportDialogPanel
implements DbEditorDialogBase.DbEditorDialogPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DbEditorDialogUi editorDialogUi;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final DbObjectEditorDialogPanelBase.ErrorWrapperPanel myErrorWrapper;
    @NotNull
    private final JBEditorTabs myTabs;
    @NotNull
    private final JComponent component;
    @NotNull
    private static final Logger LOG;

    public DbImportDialogPanel(@NotNull DbEditorDialogUi editorDialogUi) {
        Intrinsics.checkNotNullParameter((Object)editorDialogUi, (String)"editorDialogUi");
        this.editorDialogUi = editorDialogUi;
        this.getEditorDialogUi().setOnChanged((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>((Object)this){

            public final Object invoke(Continuation<? super Unit> $completion) {
                return ((DbImportDialogPanel)this.receiver).updateFromEditor((Continuation<? super Unit>)$completion);
            }
        }));
        Project project = this.getEditorDialogUi().getEditorController().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        this.myTabs = new DbStructureEditor.ProperTabs(project2, this.getEditorDialogUi());
        this.myTabs.setEmptyText(DatabaseBundle.message("status.text.select.source.to.see.preview", new Object[0]));
        this.myTabs.setMinimumSize((Dimension)JBUI.size((int)300, (int)120));
        this.myTabs.setPreferredSize((Dimension)JBUI.size((int)300, (int)300));
        this.mySplitter = new Splitter(true, 0.6f);
        this.mySplitter.setDividerPositionStrategy(Splitter.DividerPositionStrategy.DISTRIBUTE);
        this.mySplitter.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_FIRST_MIN_SIZE);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setHonorComponentsPreferredSize(false);
        this.mySplitter.setUseViewportViewSizes(true);
        this.mySplitter.setFirstComponent(this.getEditorDialogUi().getEditor().getComponent());
        this.mySplitter.setSecondComponent(this.myTabs.getComponent());
        this.myErrorWrapper = new DbObjectEditorDialogPanelBase.ErrorWrapperPanel();
        this.addPreviewListeners();
        this.component = this.myErrorWrapper.placeAfter((JComponent)this.mySplitter);
    }

    @Override
    @NotNull
    public DbEditorDialogUi getEditorDialogUi() {
        return this.editorDialogUi;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public ImportDialogModel getDialogModel() {
        DbEditorDialogModel dbEditorDialogModel = this.getEditorDialogUi().getDialogModel();
        Intrinsics.checkNotNull((Object)dbEditorDialogModel, (String)"null cannot be cast to non-null type com.intellij.database.dbimport.editor.DbImportDialogPanel.ImportDialogModel");
        return (ImportDialogModel)dbEditorDialogModel;
    }

    private final DbStructureEditor<?> getEditor() {
        DbVisualEditor<?, ?> dbVisualEditor = this.getEditorDialogUi().getEditor();
        Intrinsics.checkNotNull(dbVisualEditor, (String)"null cannot be cast to non-null type com.intellij.database.schemaEditor.ui.DbStructureEditor<*>");
        return (DbStructureEditor)dbVisualEditor;
    }

    private final void addPreviewListeners() {
        this.getEditor().addTabsListener(arg_0 -> DbImportDialogPanel.addPreviewListeners$lambda$0(this, arg_0));
        DbModelTransactionManager dbModelTransactionManager = this.getEditorDialogUi().getEditorController().getModelController().getTransactionManager();
        Runnable runnable = () -> DbImportDialogPanel.addPreviewListeners$lambda$2(this);
        DbEditorModelController dbEditorModelController = this.getEditorDialogUi().getEditorController().getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
        dbModelTransactionManager.whenFinished(runnable, dbEditorModelController);
    }

    private final void updatePreviews(ElementIdentity<?> identity) {
        Set<ElementIdentity<?>> desired = this.collectPreviewIds(identity);
        TabInfo prevSelection = this.myTabs.getSelectedInfo();
        this.removeUndesiredAndUnorderedPreviews(desired);
        this.updatePreviews(desired, prevSelection);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeUndesiredAndUnorderedPreviews(Set<? extends ElementIdentity<?>> desired) {
        Object2IntOpenHashMap indices = new Object2IntOpenHashMap();
        indices.defaultReturnValue(-1);
        Iterable $this$forEachIndexed$iv = desired;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void id;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ElementIdentity elementIdentity = (ElementIdentity)item$iv;
            int index = n;
            boolean bl = false;
            ((Map)indices).put(id, index);
        }
        int prevIdx = 0;
        for (TabInfo tab : CollectionsKt.toList((Iterable)this.myTabs.getVisibleInfos())) {
            int idx = indices.getInt(tab.getObject());
            if (idx < prevIdx) {
                this.myTabs.removeTab(tab);
                continue;
            }
            prevIdx = idx;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePreviews(Set<? extends ElementIdentity<?>> desired, TabInfo prevSelection) {
        block7: {
            Object object;
            block6: {
                Object object2;
                Object2IntOpenHashMap indices = new Object2IntOpenHashMap();
                indices.defaultReturnValue(-1);
                Iterable $this$forEachIndexed$iv = this.myTabs.getVisibleInfos();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void tab;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    object2 = (TabInfo)item$iv;
                    int index = n;
                    boolean bl = false;
                    Map map2 = (Map)indices;
                    Object object3 = tab.getObject();
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.database.schemaEditor.ElementIdentity<*>");
                    ElementIdentity elementIdentity = (ElementIdentity)object3;
                    Integer n2 = index;
                    map2.put(elementIdentity, n2);
                }
                int offset = 0;
                int index = 0;
                for (ElementIdentity<?> id : desired) {
                    int existing2 = indices.getInt(id);
                    if (existing2 != -1) {
                        index = existing2 + offset + 1;
                        continue;
                    }
                    int count = this.addPreview(id, index);
                    offset += count;
                    index += count;
                }
                if (prevSelection == null || this.myTabs.getVisibleInfos().contains(prevSelection)) break block7;
                Iterable existing2 = this.myTabs.getVisibleInfos();
                Iterator count = existing2.iterator();
                while (count.hasNext()) {
                    Object it = object2 = count.next();
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getText(), (Object)prevSelection.getText())) continue;
                    object = object2;
                    break block6;
                }
                object = null;
            }
            TabInfo tabInfo = object;
            if (tabInfo != null) {
                TabInfo it = tabInfo;
                boolean bl = false;
                this.myTabs.select(it, false);
            }
        }
    }

    private final int addPreview(ElementIdentity<?> id, int index) {
        int count = this.addDataPreview(id, index);
        count += this.addDdlPreview(id, index + count);
        return count;
    }

    private final int addDataPreview(ElementIdentity<?> id, int index) {
        JComponent jComponent = this.getDialogModel().getDataPreviewManager().getPreviewComponent(id);
        if (jComponent == null) {
            return 0;
        }
        JComponent component = jComponent;
        TabInfo tab = new TabInfo(component);
        String string = DatabaseBundle.message("database.data.import.data.preview.tab.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        tab.setText(string);
        tab.setObject(id);
        this.myTabs.addTab(tab, index);
        return 1;
    }

    private final int addDdlPreview(ElementIdentity<?> id, int index) {
        SqlPreviewComponent sqlPreviewComponent = this.getDialogModel().getDdlPreviewManager().getPreview(id);
        if (sqlPreviewComponent == null) {
            return 0;
        }
        SqlPreviewComponent preview = sqlPreviewComponent;
        EditorTextField editorTextField2 = preview.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"getEditor(...)");
        TabInfo tab = new TabInfo((JComponent)editorTextField2);
        String string = DatabaseBundle.message("database.data.import.ddl.preview.tab.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        tab.setText(string);
        tab.setObject(id);
        this.myTabs.addTab(tab, index);
        return 1;
    }

    private final Set<ElementIdentity<?>> collectPreviewIds(ElementIdentity<?> identity) {
        Collection collection = MultiElementIdentity.expand(identity).flatten(arg_0 -> DbImportDialogPanel.collectPreviewIds$lambda$7(new Function1(this){
            final /* synthetic */ DbImportDialogPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public final Iterable<ElementIdentity<?>> invoke(ElementIdentity<?> id) {
                JBIterable jBIterable = JBIterable.generate(id, arg_0 -> collectPreviewIds.1.invoke$lambda$1(arg_0 -> collectPreviewIds.1.invoke$lambda$0(this.this$0, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"generate(...)");
                return CollectionsKt.reversed((Iterable)((Iterable)jBIterable));
            }

            private static final ElementIdentity invoke$lambda$0(DbImportDialogPanel this$0, ElementIdentity identity) {
                return this$0.getDialogModel().getTargetOwner().getParent(identity);
            }

            private static final ElementIdentity invoke$lambda$1(Function1 $tmp0, Object p0) {
                return (ElementIdentity)$tmp0.invoke(p0);
            }
        }, arg_0)).flatten(arg_0 -> DbImportDialogPanel.collectPreviewIds$lambda$9(arg_0 -> DbImportDialogPanel.collectPreviewIds$lambda$8(this, arg_0), arg_0)).addAllTo((Collection)new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"addAllTo(...)");
        return (Set)collection;
    }

    private final JBIterable<ElementIdentity<?>> extraPreviews(ElementIdentity<?> id) {
        if (id.getMetaObject().kind == MappingData.KIND) {
            ElementIdentity<BasicTable> tableId = DbReferenceModelState.resolveReference(this.getEditorDialogUi().getEditorController().getModelController(), id, MappingData.TABLE_REF);
            JBIterable jBIterable = JBIterable.of(tableId);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
        return jBIterable;
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateFromEditor(Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateFromEditor.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbImportDialogPanel.access$updateFromEditor(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.getEditorDialogUi().apply((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                $continuation.label = 2;
                v1 = this.getDialogModel().getDdlPreviewManager().updatePreviews((Continuation<? super Unit>)$continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl28
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitManagers(Continuation<? super Boolean> $completion) {
        if (!($completion instanceof waitManagers.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbImportDialogPanel.access$waitManagers(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                while (true) {
                    $continuation.label = 1;
                    v0 = this.joinManagers((Continuation<? super Boolean>)$continuation);
                    if (v0 != var4_4) continue;
                    return var4_4;
                }
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                if (!((Boolean)v0).booleanValue()) ** continue;
                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object joinManagers(Continuation<? super Boolean> $completion) {
        if (!($completion instanceof joinManagers.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbImportDialogPanel.access$joinManagers(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.getEditorDialogUi().apply((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                $continuation.label = 2;
                v1 = this.getDialogModel().waitBackgroundTasks((Continuation<? super Boolean>)$continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl28
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object performOperations$intellij_database_impl(@NotNull Function2<? super DbImportRunner, ? super Continuation<? super Boolean>, ? extends Object> importExecutor, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof performOperations.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.performOperations$intellij_database_impl(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = importExecutor;
                $continuation.label = 1;
                v0 = this.waitManagers((Continuation<? super Boolean>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                importExecutor = (Function2)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = importExecutor;
                $continuation.label = 2;
                v1 = this.runScripts((Continuation<? super Boolean>)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl34
            }
            case 2: {
                importExecutor = (Function2)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl34:
                // 2 sources

                if (!((Boolean)v1).booleanValue()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)importExecutor);
                $continuation.label = 3;
                v2 = this.runImport((Function2<? super DbImportRunner, ? super Continuation<? super Boolean>, ? extends Object>)importExecutor, (Continuation<? super Boolean>)$continuation);
                if (v2 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl46
            }
            case 3: {
                importExecutor = (Function2)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl46:
                // 2 sources

                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object runScripts(Continuation<? super Boolean> $completion) {
        if (!($completion instanceof runScripts.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbImportDialogPanel.access$runScripts(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = JBIterable.from(this.getDialogModel().getTargetOwner().getCached()).filterMap((Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, runScripts$lambda$11(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Lcom/intellij/database/schemaEditor/ElementIdentity;)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, runScripts$lambda$10(com.intellij.database.schemaEditor.ElementIdentity ), (Lcom/intellij/database/schemaEditor/ElementIdentity;)Lcom/intellij/database/schemaEditor/ElementIdentity;)()));
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"filterMap(...)");
                $this$forEach$iv = (Iterable)v0;
                $i$f$forEach = 0;
                var4_7 = $this$forEach$iv.iterator();
lbl17:
                // 2 sources

                while (var4_7.hasNext()) {
                    element$iv = var4_7.next();
                    dsRootId = (ElementIdentity)element$iv;
                    $i$a$-forEach-DbImportDialogPanel$runScripts$3 = 0;
                    Intrinsics.checkNotNull((Object)dsRootId);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                    $continuation.L$1 = var4_7;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)dsRootId);
                    $continuation.I$0 = $i$f$forEach;
                    $continuation.I$1 = $i$a$-forEach-DbImportDialogPanel$runScripts$3;
                    $continuation.label = 1;
                    v1 = this.runScript(dsRootId, (Continuation<? super Boolean>)$continuation);
                    if (v1 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl43
                }
                break;
            }
            case 1: {
                $i$a$-forEach-DbImportDialogPanel$runScripts$3 = $continuation.I$1;
                $i$f$forEach = $continuation.I$0;
                dsRootId = (ElementIdentity)$continuation.L$3;
                element$iv = $continuation.L$2;
                var4_7 = (Iterator<T>)$continuation.L$1;
                $this$forEach$iv = (Iterable)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                if (((Boolean)v1).booleanValue()) ** GOTO lbl17
                return Boxing.boxBoolean((boolean)false);
            }
        }
        return Boxing.boxBoolean((boolean)true);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object runScript(ElementIdentity<BasicRoot> dsRootId, Continuation<? super Boolean> $completion) {
        DbEditorModelController dbEditorModelController = this.getEditorDialogUi().getEditorController().getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
        RawDataSource rawDataSource = DataSourceData.Companion.getDataSource(dbEditorModelController, this.getDialogModel().getTargetOwner().getParent(dsRootId));
        LocalDataSource localDataSource = rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
        if (localDataSource == null) {
            return Boxing.boxBoolean((boolean)true);
        }
        LocalDataSource dataSource = localDataSource;
        Pair<ScriptingResult, SearchPath> pair = this.generateScript(dsRootId);
        if (pair == null) {
            return Boxing.boxBoolean((boolean)true);
        }
        Pair<ScriptingResult, SearchPath> pair2 = pair;
        ScriptingResult script2 = (ScriptingResult)pair2.component1();
        SearchPath searchPath = (SearchPath)pair2.component2();
        Project project = this.getEditorDialogUi().getEditorController().getProject();
        DatabaseRefactoringHandler handler2 = new DatabaseRefactoringHandler(dataSource, searchPath, this, project){
            final /* synthetic */ DbImportDialogPanel this$0;
            {
                this.this$0 = $receiver;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, $dataSource, $searchPath);
            }

            protected Object runSync(boolean nonModalSync, Ref<String> shownSummary, Continuation<? super Unit> $completion) {
                return Unit.INSTANCE;
            }

            protected void showError(Project project, ErrorHandler handler2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                DbImportDialogPanel.access$showErrorNotification(this.this$0, handler2.getSummary());
            }
        };
        handler2.setStatement(script2.getScriptText());
        return DbObjectEditorDialogPanelBaseKt.runStatementsAsync(handler2, false, $completion);
    }

    private final void showErrorNotification(String text2) {
        if (text2 == null) {
            this.myErrorWrapper.close();
            return;
        }
        this.myErrorWrapper.setError(this.myErrorWrapper.create(EditorNotificationPanel.Status.Error).text(text2));
    }

    private final Pair<ScriptingResult, SearchPath> generateScript(ElementIdentity<BasicRoot> dsRootId) {
        BasicModel srcModel;
        BasicRoot basicRoot;
        ImportDialogModel dialogModel = this.getDialogModel();
        DbEditorModelController controller = dialogModel.getModelController();
        ElementOwner targetOwner = dialogModel.getTargetOwner();
        BasicRoot tgtRoot = targetOwner.find(dsRootId);
        if (targetOwner.getOriginal() == null) {
            basicRoot = null;
        } else {
            ElementOwner elementOwner = targetOwner.getOriginal();
            Intrinsics.checkNotNull((Object)elementOwner);
            basicRoot = elementOwner.find(dsRootId);
        }
        BasicRoot srcRoot = basicRoot;
        BasicRoot basicRoot2 = tgtRoot;
        BasicModel tgtModel = basicRoot2 != null ? basicRoot2.getModel() : null;
        BasicRoot basicRoot3 = srcRoot;
        BasicModel basicModel = srcModel = basicRoot3 != null ? basicRoot3.getModel() : null;
        if (tgtModel == null || srcModel == null) {
            return null;
        }
        LinkedHashSet correspondence = new LinkedHashSet();
        Function1 filter = arg_0 -> DbImportDialogPanel.generateScript$lambda$13(this, dsRootId, arg_0);
        DbEditorDialogModel.Companion.fillCorrespondence(correspondence, targetOwner.getOriginal(), targetOwner, controller, arg_0 -> DbImportDialogPanel.generateScript$lambda$14(filter, arg_0));
        if (correspondence.isEmpty()) {
            return null;
        }
        ElementIdentity<?> spExample = DbEditorDialogModel.Companion.findSearchPathExample(targetOwner, controller, arg_0 -> DbImportDialogPanel.generateScript$lambda$15(filter, arg_0));
        ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(srcModel, tgtModel);
        builder.getCorrespondence().addAll(correspondence);
        BasicNamespace spObject = this.getSearchPathObject(controller, targetOwner, spExample);
        builder.setCurrentNamespace(spObject);
        Project project = dialogModel.getModelController().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return TuplesKt.to((Object)ScriptGenerators.INSTANCE.makeScript(project, builder.build()), (Object)ObjectPaths.searchPathOf(spObject));
    }

    private final BasicNamespace getSearchPathObject(DbEditorModelController controller, ElementOwner owner, ElementIdentity<?> exampleId) {
        ElementIdentity<BasicNamespace> elementIdentity;
        block6: {
            block5: {
                if (exampleId == null) {
                    return null;
                }
                ElementMatcher elementMatcher = controller.getMatcher();
                Intrinsics.checkNotNullExpressionValue((Object)elementMatcher, (String)"getMatcher(...)");
                elementIdentity = DbEditorUtilsKt.skipTo(elementMatcher, exampleId, BasicNamespace.class);
                if (elementIdentity == null) break block5;
                ElementIdentity<BasicNamespace> it = elementIdentity;
                boolean bl = false;
                ElementOwner elementOwner = owner.getOriginal();
                BasicNamespace basicNamespace = elementOwner != null ? elementOwner.find(it) : null;
                elementIdentity = basicNamespace;
                if (basicNamespace != null) break block6;
            }
            return null;
        }
        ElementIdentity<BasicNamespace> spCandidate = elementIdentity;
        RawDataSource rawDataSource = DataSourceData.Companion.getDataSource(controller, exampleId);
        LocalDataSource dataSource = rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
        Object object = dataSource;
        if (object == null || (object = ((LocalDataSource)object).getDbms()) == null) {
            Dbms dbms = controller.getDbms(exampleId);
            object = dbms;
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        }
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect((Dbms)object);
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(...)");
        DatabaseDialectEx databaseDialect = databaseDialectEx;
        DasNamespace dasNamespace = DbImplUtilCore.getSearchPathObjectForSwitch(dataSource, databaseDialect, (DasObject)((Object)spCandidate));
        return dasNamespace instanceof BasicNamespace ? (BasicNamespace)dasNamespace : null;
    }

    private final boolean isAncestor(ElementIdentity<?> ancestor, ElementIdentity<?> it, boolean strict) {
        ElementIdentity<?> tmp;
        if (it == null || ancestor == null) {
            return !strict && it == ancestor;
        }
        ElementOwner targetOwner = this.getDialogModel().getTargetOwner();
        ElementIdentity<?> elementIdentity = tmp = strict ? targetOwner.getParent(it) : it;
        while (tmp != null && tmp != ancestor) {
            tmp = targetOwner.getParent(tmp);
        }
        return tmp == ancestor;
    }

    /*
     * Unable to fully structure code
     */
    private final Object runImport(Function2<? super DbImportRunner, ? super Continuation<? super Boolean>, ? extends Object> importExecutor, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof runImport.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbImportDialogPanel.access$runImport(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                dialogModel = this.getDialogModel();
                v0 = dialogModel.getModelController().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
                importRunner = DbImportRunner.Companion.create(v0, dialogModel.getTargetOwner(), dialogModel.getIdentity(), dialogModel.getCachedDataManager());
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)importExecutor);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)dialogModel);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)importRunner);
                $continuation.label = 1;
                v1 = importExecutor.invoke((Object)importRunner, (Object)$continuation);
                ** if (v1 != var8_5) goto lbl25
lbl24:
                // 1 sources

                return var8_5;
lbl25:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                importRunner = (DbImportRunner)$continuation.L$2;
                dialogModel = (ImportDialogModel)$continuation.L$1;
                importExecutor = (Function2)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl34:
                    // 2 sources

                    var3_7 = (Boolean)v1;
                }
                catch (CancellationException c) {
                    var5_12 = c.getMessage();
                    if (!(var5_12 == null || var5_12.length() == 0)) {
                        this.showErrorNotification(c.getMessage());
                    }
                    throw c;
                }
                catch (Throwable th) {
                    DbImportDialogPanel.LOG.warn(th);
                    this.showErrorNotification(th.getMessage());
                    throw ExceptionsKt.CancellationException((String)"Import failed", (Throwable)th);
                }
                return Boxing.boxBoolean((boolean)(var3_7 != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void addPreviewListeners$lambda$0(DbImportDialogPanel this$0, ElementIdentity identity) {
        this$0.updatePreviews(identity);
    }

    private static final void addPreviewListeners$lambda$2$lambda$1(DbImportDialogPanel this$0) {
        DbEditor<?, ?> dbEditor = this$0.getEditor().getSelectedEditor();
        ElementIdentity<?> selId = dbEditor != null ? dbEditor.getIdentity() : null;
        this$0.updatePreviews(selId);
    }

    private static final void addPreviewListeners$lambda$2(DbImportDialogPanel this$0) {
        ApplicationManager.getApplication().invokeLater(() -> DbImportDialogPanel.addPreviewListeners$lambda$2$lambda$1(this$0));
    }

    private static final Iterable collectPreviewIds$lambda$7(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Iterable collectPreviewIds$lambda$8(DbImportDialogPanel this$0, ElementIdentity id) {
        Intrinsics.checkNotNull((Object)id);
        return (Iterable)this$0.extraPreviews(id).append((Object)id);
    }

    private static final Iterable collectPreviewIds$lambda$9(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final ElementIdentity runScripts$lambda$10(ElementIdentity id) {
        return ElementIdentity.tryCast(id, BasicRoot.class);
    }

    private static final ElementIdentity runScripts$lambda$11(Function1 $tmp0, Object p0) {
        return (ElementIdentity)$tmp0.invoke(p0);
    }

    private static final boolean generateScript$lambda$13(DbImportDialogPanel this$0, ElementIdentity $dsRootId, ElementIdentity id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this$0.isAncestor($dsRootId, id, false);
    }

    private static final boolean generateScript$lambda$14(Function1 $tmp0, ElementIdentity p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (Boolean)$tmp0.invoke((Object)p0);
    }

    private static final boolean generateScript$lambda$15(Function1 $tmp0, ElementIdentity p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (Boolean)$tmp0.invoke((Object)p0);
    }

    public static final /* synthetic */ Object access$waitManagers(DbImportDialogPanel $this, Continuation $completion) {
        return $this.waitManagers((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$joinManagers(DbImportDialogPanel $this, Continuation $completion) {
        return $this.joinManagers((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$runScripts(DbImportDialogPanel $this, Continuation $completion) {
        return $this.runScripts((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$runScript(DbImportDialogPanel $this, ElementIdentity dsRootId, Continuation $completion) {
        return $this.runScript(dsRootId, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ void access$showErrorNotification(DbImportDialogPanel $this, String text2) {
        $this.showErrorNotification(text2);
    }

    public static final /* synthetic */ Object access$runImport(DbImportDialogPanel $this, Function2 importExecutor, Continuation $completion) {
        return $this.runImport((Function2<? super DbImportRunner, ? super Continuation<? super Boolean>, ? extends Object>)importExecutor, (Continuation<? super Boolean>)$completion);
    }

    static {
        Logger logger2 = Logger.getInstance(DbImportDialogPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\fR\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/database/dbimport/editor/DbImportDialogPanel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "bootstrapper", "Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper;Lcom/intellij/openapi/Disposable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object create(@NotNull CoroutineScope coroutineScope, @NotNull ImportDialogBootstrapper bootstrapper, @NotNull Disposable disposable, @NotNull Continuation<? super DbImportDialogPanel> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DbImportDialogPanel>, Object>(bootstrapper, coroutineScope, disposable, null){
                Object L$1;
                Object L$2;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ ImportDialogBootstrapper $bootstrapper;
                final /* synthetic */ CoroutineScope $coroutineScope;
                final /* synthetic */ Disposable $disposable;
                {
                    this.$bootstrapper = $bootstrapper;
                    this.$coroutineScope = $coroutineScope;
                    this.$disposable = $disposable;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = $this$withContext;
                            this.label = 1;
                            v0 = DataLoaderManager.Companion.getInstance().waitLoaders((Continuation)this);
                            if (v0 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            v1 = DbEditorModality.assertDialogModality(ModalityKt.contextModality((CoroutineContext)$this$withContext.getCoroutineContext()));
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"assertDialogModality(...)");
                            modalityState = v1;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)modalityState);
                            this.label = 2;
                            v2 = this.$bootstrapper.createDialogModel(this.$coroutineScope, modalityState, (Continuation<? super DbEditorDialogModel>)((Continuation)this));
                            if (v2 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl29
                        }
                        case 2: {
                            modalityState = (ModalityState)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl29:
                            // 2 sources

                            dialogModel = (DbEditorDialogModel)v2;
                            Disposer.register((Disposable)this.$disposable, (Disposable)dialogModel);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)modalityState);
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)dialogModel);
                            this.label = 3;
                            v3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DbImportDialogPanel>, Object>(dialogModel, this.$disposable, this.$bootstrapper, null){
                                Object L$0;
                                int label;
                                final /* synthetic */ DbEditorDialogModel $dialogModel;
                                final /* synthetic */ Disposable $disposable;
                                final /* synthetic */ ImportDialogBootstrapper $bootstrapper;
                                {
                                    this.$dialogModel = $dialogModel;
                                    this.$disposable = $disposable;
                                    this.$bootstrapper = $bootstrapper;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            editorDialogUi = new DbEditorDialogUi(this.$dialogModel);
                                            Disposer.register((Disposable)this.$disposable, (Disposable)editorDialogUi);
                                            this.L$0 = editorDialogUi;
                                            this.label = 1;
                                            v0 = editorDialogUi.reset((Continuation<? super Unit>)((Continuation)this));
                                            if (v0 == var3_2) {
                                                return var3_2;
                                            }
                                            ** GOTO lbl17
                                        }
                                        case 1: {
                                            editorDialogUi = (DbEditorDialogUi)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl17:
                                            // 2 sources

                                            this.L$0 = editorDialogUi;
                                            this.label = 2;
                                            v1 = this.$bootstrapper.initUi(editorDialogUi, (Continuation<? super Unit>)((Continuation)this));
                                            if (v1 == var3_2) {
                                                return var3_2;
                                            }
                                            ** GOTO lbl27
                                        }
                                        case 2: {
                                            editorDialogUi = (DbEditorDialogUi)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl27:
                                            // 2 sources

                                            return new DbImportDialogPanel(editorDialogUi);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super DbImportDialogPanel> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v3 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl44
                        }
                        case 3: {
                            dialogModel = (DbEditorDialogModel)this.L$2;
                            modalityState = (ModalityState)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl44:
                            // 2 sources

                            return v3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super DbImportDialogPanel> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0014J\u001c\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0016\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0096@\u00a2\u0006\u0002\u00100J&\u00101\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u0001022\u0006\u0010(\u001a\u00020)2\n\u00103\u001a\u0006\u0012\u0002\b\u00030'H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00064"}, d2={"Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper;", "Lcom/intellij/database/schemaEditor/DbObjectEditorDialogPanelBase$DialogBootstrapper;", "project", "Lcom/intellij/openapi/project/Project;", "invocation", "Lcom/intellij/database/dbimport/editor/DbImportDialog$InvocationType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dbimport/editor/DbImportDialog$InvocationType;)V", "getInvocation", "()Lcom/intellij/database/dbimport/editor/DbImportDialog$InvocationType;", "myDataPreviewManager", "Lcom/intellij/database/dbimport/editor/DbImportDataPreviewManager;", "getMyDataPreviewManager", "()Lcom/intellij/database/dbimport/editor/DbImportDataPreviewManager;", "setMyDataPreviewManager", "(Lcom/intellij/database/dbimport/editor/DbImportDataPreviewManager;)V", "myDdlPreviewManager", "Lcom/intellij/database/dbimport/editor/DbImportDdlPreviewManager;", "getMyDdlPreviewManager", "()Lcom/intellij/database/dbimport/editor/DbImportDdlPreviewManager;", "setMyDdlPreviewManager", "(Lcom/intellij/database/dbimport/editor/DbImportDdlPreviewManager;)V", "myAutoTableManager", "Lcom/intellij/database/dbimport/editor/DbImportAutoTableManager;", "getMyAutoTableManager", "()Lcom/intellij/database/dbimport/editor/DbImportAutoTableManager;", "setMyAutoTableManager", "(Lcom/intellij/database/dbimport/editor/DbImportAutoTableManager;)V", "myCachedDataManager", "Lcom/intellij/database/dbimport/editor/DbImportCachedDataManager;", "getMyCachedDataManager", "()Lcom/intellij/database/dbimport/editor/DbImportCachedDataManager;", "setMyCachedDataManager", "(Lcom/intellij/database/dbimport/editor/DbImportCachedDataManager;)V", "createEditorBuilder", "Lcom/intellij/database/schemaEditor/DbObjectEditorBuilder;", "createDialogModelImpl", "Lcom/intellij/database/schemaEditor/DbEditorDialogModel;", "prepareTargetIdentity", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "controller", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "targetOwner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "initUi", "", "dialogUi", "Lcom/intellij/database/schemaEditor/DbEditorDialogUi;", "(Lcom/intellij/database/schemaEditor/DbEditorDialogUi;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createEditorModelImpl", "Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "targetId", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbImportDialogPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbImportDialogPanel.kt\ncom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,394:1\n1332#2,3:395\n*S KotlinDebug\n*F\n+ 1 DbImportDialogPanel.kt\ncom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper\n*L\n343#1:395,3\n*E\n"})
    public static class ImportDialogBootstrapper
    extends DbObjectEditorDialogPanelBase.DialogBootstrapper {
        @NotNull
        private final DbImportDialog.InvocationType invocation;
        public DbImportDataPreviewManager myDataPreviewManager;
        public DbImportDdlPreviewManager myDdlPreviewManager;
        public DbImportAutoTableManager myAutoTableManager;
        public DbImportCachedDataManager myCachedDataManager;

        public ImportDialogBootstrapper(@NotNull Project project, @NotNull DbImportDialog.InvocationType invocation) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)invocation), (String)"invocation");
            super(project);
            this.invocation = invocation;
        }

        @NotNull
        public final DbImportDialog.InvocationType getInvocation() {
            return this.invocation;
        }

        @NotNull
        public final DbImportDataPreviewManager getMyDataPreviewManager() {
            DbImportDataPreviewManager dbImportDataPreviewManager = this.myDataPreviewManager;
            if (dbImportDataPreviewManager != null) {
                return dbImportDataPreviewManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDataPreviewManager");
            return null;
        }

        public final void setMyDataPreviewManager(@NotNull DbImportDataPreviewManager dbImportDataPreviewManager) {
            Intrinsics.checkNotNullParameter((Object)dbImportDataPreviewManager, (String)"<set-?>");
            this.myDataPreviewManager = dbImportDataPreviewManager;
        }

        @NotNull
        public final DbImportDdlPreviewManager getMyDdlPreviewManager() {
            DbImportDdlPreviewManager dbImportDdlPreviewManager = this.myDdlPreviewManager;
            if (dbImportDdlPreviewManager != null) {
                return dbImportDdlPreviewManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDdlPreviewManager");
            return null;
        }

        public final void setMyDdlPreviewManager(@NotNull DbImportDdlPreviewManager dbImportDdlPreviewManager) {
            Intrinsics.checkNotNullParameter((Object)dbImportDdlPreviewManager, (String)"<set-?>");
            this.myDdlPreviewManager = dbImportDdlPreviewManager;
        }

        @NotNull
        public final DbImportAutoTableManager getMyAutoTableManager() {
            DbImportAutoTableManager dbImportAutoTableManager = this.myAutoTableManager;
            if (dbImportAutoTableManager != null) {
                return dbImportAutoTableManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myAutoTableManager");
            return null;
        }

        public final void setMyAutoTableManager(@NotNull DbImportAutoTableManager dbImportAutoTableManager) {
            Intrinsics.checkNotNullParameter((Object)dbImportAutoTableManager, (String)"<set-?>");
            this.myAutoTableManager = dbImportAutoTableManager;
        }

        @NotNull
        public final DbImportCachedDataManager getMyCachedDataManager() {
            DbImportCachedDataManager dbImportCachedDataManager = this.myCachedDataManager;
            if (dbImportCachedDataManager != null) {
                return dbImportCachedDataManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myCachedDataManager");
            return null;
        }

        public final void setMyCachedDataManager(@NotNull DbImportCachedDataManager dbImportCachedDataManager) {
            Intrinsics.checkNotNullParameter((Object)dbImportCachedDataManager, (String)"<set-?>");
            this.myCachedDataManager = dbImportCachedDataManager;
        }

        @Override
        @NotNull
        public DbObjectEditorBuilder createEditorBuilder() {
            return new DbImportEditorBuilder();
        }

        @Override
        @NotNull
        protected DbEditorDialogModel createDialogModelImpl() {
            return new ImportDialogModel(this);
        }

        @Override
        @NotNull
        public ElementIdentity<?> prepareTargetIdentity(@NotNull DbEditorModelController controller, @NotNull ElementOwner targetOwner) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter((Object)targetOwner, (String)"targetOwner");
            this.setMyDataPreviewManager(new DbImportDataPreviewManager(controller));
            this.setMyDdlPreviewManager(new DbImportDdlPreviewManager(controller));
            this.setMyAutoTableManager(new DbImportAutoTableManager(controller));
            this.setMyCachedDataManager(new DbImportCachedDataManager(controller));
            ElementOwner elementOwner = targetOwner.getOriginal();
            Intrinsics.checkNotNull((Object)elementOwner);
            ElementIdentity<WrapperElement<FakeRootData>> elementIdentity = elementOwner.identify(FakeRootData.META.newDataObject());
            Intrinsics.checkNotNullExpressionValue(elementIdentity, (String)"identify(...)");
            return elementIdentity;
        }

        @Override
        @Nullable
        public Object initUi(@NotNull DbEditorDialogUi dialogUi, @NotNull Continuation<? super Unit> $completion) {
            return ImportDialogBootstrapper.initUi$suspendImpl(this, dialogUi, $completion);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Object initUi$suspendImpl(ImportDialogBootstrapper $this, DbEditorDialogUi dialogUi, Continuation<? super Unit> $completion) {
            DbEditorDialogModel dialogModel = dialogUi.getDialogModel();
            JBIterable jBIterable = JBIterable.from(dialogModel.getTargetOwner().getCached());
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
            JBIterable ids = jBIterable;
            Object[] objectArray = new JBIterable[]{ids.filter(arg_0 -> ImportDialogBootstrapper.initUi$lambda$1(ImportDialogBootstrapper::initUi$lambda$0, arg_0)), ids.filter(arg_0 -> ImportDialogBootstrapper.initUi$lambda$3(ImportDialogBootstrapper::initUi$lambda$2, arg_0))};
            List openIds = (List)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), ImportDialogBootstrapper::initUi$lambda$4), ImportDialogBootstrapper::initUi$lambda$5));
            if (openIds != null) {
                Sequence $this$forEachIndexed$iv = SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)openIds), (int)5);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void id;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    ElementIdentity elementIdentity = (ElementIdentity)item$iv;
                    int index = n;
                    boolean bl = false;
                    boolean isLead = index == 0;
                    Intrinsics.checkNotNull((Object)id);
                    dialogUi.edit((ElementIdentity<?>)id, true, isLead, !isLead, false, false);
                }
            }
            return Unit.INSTANCE;
        }

        @Override
        @Nullable
        protected DbEditorModel<?, ?> createEditorModelImpl(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> targetId) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter(targetId, (String)"targetId");
            DbEditorModel<?, DbStructureModelState> dbEditorModel = controller.getBuilder().createStructureModel(controller, targetId);
            Intrinsics.checkNotNullExpressionValue(dbEditorModel, (String)"createStructureModel(...)");
            DbEditorModel<?, DbStructureModelState> model = dbEditorModel;
            controller.createStructureNodeModel(targetId);
            return model;
        }

        private static final boolean initUi$lambda$0(ElementIdentity id) {
            return id.getMetaObject().kind == MappingData.KIND;
        }

        private static final boolean initUi$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean initUi$lambda$2(ElementIdentity id) {
            ObjectKind objectKind = id.getMetaObject().kind;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"kind");
            return DbImportDataPreviewManager.Companion.isSourceKind(objectKind);
        }

        private static final boolean initUi$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final List initUi$lambda$4(JBIterable it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.toList();
        }

        private static final boolean initUi$lambda$5(List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !((Collection)it).isEmpty();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogModel;", "Lcom/intellij/database/schemaEditor/DbEditorDialogModel;", "bootstrapper", "Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper;", "<init>", "(Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper;)V", "dataPreviewManager", "Lcom/intellij/database/dbimport/editor/DbImportDataPreviewManager;", "getDataPreviewManager", "()Lcom/intellij/database/dbimport/editor/DbImportDataPreviewManager;", "ddlPreviewManager", "Lcom/intellij/database/dbimport/editor/DbImportDdlPreviewManager;", "getDdlPreviewManager", "()Lcom/intellij/database/dbimport/editor/DbImportDdlPreviewManager;", "autoTableManager", "Lcom/intellij/database/dbimport/editor/DbImportAutoTableManager;", "cachedDataManager", "Lcom/intellij/database/dbimport/editor/DbImportCachedDataManager;", "getCachedDataManager", "()Lcom/intellij/database/dbimport/editor/DbImportCachedDataManager;", "joinManagers", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitBackgroundTasks", "intellij.database.impl"})
    public static final class ImportDialogModel
    extends DbEditorDialogModel {
        @NotNull
        private final DbImportDataPreviewManager dataPreviewManager;
        @NotNull
        private final DbImportDdlPreviewManager ddlPreviewManager;
        @NotNull
        private final DbImportAutoTableManager autoTableManager;
        @NotNull
        private final DbImportCachedDataManager cachedDataManager;

        public ImportDialogModel(@NotNull ImportDialogBootstrapper bootstrapper) {
            Intrinsics.checkNotNullParameter((Object)bootstrapper, (String)"bootstrapper");
            super(bootstrapper);
            this.dataPreviewManager = bootstrapper.getMyDataPreviewManager();
            this.ddlPreviewManager = bootstrapper.getMyDdlPreviewManager();
            this.autoTableManager = bootstrapper.getMyAutoTableManager();
            this.cachedDataManager = bootstrapper.getMyCachedDataManager();
        }

        @NotNull
        public final DbImportDataPreviewManager getDataPreviewManager() {
            return this.dataPreviewManager;
        }

        @NotNull
        public final DbImportDdlPreviewManager getDdlPreviewManager() {
            return this.ddlPreviewManager;
        }

        @NotNull
        public final DbImportCachedDataManager getCachedDataManager() {
            return this.cachedDataManager;
        }

        /*
         * Unable to fully structure code
         */
        private final Object joinManagers(Continuation<? super Boolean> $completion) {
            if (!($completion instanceof joinManagers.1)) ** GOTO lbl-1000
            var3_2 = $completion;
            if ((var3_2.label & -2147483648) != 0) {
                var3_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ ImportDialogModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ImportDialogModel.access$joinManagers(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = this.dataPreviewManager.join((Continuation<? super Boolean>)$continuation);
                    if (v0 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    if (!((Boolean)v0).booleanValue()) break;
                    $continuation.label = 2;
                    v1 = this.autoTableManager.join((Continuation<? super Boolean>)$continuation);
                    if (v1 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl29
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl29:
                    // 2 sources

                    if (!((Boolean)v1).booleanValue()) break;
                    $continuation.label = 3;
                    v2 = this.ddlPreviewManager.join((Continuation<? super Boolean>)$continuation);
                    if (v2 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl38
                }
                case 3: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl38:
                    // 2 sources

                    return v2;
                }
            }
            return Boxing.boxBoolean((boolean)false);
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object waitBackgroundTasks(@NotNull Continuation<? super Boolean> $completion) {
            if (!($completion instanceof waitBackgroundTasks.1)) ** GOTO lbl-1000
            var3_2 = $completion;
            if ((var3_2.label & -2147483648) != 0) {
                var3_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ ImportDialogModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.waitBackgroundTasks((Continuation<? super Boolean>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = super.waitBackgroundTasks((Continuation<? super Boolean>)$continuation);
                    if (v0 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    if (!((Boolean)v0).booleanValue()) break;
                    $continuation.label = 2;
                    v1 = this.joinManagers((Continuation<? super Boolean>)$continuation);
                    if (v1 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl29
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl29:
                    // 2 sources

                    return v1;
                }
            }
            return Boxing.boxBoolean((boolean)false);
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static final /* synthetic */ Object access$joinManagers(ImportDialogModel $this, Continuation $completion) {
            return $this.joinManagers((Continuation<? super Boolean>)$completion);
        }
    }
}

