/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.datagrid.DatabaseObjectNormalizer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.ObjectNormalizer;
import com.intellij.database.dbimport.AbstractTableSource;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.extractors.DbObjectFormatterUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.WrapInSelectResult;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableSource
extends AbstractTableSource {
    private static final String COUNT_THREAD = "Select count thread";
    private final DbDataSource myDbDataSource;
    private final LocalDataSource myDataSource;
    private final SearchPath myPath;
    private final String myQueryText;
    private final Project myProject;
    private final boolean mySingleConnection;
    private final ObjectNormalizer myNormalizer;
    private long myLinesCount;
    private boolean myDataRead;
    private GuardedRef<DatabaseConnection> myConnection;
    private RemoteResultSet myResultSet;
    private long myExecTime;
    private List<GridColumn> myDescriptors;
    private ClosableResultsProducer myProducer;

    public DatabaseTableSource(@NotNull DbDataSource dbDataSource, @NotNull LocalDataSource source, @Nullable SearchPath path, @NotNull String queryText, @NotNull Project project) {
        if (dbDataSource == null) {
            DatabaseTableSource.$$$reportNull$$$0(0);
        }
        if (source == null) {
            DatabaseTableSource.$$$reportNull$$$0(1);
        }
        if (queryText == null) {
            DatabaseTableSource.$$$reportNull$$$0(2);
        }
        if (project == null) {
            DatabaseTableSource.$$$reportNull$$$0(3);
        }
        this.myDbDataSource = dbDataSource;
        this.myDataSource = source;
        this.myPath = path;
        this.myQueryText = queryText;
        this.myProject = project;
        this.mySingleConnection = source.isSingleConnection();
        this.myNormalizer = new DatabaseObjectNormalizer(source.getDbms());
    }

    private static int getBatchSize() {
        return Registry.intValue((String)"database.batch.size", (int)2000);
    }

    @Override
    @Nullable
    public ReaderTask.Result read() throws Exception {
        if (this.myDataRead) {
            return null;
        }
        this.init();
        RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(DatabaseTableSource.getBatchSize(), Integer.MAX_VALUE, false);
        long start2 = System.currentTimeMillis();
        List objects = (List)RemoteUtil.handleRemoteResult((Object)this.myResultSet.getObjects(options), List.class, (Object)this);
        long spent = System.currentTimeMillis() - start2;
        this.myDataRead = objects.size() < DatabaseTableSource.getBatchSize();
        this.convertValues(objects, this.myDescriptors);
        BatchRecords records = objects.isEmpty() ? null : new BatchRecords(objects, this.myLinesCount, (double)objects.size());
        this.myLinesCount += records == null ? 0L : (long)records.getLinesCount();
        long execTimeForFirst = this.myExecTime;
        this.myExecTime = 0L;
        return records == null ? null : new ReaderTask.ResultImpl(records, spent + execTimeForFirst);
    }

    public void convertValues(@NotNull List<Object[]> rows, @NotNull List<GridColumn> columns) {
        if (rows == null) {
            DatabaseTableSource.$$$reportNull$$$0(4);
        }
        if (columns == null) {
            DatabaseTableSource.$$$reportNull$$$0(5);
        }
        for (Object[] row : rows) {
            for (int i2 = 0; i2 < row.length; ++i2) {
                row[i2] = DbObjectFormatterUtil.unwrap(this.myNormalizer.objectToObject(row[i2], columns.get(i2)));
            }
        }
    }

    @Override
    public void calculateSize(@NotNull Consumer<Double> callback) {
        if (callback == null) {
            DatabaseTableSource.$$$reportNull$$$0(6);
        }
        if (!this.mySingleConnection) {
            new Thread((Runnable)new MySizeTask(callback), COUNT_THREAD).start();
        }
    }

    @Nullable
    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    boolean isSingleConnection() {
        return this.mySingleConnection;
    }

    @NotNull
    private synchronized GuardedRef<DatabaseConnection> getConnection() throws Exception {
        GuardedRef<DatabaseConnection> guardedRef = DatabaseSessionManager.getFacade(this.myProject, this.myDataSource, null, this.myPath, false, null, DGDepartment.DATA_IMPORT).connect();
        if (guardedRef == null) {
            DatabaseTableSource.$$$reportNull$$$0(7);
        }
        return guardedRef;
    }

    private void init() throws Exception {
        if (this.myConnection != null) {
            return;
        }
        this.createConnectionIfNeeded();
        long start2 = System.currentTimeMillis();
        this.myProducer = SmartStatements.poweredBy(this.myConnection.get()).simple().reuse().noisy().execute(this.myQueryText, StandardExecutionMode.QUERY);
        this.myProducer.advance();
        this.myExecTime = System.currentTimeMillis() - start2;
        this.myResultSet = Objects.requireNonNull(this.myProducer.processCurrent(StandardResultsProcessors.RESULT_SET));
        this.myDescriptors = Arrays.asList(JdbcEngineUtils.getColumnDescriptors(this.myResultSet));
    }

    private void createConnectionIfNeeded() throws Exception {
        if (this.myConnection == null) {
            this.myConnection = this.getConnection();
        }
    }

    @Override
    public void close() {
        DbImplUtil.closeSafe(this.myProducer);
        DbImplUtil.closeSafe(this.myConnection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/DatabaseTableSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/DatabaseTableSource";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertValues";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateSize";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private class MySizeTask
    implements Runnable {
        private final Consumer<Double> myCallback;

        MySizeTask(Consumer<Double> callback) {
            if (callback == null) {
                MySizeTask.$$$reportNull$$$0(0);
            }
            this.myCallback = callback;
        }

        @Override
        public void run() {
            try (GuardedRef<DatabaseConnection> connection2 = DatabaseTableSource.this.getConnection();){
                String alias = DbImplUtil.findFreeAlias(DatabaseTableSource.this.myProject, DatabaseTableSource.this.myDataSource.getDbms(), DatabaseTableSource.this.myQueryText, "t");
                WrapInSelectTask task = DmlTaskKt.wrapInSelect(DatabaseTableSource.this.myQueryText, DatabaseTableSource.this.myProject).countAll().version(DatabaseTableSource.this.myDataSource.getVersion()).alias(alias).build(DbImplUtil.createBuilderForUIExec(DatabaseTableSource.this.myDataSource.getDbms(), (DasObject)DatabaseTableSource.this.myDbDataSource));
                WrapInSelectResult result2 = DmlUtilKt.dmlGenerator(DatabaseTableSource.this.myDataSource.getDbms()).generate(task);
                if (result2 == null) {
                    return;
                }
                long count = DbImplUtilCore.getRowCount(connection2.get(), result2.getStatement());
                this.myCallback.consume((Object)count);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/dbimport/DatabaseTableSource$MySizeTask", "<init>"));
        }
    }
}

