/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.mutating;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementBasis;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.extractors.DatabaseFormatterCreator;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RowQueryData
implements Iterable<ColumnQueryData> {
    private final List<ColumnQueryData> myInfos;
    private final String mySql;
    private final BitSet myEscapingIndexes;
    private final int[] myOffsets;
    private final FormatterCreator myFormatterCreator;
    private final FormatsCache myFormatsCache;

    public RowQueryData(@NotNull List<ColumnQueryData> infos, int @NotNull [] offsets, @NotNull String sql) {
        if (infos == null) {
            RowQueryData.$$$reportNull$$$0(0);
        }
        if (sql == null) {
            RowQueryData.$$$reportNull$$$0(1);
        }
        if (offsets == null) {
            RowQueryData.$$$reportNull$$$0(2);
        }
        this(infos, offsets, sql, RowQueryData.escapingIndexes(offsets.length));
    }

    public RowQueryData(@NotNull List<ColumnQueryData> infos, int @NotNull [] offsets, @NotNull String sql, @NotNull BitSet escapingIndexes) {
        if (infos == null) {
            RowQueryData.$$$reportNull$$$0(3);
        }
        if (sql == null) {
            RowQueryData.$$$reportNull$$$0(4);
        }
        if (escapingIndexes == null) {
            RowQueryData.$$$reportNull$$$0(5);
        }
        if (offsets == null) {
            RowQueryData.$$$reportNull$$$0(6);
        }
        this.myFormatterCreator = new DatabaseFormatterCreator(Dbms.UNKNOWN);
        this.myFormatsCache = new FormatsCache();
        this.myInfos = infos;
        this.myOffsets = offsets;
        this.mySql = sql;
        this.myEscapingIndexes = escapingIndexes;
    }

    public static BitSet escapingIndexes(int size) {
        boolean useLikeOperatorFlag = Registry.is((String)"database.sqlGenerator.forceUseLike", (boolean)false);
        if (useLikeOperatorFlag) {
            return RowQueryData.escapingIndexes(0, size);
        }
        return new BitSet();
    }

    public static BitSet escapingIndexes(int from, int to) {
        BitSet set = new BitSet(to);
        set.set(from, to);
        return set;
    }

    public RowQueryData(@NotNull List<ColumnQueryData> infos) {
        if (infos == null) {
            RowQueryData.$$$reportNull$$$0(7);
        }
        this(infos, ArrayUtilRt.EMPTY_INT_ARRAY, "test");
    }

    @NotNull
    public BitSet getEscapingIndexes() {
        BitSet bitSet = this.myEscapingIndexes;
        if (bitSet == null) {
            RowQueryData.$$$reportNull$$$0(8);
        }
        return bitSet;
    }

    @NotNull
    public String getSql() {
        String string = this.mySql;
        if (string == null) {
            RowQueryData.$$$reportNull$$$0(9);
        }
        return string;
    }

    public int @NotNull [] getOffsets() {
        if (this.myOffsets == null) {
            RowQueryData.$$$reportNull$$$0(10);
        }
        return this.myOffsets;
    }

    public int size() {
        return this.myInfos.size();
    }

    @NotNull
    public List<ColumnQueryData> getColumnsData() {
        List<ColumnQueryData> list = this.myInfos;
        if (list == null) {
            RowQueryData.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    public Iterator<ColumnQueryData> iterator() {
        return this.myInfos.iterator();
    }

    @NotNull
    public ParameterizedStatementData asParameterizedStatementData() {
        int idx = 1;
        ArrayList<CallableStatementData.InParameter> parameters = new ArrayList<CallableStatementData.InParameter>();
        for (ColumnQueryData info2 : this.myInfos) {
            parameters.add(new CallableStatementData.InParameter(idx++, info2, this.myFormatsCache, this.myFormatterCreator));
        }
        return new ParameterizedStatementData(new ParameterizedStatementBasis(this.mySql, this.myEscapingIndexes).withParametersOffsets(this.myOffsets), new ParameterizedStatementDecoration(parameters));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsets";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapingIndexes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/mutating/RowQueryData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/mutating/RowQueryData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapingIndexes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSql";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOffsets";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

