/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class SqlDocumentDataHookUp
extends DocumentDataHookUp {
    private static final String COMMA = ",";
    private static final String SEMICOLON = ";";
    private final SqlLanguageDialect myDialect;

    public SqlDocumentDataHookUp(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(1);
        }
        if (document == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(2);
        }
        super(project, document, range);
        this.myDialect = dialect;
    }

    @Nullable
    protected SqlInsertsMarkup buildMarkup(@NotNull CharSequence sequence, @Nullable GridRequestSource source) {
        if (sequence == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(3);
        }
        return SqlDocumentDataHookUp.buildMarkup(this.getProject(), sequence, this.myDialect);
    }

    @VisibleForTesting
    @Nullable
    public static SqlInsertsMarkup buildMarkup(@NotNull Project project, @NotNull CharSequence sequence, @NotNull SqlLanguageDialect dialect) {
        Ref insertTargetRef;
        JBIterable inserts;
        List blocks;
        if (project == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(4);
        }
        if (sequence == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(5);
        }
        if (dialect == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(6);
        }
        return ContainerUtil.isEmpty((Collection)(blocks = ContainerUtil.mapNotNull((Iterable)(inserts = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)SqlPsiFacade.getInstance(project).createROFile(dialect, sequence))).forceDisregardTypes(Conditions.is((Object)GeneratedParserUtilBase.DUMMY_BLOCK)).expandAndSkip(Conditions.instanceOf(SqlBatchBlock.class))).filter(SqlInsertStatement.class)), arg_0 -> SqlDocumentDataHookUp.lambda$buildMarkup$0(dialect, insertTargetRef = Ref.create(), arg_0)))) ? null : new SqlInsertsMarkup(sequence, blocks, (InsertTarget)insertTargetRef.get());
    }

    @Nullable
    private static Block parseBlock(@NotNull SqlInsertStatement insertStatement, @NotNull SqlLanguageDialect dialect, @NotNull Ref<InsertTarget> insertTargetRef) {
        if (insertStatement == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(7);
        }
        if (dialect == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(8);
        }
        if (insertTargetRef == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(9);
        }
        return SqlDocumentDataHookUp.isOracleInsertAllStatement(insertStatement, dialect) ? SqlDocumentDataHookUp.parseMultiTableInsertBlock(insertStatement, insertTargetRef) : SqlDocumentDataHookUp.parseInsertBlock(insertStatement, insertTargetRef);
    }

    private static boolean isOracleInsertAllStatement(@NotNull SqlInsertStatement statement2, @NotNull SqlLanguageDialect dialect) {
        if (statement2 == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(10);
        }
        if (dialect == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(11);
        }
        if (!dialect.getDbms().isOracle()) {
            return false;
        }
        SqlDmlInstruction instruction = (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)statement2, SqlDmlInstruction.class);
        return instruction != null && instruction.getNode().findChildByType((IElementType)SqlCommonKeywords.SQL_ALL) != null;
    }

    @Nullable
    private static Block parseMultiTableInsertBlock(@NotNull SqlInsertStatement insertStatement, @NotNull Ref<InsertTarget> insertTargetRef) {
        SqlDmlInstruction parentInstruction;
        if (insertStatement == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(12);
        }
        if (insertTargetRef == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(13);
        }
        if ((parentInstruction = (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)insertStatement, SqlDmlInstruction.class)) == null) {
            return null;
        }
        List instructions = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parentInstruction, SqlDmlInstruction.class);
        List insertBlocks = ContainerUtil.mapNotNull((Collection)instructions, instruction -> SqlDocumentDataHookUp.parseInsertBlock(instruction, insertTargetRef, null, null));
        TextRange separatorRange = SqlDocumentDataHookUp.getFollowingSeparatorRange((PsiElement)insertStatement, SEMICOLON);
        return insertBlocks.isEmpty() ? null : new MultiTableInsertBlock(insertStatement.getTextRange(), insertBlocks, separatorRange, instructions.size());
    }

    @Nullable
    private static InsertBlock parseInsertBlock(@NotNull SqlInsertStatement insertStatement, @NotNull Ref<InsertTarget> insertTargetRef) {
        if (insertStatement == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(14);
        }
        if (insertTargetRef == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(15);
        }
        SqlDmlInstruction dmlInstruction = (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)insertStatement, SqlDmlInstruction.class);
        TextRange separatorRange = SqlDocumentDataHookUp.getFollowingSeparatorRange((PsiElement)insertStatement, SEMICOLON);
        return dmlInstruction == null ? null : SqlDocumentDataHookUp.parseInsertBlock(dmlInstruction, insertTargetRef, insertStatement.getTextRange(), separatorRange);
    }

    @Nullable
    private static InsertBlock parseInsertBlock(@NotNull SqlDmlInstruction instruction, @NotNull Ref<InsertTarget> insertTargetRef, @Nullable TextRange insertStatementRange, @Nullable TextRange separatorRange) {
        SqlTableColumnsList columnsList;
        if (instruction == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(16);
        }
        if (insertTargetRef == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(17);
        }
        if ((columnsList = (SqlTableColumnsList)PsiTreeUtil.getChildOfType((PsiElement)instruction, SqlTableColumnsList.class)) == null || !insertTargetRef.isNull() && !((InsertTarget)insertTargetRef.get()).matches(columnsList)) {
            return null;
        }
        List<TextRange> columns = SqlDocumentDataHookUp.parseColumns(columnsList);
        List valuesBlocks = SqlDocumentDataHookUp.parseValuesBlocks(instruction, (InsertTarget)insertTargetRef.get());
        if (valuesBlocks.isEmpty()) {
            return null;
        }
        if (insertTargetRef.isNull()) {
            int columnCount = columns != null ? columns.size() : valuesBlocks.get((int)0).values.size();
            insertTargetRef.set((Object)InsertTarget.create(columnsList, columnCount));
            if (insertTargetRef.isNull()) {
                return null;
            }
            valuesBlocks = ContainerUtil.filter(valuesBlocks, block -> block.values.size() == columnCount);
        }
        TextRange range = insertStatementRange != null ? insertStatementRange : instruction.getTextRange();
        return new InsertBlock(range, valuesBlocks, columns, separatorRange);
    }

    @Nullable
    private static List<TextRange> parseColumns(@Nullable SqlTableColumnsList columnsList) {
        SqlReferenceList referenceList = columnsList != null ? columnsList.getColumnsReferenceList() : null;
        return referenceList == null ? null : ContainerUtil.map(referenceList.getReferenceList(), columnRef -> columnRef.getTextRange());
    }

    @NotNull
    private static @Unmodifiable List<ValuesBlock> parseValuesBlocks(@NotNull SqlDmlInstruction instruction, @Nullable InsertTarget insertTarget) {
        SqlValuesExpression valuesExpression;
        if (instruction == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(18);
        }
        if ((valuesExpression = (SqlValuesExpression)PsiTreeUtil.getChildOfType((PsiElement)instruction, SqlValuesExpression.class)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlDocumentDataHookUp.$$$reportNull$$$0(19);
            }
            return list;
        }
        SmartList valuesBlocks = new SmartList();
        for (SqlExpression expression : valuesExpression.getExpressions()) {
            ContainerUtil.addIfNotNull((Collection)valuesBlocks, (Object)SqlDocumentDataHookUp.parseValuesBlock(expression, insertTarget));
        }
        SmartList smartList = valuesBlocks;
        if (smartList == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    @Nullable
    private static ValuesBlock parseValuesBlock(@NotNull SqlExpression expression, @Nullable InsertTarget insertTarget) {
        SqlParenthesizedExpression tuple;
        if (expression == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(21);
        }
        if ((tuple = (SqlParenthesizedExpression)ObjectUtils.tryCast((Object)expression, SqlParenthesizedExpression.class)) == null || insertTarget != null && !insertTarget.matches(tuple)) {
            return null;
        }
        TextRange range = expression.getTextRange();
        List valueRanges = ContainerUtil.map((Collection)tuple.getExpressionList(), expression1 -> expression1.getTextRange());
        return new ValuesBlock(range, valueRanges, SqlDocumentDataHookUp.getFollowingSeparatorRange((PsiElement)expression, COMMA));
    }

    @Nullable
    private static TextRange getFollowingSeparatorRange(@NotNull PsiElement element, @NotNull String separatorText) {
        PsiElement separator;
        if (element == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(22);
        }
        if (separatorText == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(23);
        }
        return (separator = SqlDocumentDataHookUp.getFollowingSeparator(element, separatorText)) != null ? separator.getTextRange() : null;
    }

    @Nullable
    private static PsiElement getFollowingSeparator(@NotNull PsiElement element, @NotNull String separatorText) {
        PsiElement separator;
        if (element == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(24);
        }
        if (separatorText == null) {
            SqlDocumentDataHookUp.$$$reportNull$$$0(25);
        }
        return (separator = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element)) != null && separatorText.equals(separator.getText()) ? separator : null;
    }

    private static /* synthetic */ Block lambda$buildMarkup$0(SqlLanguageDialect dialect, Ref insertTargetRef, SqlInsertStatement insertStatement) {
        return SqlDocumentDataHookUp.parseBlock(insertStatement, dialect, (Ref<InsertTarget>)insertTargetRef);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertStatement";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertTargetRef";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/SqlDocumentDataHookUp";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separatorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValuesBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildMarkup";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseBlock";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isOracleInsertAllStatement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseMultiTableInsertBlock";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseInsertBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseValuesBlocks";
                break;
            }
            case 19: 
            case 20: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseValuesBlock";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFollowingSeparatorRange";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFollowingSeparator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 20 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class SqlInsertsMarkup
    extends DocumentDataHookUp.DataMarkup {
        public final InsertTarget insertTarget;
        public final List<Block> blocks;

        SqlInsertsMarkup(@NotNull CharSequence sequence, @NotNull List<Block> blocks, @NotNull InsertTarget insertTarget) {
            if (sequence == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(0);
            }
            if (blocks == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(1);
            }
            if (insertTarget == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(2);
            }
            super(SqlInsertsMarkup.columnsFromBlocks(sequence, blocks), SqlInsertsMarkup.rowsFromBlocks(sequence, blocks));
            this.blocks = blocks;
            this.insertTarget = insertTarget;
        }

        protected boolean deleteRows(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<GridRow> sortedRows) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(3);
            }
            if (sortedRows == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(4);
            }
            new RecursiveBlockVisitor(){
                private int myRowIndex;
                private int myValuesTupleIdx;

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ++this.myValuesTupleIdx;
                    return true;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    GridRow row;
                    int blockIdx;
                    List<ValuesBlock> tuples;
                    if (block == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (this.shouldDeleteNextValuesTuples((tuples = block.valuesBlocks).size())) {
                        return this.deleteBlockAndAdvance(block, tuples.size());
                    }
                    int leftToDeleteInThisBlock = 0;
                    for (int rowIdx = this.myRowIndex; rowIdx < sortedRows.size() && (blockIdx = (row = (GridRow)sortedRows.get(rowIdx)).getRowNum() - 1) < this.myValuesTupleIdx + tuples.size(); ++rowIdx) {
                        ++leftToDeleteInThisBlock;
                    }
                    for (int tupleIdx = 0; tupleIdx < tuples.size() && leftToDeleteInThisBlock > 0; ++tupleIdx) {
                        boolean deleteAllSubsequentTuples;
                        ValuesBlock currentTuple = tuples.get(tupleIdx);
                        int nextTupleIdxToDelete = ((GridRow)sortedRows.get(this.myRowIndex)).getRowNum() - 1 - this.myValuesTupleIdx;
                        if (tupleIdx == nextTupleIdxToDelete) {
                            this.deleteBlockAndAdvance(currentTuple, 1);
                            --leftToDeleteInThisBlock;
                            continue;
                        }
                        boolean bl = deleteAllSubsequentTuples = leftToDeleteInThisBlock == tuples.size() - tupleIdx - 1 && tupleIdx + 1 == nextTupleIdxToDelete;
                        if (deleteAllSubsequentTuples) {
                            ValuesBlock lastTuple = tuples.get(tuples.size() - 1);
                            int startOffset = currentTuple.separatorRange != null ? currentTuple.separatorRange.getStartOffset() : tuples.get((int)nextTupleIdxToDelete).range.getStartOffset();
                            int endOffset = lastTuple.separatorRange != null ? lastTuple.separatorRange.getEndOffset() : lastTuple.range.getEndOffset();
                            session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, TextRange.create((int)startOffset, (int)endOffset)));
                            this.myRowIndex += leftToDeleteInThisBlock;
                            this.myValuesTupleIdx += leftToDeleteInThisBlock;
                            break;
                        }
                        ++this.myValuesTupleIdx;
                    }
                    return super.visitInsertBlock(block);
                }

                @Override
                protected boolean visitInsertAllBlock(@NotNull MultiTableInsertBlock block) {
                    int intoBlocksCount;
                    if (block == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return block.totalInsertBlocksCount == (intoBlocksCount = block.insertBlocks.size()) && this.shouldDeleteNextValuesTuples(intoBlocksCount) ? this.deleteBlockAndAdvance(block, intoBlocksCount) : super.visitInsertAllBlock(block);
                }

                private boolean shouldDeleteNextValuesTuples(int count) {
                    int currentRowNum;
                    int previousRowNum;
                    int nextValuesBlockIndex = ((GridRow)sortedRows.get(this.myRowIndex)).getRowNum() - 1;
                    if (nextValuesBlockIndex != this.myValuesTupleIdx) {
                        return false;
                    }
                    int consecutiveRowsToDelete = 1;
                    for (int rowIdx = this.myRowIndex + 1; rowIdx < sortedRows.size() && consecutiveRowsToDelete != count && (previousRowNum = ((GridRow)sortedRows.get(rowIdx - 1)).getRowNum()) == (currentRowNum = ((GridRow)sortedRows.get(rowIdx)).getRowNum()) - 1; ++consecutiveRowsToDelete, ++rowIdx) {
                    }
                    return count == consecutiveRowsToDelete;
                }

                private boolean deleteBlockAndAdvance(@NotNull Block block, int rows) {
                    if (block == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    TextRange range = block.separatorRange != null ? block.range.union(block.separatorRange) : block.range;
                    session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, range));
                    this.myRowIndex += rows;
                    this.myValuesTupleIdx += rows;
                    return this.myRowIndex < sortedRows.size();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "block";
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitValuesBlock";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertBlock";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertAllBlock";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "deleteBlockAndAdvance";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.visitBlocks(this.blocks);
            return false;
        }

        protected boolean insertRow(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(5);
            }
            this.insertRow(session, JBIterable.of((Object)"NULL").repeat(this.columns.size()).toList());
            return true;
        }

        protected boolean cloneRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull GridRow row) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(6);
            }
            if (row == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(7);
            }
            this.insertRow(session, ContainerUtil.map((Iterable)row, (Function)Functions.TO_STRING()));
            return true;
        }

        protected boolean deleteColumns(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<GridColumn> sortedColumns) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(8);
            }
            if (sortedColumns == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(9);
            }
            if (sortedColumns.size() == this.columns.size()) {
                for (Block block : this.blocks) {
                    TextRange range = block.separatorRange != null ? block.range.union(block.separatorRange) : block.range;
                    session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, range));
                }
                return true;
            }
            new RecursiveBlockVisitor(){
                private final int myLastColumnToLeaveIdx;
                {
                    int columnCount = columns.size();
                    int tailColumnsToDelete = 0;
                    for (int i2 = 0; i2 < sortedColumns.size() && ((GridColumn)sortedColumns.get(sortedColumns.size() - i2 - 1)).getColumnNumber() == columnCount - i2 - 1; ++i2) {
                        ++tailColumnsToDelete;
                    }
                    this.myLastColumnToLeaveIdx = columnCount - tailColumnsToDelete - 1;
                }

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.deleteColumns(block.values);
                    return true;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    if (block == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    this.deleteColumns(block.columns);
                    return super.visitInsertBlock(block);
                }

                private void deleteColumns(@NotNull List<TextRange> values) {
                    JBIterator columnToDeleteIt;
                    if (values == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (!(columnToDeleteIt = JBIterator.from(sortedColumns.iterator())).advance()) {
                        return;
                    }
                    for (int valueIdx = 0; valueIdx < values.size(); ++valueIdx) {
                        int endOffset;
                        int startOffset;
                        TextRange valueRange = values.get(valueIdx);
                        if (valueIdx == this.myLastColumnToLeaveIdx) {
                            startOffset = valueRange.getEndOffset();
                            endOffset = values.get(values.size() - 1).getEndOffset();
                            session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, TextRange.create((int)startOffset, (int)endOffset)));
                            break;
                        }
                        if (valueIdx != ((GridColumn)columnToDeleteIt.current()).getColumnNumber()) continue;
                        startOffset = valueRange.getStartOffset();
                        endOffset = valueIdx + 1 < values.size() ? values.get(valueIdx + 1).getStartOffset() : valueRange.getEndOffset();
                        session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, TextRange.create((int)startOffset, (int)endOffset)));
                        if (!columnToDeleteIt.advance()) break;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "block";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "values";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitValuesBlock";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertBlock";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "deleteColumns";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.visitBlocks(this.blocks);
            return true;
        }

        protected boolean insertColumn(@NotNull DocumentDataHookUp.UpdateSession session, @Nullable String name2) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(10);
            }
            this.insertColumn(session, null, name2);
            return true;
        }

        protected boolean cloneColumn(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull GridColumn column2) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(11);
            }
            if (column2 == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(12);
            }
            this.insertColumn(session, column2, null);
            return true;
        }

        protected boolean update(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<RowMutation> infos) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(13);
            }
            if (infos == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(14);
            }
            new RecursiveBlockVisitor(){
                private int myRowToUpdateIdx = 0;
                private int myCurrentRowNum = 0;

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ++this.myCurrentRowNum;
                    RowMutation rowInfo = (RowMutation)infos.get(this.myRowToUpdateIdx);
                    GridRow rowToUpdate = rowInfo.getRow();
                    if (rowToUpdate.getRowNum() == this.myCurrentRowNum) {
                        List<TextRange> valueRanges = block.values;
                        for (ColumnQueryData info2 : rowInfo.getData()) {
                            GridColumn column2 = info2.getColumn();
                            Object newValue = info2.getObject();
                            String valueText = newValue == null ? "NULL" : String.valueOf(newValue);
                            session.replace(valueRanges.get(column2.getColumnNumber()), (CharSequence)valueText);
                        }
                        ++this.myRowToUpdateIdx;
                    }
                    return this.myRowToUpdateIdx < infos.size();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$3", "visitValuesBlock"));
                }
            }.visitBlocks(this.blocks);
            return true;
        }

        protected boolean renameColumn(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull ModelIndex<GridColumn> column2, @NotNull String name2) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(15);
            }
            if (column2 == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(16);
            }
            if (name2 == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(17);
            }
            return false;
        }

        private void insertRow(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<String> values) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(18);
            }
            if (values == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(19);
            }
            Objects.requireNonNull((Block)ContainerUtil.getLastItem(this.blocks)).accept(new RecursiveBlockVisitor(){

                @Override
                protected boolean visitInsertAllBlock(@NotNull MultiTableInsertBlock block) {
                    if (block == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    List<InsertBlock> insertBlocks = block.insertBlocks;
                    InsertBlock lastInsertBlock = Objects.requireNonNull((InsertBlock)ContainerUtil.getLastItem(insertBlocks));
                    int offset = lastInsertBlock.range.getEndOffset();
                    String intoText = this.appendIntoDmlInstruction(new StringBuilder().append("\n"), values).toString();
                    session.insert((CharSequence)intoText, offset);
                    return false;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    List<ValuesBlock> valuesBlocks;
                    if (block == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    if ((valuesBlocks = block.valuesBlocks).size() == 1) {
                        this.insertInsertStatement(block);
                    } else {
                        this.insertValuesTuple(Objects.requireNonNull((ValuesBlock)ContainerUtil.getLastItem(valuesBlocks)));
                    }
                    return false;
                }

                private void insertValuesTuple(@NotNull ValuesBlock nextTo) {
                    if (nextTo == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    TextRange separatorRange = nextTo.separatorRange;
                    StringBuilder sb = new StringBuilder();
                    sb.append(separatorRange == null ? SqlDocumentDataHookUp.COMMA : "").append(" ");
                    String valuesTuple = SqlInsertsMarkup.appendValuesTuple(sb, values).toString();
                    int offset = separatorRange != null ? separatorRange.getEndOffset() : nextTo.range.getEndOffset();
                    session.insert((CharSequence)valuesTuple, offset);
                }

                private void insertInsertStatement(@NotNull InsertBlock nextTo) {
                    if (nextTo == null) {
                        4.$$$reportNull$$$0(3);
                    }
                    TextRange separatorRange = nextTo.separatorRange;
                    StringBuilder sb = new StringBuilder();
                    sb.append(separatorRange == null ? SqlDocumentDataHookUp.SEMICOLON : "").append("\n");
                    String insertStatement = this.appendIntoDmlInstruction(sb.append("INSERT "), values).toString();
                    int offset = separatorRange != null ? separatorRange.getEndOffset() : nextTo.range.getEndOffset();
                    session.insert((CharSequence)insertStatement, offset);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "block";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "nextTo";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertAllBlock";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertBlock";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "insertValuesTuple";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "insertInsertStatement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private void insertColumn(@NotNull DocumentDataHookUp.UpdateSession session, @Nullable GridColumn columnToClone, @Nullable String name2) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(20);
            }
            this.doInsertColumn(session, columnToClone, (String)ObjectUtils.notNull((Object)name2, (Object)("column" + (this.columns.size() + 1))));
        }

        private void doInsertColumn(final @NotNull DocumentDataHookUp.UpdateSession session, final @Nullable GridColumn columnToClone, final @NotNull String name2) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(21);
            }
            if (name2 == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(22);
            }
            new RecursiveBlockVisitor(){
                private int myRowIndex = 0;

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    int offset = Objects.requireNonNull((TextRange)ContainerUtil.getLastItem(block.values)).getEndOffset();
                    String value = columnToClone != null ? String.valueOf(columnToClone.getValue((GridRow)rows.get(this.myRowIndex))) : "NULL";
                    session.insert((CharSequence)(", " + value), offset);
                    ++this.myRowIndex;
                    return true;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    TextRange lastColumn;
                    if (block == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    if ((lastColumn = (TextRange)ContainerUtil.getLastItem(block.columns)) != null) {
                        int offset = lastColumn.getEndOffset();
                        session.insert((CharSequence)(", " + name2), offset);
                    }
                    return super.visitInsertBlock(block);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "block";
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitValuesBlock";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertBlock";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.visitBlocks(this.blocks);
        }

        @NotNull
        private StringBuilder appendIntoDmlInstruction(@NotNull StringBuilder sb, @NotNull List<String> values) {
            if (sb == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(23);
            }
            if (values == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(24);
            }
            String comma = ", ";
            sb.append("INTO ").append(this.insertTarget.getTableRefText());
            if (this.insertTarget.isColumnListPresent()) {
                sb.append("(");
                for (GridColumn column2 : this.columns) {
                    sb.append(column2.getName()).append(comma);
                }
                sb.setLength(sb.length() - comma.length());
                sb.append(")");
            }
            sb.append(" VALUES ");
            return SqlInsertsMarkup.appendValuesTuple(sb, values);
        }

        @NotNull
        private static StringBuilder appendValuesTuple(@NotNull StringBuilder sb, @NotNull List<String> values) {
            if (sb == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(25);
            }
            if (values == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(26);
            }
            sb.append("(");
            String comma = ", ";
            for (String value : values) {
                sb.append(value).append(comma);
            }
            sb.setLength(sb.length() - comma.length());
            sb.append(")");
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(27);
            }
            return stringBuilder;
        }

        @NotNull
        private static List<GridColumn> columnsFromBlocks(@NotNull CharSequence sequence, @NotNull List<Block> blocks) {
            if (sequence == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(28);
            }
            if (blocks == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(29);
            }
            final Ref columnRanges = Ref.create();
            new RecursiveBlockVisitor(){

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    if (block == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    if (block.columns != null) {
                        columnRanges.set(block.columns);
                        return false;
                    }
                    return super.visitInsertBlock(block);
                }

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    columnRanges.set(block.values);
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "block";
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$6";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInsertBlock";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitValuesBlock";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.visitBlocks(blocks);
            List ranges = Objects.requireNonNull((List)columnRanges.get());
            ArrayList<GridColumn> columns = new ArrayList<GridColumn>(ranges.size());
            for (int i2 = 0; i2 < ranges.size(); ++i2) {
                String columnName = ((TextRange)ranges.get(i2)).subSequence(sequence).toString();
                columns.add((GridColumn)new DataConsumer.Column(i2, columnName, 12, "String", "java.lang.String"));
            }
            ArrayList<GridColumn> arrayList = columns;
            if (arrayList == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(30);
            }
            return arrayList;
        }

        @NotNull
        private static List<GridRow> rowsFromBlocks(final @NotNull CharSequence sequence, @NotNull List<Block> blocks) {
            if (sequence == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(31);
            }
            if (blocks == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(32);
            }
            final ArrayList<GridRow> rows = new ArrayList<GridRow>();
            new RecursiveBlockVisitor(){

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    List<TextRange> valueRanges = block.values;
                    Object[] values = new Object[valueRanges.size()];
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        values[i2] = valueRanges.get(i2).subSequence(sequence).toString();
                    }
                    rows.add(DataConsumer.Row.create((int)rows.size(), (Object[])values));
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$7", "visitValuesBlock"));
                }
            }.visitBlocks(blocks);
            ArrayList<GridRow> arrayList = rows;
            if (arrayList == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(33);
            }
            return arrayList;
        }

        @NotNull
        private static TextRange includeWhitespaceUpToNextLine(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull TextRange range) {
            if (session == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(34);
            }
            if (range == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(35);
            }
            int endOffset = range.getEndOffset();
            while (session.isValidOffset(endOffset) && Character.isWhitespace(session.charAt(endOffset)) && session.isValidOffset(++endOffset) && session.charAt(endOffset) != '\n') {
            }
            TextRange textRange = range.getEndOffset() == endOffset ? range : TextRange.create((int)range.getStartOffset(), (int)endOffset);
            if (textRange == null) {
                SqlInsertsMarkup.$$$reportNull$$$0(36);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 27, 30, 33, 36 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 1: 
                case 29: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blocks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertTarget";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 18: 
                case 20: 
                case 21: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortedRows";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortedColumns";
                    break;
                }
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 17: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 19: 
                case 24: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 23: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 27: 
                case 30: 
                case 33: 
                case 36: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup";
                    break;
                }
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendValuesTuple";
                    break;
                }
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "columnsFromBlocks";
                    break;
                }
                case 33: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rowsFromBlocks";
                    break;
                }
                case 36: {
                    objectArray = objectArray2;
                    objectArray2[1] = "includeWhitespaceUpToNextLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRows";
                    break;
                }
                case 5: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "insertRow";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneRow";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteColumns";
                    break;
                }
                case 10: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "insertColumn";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneColumn";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "renameColumn";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "doInsertColumn";
                    break;
                }
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "appendIntoDmlInstruction";
                    break;
                }
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "appendValuesTuple";
                    break;
                }
                case 27: 
                case 30: 
                case 33: 
                case 36: {
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "columnsFromBlocks";
                    break;
                }
                case 31: 
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "rowsFromBlocks";
                    break;
                }
                case 34: 
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "includeWhitespaceUpToNextLine";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 27, 30, 33, 36 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static final class InsertTarget {
        private final String myTableIdentity;
        private final List<String> myColumnIdentities;
        private final int myColumnCount;

        private InsertTarget(@NotNull String tableIdentity, @Nullable List<String> columnIdentities, int count) {
            if (tableIdentity == null) {
                InsertTarget.$$$reportNull$$$0(0);
            }
            this.myTableIdentity = tableIdentity;
            this.myColumnIdentities = columnIdentities;
            this.myColumnCount = count;
        }

        public boolean matches(@Nullable SqlTableColumnsList tableColumnsList) {
            return tableColumnsList != null && this.myTableIdentity.equals(InsertTarget.getTableIdentity(tableColumnsList)) && Comparing.equal(this.myColumnIdentities, InsertTarget.getColumnIdentities(tableColumnsList));
        }

        public boolean matches(@Nullable SqlParenthesizedExpression valuesTuple) {
            return valuesTuple != null && valuesTuple.getExpressionList().size() == this.myColumnCount;
        }

        @NotNull
        public String getTableRefText() {
            String string = this.myTableIdentity;
            if (string == null) {
                InsertTarget.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isColumnListPresent() {
            return this.myColumnIdentities != null;
        }

        @Nullable
        public static InsertTarget create(@Nullable SqlTableColumnsList tableColumnsList, int columnCount) {
            if (tableColumnsList == null) {
                return null;
            }
            String tableIdentity = InsertTarget.getTableIdentity(tableColumnsList);
            if (tableIdentity == null) {
                return null;
            }
            List<String> columnIdentities = InsertTarget.getColumnIdentities(tableColumnsList);
            return columnIdentities != null && columnIdentities.size() != columnCount ? null : new InsertTarget(tableIdentity, columnIdentities, columnCount);
        }

        @Nullable
        private static List<String> getColumnIdentities(@NotNull SqlTableColumnsList tableColumnsList) {
            SqlReferenceList columnRefs;
            if (tableColumnsList == null) {
                InsertTarget.$$$reportNull$$$0(2);
            }
            return (columnRefs = tableColumnsList.getColumnsReferenceList()) == null ? null : ContainerUtil.map(columnRefs.getReferenceList(), expression -> expression.getText());
        }

        @Nullable
        private static String getTableIdentity(@NotNull SqlTableColumnsList tableColumnsList) {
            SqlReferenceExpression tableReference;
            if (tableColumnsList == null) {
                InsertTarget.$$$reportNull$$$0(3);
            }
            return (tableReference = tableColumnsList.getTableReference()) != null ? tableReference.getText() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableIdentity";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertTarget";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableColumnsList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertTarget";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableRefText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnIdentities";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableIdentity";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static class Block {
        public final TextRange range;
        public final TextRange separatorRange;

        Block(@NotNull TextRange range, @Nullable TextRange separatorRange) {
            if (range == null) {
                Block.$$$reportNull$$$0(0);
            }
            this.range = range;
            this.separatorRange = separatorRange;
        }

        public boolean accept(@NotNull RecursiveBlockVisitor visitor2) {
            if (visitor2 == null) {
                Block.$$$reportNull$$$0(1);
            }
            return visitor2.visitBlock(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$Block";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static final class InsertBlock
    extends Block {
        public final List<ValuesBlock> valuesBlocks;
        public final List<TextRange> columns;

        InsertBlock(@NotNull TextRange range, @NotNull List<ValuesBlock> blocks, @Nullable List<TextRange> columns, @Nullable TextRange separatorRange) {
            if (range == null) {
                InsertBlock.$$$reportNull$$$0(0);
            }
            if (blocks == null) {
                InsertBlock.$$$reportNull$$$0(1);
            }
            super(range, separatorRange);
            this.columns = columns;
            this.valuesBlocks = blocks;
        }

        @Override
        public boolean accept(@NotNull RecursiveBlockVisitor visitor2) {
            if (visitor2 == null) {
                InsertBlock.$$$reportNull$$$0(2);
            }
            return visitor2.visitInsertBlock(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blocks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static final class MultiTableInsertBlock
    extends Block {
        public final List<InsertBlock> insertBlocks;
        public final int totalInsertBlocksCount;

        MultiTableInsertBlock(@NotNull TextRange range, @NotNull List<InsertBlock> insertBlocks, @Nullable TextRange separatorRange, int totalInsertBlocksCount) {
            if (range == null) {
                MultiTableInsertBlock.$$$reportNull$$$0(0);
            }
            if (insertBlocks == null) {
                MultiTableInsertBlock.$$$reportNull$$$0(1);
            }
            super(range, separatorRange);
            this.insertBlocks = insertBlocks;
            this.totalInsertBlocksCount = totalInsertBlocksCount;
        }

        @Override
        public boolean accept(@NotNull RecursiveBlockVisitor visitor2) {
            if (visitor2 == null) {
                MultiTableInsertBlock.$$$reportNull$$$0(2);
            }
            return visitor2.visitInsertAllBlock(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertBlocks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$MultiTableInsertBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static final class ValuesBlock
    extends Block {
        public final List<TextRange> values;

        ValuesBlock(@NotNull TextRange range, @NotNull List<TextRange> values, @Nullable TextRange separatorRange) {
            if (range == null) {
                ValuesBlock.$$$reportNull$$$0(0);
            }
            if (values == null) {
                ValuesBlock.$$$reportNull$$$0(1);
            }
            super(range, separatorRange);
            this.values = values;
        }

        @Override
        public boolean accept(@NotNull RecursiveBlockVisitor visitor2) {
            if (visitor2 == null) {
                ValuesBlock.$$$reportNull$$$0(2);
            }
            return visitor2.visitValuesBlock(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$ValuesBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class RecursiveBlockVisitor {
        protected boolean visitBlock(@NotNull Block block) {
            if (block == null) {
                RecursiveBlockVisitor.$$$reportNull$$$0(0);
            }
            return true;
        }

        protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
            if (block == null) {
                RecursiveBlockVisitor.$$$reportNull$$$0(1);
            }
            return true;
        }

        protected boolean visitInsertBlock(@NotNull InsertBlock block) {
            if (block == null) {
                RecursiveBlockVisitor.$$$reportNull$$$0(2);
            }
            return this.visitBlocks(block.valuesBlocks);
        }

        protected boolean visitInsertAllBlock(@NotNull MultiTableInsertBlock block) {
            if (block == null) {
                RecursiveBlockVisitor.$$$reportNull$$$0(3);
            }
            return this.visitBlocks(block.insertBlocks);
        }

        public boolean visitBlocks(@NotNull Iterable<? extends Block> blocks) {
            if (blocks == null) {
                RecursiveBlockVisitor.$$$reportNull$$$0(4);
            }
            for (Block block : blocks) {
                if (block.accept(this)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blocks";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/SqlDocumentDataHookUp$RecursiveBlockVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitValuesBlock";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInsertBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInsertAllBlock";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBlocks";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

