/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseMutator;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.datagrid.TypesMutationsStorage;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.DatabaseMutation;
import com.intellij.database.datagrid.mutating.DmlMutationContext;
import com.intellij.database.datagrid.mutating.GridColumnMutation;
import com.intellij.database.datagrid.mutating.GridRowMutation;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.datagrid.mutating.QueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.GridTablesModel;
import com.intellij.database.util.Version;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseMutatorImpl<T>
implements DatabaseMutator<T> {
    private final GridListModelBase<GridRow, GridColumn> myModel;
    private final GridMutationModel myMutationModel;
    private final DatabaseGridDataHookUp myHookUp;
    private final MutationsStorage myStorage;
    private final TypesMutationsStorage<T> myTypesMutationsStorage;
    private final TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean> myValuesEqual;
    private static final Logger LOG = Logger.getInstance(DatabaseMutatorImpl.class);
    private boolean myFailed;

    public DatabaseMutatorImpl(@NotNull GridListModelBase<GridRow, GridColumn> model, @NotNull GridMutationModel mutationModel, @NotNull DatabaseGridDataHookUp hookUp, @NotNull MutationsStorage storage, @Nullable TypesMutationsStorage<T> typesMutationsStorage, @NotNull TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean> valuesEqual) {
        if (model == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(0);
        }
        if (mutationModel == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(1);
        }
        if (hookUp == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(2);
        }
        if (storage == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(3);
        }
        if (valuesEqual == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(4);
        }
        this.myModel = model;
        this.myMutationModel = mutationModel;
        this.myHookUp = hookUp;
        this.myStorage = storage;
        this.myTypesMutationsStorage = typesMutationsStorage;
        this.myValuesEqual = valuesEqual;
        this.myHookUp.addRequestListener(new MyRequestListener(), (Disposable)this.myHookUp);
    }

    public void mutate(@NotNull GridRequestSource source, @NotNull ModelIndexSet<GridRow> rows, @NotNull ModelIndexSet<GridColumn> columns, @Nullable Object newValue, boolean allowImmediateUpdate) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(5);
        }
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(6);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(7);
        }
        this.mutate(source, GridUtilCore.createMutations(rows, columns, (Object)newValue), allowImmediateUpdate);
    }

    public void mutate(@NotNull GridRequestSource source, @NotNull List<CellMutation> mutations, boolean allowImmediateUpdate) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(8);
        }
        if (mutations == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(9);
        }
        boolean hasInsertedRows = false;
        boolean hasNotInsertedRows = false;
        HashSet<ModelIndex> updatedRows = new HashSet<ModelIndex>();
        HashSet<ModelIndex> updatedColumns = new HashSet<ModelIndex>();
        for (CellMutation mutation : mutations) {
            boolean shouldSkip;
            Object value = mutation.getValue();
            ModelIndex rowIdx = mutation.getRow();
            ModelIndex columnIdx = mutation.getColumn();
            updatedRows.add(rowIdx);
            updatedColumns.add(columnIdx);
            MutationData oldMutation = this.myStorage.get(rowIdx, columnIdx);
            boolean bl = shouldSkip = oldMutation == null && this.myModel.allValuesEqualTo(Collections.singletonList(mutation)) || oldMutation != null && (Boolean)this.myValuesEqual.fun(oldMutation.getValue(), value, (Object)this.myHookUp) != false;
            if (shouldSkip) continue;
            boolean isInserted = this.isInsertedRow((ModelIndex<GridRow>)rowIdx);
            hasInsertedRows |= isInserted;
            hasNotInsertedRows |= !isInserted;
            boolean valuesEqual = !rowIdx.isValid(this.myModel) || !columnIdx.isValid(this.myModel) ? mutation.getValue() == ReservedCellValue.UNSET && this.getType((ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)columnIdx) == null : (Boolean)this.myValuesEqual.fun(mutation.getValue(), this.myModel.getValueAt(rowIdx, columnIdx), (Object)this.myHookUp);
            CellMutation newValue = valuesEqual ? null : mutation;
            this.myStorage.set(rowIdx, columnIdx, newValue);
            this.myStorage.removeColumnFromDeleted(columnIdx);
            this.myStorage.removeRowFromDeleted(rowIdx);
        }
        this.myMutationModel.notifyCellsUpdated(ModelIndexSet.forRows(this.myModel, updatedRows), ModelIndexSet.forColumns(this.myModel, updatedColumns), source.place);
        this.myFailed = false;
        if (allowImmediateUpdate && this.isUpdateImmediately() && this.hasPendingChanges() && !this.hasUnparsedValues() && this.myHookUp.isForSingleSource()) {
            this.submit(source, hasInsertedRows && hasNotInsertedRows && this.isUpdateImmediately());
            return;
        }
        source.setMutatedDataLocally(true);
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    @Override
    public void setType(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2, @Nullable T domain) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(10);
        }
        if (column2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(11);
        }
        if (this.myTypesMutationsStorage != null) {
            this.myTypesMutationsStorage.setType(row, column2, domain);
        }
    }

    @Override
    @Nullable
    public T getType(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(12);
        }
        if (column2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(13);
        }
        return (T)(this.myTypesMutationsStorage != null ? this.myTypesMutationsStorage.getType(row, column2) : null);
    }

    public void revert(@NotNull GridRequestSource source, @NotNull ModelIndexSet<GridRow> rows, @NotNull ModelIndexSet<GridColumn> columns) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(14);
        }
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(15);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(16);
        }
        JBIterable<ModelIndex<GridRow>> sorted = DatabaseMutatorImpl.sorted(rows);
        List modifiedRows = sorted.filter(idx -> !this.myStorage.isInsertedRow(idx) && this.myStorage.isModified(idx)).toList();
        List modifiedColumns = DatabaseMutatorImpl.sorted(columns).filter(idx -> !this.isDeletedColumn((ModelIndex<GridColumn>)idx)).toList();
        modifiedRows.forEach(rowIdx -> modifiedColumns.forEach(colIdx -> this.revert((ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)colIdx)));
        this.myMutationModel.notifyCellsUpdated(ModelIndexSet.forRows(this.myModel, (Iterable)modifiedRows), ModelIndexSet.forColumns(this.myModel, (Iterable)modifiedColumns), source.place);
        List deletedRows = sorted.filter(row -> this.isDeletedRow((ModelIndex<GridRow>)row)).toList();
        deletedRows.forEach(index -> this.myStorage.removeRowFromDeleted(index));
        this.myMutationModel.notifyCellsUpdated(ModelIndexSet.forRows(this.myModel, (Iterable)deletedRows), this.myMutationModel.getColumnIndices(), source.place);
        List deletedColumns = DatabaseMutatorImpl.sorted(columns).filter(idx -> this.isDeletedColumn((ModelIndex<GridColumn>)idx)).toList();
        deletedColumns.forEach(index -> this.myStorage.removeColumnFromDeleted(index));
        this.myMutationModel.notifyCellsUpdated(this.myMutationModel.getRowIndices(), ModelIndexSet.forColumns(this.myModel, (Iterable)deletedColumns), source.place);
        this.doDeleteRows((ModelIndexSet<GridRow>)ModelIndexSet.forRows(this.myModel, (Iterable)sorted.filter(row -> this.isInsertedRow((ModelIndex<GridRow>)row))));
        this.doDeleteColumns((ModelIndexSet<GridColumn>)ModelIndexSet.forColumns(this.myModel, (Iterable)columns.asIterable().filter(this::isInsertedColumn)));
        source.setMutatedDataLocally(true);
        this.notifyRequestFinished(source, true);
    }

    private void revert(@NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> colIdx) {
        if (rowIdx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(17);
        }
        if (colIdx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(18);
        }
        this.myStorage.set(rowIdx, colIdx, null);
    }

    public boolean isUpdateSafe(@NotNull ModelIndexSet<GridRow> rowIndices, @NotNull ModelIndexSet<GridColumn> columnIndices, @Nullable Object newValue) {
        if (rowIndices == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(19);
        }
        if (columnIndices == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(20);
        }
        if (!this.hasPendingChanges() || !this.isUpdateImmediately() || this.hasDifferentRowTypes(rowIndices)) {
            return true;
        }
        List<ModelIndex<GridRow>> rows = this.getRowsInDatabaseDataModel(rowIndices);
        ModelIndex first2 = (ModelIndex)JBIterable.from(rows).filter(Conditions.notNull()).first();
        return first2 == null || this.myModel.allValuesEqualTo(rowIndices, columnIndices, newValue);
    }

    public boolean isInsertedRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(21);
        }
        return this.myStorage.isInsertedRow(row);
    }

    public boolean isInsertedColumn(@NotNull ModelIndex<GridColumn> idx) {
        if (idx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(22);
        }
        return this.myStorage.isInsertedColumn(idx);
    }

    public boolean isDeletedColumn(@NotNull ModelIndex<GridColumn> idx) {
        if (idx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(23);
        }
        return this.myStorage.isDeletedColumn(idx);
    }

    @Nullable
    public GridColumn getInsertedColumn(@NotNull ModelIndex<GridColumn> idx) {
        if (idx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(24);
        }
        return this.myStorage.getInsertedColumn(idx);
    }

    public int getInsertedRowsCount() {
        return this.myStorage.getInsertedRowsCount();
    }

    public int getInsertedColumnsCount() {
        return this.myStorage.getInsertedColumnsCount();
    }

    @Nullable
    public MutationData getMutation(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(25);
        }
        if (column2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(26);
        }
        return this.myStorage.get(row, column2);
    }

    @Nullable
    public MutationType getMutationType(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(27);
        }
        if (column2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(28);
        }
        if (this.isDeletedRow(row) || this.isDeletedColumn(column2)) {
            return MutationType.DELETE;
        }
        if (this.isInsertedRow(row) || this.isInsertedColumn(column2)) {
            return MutationType.INSERT;
        }
        return this.getMutation(row, column2) == null ? null : MutationType.MODIFY;
    }

    public boolean isUpdateImmediately() {
        return DatabaseSettings.getSettings().isSubmitImmediately();
    }

    public boolean hasPendingChanges() {
        return this.myStorage.hasChanges();
    }

    public boolean hasUnparsedValues() {
        return this.myStorage.hasUnparsedValues();
    }

    public void deleteRows(@NotNull GridRequestSource source, @NotNull ModelIndexSet<GridRow> rows) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(29);
        }
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(30);
        }
        this.deleteRowsOrColumns(source, rows, this::doDeleteRows);
    }

    public void insertRows(@NotNull GridRequestSource source, int amount) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(31);
        }
        if (!this.isReadOnly()) {
            this.doInsertRows(IntStream.range(0, amount).mapToObj(i2 -> this.createRow(null)).toList());
        }
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    public void cloneRow(@NotNull GridRequestSource source, @NotNull ModelIndex<GridRow> toClone) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(32);
        }
        if (toClone == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(33);
        }
        if (this.isReadOnly() || !this.isValidRowIdx(toClone)) {
            this.notifyRequestFinished(source, false);
            return;
        }
        GridRow newRow = this.createRow(toClone);
        this.doInsertRow(newRow);
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    public boolean isFailed() {
        return this.myFailed;
    }

    @NotNull
    protected GridRow createRow(@Nullable ModelIndex<GridRow> templateIdx) {
        Object[] newRow = new Object[this.myMutationModel.getColumnCount()];
        Map nameToDasColumn = CollectionFactory.createCaseInsensitiveStringMap();
        DasTable dasTable = (DasTable)ObjectUtils.tryCast((Object)this.myHookUp.getDatabaseTable(), DasTable.class);
        if (dasTable != null) {
            for (DasColumn dasColumn : DasUtil.getColumns(dasTable)) {
                nameToDasColumn.put(dasColumn.getName(), dasColumn);
            }
        }
        for (ModelIndex columnIdx : this.myMutationModel.getColumnIndices().asIterable()) {
            Object existing2;
            MutationData mutation;
            GridColumn column2 = Objects.requireNonNull(this.myMutationModel.getColumn(columnIdx));
            DasColumn dasColumn = (DasColumn)nameToDasColumn.get(column2.getName());
            MutationData mutationData = mutation = templateIdx == null ? null : this.getMutation(templateIdx, (ModelIndex<GridColumn>)columnIdx);
            Object object = mutation != null ? mutation.getValue() : (existing2 = templateIdx != null ? this.myMutationModel.getValueAt(templateIdx, columnIdx) : null);
            ReservedCellValue value = GridUtilCore.isVirtualColumn((GridColumn)column2) || GridUtilCore.isRowId((GridColumn)column2) ? ReservedCellValue.COMPUTED : (templateIdx != null && !DasUtil.isPrimary(dasColumn) ? existing2 : DbImplUtil.getDefaultNullValue(dasColumn, this.myHookUp.getDbms()));
            newRow[columnIdx.asInteger()] = value;
        }
        DataConsumer.Row row = DataConsumer.Row.create((int)(this.myHookUp.getPageModel().getPageEnd() + this.myStorage.getInsertedRowsCount()), (Object[])newRow);
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(34);
        }
        return row;
    }

    @Nullable
    public ModelIndex<GridRow> getLastInsertedRow() {
        return this.myStorage.getLastInsertedRow();
    }

    public boolean isDeletedRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(35);
        }
        return this.myStorage.isDeletedRow(row);
    }

    public boolean isDeletedRows(@NotNull ModelIndexSet<GridRow> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(36);
        }
        return this.myStorage.isDeletedRows(rows);
    }

    @NotNull
    public ModelIndexSet<GridRow> getAffectedRows() {
        HashSet affectedRows = new HashSet();
        affectedRows.addAll(this.myStorage.getModifiedRows());
        affectedRows.addAll(this.myStorage.getDeletedRows().toList());
        ModelIndexSet modelIndexSet = ModelIndexSet.forRows(this.myModel, affectedRows);
        if (modelIndexSet == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(37);
        }
        return modelIndexSet;
    }

    @NotNull
    public JBIterable<ModelIndex<GridRow>> getInsertedRows() {
        JBIterable jBIterable = this.myStorage.getInsertedRows();
        if (jBIterable == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(38);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ModelIndex<GridColumn>> getInsertedColumns() {
        JBIterable jBIterable = this.myStorage.getInsertedColumns();
        if (jBIterable == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(39);
        }
        return jBIterable;
    }

    public void submit(@NotNull GridRequestSource source, boolean includeInserted) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(40);
        }
        GridTablesModel gridTablesModel = this.myHookUp.getGridTablesModel();
        if (this.isReadOnly() || gridTablesModel == null || gridTablesModel.isTablesEmpty()) {
            this.notifyRequestFinished(source, false);
            return;
        }
        if (!(this.myStorage.getDeletedRowsCount() != 0 || this.myStorage.getModifiedRowsCount() != 0 || this.myStorage.getDeletedColumnsCount() != 0 || this.myStorage.getInsertedRowsCount() != 0 && includeInserted)) {
            this.notifyUpdateCountReceived(source, this.myStorage.getInsertedRowsCount());
            this.notifyRequestFinished(source, true);
            return;
        }
        PendingContexts contexts = this.generatePendingContexts(includeInserted);
        List<DataRequest.DmlRequest> requests = new ArrayList<DataRequest.DmlRequest>();
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newDeleteRequest), contexts.delete));
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newUpdateRequest), contexts.update));
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newInsertRequest), contexts.insert));
        requests = ContainerUtil.filter(requests, Objects::nonNull);
        if (!requests.isEmpty()) {
            GridDataRequest request2 = DataRequest.newCompositeRequest(this.myHookUp, requests);
            this.processRequest(source, request2, DataBusGridDataHookUp.ReloadPolicy.WHEN_DONE);
            return;
        }
        source.setMutatedDataLocally(true);
        this.notifyRequestFinished(source, true);
    }

    @NotNull
    public String getPendingChanges() {
        PendingContexts contexts = this.generatePendingContexts(true);
        ArrayList<JdbcEngine.StatementPrinter.StatementRecipe> recipes = new ArrayList<JdbcEngine.StatementPrinter.StatementRecipe>();
        if (contexts.delete != null) {
            recipes.add(new JdbcEngine.StatementPrinter.StatementRecipe(QueryData.Operation.DELETE, contexts.delete));
        }
        if (contexts.update != null) {
            recipes.add(new JdbcEngine.StatementPrinter.StatementRecipe(QueryData.Operation.UPDATE, contexts.update));
        }
        if (contexts.insert != null) {
            recipes.add(new JdbcEngine.StatementPrinter.StatementRecipe(QueryData.Operation.INSERT, contexts.insert));
        }
        String string = new JdbcEngine.StatementPrinter(recipes).printAll(this.myHookUp.getDbms());
        if (string == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(41);
        }
        return string;
    }

    @Override
    public void pageReloaded() {
        this.myFailed = false;
    }

    public boolean hasMutatedRows(@NotNull ModelIndexSet<GridRow> rows, @NotNull ModelIndexSet<GridColumn> columns) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(42);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(43);
        }
        for (ModelIndex row : rows.asIterable()) {
            for (ModelIndex column2 : columns.asIterable()) {
                MutationData mutation = this.myStorage.get(row, column2);
                if (mutation == null) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public MutationType getMutationType(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(44);
        }
        return !this.isValidRowIdx(row) ? null : (this.isInsertedRow(row) ? MutationType.INSERT : (this.isDeletedRow(row) ? MutationType.DELETE : (this.myStorage.isModified(row) ? MutationType.MODIFY : null)));
    }

    private boolean isValidRowIdx(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(45);
        }
        return this.myModel.isValidRowIdx(row) || this.isInsertedRow(row);
    }

    private boolean isValidColumnIdx(@NotNull ModelIndex<GridColumn> column2) {
        if (column2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(46);
        }
        return this.myModel.isValidColumnIdx(column2) || this.isInsertedColumn(column2);
    }

    public boolean hasUnparsedValues(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(47);
        }
        return this.isValidRowIdx(row) && this.myStorage.hasUnparsedValues(row);
    }

    @NotNull
    protected List<ModelIndex<GridRow>> getRowsInDatabaseDataModel(@NotNull ModelIndexSet<GridRow> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(48);
        }
        List list = rows.asIterable().map(row -> this.isValidRowIdx((ModelIndex<GridRow>)row) && this.isInsertedRow((ModelIndex<GridRow>)row) ? null : row).toList();
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(49);
        }
        return list;
    }

    protected void processRequest(@NotNull GridRequestSource source, @NotNull GridDataRequest request2, DataBusGridDataHookUp.ReloadPolicy reloadPolicy) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(50);
        }
        if (request2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(51);
        }
        this.myHookUp.processRequest(source, request2, reloadPolicy);
    }

    @NotNull
    protected List<GridColumn> getPhysicalColumns(@NotNull ModelIndexSet<GridColumn> columnIndices) {
        if (columnIndices == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(52);
        }
        List list = columnIndices.asIterable().filterMap(columnIndex -> {
            GridColumn column2 = (GridColumn)this.myModel.getColumn(columnIndex);
            return column2 != null && GridUtilCore.isRowId((GridColumn)column2) ? null : column2;
        }).toList();
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(53);
        }
        return list;
    }

    public void deleteColumns(@NotNull GridRequestSource source, @NotNull ModelIndexSet<GridColumn> columns) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(54);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(55);
        }
        this.deleteRowsOrColumns(source, columns, this::doDeleteColumns);
    }

    private <T> void deleteRowsOrColumns(GridRequestSource source, ModelIndexSet<T> objects, Function<ModelIndexSet<T>, Boolean> delete) {
        if (this.isReadOnly() || !((Boolean)delete.fun(objects)).booleanValue()) {
            source.setMutatedDataLocally(true);
            this.notifyRequestFinished(source, !this.isReadOnly() && this.getDatabaseTable() != null);
            return;
        }
        if (this.isUpdateImmediately()) {
            this.submit(source, false);
            return;
        }
        source.setMutatedDataLocally(true);
        this.notifyRequestFinished(source, true);
    }

    private boolean doDeleteColumns(@NotNull ModelIndexSet<GridColumn> columns) {
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(56);
        }
        this.myFailed = false;
        return this.doDeleteRowsOrColumns(columns, this::isValidColumnIdx, this::isInsertedColumn, arg_0 -> ((MutationsStorage)this.myStorage).deleteColumn(arg_0), column2 -> this.myMutationModel.notifyColumnsRemoved(ModelIndexSet.forColumns(this.myModel, (ModelIndex[])new ModelIndex[]{column2})));
    }

    public void insertColumn(@NotNull GridRequestSource source, @Nullable String name2) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(57);
        }
        if (!this.isReadOnly()) {
            this.doInsertColumn(name2);
        }
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    private void doInsertColumn(@Nullable String name2) {
        this.myFailed = false;
        int newColumnIdx = this.myMutationModel.getColumnCount();
        ModelIndex columnIdx = ModelIndex.forColumn(this.myModel, (int)newColumnIdx);
        String columnName = name2 != null ? name2 : GridUtilCore.generateColumnName((GridModel)this.myMutationModel);
        String columnType = DatabaseMutatorImpl.getStringTypeName(this.myHookUp.getDbms(), this.myHookUp.getDataSource().getVersion());
        DataConsumer.Column column2 = new DataConsumer.Column(columnIdx.asInteger(), columnName, 12, (String)ObjectUtils.notNull((Object)columnType, (Object)"unknown"), "");
        this.myStorage.insertColumn(columnIdx, (GridColumn)column2);
        this.myMutationModel.notifyColumnsAdded(ModelIndexSet.forColumns(this.myModel, (ModelIndex[])new ModelIndex[]{columnIdx}));
    }

    public void renameColumn(@NotNull GridRequestSource source, @NotNull ModelIndex<GridColumn> idx, @NotNull String newName) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(58);
        }
        if (idx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(59);
        }
        if (newName == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(60);
        }
        this.myStorage.renameColumn(idx, newName);
    }

    @Nullable
    private static String getStringTypeName(@NotNull Dbms dbms, @Nullable Version version) {
        DomainRegistry registry;
        Domain textDomain;
        if (dbms == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(61);
        }
        return (textDomain = (Domain)ContainerUtil.find((registry = BaseDomainRegistry.get(dbms, version)).getDomains(), domain -> LogicalType.isText((LogicalType)domain.getLogicType()))) == null ? null : textDomain.simpleName();
    }

    public void cloneColumn(@NotNull GridRequestSource source, @NotNull ModelIndex<GridColumn> toClone) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(62);
        }
        if (toClone == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(63);
        }
    }

    @NotNull
    private static <T> JBIterable<ModelIndex<T>> sorted(@NotNull ModelIndexSet<T> objects) {
        if (objects == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(64);
        }
        JBIterable jBIterable = objects.asIterable().sort(Comparator.comparingInt(Index::asInteger));
        if (jBIterable == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(65);
        }
        return jBIterable;
    }

    private boolean doDeleteRows(@NotNull ModelIndexSet<GridRow> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(66);
        }
        this.myFailed = false;
        return this.doDeleteRowsOrColumns(rows, this::isValidRowIdx, this::isInsertedRow, arg_0 -> ((MutationsStorage)this.myStorage).deleteRow(arg_0), row -> this.myMutationModel.notifyRowsRemoved(ModelIndexSet.forRows(this.myModel, (ModelIndex[])new ModelIndex[]{row})));
    }

    private <T> boolean doDeleteRowsOrColumns(@NotNull ModelIndexSet<T> indexes, @NotNull Function<ModelIndex<T>, Boolean> isValid, @NotNull Function<ModelIndex<T>, Boolean> isInserted, @NotNull Consumer<ModelIndex<T>> deleteInStorage, @NotNull Consumer<ModelIndex<T>> notifyRemoved) {
        if (indexes == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(67);
        }
        if (isValid == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(68);
        }
        if (isInserted == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(69);
        }
        if (deleteInStorage == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(70);
        }
        if (notifyRemoved == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(71);
        }
        boolean databaseDataModified = false;
        JBIterable<ModelIndex<T>> sorted = DatabaseMutatorImpl.sorted(indexes);
        for (int i2 = sorted.size() - 1; i2 >= 0; --i2) {
            ModelIndex idx = (ModelIndex)sorted.get(i2);
            if (!((Boolean)isValid.fun((Object)Objects.requireNonNull(idx))).booleanValue()) continue;
            boolean inserted = (Boolean)isInserted.fun((Object)idx);
            databaseDataModified |= !inserted;
            deleteInStorage.accept(idx);
            if (!inserted) continue;
            notifyRemoved.accept(idx);
        }
        return databaseDataModified && this.getDatabaseTable() != null;
    }

    @NotNull
    private PendingContexts generatePendingContexts(boolean includeInserted) {
        DmlMutationContext insert = includeInserted ? this.createInsertContext() : null;
        DmlMutationContext update2 = this.createUpdateContext();
        DmlMutationContext delete = this.createDeleteContext();
        return new PendingContexts(insert, update2, delete);
    }

    @Nullable
    private DmlMutationContext createInsertContext() {
        ArrayList<DatabaseMutation> rowMutations = new ArrayList<DatabaseMutation>();
        for (ModelIndex rowIdx : this.myStorage.getInsertedRows()) {
            Object[] values = new Object[this.myModel.getColumnCount()];
            for (ModelIndex columnIdx : this.myModel.getColumnIndices().asIterable()) {
                MutationData data = this.myStorage.get(rowIdx, columnIdx);
                values[columnIdx.asInteger()] = data == null ? null : data.getValue();
            }
            DataConsumer.Row row = DataConsumer.Row.create((int)rowIdx.asInteger(), (Object[])values);
            List<ColumnQueryData> infos = this.createUpdateData((ModelIndex<GridRow>)rowIdx);
            DasObject dasTable = this.getDasTable();
            if (dasTable == null) {
                LOG.warn("Table not found for row: " + String.valueOf(rowIdx) + "to create dml mutation context");
                continue;
            }
            rowMutations.add((DatabaseMutation)new GridRowMutation(dasTable, this.myModel.getColumns(), (GridRow)row, infos));
        }
        return this.asContext(rowMutations);
    }

    @Nullable
    private DmlMutationContext createDeleteContext() {
        DasObject dasTable = this.getDasTable();
        if (dasTable == null) {
            LOG.warn("Table not found for to create delete context");
            return null;
        }
        List mutations = this.myStorage.getDeletedRows().map(row -> (GridRow)this.myModel.getRow(row)).filter(Objects::nonNull).map(row -> new GridRowMutation(dasTable, (List<? extends GridColumn>)this.getColumnsByTable(dasTable), (GridRow)row, DatabaseMutatorImpl.createColumnsUpdateData(row, this.getColumnsByTable(dasTable)))).append((Iterable)this.myStorage.getDeletedColumns().map(column2 -> new GridColumnMutation(dasTable, Objects.requireNonNull((GridColumn)this.myModel.getColumn(column2))))).toList();
        return this.asContext(mutations);
    }

    private DasObject getDasTable() {
        GridTablesModel gridTablesModel = this.myHookUp.getGridTablesModel();
        if (gridTablesModel != null && !gridTablesModel.isTablesEmpty()) {
            return gridTablesModel.getFirstTable();
        }
        return null;
    }

    @Nullable
    private DmlMutationContext createUpdateContext() {
        List<DatabaseMutation> rowMutations = new ArrayList<DatabaseMutation>();
        for (ModelIndex rowIdx : this.myStorage.getModifiedRows()) {
            GridRow row;
            if (this.isInsertedRow((ModelIndex<GridRow>)rowIdx) || !this.myStorage.isModified(rowIdx) || !this.isValidRowIdx((ModelIndex<GridRow>)rowIdx) || (row = (GridRow)this.myModel.getRow(rowIdx)) == null) continue;
            rowMutations.addAll(this.getGridRowMutations(row, this.createUpdateData((ModelIndex<GridRow>)rowIdx)));
        }
        rowMutations = this.mergeRowsIfPossible(rowMutations);
        return this.asContext(rowMutations);
    }

    private List<DatabaseMutation> mergeRowsIfPossible(List<DatabaseMutation> mutations) {
        GridTablesModel gridTablesModel = this.myHookUp.getGridTablesModel();
        if (mutations == null || mutations.isEmpty() || gridTablesModel == null) {
            return List.of();
        }
        if (gridTablesModel.isForSingleTable()) {
            return mutations;
        }
        HashMap<DasObject, List> groupedMutations = new HashMap<DasObject, List>();
        for (DatabaseMutation mutation : mutations) {
            if (mutation instanceof GridRowMutation) {
                GridRowMutation rowMutation = (GridRowMutation)mutation;
                groupedMutations.computeIfAbsent(rowMutation.getDasObject(), k -> new ArrayList()).add(mutation);
                continue;
            }
            if (!(mutation instanceof GridColumnMutation)) continue;
            GridColumnMutation columnMutation = (GridColumnMutation)mutation;
            groupedMutations.computeIfAbsent(columnMutation.getDasObject(), k -> new ArrayList()).add(mutation);
        }
        return groupedMutations.entrySet().stream().flatMap(entry -> this.getMergedMutationsForTable((DasObject)entry.getKey(), (List)entry.getValue()).stream()).toList();
    }

    private List<DatabaseMutation> getMergedMutationsForTable(DasObject dasTable, List<DatabaseMutation> tableMutations) {
        ArrayList<DatabaseMutation> result2 = new ArrayList<DatabaseMutation>(tableMutations.size());
        if (tableMutations.size() <= 1) {
            result2.addAll(tableMutations);
            return result2;
        }
        HashMap<RowKey, ArrayList> groupedMutationsByRow = new HashMap<RowKey, ArrayList>();
        ArrayList<DatabaseMutation> uniqueMutations = new ArrayList<DatabaseMutation>();
        for (DatabaseMutation databaseMutation : tableMutations) {
            if (databaseMutation instanceof GridRowMutation) {
                GridRowMutation gridRowMutation = (GridRowMutation)databaseMutation;
                List columns = ContainerUtil.map((Collection)Objects.requireNonNull(gridRowMutation.getColumns()), c2 -> new ColumnQueryData(c2, c2.getValue(gridRowMutation.getRow())));
                List<ColumnQueryData> keyColumns = DbImplUtil.getWhereClauseColumns(dasTable, columns, this.myHookUp.getDbms());
                if (!keyColumns.isEmpty()) {
                    RowKey rowKey = DatabaseMutatorImpl.createRowKey(gridRowMutation, keyColumns);
                    groupedMutationsByRow.computeIfAbsent(rowKey, k -> new ArrayList()).add(databaseMutation);
                    continue;
                }
                uniqueMutations.add(databaseMutation);
                continue;
            }
            uniqueMutations.add(databaseMutation);
        }
        for (Map.Entry entry : groupedMutationsByRow.entrySet()) {
            if (DatabaseMutatorImpl.isOnlyUniqueColumns((List)entry.getValue())) {
                DatabaseMutation firstMutation = (DatabaseMutation)((ArrayList)entry.getValue()).get(0);
                if (firstMutation instanceof GridRowMutation) {
                    GridRowMutation gridRowMutation = (GridRowMutation)firstMutation;
                    GridRow row = gridRowMutation.getRow();
                    List<ColumnQueryData> mergedData = ((ArrayList)entry.getValue()).stream().filter(RowMutation.class::isInstance).map(RowMutation.class::cast).flatMap(rowMutation -> rowMutation.getData().stream()).toList();
                    result2.add((DatabaseMutation)new GridRowMutation(dasTable, this.getColumnsByTable(dasTable), row, mergedData));
                    continue;
                }
                result2.addAll((Collection)entry.getValue());
                continue;
            }
            result2.addAll((Collection)entry.getValue());
        }
        if (!uniqueMutations.isEmpty()) {
            result2.addAll(uniqueMutations);
        }
        return result2;
    }

    private static boolean isOnlyUniqueColumns(List<DatabaseMutation> tableMutations) {
        HashSet<String> visitedColumns = new HashSet<String>();
        for (DatabaseMutation mutation : tableMutations) {
            if (!(mutation instanceof RowMutation)) {
                return false;
            }
            RowMutation rowMutation = (RowMutation)mutation;
            int initialSize = visitedColumns.size();
            int expectedNewSize = initialSize + rowMutation.getData().size();
            for (ColumnQueryData column2 : rowMutation.getData()) {
                if (visitedColumns.add(column2.getColumn().getName())) continue;
                return false;
            }
            if (visitedColumns.size() == expectedNewSize) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static RowKey createRowKey(GridRowMutation gridRowMutation, List<ColumnQueryData> keyColumns) {
        Object[] keyValues = new Object[keyColumns.size()];
        for (int i2 = 0; i2 < keyColumns.size(); ++i2) {
            keyValues[i2] = keyColumns.get(i2).getColumn().getValue(gridRowMutation.getRow());
        }
        return new RowKey(keyValues);
    }

    @NotNull
    private List<GridRowMutation> getGridRowMutations(@NotNull GridRow row, @NotNull List<ColumnQueryData> columnsQueryData) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(72);
        }
        if (columnsQueryData == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(73);
        }
        if (columnsQueryData.isEmpty()) {
            List<GridRowMutation> list = Collections.emptyList();
            if (list == null) {
                DatabaseMutatorImpl.$$$reportNull$$$0(74);
            }
            return list;
        }
        GridTablesModel gridTablesModel = this.myHookUp.getGridTablesModel();
        if (gridTablesModel == null) {
            List<GridRowMutation> list = Collections.emptyList();
            if (list == null) {
                DatabaseMutatorImpl.$$$reportNull$$$0(75);
            }
            return list;
        }
        if (gridTablesModel.isForSingleTable() && !gridTablesModel.isTablesEmpty()) {
            List<GridRowMutation> list = Collections.singletonList(new GridRowMutation(gridTablesModel.getFirstTable(), this.myModel.getColumns(), row, columnsQueryData));
            if (list == null) {
                DatabaseMutatorImpl.$$$reportNull$$$0(76);
            }
            return list;
        }
        HashMap<DasObject, List> columnsQueryDataByTable = new HashMap<DasObject, List>();
        for (ColumnQueryData columnData : columnsQueryData) {
            int columnNumber = columnData.getColumn().getColumnNumber();
            DasObject table = Objects.requireNonNullElse(gridTablesModel.getDasTableByColumnIndex(columnNumber), gridTablesModel.getFirstTable());
            columnsQueryDataByTable.computeIfAbsent(table, k -> new ArrayList()).add(columnData);
        }
        List list = ContainerUtil.map(columnsQueryDataByTable.entrySet(), entry -> new GridRowMutation((DasObject)entry.getKey(), this.getColumnsByTable((DasObject)entry.getKey()), row, (List)entry.getValue()));
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(77);
        }
        return list;
    }

    @NotNull
    private @NotNull List<? extends @NotNull GridColumn> getColumnsByTable(DasObject table) {
        GridTablesModel gridTablesModel = this.myHookUp.getGridTablesModel();
        ArrayList<GridColumn> result2 = new ArrayList<GridColumn>(this.myModel.getColumnCount());
        if (gridTablesModel == null || gridTablesModel.isColumnsEmpty()) {
            List list = this.myModel.getColumns();
            if (list == null) {
                DatabaseMutatorImpl.$$$reportNull$$$0(78);
            }
            return list;
        }
        for (GridColumn column2 : this.myModel.getColumns()) {
            int columnNumber = column2.getColumnNumber();
            if (!Objects.equals(gridTablesModel.getDasTableByColumnIndex(columnNumber), table)) continue;
            if (gridTablesModel.isColumnWithSynonym(columnNumber) && column2 instanceof DataConsumer.Column) {
                DataConsumer.Column consumerColumn = (DataConsumer.Column)column2;
                result2.add(this.getColumnWithRealName(consumerColumn, columnNumber));
                continue;
            }
            result2.add(column2);
        }
        ArrayList<GridColumn> arrayList = result2;
        if (arrayList == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(79);
        }
        return arrayList;
    }

    @Nullable
    private DmlMutationContext asContext(@NotNull List<DatabaseMutation> mutations) {
        if (mutations == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(80);
        }
        if (mutations.isEmpty()) {
            return null;
        }
        ArrayList<DatabaseMutation> sorted = new ArrayList<DatabaseMutation>(mutations);
        ContainerUtil.sort(sorted);
        return new DmlMutationContext(sorted);
    }

    @NotNull
    private List<ColumnQueryData> createUpdateData(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(81);
        }
        ArrayList<ColumnQueryData> infos = new ArrayList<ColumnQueryData>();
        int columnCount = this.myMutationModel.getColumnCount();
        for (int i2 = 0; i2 < columnCount; ++i2) {
            ModelIndex columnIdx = ModelIndex.forColumn(this.myModel, (int)i2);
            MutationData mutation = this.myStorage.get(row, columnIdx);
            if (mutation == null || !this.isValidColumnIdx((ModelIndex<GridColumn>)columnIdx)) continue;
            GridColumn column2 = this.myMutationModel.getColumn(columnIdx);
            if (this.myHookUp.getGridTablesModel() != null && this.myHookUp.getGridTablesModel().isColumnWithSynonym(columnIdx.value) && column2 instanceof DataConsumer.Column) {
                DataConsumer.Column dataConsumerColumn = (DataConsumer.Column)column2;
                column2 = this.getColumnWithRealName(dataConsumerColumn, columnIdx.value);
            }
            if (column2 == null) continue;
            infos.add(new ColumnQueryData(column2, mutation.getValue()));
        }
        ArrayList<ColumnQueryData> arrayList = infos;
        if (arrayList == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(82);
        }
        return arrayList;
    }

    @NotNull
    private GridColumn getColumnWithRealName(DataConsumer.Column dataConsumerColumn, int columnIdx) {
        if (this.myHookUp.getGridTablesModel() == null) {
            DataConsumer.Column column2 = dataConsumerColumn;
            if (column2 == null) {
                DatabaseMutatorImpl.$$$reportNull$$$0(83);
            }
            return column2;
        }
        String realColumnName = this.myHookUp.getGridTablesModel().getRealColumnName(columnIdx);
        return new DataConsumer.Column(dataConsumerColumn.getColumnNumber(), realColumnName, dataConsumerColumn.getType(), dataConsumerColumn.getTypeName(), dataConsumerColumn.getJavaClassName());
    }

    private void doInsertRows(@NotNull List<GridRow> newRows) {
        if (newRows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(84);
        }
        this.myFailed = false;
        List<GridColumn> columns = this.getPhysicalColumns((ModelIndexSet<GridColumn>)this.myModel.getColumnIndices());
        int newRowIdx = this.myMutationModel.getRowCount();
        ArrayList<ModelIndex> rowIdxes = new ArrayList<ModelIndex>();
        for (GridRow newRow : newRows) {
            ModelIndex rowIdx = ModelIndex.forRow(this.myModel, (int)newRowIdx);
            this.myStorage.insertRow(rowIdx);
            for (GridColumn column2 : columns) {
                ModelIndex columnIdx = ModelIndex.forColumn(this.myModel, (int)column2.getColumnNumber());
                CellMutation mutation = new CellMutation(rowIdx, columnIdx, column2.getValue(newRow));
                this.myStorage.set(rowIdx, columnIdx, mutation);
            }
            rowIdxes.add(rowIdx);
            ++newRowIdx;
        }
        this.myMutationModel.notifyRowsAdded(ModelIndexSet.forRows(this.myModel, rowIdxes));
    }

    private void doInsertRow(@NotNull GridRow newRow) {
        if (newRow == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(85);
        }
        this.myFailed = false;
        int newRowIdx = this.myMutationModel.getRowCount();
        ModelIndex rowIdx = ModelIndex.forRow(this.myModel, (int)newRowIdx);
        this.myStorage.insertRow(rowIdx);
        List<GridColumn> columns = this.getPhysicalColumns((ModelIndexSet<GridColumn>)this.myModel.getColumnIndices());
        for (GridColumn column2 : columns) {
            ModelIndex columnIdx = ModelIndex.forColumn(this.myModel, (int)column2.getColumnNumber());
            CellMutation mutation = new CellMutation(rowIdx, columnIdx, column2.getValue(newRow));
            this.myStorage.set(rowIdx, columnIdx, mutation);
        }
        this.myMutationModel.notifyRowsAdded(ModelIndexSet.forRows(this.myModel, (ModelIndex[])new ModelIndex[]{rowIdx}));
    }

    @Nullable
    private DasObject getDatabaseTable() {
        return this.myHookUp.getDatabaseTable();
    }

    private void notifyRequestFinished(@NotNull GridRequestSource source, boolean success) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(86);
        }
        this.myHookUp.notifyRequestFinished(source, success);
    }

    private void notifyUpdateCountReceived(@NotNull GridRequestSource source, int count) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(87);
        }
        this.myHookUp.notifyUpdateCountReceived(source, count);
    }

    private boolean isReadOnly() {
        return this.myHookUp.isReadOnly();
    }

    private boolean hasDifferentRowTypes(@NotNull ModelIndexSet<GridRow> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(88);
        }
        boolean hasInserted = false;
        boolean hasNotInserted = false;
        for (ModelIndex rowModelIndex : rows.asIterable()) {
            boolean inserted = this.isInsertedRow((ModelIndex<GridRow>)rowModelIndex);
            hasInserted |= inserted;
            hasNotInserted |= !inserted;
        }
        return hasInserted && hasNotInserted;
    }

    @Nullable
    private DataRequest.DmlRequest createRequest(@NotNull PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest> creator, @Nullable DmlMutationContext context) {
        if (creator == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(89);
        }
        return context == null ? null : (DataRequest.DmlRequest)((Object)creator.fun((Object)this.myHookUp, (Object)context));
    }

    @NotNull
    private static List<ColumnQueryData> createColumnsUpdateData(@NotNull GridRow row, @NotNull List<? extends GridColumn> columns) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(90);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(91);
        }
        List list = ContainerUtil.map(columns, column2 -> new ColumnQueryData(column2, column2.getValue(row)));
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(92);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 34, 37, 38, 39, 41, 49, 53, 65, 74, 75, 76, 77, 78, 79, 82, 83, 92 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutationModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesEqual";
                break;
            }
            case 5: 
            case 8: 
            case 14: 
            case 29: 
            case 31: 
            case 32: 
            case 40: 
            case 50: 
            case 54: 
            case 57: 
            case 58: 
            case 62: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 15: 
            case 30: 
            case 36: 
            case 42: 
            case 48: 
            case 66: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 7: 
            case 16: 
            case 43: 
            case 55: 
            case 56: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 9: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 10: 
            case 12: 
            case 21: 
            case 25: 
            case 27: 
            case 35: 
            case 44: 
            case 45: 
            case 47: 
            case 72: 
            case 81: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 11: 
            case 13: 
            case 26: 
            case 28: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colIdx";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndices";
                break;
            }
            case 20: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndices";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 33: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toClone";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 49: 
            case 53: 
            case 65: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseMutatorImpl";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexes";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isValid";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isInserted";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleteInStorage";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notifyRemoved";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsQueryData";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRows";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRow";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseMutatorImpl";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createRow";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedRows";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertedRows";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertedColumns";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getPendingChanges";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowsInDatabaseDataModel";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalColumns";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getGridRowMutations";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsByTable";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateData";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnWithRealName";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnsUpdateData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mutate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isUpdateSafe";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedRow";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedColumn";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedColumn";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getInsertedColumn";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMutation";
                break;
            }
            case 27: 
            case 28: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getMutationType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "deleteRows";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "insertRows";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "cloneRow";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 49: 
            case 53: 
            case 65: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 92: {
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedRow";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedRows";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasMutatedRows";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isValidRowIdx";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isValidColumnIdx";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "hasUnparsedValues";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getRowsInDatabaseDataModel";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processRequest";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getPhysicalColumns";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "deleteColumns";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "doDeleteColumns";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "insertColumn";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "renameColumn";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getStringTypeName";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "cloneColumn";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "doDeleteRows";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "doDeleteRowsOrColumns";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getGridRowMutations";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "asContext";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateData";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "doInsertRows";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "doInsertRow";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "notifyRequestFinished";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "notifyUpdateCountReceived";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "hasDifferentRowTypes";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "createColumnsUpdateData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 34, 37, 38, 39, 41, 49, 53, 65, 74, 75, 76, 77, 78, 79, 82, 83, 92 -> new IllegalStateException(string);
        };
    }

    private class MyRequestListener
    implements GridDataHookUp.RequestListener<GridRow, GridColumn> {
        private MyRequestListener() {
        }

        public void error(@NotNull GridRequestSource source, @NotNull ErrorInfo errorInfo) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(0);
            }
            if (errorInfo == null) {
                MyRequestListener.$$$reportNull$$$0(1);
            }
            DatabaseMutatorImpl.this.myFailed = true;
        }

        public void updateCountReceived(@NotNull GridRequestSource source, int updateCount2) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(2);
            }
        }

        public void requestFinished(@NotNull GridRequestSource source, boolean success) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DatabaseMutatorImpl$MyRequestListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PendingContexts {
        final DmlMutationContext insert;
        final DmlMutationContext update;
        final DmlMutationContext delete;

        private PendingContexts(@Nullable DmlMutationContext insert, @Nullable DmlMutationContext update2, @Nullable DmlMutationContext delete) {
            this.insert = insert;
            this.update = update2;
            this.delete = delete;
        }
    }

    private static final class RowKey {
        private final Object[] values;
        private final int hashCode;

        private RowKey(Object[] values) {
            this.values = values;
            this.hashCode = Arrays.hashCode(values);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowKey rowKey = (RowKey)o;
            return Arrays.equals(this.values, rowKey.values);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

