/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.ui.CompletionParamEditorBase;
import com.intellij.database.dataSource.url.ui.MyUpdater;
import com.intellij.database.dataSource.url.ui.UniformLookSettingsProvider;
import com.intellij.database.schemaEditor.ui.ManualPopupButton;
import com.intellij.database.util.AsyncUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionParamEditor<T>
extends CompletionParamEditorBase<T, ProgressFieldWithCompletion<T>> {
    private static final Key<CompletionParamEditor<?>> PARAM_EDITOR_KEY = Key.create((String)"CompletionParamEditor");
    protected static final Key<Boolean> FORCED_KEY = Key.create((String)"FORCED_KEY");
    private final CompletionProvider myProvider;
    private boolean myValidateOnDirtyCompletion;
    private boolean myReportErrorOnAutoPopup;
    protected List<T> myModel;
    private boolean myDirty;
    private boolean myFailed;
    private @NlsActions.ActionText String myForceRefreshTitle;
    private final ActionGroup myContextMenu;

    public CompletionParamEditor(@NlsContexts.Label @NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            CompletionParamEditor.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            CompletionParamEditor.$$$reportNull$$$0(1);
        }
        super(new ProgressFieldWithCompletion(interchange.getProject()), interchange, label);
        this.myValidateOnDirtyCompletion = false;
        this.myReportErrorOnAutoPopup = false;
        this.myModel = Collections.emptyList();
        this.myDirty = true;
        this.myFailed = false;
        this.myForceRefreshTitle = null;
        this.myContextMenu = new ActionGroup(){

            @NotNull
            public @NotNull AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                List items = CompletionParamEditor.this.getContextMenuEntries().toList();
                AnAction[] anActionArray = items.toArray(AnAction.EMPTY_ARRAY);
                if (anActionArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$1", "getChildren"));
            }
        };
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.getEditorComponent()));
        this.myProvider = new CompletionProvider();
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().installProvider((TextFieldWithAutoCompletionListProvider)this.myProvider);
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider((EditorSettingsProvider)new UniformLookSettingsProvider());
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CompletionParamEditor.this.fireChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$2", "documentChanged"));
            }
        });
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider(editor2 -> {
            editor2.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler.Simple(this.myContextMenu));
            PARAM_EDITOR_KEY.set((UserDataHolder)editor2, (Object)this);
        });
        ManualPopupButton.INSTANCE.install((EditorTextField)((ProgressFieldWithCompletion)this.getEditorComponent()).getField(), false);
    }

    @NotNull
    protected JBIterable<AnAction> getContextMenuEntries() {
        if (this.myForceRefreshTitle == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                CompletionParamEditor.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)MyForceRefresh.INSTANCE);
        if (jBIterable == null) {
            CompletionParamEditor.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    public void setSupersedeTasks(boolean supersedeTasks) {
        this.getMyUpdater().setMySupersedeTasks(supersedeTasks);
    }

    public void setReportErrorOnAutoPopup(boolean reportErrorOnAutoPopup) {
        this.myReportErrorOnAutoPopup = reportErrorOnAutoPopup;
    }

    public void setValidateOnDirtyCompletion(boolean validateOnDirtyCompletion) {
        this.myValidateOnDirtyCompletion = validateOnDirtyCompletion;
    }

    protected void addUpdateOnShow() {
        UiNotifyConnector.installOn(this.getEditorComponent(), (Activatable)new Activatable(){

            public void showNotify() {
                CompletionParamEditor.this.updateModelAtShow();
            }
        });
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        TextFieldWithAutoCompletion textFieldWithAutoCompletion = ((ProgressFieldWithCompletion)this.getEditorComponent()).getField();
        if (textFieldWithAutoCompletion == null) {
            CompletionParamEditor.$$$reportNull$$$0(4);
        }
        return textFieldWithAutoCompletion;
    }

    @Override
    public void addFocusListener(@NotNull FocusListener listener2) {
        if (listener2 == null) {
            CompletionParamEditor.$$$reportNull$$$0(5);
        }
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().addFocusListener(listener2);
    }

    protected void onCompletion(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionParamEditor.$$$reportNull$$$0(6);
        }
        if (!this.myValidateOnDirtyCompletion || !this.myDirty && parameters.getCompletionType() == CompletionType.BASIC && (!this.myFailed || parameters.isAutoPopup())) {
            return;
        }
        this.myDirty = false;
        AsyncUtil.markAsyncFriendly(ProgressIndicatorProvider.getGlobalProgressIndicator(), true);
        this.updateModelSync(parameters.isAutoPopup());
    }

    protected void updateNowIfVisible() {
        if (((ProgressFieldWithCompletion)this.getEditorComponent()).isVisible()) {
            this.updateModelAsync();
        } else {
            this.setDirty(true);
        }
    }

    protected void setDirty(boolean dirty) {
        this.myDirty = dirty;
    }

    protected void setUpdateTitle(@NlsContexts.ProgressTitle String updateTitle) {
        this.getMyUpdater().setMyUpdateTitle(updateTitle);
    }

    @NotNull
    private MyUpdater<T> getMyUpdater() {
        MyUpdater myUpdater = this.getMyUpdater$intellij_database_impl();
        if (myUpdater == null) {
            CompletionParamEditor.$$$reportNull$$$0(7);
        }
        return myUpdater;
    }

    protected void resetVariants() {
        this.myModel = Collections.emptyList();
        this.myProvider.setItems(this.myModel);
        this.setDirty(true);
    }

    protected void setVariantsAndCompletionVariants(@NotNull List<T> variants) {
        if (variants == null) {
            CompletionParamEditor.$$$reportNull$$$0(8);
        }
        this.setCompletionVariants(variants);
        this.setVariants(variants);
    }

    protected void setVariants(@NotNull List<T> variants) {
        if (variants == null) {
            CompletionParamEditor.$$$reportNull$$$0(9);
        }
        this.myModel = variants;
    }

    protected void setCompletionVariants(@NotNull List<T> variants) {
        if (variants == null) {
            CompletionParamEditor.$$$reportNull$$$0(10);
        }
        this.myProvider.setItems(variants);
        this.setDirty(false);
    }

    @Nullable
    public T getItemByText(@NotNull String text2) {
        if (text2 == null) {
            CompletionParamEditor.$$$reportNull$$$0(11);
        }
        for (T item : this.myModel) {
            if (!text2.equals(this.getText(item))) continue;
            return item;
        }
        for (T item : this.myModel) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)this.getText(item))) continue;
            return item;
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        String string = ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().getText();
        if (string == null) {
            CompletionParamEditor.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    public void setText(@NotNull String text2) {
        if (text2 == null) {
            CompletionParamEditor.$$$reportNull$$$0(13);
        }
        if (!text2.equals(((ProgressFieldWithCompletion)this.getEditorComponent()).getField().getText())) {
            ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().setText(text2);
        }
    }

    protected void updateModelAsync() {
        this.getMyUpdater().update(true, Collections.emptyMap());
    }

    protected void updateModelForce() {
        this.getMyUpdater().update(false, Collections.singletonMap(FORCED_KEY, Boolean.TRUE));
    }

    protected void updateModelSync(boolean isAutoPopup) {
        this.getMyUpdater().updateSync(isAutoPopup, Collections.emptyMap());
    }

    protected void updateModelAtShow() {
        this.updateModelAsync();
    }

    @NotNull
    protected abstract String getText(@NotNull T var1);

    @Nullable
    protected String getTailText(@NotNull T item) {
        if (item == null) {
            CompletionParamEditor.$$$reportNull$$$0(14);
        }
        return null;
    }

    @Nullable
    protected String getTypeText(@NotNull T item) {
        if (item == null) {
            CompletionParamEditor.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Nullable
    protected Icon getIcon(@NotNull T item) {
        if (item == null) {
            CompletionParamEditor.$$$reportNull$$$0(16);
        }
        return null;
    }

    public void setForceRefresh(@NlsActions.ActionText @Nullable String forceRefreshTitle) {
        this.myForceRefreshTitle = forceRefreshTitle;
    }

    @Override
    protected void applyVariants(@NotNull List<T> res2) {
        if (res2 == null) {
            CompletionParamEditor.$$$reportNull$$$0(17);
        }
        this.myFailed = false;
        this.setCompletionVariants(res2);
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> this.setVariants(res2));
    }

    public boolean canRefresh() {
        return !this.getMyUpdater().isRunning() || this.getMyUpdater().getMySupersedeTasks();
    }

    @Override
    protected void setBusy(boolean busy) {
        ((ProgressFieldWithCompletion)this.getEditorComponent()).setBusy(busy);
    }

    @Override
    protected void showError(boolean isAutoPopup, @Nls String errorHandler) {
        this.myFailed = true;
        if (!errorHandler.isEmpty()) {
            if (!isAutoPopup || this.myReportErrorOnAutoPopup) {
                this.getInterchange().showError(errorHandler, this);
            }
        } else {
            this.myDirty = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextMenuEntries";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusableComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyUpdater";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFocusListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onCompletion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setVariantsAndCompletionVariants";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setVariants";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionVariants";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getItemByText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTailText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyVariants";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7, 12 -> new IllegalStateException(string);
        };
    }

    public static class ProgressFieldWithCompletion<T>
    extends JPanel
    implements Disposable,
    Runnable {
        private final AsyncProcessIcon myBusyIcon = new AsyncProcessIcon("updating");
        private boolean myBusy;
        private final TextFieldWithAutoCompletion<T> myField;

        public ProgressFieldWithCompletion(Project project) {
            this.setLayout(new OverlayLayout(this));
            this.myField = new TextFieldWithAutoCompletion(project, TextFieldWithAutoCompletion.EMPTY_COMPLETION, true, null);
            this.myBusyIcon.setVisible(false);
            this.myBusyIcon.suspend();
            this.add((Component)this.myBusyIcon);
            this.add((Component)this.myField);
        }

        @NotNull
        public TextFieldWithAutoCompletion<T> getField() {
            TextFieldWithAutoCompletion<T> textFieldWithAutoCompletion = this.myField;
            if (textFieldWithAutoCompletion == null) {
                ProgressFieldWithCompletion.$$$reportNull$$$0(0);
            }
            return textFieldWithAutoCompletion;
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myBusyIcon);
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.updateBusyLocation();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.updateBusyLocation();
        }

        public void setBusy(boolean busy) {
            if (this.myBusy == busy) {
                return;
            }
            this.myBusy = busy;
            UIUtil.invokeLaterIfNeeded((Runnable)this);
        }

        @Override
        public void run() {
            this.myBusyIcon.setVisible(this.myBusy);
            if (this.myBusy) {
                this.myBusyIcon.resume();
            } else {
                this.myBusyIcon.suspend();
            }
            this.revalidate();
        }

        public void updateBusyLocation() {
            Rectangle rec;
            if (this.myField.getEditor() != null) {
                JComponent component = this.myField.getEditor().getComponent();
                rec = SwingUtilities.convertRectangle(component, component.getVisibleRect(), this);
            } else {
                rec = this.myField.getVisibleRect();
            }
            Dimension iconSize = this.myBusyIcon.getPreferredSize();
            int displacement = Math.max((rec.height - iconSize.height) / 2, 0);
            Rectangle newBounds = new Rectangle(rec.x + rec.width - iconSize.width - displacement, rec.y + displacement, iconSize.width, iconSize.height);
            if (!newBounds.equals(this.myBusyIcon.getBounds())) {
                this.myBusyIcon.setBounds(newBounds);
                SwingUtilities.invokeLater(() -> this.repaint());
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JPanel.AccessibleJPanel(){

                    @Override
                    public void setAccessibleName(@Nls String s) {
                        myField.getAccessibleContext().setAccessibleName(s);
                    }
                };
            }
            return this.accessibleContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$ProgressFieldWithCompletion", "getField"));
        }
    }

    private class CompletionProvider
    extends TextFieldWithAutoCompletionListProvider<T> {
        protected CompletionProvider() {
            super(null);
        }

        @NotNull
        public Collection<T> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            if (!cached) {
                CompletionParamEditor.this.onCompletion(parameters);
            }
            Collection collection = super.getItems(prefix, cached, parameters);
            if (collection == null) {
                CompletionProvider.$$$reportNull$$$0(0);
            }
            return collection;
        }

        public boolean isDumbAware() {
            return true;
        }

        @Nullable
        protected Icon getIcon(@NotNull T item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(1);
            }
            return CompletionParamEditor.this.getIcon(item);
        }

        @NotNull
        protected String getLookupString(@NotNull T item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(2);
            }
            String string = CompletionParamEditor.this.getText(item);
            if (string == null) {
                CompletionProvider.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        protected String getTailText(@NotNull T item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(4);
            }
            return CompletionParamEditor.this.getTailText(item);
        }

        @Nullable
        protected String getTypeText(@NotNull T item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(5);
            }
            return CompletionParamEditor.this.getTypeText(item);
        }

        public int compare(T item1, T item2) {
            return StringUtil.naturalCompare((String)this.getLookupString(item1), (String)this.getLookupString(item2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor$CompletionProvider";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor$CompletionProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyForceRefresh
    extends DumbAwareAction {
        public static final AnAction INSTANCE = new MyForceRefresh();

        MyForceRefresh() {
            super(DatabaseBundle.messagePointer("action.CompletionParamEditor.text", new Object[0]), AllIcons.Actions.Refresh);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyForceRefresh.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyForceRefresh.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            CompletionParamEditor editor2 = this.getParamEditor(e.getDataContext());
            if (editor2 == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            presentation.setVisible(true);
            presentation.setEnabled(editor2.canRefresh());
            presentation.setText(editor2.myForceRefreshTitle);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CompletionParamEditor editor2;
            if (e == null) {
                MyForceRefresh.$$$reportNull$$$0(2);
            }
            if ((editor2 = this.getParamEditor(e.getDataContext())) == null) {
                return;
            }
            editor2.updateModelForce();
        }

        @Nullable
        CompletionParamEditor getParamEditor(@NotNull DataContext context) {
            Editor editor2;
            if (context == null) {
                MyForceRefresh.$$$reportNull$$$0(3);
            }
            if ((editor2 = (Editor)CommonDataKeys.EDITOR.getData(context)) == null) {
                return null;
            }
            return (CompletionParamEditor)PARAM_EDITOR_KEY.get((UserDataHolder)editor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor$MyForceRefresh";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor$MyForceRefresh";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getParamEditor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

