/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.TypeDescriptor;
import com.intellij.database.dataSource.url.TypeDescriptorUi;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.ComboBoxTypeDescriptor;
import com.intellij.database.dataSource.url.ui.DatabaseTypeDescriptor;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.TextCBTypeDescriptor;
import com.intellij.database.dataSource.url.ui.TextFieldTypeDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class TypesRegistryUi {
    private static final ExtensionPointName<TypeDescriptorUiFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.urlParamEditorUiProvider");
    private volatile Map<String, TypeDescriptorUi> myTypeUis;
    private volatile boolean epHasChanged = false;

    public static TypesRegistryUi getInstance() {
        return (TypesRegistryUi)ApplicationManager.getApplication().getService(TypesRegistryUi.class);
    }

    private TypesRegistryUi() {
        this.updateState();
        EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<TypeDescriptorUiFactory>(){

            public void extensionAdded(@NotNull TypeDescriptorUiFactory factory, @NotNull PluginDescriptor pluginDescriptor) {
                if (factory == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                TypesRegistryUi.this.epHasChanged = true;
            }

            public void extensionRemoved(@NotNull TypeDescriptorUiFactory factory, @NotNull PluginDescriptor pluginDescriptor) {
                if (factory == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                TypesRegistryUi.this.epHasChanged = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistryUi$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void updateState() {
        HashMap<String, TypeDescriptorUi> newTypeUis = new HashMap<String, TypeDescriptorUi>();
        TypesRegistryUi.put(newTypeUis, new TextFieldTypeDescriptor("large_text", FieldSize.LARGE, new AnAction[0]));
        TypesRegistryUi.put(newTypeUis, new TextFieldTypeDescriptor("medium_text"));
        TypesRegistryUi.put(newTypeUis, new TextFieldTypeDescriptor("small_text", FieldSize.SMALL, new AnAction[0]));
        TypesRegistryUi.put(newTypeUis, new DatabaseTypeDescriptor("database"));
        TypesRegistryUi.put(newTypeUis, new TextFieldTypeDescriptor("file", FieldSize.LARGE, TypesRegistryUi.getSelectDbAction(true), TypesRegistryUi.getCreateDbAction()));
        TypesRegistryUi.put(newTypeUis, new TextFieldTypeDescriptor("path", FieldSize.LARGE, TypesRegistryUi.getSelectDbAction(false)));
        TypesRegistryUi.put(newTypeUis, new TextFieldTypeDescriptor("path_db", FieldSize.LARGE, TypesRegistryUi.getSelectDbPathFileAction()));
        TypesRegistryUi.put(newTypeUis, new TextCBTypeDescriptor("true_box", "true", "", "true", "false|"));
        TypesRegistryUi.put(newTypeUis, new ComboBoxTypeDescriptor("variants"));
        for (TypeDescriptorUiFactory factory : (TypeDescriptorUiFactory[])EP_NAME.getExtensions()) {
            factory.createTypeDescriptor((Consumer<? super TypeDescriptorUi>)((Consumer)o -> TypesRegistryUi.put(newTypeUis, o)));
        }
        this.myTypeUis = newTypeUis;
    }

    private static void put(Map<String, TypeDescriptorUi> typeUis, @NotNull TypeDescriptorUi desc) {
        if (desc == null) {
            TypesRegistryUi.$$$reportNull$$$0(0);
        }
        TypeDescriptorUi prev2 = typeUis.put(desc.getId(), desc);
        assert (prev2 == null);
    }

    @Nullable
    public TypeDescriptorUi get(@NotNull String id) {
        if (id == null) {
            TypesRegistryUi.$$$reportNull$$$0(1);
        }
        this.ensureStateIsUpdated();
        TypeDescriptorUi desc = this.myTypeUis.get(id);
        if (desc != null) {
            return desc;
        }
        TypeDescriptor tDesc = TypesRegistry.getInstance().get(id);
        String parent = tDesc == null ? null : tDesc.getCategory();
        return parent == null || id.equals(parent) ? null : this.get(parent);
    }

    private void ensureStateIsUpdated() {
        if (this.epHasChanged) {
            this.updateState();
            this.epHasChanged = false;
        }
    }

    private static AnAction getSelectDbPathFileAction() {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, false, false, false, false);
        descriptor2.setHideIgnored(false);
        descriptor2.setTitle(DatabaseBundle.message("dialog.title.choose.database.file.or.path", new Object[0]));
        return new ParamEditorBase.FMChooseAction(descriptor2){

            protected void setFile(@NotNull ParamEditorBase editor2, @NotNull VirtualFile file) {
                if (editor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (file.isDirectory()) {
                    super.setFile(editor2, file);
                    return;
                }
                editor2.setText(file.getParent().getPath());
                editor2.getInterchange().putProperty("database", file.getNameWithoutExtension());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/url/TypesRegistryUi$2";
                objectArray[2] = "setFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static AnAction getSelectDbAction(boolean file) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(file, !file, false, false, false, false);
        descriptor2.setHideIgnored(false);
        descriptor2.setTitle(DatabaseBundle.message("dialog.title.choose.database", file ? DatabaseBundle.message("dialog.title.choose.database.file", new Object[0]) : DatabaseBundle.message("dialog.title.choose.database.path", new Object[0])));
        return new ParamEditorBase.FMChooseAction(descriptor2);
    }

    private static AnAction getCreateDbAction() {
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(DatabaseBundle.message("dialog.title.new.database", new Object[0]), DatabaseBundle.message("label.choose.database.file.path.name", new Object[0]));
        return new ParamEditorBase.FMSaveAction(descriptor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistryUi";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface TypeDescriptorUiFactory {
        public void createTypeDescriptor(@NotNull Consumer<? super TypeDescriptorUi> var1);
    }
}

