/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import me.xuender.unidecode.Unidecode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public final class DbSrcBackendUtils {
    private static final Logger LOG = Logger.getInstance(DbSrcBackendUtils.class);
    private static final Tag META_DATA_TAG = new Tag("md");

    public static byte[] serializeMetaData(@NotNull ObjectPath object, @NotNull DbSrcStorageDsMetadata.MetaData metaData) {
        if (object == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(0);
        }
        if (metaData == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(1);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
        try {
            writer.write("#n:");
            writer.write(StringUtil.escapeStringCharacters((String)object.getName()));
            if (object.getIdentity() != null) {
                writer.write("\n#i:");
                writer.write(StringUtil.escapeStringCharacters((String)object.getIdentity()));
            }
            if (metaData != DbSrcStorageDsMetadata.MetaData.EMPTY) {
                writer.write("\n");
                new Yaml((Representer)new MyRepresenter()).dump((Object)metaData, (Writer)writer);
            }
            writer.flush();
            return stream.toByteArray();
        }
        catch (IOException e) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
    }

    @NotNull
    static DbSrcStorageDsMetadata.MetaData deserializeMetaData(InputStream stream) {
        DbSrcStorageDsMetadata.MetaData metaData;
        try {
            DbSrcStorageDsMetadata.MetaData meta = (DbSrcStorageDsMetadata.MetaData)RemoteUtil.executeWithClassLoader(() -> (DbSrcStorageDsMetadata.MetaData)new Yaml((BaseConstructor)new Constructor(DbSrcStorageDsMetadata.MetaData.class, new LoaderOptions()), (Representer)new MyRepresenter()).load((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)), (ClassLoader)DbSrcStorageDsMetadata.class.getClassLoader());
            metaData = (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)meta, (Object)DbSrcStorageDsMetadata.MetaData.EMPTY);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            DbSrcStorageDsMetadata.MetaData metaData2 = DbSrcStorageDsMetadata.MetaData.EMPTY;
            if (metaData2 == null) {
                DbSrcBackendUtils.$$$reportNull$$$0(3);
            }
            return metaData2;
        }
        if (metaData == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(2);
        }
        return metaData;
    }

    @NotNull
    static Path getDir(@NotNull String root, boolean staging, @Nullable ObjectPath object, @Nullable ObjectKind group, @Nullable String ext) {
        if (root == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(4);
        }
        FileSystem fs = FileSystems.getDefault();
        String sep = fs.getSeparator();
        Path path = fs.getPath(DbSrcBackendUtils.getDir(root, staging, object, group, ext, sep), new String[0]);
        if (path == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(5);
        }
        return path;
    }

    @NotNull
    private static String getDir(@NotNull String root, boolean staging, @Nullable ObjectPath object, @Nullable ObjectKind group, @Nullable String ext, @NotNull String sep) {
        if (root == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(6);
        }
        if (sep == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(7);
        }
        StringBuilder path = new StringBuilder();
        path.append(root).append(sep).append(staging ? "_staging_" : "_src_");
        if (object != null) {
            DbSrcBackendUtils.appendPath(path.append(sep), object, 0, sep);
        }
        if (group != null) {
            path.append(sep).append(group.code());
        } else if (ext != null) {
            path.append(ext);
        }
        String string = path.toString();
        if (string == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static void appendPath(@NotNull StringBuilder res2, @NotNull ObjectPath object, int start2, @NotNull String sep) {
        if (res2 == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(9);
        }
        if (object == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(10);
        }
        if (sep == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(11);
        }
        DbSrcBackendUtils.appendPathInner(res2, object, start2, sep);
    }

    public static boolean isSamePhysicalLocation(@NotNull ObjectPath o1, @NotNull ObjectPath o2) {
        if (o1 == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(12);
        }
        if (o2 == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(13);
        }
        StringBuilder sb1 = new StringBuilder();
        DbSrcBackendUtils.appendPath(sb1, o1, 0, "/");
        StringBuilder sb2 = new StringBuilder();
        DbSrcBackendUtils.appendPath(sb2, o2, 0, "/");
        return StringUtil.equals((CharSequence)sb1, (CharSequence)sb2);
    }

    private static int appendPathInner(@NotNull StringBuilder res2, @NotNull ObjectPath object, int start2, @NotNull String sep) {
        int d;
        if (res2 == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(14);
        }
        if (object == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(15);
        }
        if (sep == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(16);
        }
        int n = d = object.parent == null ? 0 : DbSrcBackendUtils.appendPathInner(res2, object.parent, start2, sep);
        if (d >= start2) {
            if (d != start2) {
                res2.append(sep);
            }
            res2.append(object.kind.code()).append(sep);
            DbSrcBackendUtils.appendSimpleName(res2, object.name, object.getIdentity());
        }
        return d + 1;
    }

    public static String getSimpleName(@NotNull String name2, @Nullable String identity) {
        if (name2 == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(17);
        }
        StringBuilder builder = new StringBuilder();
        DbSrcBackendUtils.appendSimpleName(builder, name2, identity);
        return builder.toString();
    }

    private static void appendSimpleName(@NotNull StringBuilder res2, @NotNull String name2, @Nullable String identity) {
        if (res2 == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(18);
        }
        if (name2 == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(19);
        }
        String trans = Unidecode.decode((String)name2);
        int l = trans.length();
        for (int i2 = 0; i2 < l; ++i2) {
            char c2 = trans.charAt(i2);
            if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9' || c2 == '-' || c2 == '.') {
                res2.append(c2);
                continue;
            }
            res2.append('_');
        }
        res2.append(".");
        int hc = name2.hashCode() + Comparing.hashcode((Object)identity) * 31;
        byte[] bytes2 = new byte[]{(byte)(hc & 0xFF), (byte)(hc >>> 8 & 0xFF), (byte)(hc >>> 16 & 0xFF), (byte)(hc >>> 24 & 0xFF)};
        for (byte b : Base64.getUrlEncoder().encode(bytes2)) {
            if (b == 61) break;
            res2.append((char)b);
        }
    }

    public static ObjectPath normalizePath(@Nullable ObjectPath path) {
        if (path == null) {
            return null;
        }
        ObjectPath parent = DbSrcBackendUtils.normalizePath(path.parent);
        if (parent == path.parent && path.isQuoted()) {
            return path;
        }
        return DbSrcBackendUtils.createPath(parent, path.name, path.kind, path.getIdentity());
    }

    @NotNull
    public static ObjectPath createPath(@Nullable ObjectPath parent, @NotNull String name2, @NotNull ObjectKind kind, @Nullable String identity) {
        if (name2 == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(20);
        }
        if (kind == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(21);
        }
        ObjectPath objectPath = ObjectPath.create(name2, kind, true, identity, parent);
        if (objectPath == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(22);
        }
        return objectPath;
    }

    @Nullable
    static Pair<String, String> extractNameAndIdentity(byte[] data) {
        int end = DbSrcBackendUtils.getPropertyLineEnd(data, 0, 'n');
        if (end == -1) {
            return null;
        }
        String name2 = DbUtil.intern(DbSrcBackendUtils.toStr(data, 3, end));
        String identity = null;
        if (end + 1 < data.length) {
            int s = end;
            if (data[s] == 13 && data[s + 1] == 10) {
                ++s;
            }
            if ((end = DbSrcBackendUtils.getPropertyLineEnd(data, s + 1, 'i')) != -1) {
                identity = DbUtil.intern(DbSrcBackendUtils.toStr(data, s + 4, end));
            }
        }
        return Pair.create((Object)name2, identity);
    }

    private static String toStr(byte[] data, int start2, int end) {
        return StringUtil.unescapeStringCharacters((String)new String(data, start2, end - start2, StandardCharsets.UTF_8));
    }

    private static int getPropertyLineEnd(byte[] data, int start2, char l) {
        if (start2 + 2 >= data.length || data[start2] != 35 || data[start2 + 1] != l || data[start2 + 2] != 58) {
            return -1;
        }
        for (int i2 = start2 + 3; i2 < data.length; ++i2) {
            byte c2 = data[i2];
            if (c2 != 13 && c2 != 10) continue;
            return i2;
        }
        return data.length;
    }

    @NotNull
    public static <K, T> List<T> clearAndGetValues(@NotNull Map<K, ? extends T> map2) {
        if (map2 == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(23);
        }
        ArrayList<K> keys = new ArrayList<K>(map2.keySet());
        List list = ContainerUtil.mapNotNull(keys, map2::remove);
        if (list == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(24);
        }
        return list;
    }

    static boolean isStaging(@NotNull SrcType type) {
        if (type == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(25);
        }
        return type != SrcType.ORIGINAL;
    }

    @NotNull
    static Path getSrc(@SystemDependent String root, @NotNull ObjectPath object, @NotNull SrcType type) {
        if (object == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(26);
        }
        if (type == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(27);
        }
        return DbSrcBackendUtils.getDir(root, DbSrcBackendUtils.isStaging(type), object, null, type == SrcType.USER_BASE ? ".base.sql" : ".sql");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 8, 22, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendUtils";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sep";
                break;
            }
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeMetaData";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDir";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "clearAndGetValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serializeMetaData";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 22: 
            case 24: {
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDir";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSamePhysicalLocation";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendPathInner";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendSimpleName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createPath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "clearAndGetValues";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isStaging";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSrc";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 8, 22, 24 -> new IllegalStateException(string);
        };
    }

    private static class MyRepresenter
    extends Representer {
        MyRepresenter() {
            super(new DumperOptions());
            this.addClassTag(DbSrcStorageDsMetadata.MetaData.class, META_DATA_TAG);
            this.representers.put(DbSrcStorageDsMetadata.MetaData.class, new Represent(){

                public Node representData(Object data) {
                    DbSrcStorageDsMetadata.MetaData md = (DbSrcStorageDsMetadata.MetaData)data;
                    return this.representSequence(META_DATA_TAG, Arrays.asList(md.srcVersion, md.contentHash, md.offsets, md.kinds, md.introContentVersion, md.genContentVersion), DumperOptions.FlowStyle.FLOW);
                }
            });
        }
    }

    public static enum SrcType implements SrcTypeOrFolder
    {
        ORIGINAL,
        USER,
        USER_BASE;

        public static final SrcTypeOrFolder FOLDER;

        static {
            FOLDER = new SrcTypeOrFolder(){

                public String toString() {
                    return "FOLDER";
                }
            };
        }
    }

    public static interface SrcTypeOrFolder {
    }

    public static class InputStreamWrapper
    extends InputStream {
        private final InputStream delegate;

        public InputStreamWrapper(@NotNull InputStream delegate) {
            if (delegate == null) {
                InputStreamWrapper.$$$reportNull$$$0(0);
            }
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            if (b == null) {
                InputStreamWrapper.$$$reportNull$$$0(1);
            }
            return this.delegate.read(b);
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                InputStreamWrapper.$$$reportNull$$$0(2);
            }
            return this.delegate.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendUtils$InputStreamWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

