/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcValidator {
    private static final Logger LOG = Logger.getInstance(DbSrcValidator.class);

    public static boolean isEnabled() {
        return ApplicationManager.getApplication().isInternal();
    }

    @NotNull
    public Couple<List<LocalDataSource>> collect(@NotNull Project project, @NotNull Iterable<LocalDataSource> dataSources) {
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(0);
        }
        if (dataSources == null) {
            DbSrcValidator.$$$reportNull$$$0(1);
        }
        Couple res2 = Couple.of(new ArrayList(), new ArrayList());
        for (LocalDataSource source : dataSources) {
            Result result2;
            if (project.isDisposed()) break;
            DbSrcStorage storage = DbSrcStorageManager.getInstance(source.isGlobal() ? null : project).getStorage(source.getUniqueId(), true);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)source.getModel(), BasicModel.class);
            if (model == null || (result2 = DbSrcValidator.isValid(storage, model, source.getIntrospectionScope())) == Result.VALID) continue;
            if (result2 == Result.GENERATE || result2 == Result.GENERATE_AND_INTROSPECT) {
                ((List)res2.first).add(source);
            }
            if (result2 != Result.INTROSPECT && result2 != Result.GENERATE_AND_INTROSPECT) continue;
            ((List)res2.second).add(source);
        }
        Couple couple = res2;
        if (couple == null) {
            DbSrcValidator.$$$reportNull$$$0(2);
        }
        return couple;
    }

    @NotNull
    public static Result isValid(@NotNull DbSrcStorage storage, @NotNull BasicModel model, @NotNull TreePattern scope2) {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(3);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(4);
        }
        if (scope2 == null) {
            DbSrcValidator.$$$reportNull$$$0(5);
        }
        Result result2 = Result.VALID;
        for (BasicSchema schema : DbSrcValidator.getSchemas(model, scope2)) {
            Result cur = DbSrcValidator.isValid(storage, scope2, model, schema);
            if (result2 == Result.GENERATE && cur == Result.INTROSPECT || result2 == Result.INTROSPECT && cur == Result.GENERATE) {
                Result result3 = Result.GENERATE_AND_INTROSPECT;
                if (result3 == null) {
                    DbSrcValidator.$$$reportNull$$$0(6);
                }
                return result3;
            }
            if (cur.compareTo(result2) <= 0) continue;
            result2 = cur;
        }
        Result result4 = result2;
        if (result4 == null) {
            DbSrcValidator.$$$reportNull$$$0(7);
        }
        return result4;
    }

    @NotNull
    public static Result isValid(@NotNull DbSrcStorage storage, @NotNull TreePattern scope2, @NotNull BasicModel model, @NotNull BasicSchema schema) {
        Result result2;
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(8);
        }
        if (scope2 == null) {
            DbSrcValidator.$$$reportNull$$$0(9);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(10);
        }
        if (schema == null) {
            DbSrcValidator.$$$reportNull$$$0(11);
        }
        if ((result2 = DbSrcValidator.checkVersions(storage, model, schema)) != null) {
            Result result3 = result2;
            if (result3 == null) {
                DbSrcValidator.$$$reportNull$$$0(12);
            }
            return result3;
        }
        result2 = Result.VALID;
        for (BasicSourceAware object : DbSrcValidator.getSources(scope2, model, schema)) {
            Result cur = (Result)((Object)ObjectUtils.chooseNotNull((Object)((Object)DbSrcValidator.checkVersions(storage, model, object)), (Object)((Object)Result.VALID)));
            if (cur.compareTo(result2) > 0) {
                result2 = cur;
            }
            if (result2 != Result.INTROSPECT) continue;
            break;
        }
        DbSrcValidator.updateSchemaValidness(storage, model, schema, result2);
        Result result4 = result2;
        if (result4 == null) {
            DbSrcValidator.$$$reportNull$$$0(13);
        }
        return result4;
    }

    @NotNull
    private static JBIterable<BasicSchema> getSchemas(@NotNull BasicModel model, @NotNull TreePattern scope2) {
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(14);
        }
        if (scope2 == null) {
            DbSrcValidator.$$$reportNull$$$0(15);
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)model.traverser().withRoots(model.getModelRoots())).expand(n -> n.getKind() != ObjectKind.SCHEMA)).filter(BasicSchema.class).filter(s -> DataSourceSchemaMapping.matches(scope2, s));
        if (jBIterable == null) {
            DbSrcValidator.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    private static JBIterable<BasicSourceAware> getSources(@NotNull TreePattern scope2, @NotNull BasicModel model, @Nullable BasicSchema schema) {
        if (scope2 == null) {
            DbSrcValidator.$$$reportNull$$$0(17);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(18);
        }
        JBTreeTraverser traverser = model.traverser();
        traverser = schema != null ? (JBTreeTraverser)traverser.withRoot((Object)schema) : (JBTreeTraverser)((JBTreeTraverser)traverser.withRoot((Object)model.getRoot())).expand(o -> DataSourceSchemaMapping.isIntrospected(scope2, o));
        return traverser.filter(BasicSourceAware.class);
    }

    @Nullable
    private static Result checkVersions(@NotNull DbSrcStorage storage, @NotNull BasicModel model, @NotNull BasicElement object) {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(19);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(20);
        }
        if (object == null) {
            DbSrcValidator.$$$reportNull$$$0(21);
        }
        ObjectPath path = ObjectPaths.of(object);
        Dbms dbms = model.getDbms();
        ScriptGenerator service = (ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms);
        DbSrcStorageDsMetadata.MetaData metaData = storage.getMetaData(path);
        if (metaData == null) {
            return null;
        }
        ScriptingCapabilities caps = service.capabilities(object);
        if (object.getKind() == ObjectKind.SCHEMA) {
            if (metaData.introContentVersion < 0 && metaData.introContentVersion != DbSrcStorageDsMetadata.MetaData.EMPTY.introContentVersion) {
                return Result.INTROSPECT;
            }
            if (metaData.genContentVersion < 0 && metaData.genContentVersion != DbSrcStorageDsMetadata.MetaData.EMPTY.genContentVersion) {
                return Result.GENERATE;
            }
            int genVersion = caps.getCreateVersion();
            int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(dbms, object.getKind());
            boolean match = introVersion == metaData.introContentVersion && genVersion == metaData.genContentVersion;
            return match ? Result.VALID : null;
        }
        int genVersion = caps.getCreateVersion();
        int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(dbms, object.getKind());
        if (introVersion != metaData.introContentVersion) {
            return Result.INTROSPECT;
        }
        if (genVersion != metaData.genContentVersion) {
            return Result.GENERATE;
        }
        return Result.VALID;
    }

    private static void updateSchemaValidness(@NotNull DbSrcStorage storage, @NotNull BasicModel model, @NotNull BasicSchema object, @NotNull Result result2) {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(22);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(23);
        }
        if (object == null) {
            DbSrcValidator.$$$reportNull$$$0(24);
        }
        if (result2 == null) {
            DbSrcValidator.$$$reportNull$$$0(25);
        }
        ObjectPath path = ObjectPaths.of(object);
        Dbms dbms = model.getDbms();
        ScriptingCapabilities caps = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(object);
        DbSrcStorageDsMetadata.MetaData metaData = (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)storage.getMetaData(path), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY);
        int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(dbms, object.getKind());
        int genVersion = caps.getCreateVersion();
        metaData = DbSrcStorageDsMetadata.MetaData.modContentVersion(metaData, result2 == Result.INTROSPECT ? -introVersion : introVersion, result2 != Result.VALID ? -genVersion : genVersion);
        try {
            storage.putMetaData(path, metaData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void invalidate(@NotNull DbSrcStorage storage, @NotNull ObjectPath path) {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(26);
        }
        if (path == null) {
            DbSrcValidator.$$$reportNull$$$0(27);
        }
        DbSrcStorageDsMetadata.MetaData metaData = (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)storage.getMetaData(path), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY);
        try {
            storage.putMetaData(path, DbSrcStorageDsMetadata.MetaData.modContentVersion(metaData, DbSrcStorageDsMetadata.MetaData.EMPTY.introContentVersion, DbSrcStorageDsMetadata.MetaData.EMPTY.genContentVersion));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void suggestIntrospecting(@NotNull Project project, @NotNull List<LocalDataSource> dataSources) {
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(28);
        }
        if (dataSources == null) {
            DbSrcValidator.$$$reportNull$$$0(29);
        }
        String names = StringUtil.join(dataSources, AbstractDataSource::getName, (String)", ");
        ConnDatabaseNotifications.DATABASE_VIEW_GROUP().createNotification(DatabaseBundle.message("notification.title.invalid.source.code.database.objects", new Object[0]), DatabaseBundle.message("notification.content.must.be.href.introspect.synchronized", names), NotificationType.WARNING).setListener((notification, event) -> {
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (!event.getDescription().equals("introspect")) {
                return;
            }
            for (LocalDataSource dataSource : dataSources) {
                DataSourceUtil.performManualSyncTask(LoaderContext.selectGeneralTask(project, dataSource));
            }
        }).setDisplayId("DbSrcValidator.introspection.suggested").notify(project);
    }

    public static void suggestRegenerating(final @NotNull Project project, final @NotNull List<LocalDataSource> dataSources) {
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(30);
        }
        if (dataSources == null) {
            DbSrcValidator.$$$reportNull$$$0(31);
        }
        String names = StringUtil.join(dataSources, AbstractDataSource::getName, (String)", ");
        ConnDatabaseNotifications.DATABASE_VIEW_GROUP().createNotification(DatabaseBundle.message("notification.title.invalid.source.code.database.objects", new Object[0]), DatabaseBundle.message("notification.content.must.be.href.regenerate.regenerated", names), NotificationType.WARNING).setListener((notification, event) -> {
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (!event.getDescription().equals("regenerate")) {
                return;
            }
            new Task.Backgroundable(project, DatabaseBundle.message("progress.title.regenerating.db.objects.source.code", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DbSrcValidator.regenerateSources(project, dataSources);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/srcStorage/DbSrcValidator$1", "run"));
                }
            }.queue();
        }).setDisplayId("DbSrcValidator.regeneration.suggested").notify(project);
    }

    public static void regenerateSources(@NotNull Project project, @NotNull List<LocalDataSource> dataSources) {
        ProgressIndicator indicator;
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(32);
        }
        if (dataSources == null) {
            DbSrcValidator.$$$reportNull$$$0(33);
        }
        if ((indicator = ProgressIndicatorProvider.getGlobalProgressIndicator()) != null) {
            indicator.setText(DatabaseBundle.message("progress.text.regenerating.db.objects.source.code", new Object[0]));
        }
        for (LocalDataSource dataSource : dataSources) {
            DbSrcValidator.regenerateSources(project, dataSource);
        }
    }

    public static void regenerateSources(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        BasicModModel model;
        DbSrcModelStorage modelStorage;
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(34);
        }
        if (dataSource == null) {
            DbSrcValidator.$$$reportNull$$$0(35);
        }
        DbSrcModelStorage dbSrcModelStorage = modelStorage = (model = (BasicModModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModModel.class)) == null ? null : (DbSrcModelStorage)ObjectUtils.tryCast((Object)model.getTextStorage(), DbSrcModelStorage.class);
        if (modelStorage == null) {
            return;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText2(InspectionsBundle.message((String)"processing.progress.text", (Object[])new Object[]{dataSource.getName()}));
        }
        ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
        DbSrcStorage storage = DbSrcStorageManager.getInstance(dataSource.isGlobal() ? null : project).getStorage(dataSource.getUniqueId(), true);
        DbImplUtilCore.performSrcOperation(project, model, ModalityState.defaultModalityState(), true, () -> modelStorage.writeSession(model, () -> {
            for (BasicSourceAware aware : DbSrcValidator.getSources(dataSource.getIntrospectionScope(), model, null)) {
                CompositeText compositeText;
                int version = service.capabilities(aware).getCreateVersion();
                DbSrcStorageDsMetadata.MetaData metaData = storage.getMetaData(ObjectPaths.of(aware));
                if (metaData == null || metaData.genContentVersion == version || (compositeText = modelStorage.load(aware)) == null) continue;
                modelStorage.save(aware, compositeText);
            }
        }));
    }

    public static void checkOutdatedFiles(@Nullable Project project) {
        VirtualFile root = DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(project, null, null, null, null));
        if (root == null) {
            return;
        }
        ArrayList<String> pruned = new ArrayList<String>();
        for (VirtualFile dsRoot : root.getChildren()) {
            if (!DbSrcValidator.checkOutdatedFiles(project, dsRoot)) continue;
            pruned.add(dsRoot.getName());
        }
        if (!pruned.isEmpty()) {
            DbSrcValidator.notifyPruned(project, pruned);
        }
    }

    @Nullable
    private static Project getAnyProject() {
        return DbImplUtilCore.getAnyProject();
    }

    private static void notifyPruned(final Project dsProject, List<String> pruned) {
        final List dataSources = JBIterable.from(pruned).filterMap(ds -> DbSrcUtilsCore.findDataSource(dsProject, ds)).toList();
        ConnDatabaseNotifications.DATABASE_VIEW_GROUP().createNotification(DatabaseBundle.message("notification.title.stale.cached.sources.removed", new Object[0]), DatabaseBundle.message("notification.content.href.sync.refresh.may.be.required.for", StringUtil.join((Collection)dataSources, DasDataSource::getName, (String)", ")), NotificationType.WARNING).setListener((NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                Project project = dsProject == null ? DbSrcValidator.getAnyProject() : dsProject;
                for (LocalDataSource dataSource : dataSources) {
                    DataSourceUtil.performAutoSyncTask(LoaderContext.selectGeneralTask(project, dataSource));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcValidator$2";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).setDisplayId("DbSrcValidator.stale.pruned").notify(dsProject);
    }

    private static boolean checkOutdatedFiles(@Nullable Project dsProject, @NotNull VirtualFile root) {
        LocalDataSource localDs;
        if (root == null) {
            DbSrcValidator.$$$reportNull$$$0(36);
        }
        if (!((localDs = DbSrcUtilsCore.findDataSource(dsProject, root.getName())) instanceof LocalDataSource)) {
            return false;
        }
        LinkedHashSet<ObjectPath> leftOvers = new LinkedHashSet<ObjectPath>();
        ArrayList<VirtualFile> leftOverFiles = new ArrayList<VirtualFile>();
        DbSrcValidator.collectLeftOvers(dsProject, localDs, root, leftOvers, leftOverFiles);
        if (leftOvers.isEmpty()) {
            return false;
        }
        DbSrcStorage storage = DbSrcStorageManager.getInstance(dsProject).getStorage(Objects.requireNonNull(localDs.getUniqueId()), true);
        LOG.warn("Found " + leftOvers.size() + " left over files in storage of " + localDs.getName() + ":\n" + StringUtil.join((Iterable)JBIterable.from(leftOvers).take(5), ObjectPath::getDisplayName, (String)"\n") + (leftOvers.size() > 5 ? "\n..." : "") + "\nPruning.");
        try {
            for (ObjectPath path : leftOvers) {
                storage.dropObject(path, true);
                DbSrcValidator.cleanupDatabaseAndSchemaStamps(storage, path);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        RefreshQueue.getInstance().refresh(true, true, null, leftOverFiles);
        return true;
    }

    private static void collectLeftOvers(@Nullable Project project, LocalDataSource localDs, @NotNull VirtualFile root, Set<ObjectPath> leftOvers, List<VirtualFile> leftOverFiles) {
        if (root == null) {
            DbSrcValidator.$$$reportNull$$$0(37);
        }
        while (true) {
            try {
                EmptyProgressIndicator indicator = new EmptyProgressIndicator();
                ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> DbSrcValidator.collectLeftOvers(project, localDs, root, leftOvers, leftOverFiles, (ProgressIndicator)indicator), (ProgressIndicator)indicator);
            }
            catch (ProcessCanceledException ignored) {
                continue;
            }
            break;
        }
    }

    private static void collectLeftOvers(@Nullable Project dsProject, LocalDataSource localDs, @NotNull VirtualFile root, final Set<ObjectPath> leftOvers, final List<VirtualFile> leftOverFiles, final ProgressIndicator indicator) {
        DbDataSource dataSource;
        if (root == null) {
            DbSrcValidator.$$$reportNull$$$0(38);
        }
        Project project = dsProject == null ? DbSrcValidator.getAnyProject() : dsProject;
        DbDataSource dbDataSource = dataSource = project == null ? null : DbPsiFacade.getInstance(project).findDataSource(localDs.getUniqueId());
        if (dataSource == null) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT}){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                indicator.checkCanceled();
                ObjectPath path = DbSrcUtilsCore.getFullPath(file.getPath());
                if (path == null) {
                    return true;
                }
                if (!leftOvers.contains(path)) {
                    DbElement element = DbSqlUtilCore.findElement(dataSource, path);
                    if (element != null) {
                        return true;
                    }
                    if (DbSrcFileSystem.getInstance().isOrphaned(file)) {
                        return false;
                    }
                    leftOvers.add(path);
                }
                leftOverFiles.add(file);
                VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{file});
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcValidator$3", "visitFile"));
            }
        });
    }

    private static void cleanupDatabaseAndSchemaStamps(@NotNull DbSrcStorage storage, @NotNull ObjectPath obj2) throws IOException {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(39);
        }
        if (obj2 == null) {
            DbSrcValidator.$$$reportNull$$$0(40);
        }
        DbSrcValidator.cleanupStamps(storage, obj2.findParent(ObjectKind.SCHEMA, true));
        DbSrcValidator.cleanupStamps(storage, obj2.findParent(ObjectKind.DATABASE, true));
    }

    private static void cleanupStamps(@NotNull DbSrcStorage storage, @Nullable ObjectPath obj2) throws IOException {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(41);
        }
        if (obj2 == null) {
            return;
        }
        DbSrcStorageDsMetadata.MetaData md = storage.getMetaData(obj2);
        if (md == null || md.srcVersion == null) {
            return;
        }
        storage.putMetaData(obj2, DbSrcStorageDsMetadata.MetaData.modSrcVersion(md, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 12, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcValidator";
                break;
            }
            case 3: 
            case 8: 
            case 19: 
            case 22: 
            case 26: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 4: 
            case 10: 
            case 14: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: 
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "isValid";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSchemas";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSources";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkVersions";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateSchemaValidness";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "suggestIntrospecting";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "suggestRegenerating";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "regenerateSources";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkOutdatedFiles";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "collectLeftOvers";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "cleanupDatabaseAndSchemaStamps";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "cleanupStamps";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 12, 13, 16 -> new IllegalStateException(string);
        };
    }

    public static enum Result {
        VALID,
        GENERATE,
        INTROSPECT,
        GENERATE_AND_INTROSPECT;

    }
}

