/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fR3\u0010\u0004\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus;", "", "<init>", "()V", "myCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry;", "getStatus", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "StatusEntry", "Companion", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDbSrcFileStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbSrcFileStatus.kt\ncom/intellij/database/dataSource/srcStorage/DbSrcFileStatus\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class DbSrcFileStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<String, StatusEntry> myCache;

    public DbSrcFileStatus() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.myCache = concurrentMap;
    }

    @NotNull
    public final StatusEntry getStatus(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        String url = string;
        boolean bl = DbSrcUtils.isDbSrcFile(file);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "DbSrcFile expected, got: " + url;
            throw new AssertionError((Object)string2);
        }
        if (file.isDirectory() || !file.isValid()) {
            return StatusEntry.Companion.getNON_MODIFIED_ENTRY();
        }
        StatusEntry entry = (StatusEntry)this.myCache.get(url);
        if (entry == null || !entry.isValid(file)) {
            entry = StatusEntry.Companion.entryOf(file);
            ((Map)this.myCache).put(url, entry);
        }
        return entry;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus$Companion;", "", "<init>", "()V", "getStamp", "", "baseFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContent", "", "vFile", "latest", "", "getDocument", "Lcom/intellij/openapi/editor/Document;", "file", "documentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        private final long getStamp(VirtualFile baseFile) {
            VirtualFile virtualFile = baseFile;
            return virtualFile != null ? virtualFile.getModificationStamp() : Long.MIN_VALUE;
        }

        @Nullable
        public final String getContent(@Nullable VirtualFile vFile, boolean latest) {
            if (vFile == null) {
                return null;
            }
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            Document document = this.getDocument(vFile, fileDocumentManager);
            if (document == null) {
                return null;
            }
            Document doc = document;
            if (latest || !FileDocumentManager.getInstance().isDocumentUnsaved(doc)) {
                return doc.getText();
            }
            try {
                return VfsUtilCore.loadText((VirtualFile)vFile);
            }
            catch (IOException e) {
                return null;
            }
        }

        private final Document getDocument(VirtualFile file, FileDocumentManager documentManager) {
            return (Document)ReadAction.compute(() -> Companion.getDocument$lambda$0(documentManager, file));
        }

        private static final Document getDocument$lambda$0(FileDocumentManager $documentManager, VirtualFile $file) {
            return $documentManager.getDocument($file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry;", "", "myKey", "Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry$StatusEntryKey;", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "<init>", "(Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry$StatusEntryKey;Lcom/intellij/openapi/vcs/FileStatus;)V", "getStatus", "()Lcom/intellij/openapi/vcs/FileStatus;", "baseFileUrl", "", "getBaseFileUrl", "()Ljava/lang/String;", "originalFileUrl", "getOriginalFileUrl", "toString", "isValid", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "StatusEntryKey", "Companion", "intellij.database.connectivity"})
    public static final class StatusEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final StatusEntryKey myKey;
        @Nullable
        private final FileStatus status;
        @NotNull
        private static final StatusEntryKey NON_MODIFIED_KEY = new StatusEntryKey(0L, 0L, null, 0L, null);
        @NotNull
        private static final StatusEntry NON_MODIFIED_ENTRY = new StatusEntry(NON_MODIFIED_KEY, null);

        private StatusEntry(StatusEntryKey myKey, FileStatus status) {
            this.myKey = myKey;
            this.status = status;
        }

        @Nullable
        public final FileStatus getStatus() {
            return this.status;
        }

        @Nullable
        public final String getBaseFileUrl() {
            return this.myKey.getMyBaseFileUrl();
        }

        @Nullable
        public final String getOriginalFileUrl() {
            return this.myKey.getMyOriginalFileUrl();
        }

        @NotNull
        public String toString() {
            return this.myKey + "\nstatus: " + this.status;
        }

        public final boolean isValid(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return Intrinsics.areEqual((Object)StatusEntry.Companion.keyOf(file), (Object)this.myKey);
        }

        public /* synthetic */ StatusEntry(StatusEntryKey myKey, FileStatus status, DefaultConstructorMarker $constructor_marker) {
            this(myKey, status);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry$Companion;", "", "<init>", "()V", "NON_MODIFIED_KEY", "Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry$StatusEntryKey;", "keyOf", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "NON_MODIFIED_ENTRY", "Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry;", "getNON_MODIFIED_ENTRY", "()Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry;", "entryOf", "intellij.database.connectivity"})
        @SourceDebugExtension(value={"SMAP\nDbSrcFileStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbSrcFileStatus.kt\ncom/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final StatusEntryKey keyOf(VirtualFile file) {
                VirtualFile virtualFile;
                VirtualFile origFile;
                long stamp;
                Document document;
                DbSrcFileSystem dbFs;
                VirtualFileSystem virtualFileSystem = file.getFileSystem();
                DbSrcFileSystem dbSrcFileSystem = dbFs = virtualFileSystem instanceof DbSrcFileSystem ? (DbSrcFileSystem)virtualFileSystem : null;
                if (dbFs == null || !DbSrcUtils.isSrc(file)) {
                    return NON_MODIFIED_KEY;
                }
                VirtualFile orig = dbFs.getSatelliteFile(file, DbSrcFileSystemCore.ItemType.ORIG, false);
                VirtualFile base = dbFs.getSatelliteFile(file, DbSrcFileSystemCore.ItemType.USER_BASE, false);
                boolean isFileModified = orig != null || base != null;
                boolean orphaned = !isFileModified && dbFs.isOrphaned(file);
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
                FileDocumentManager documentManager = fileDocumentManager;
                boolean isDocumentModified = documentManager.isFileModified(file);
                Document document2 = document = isDocumentModified ? DbSrcFileStatus.Companion.getDocument(file, documentManager) : null;
                long l = stamp = document2 != null ? document2.getModificationStamp() : DbSrcFileStatus.Companion.getStamp(file);
                if (!(orphaned || isDocumentModified || isFileModified)) {
                    return NON_MODIFIED_KEY;
                }
                VirtualFile virtualFile2 = orig;
                if (virtualFile2 == null) {
                    virtualFile2 = origFile = file;
                }
                if ((virtualFile = base) == null) {
                    virtualFile = orig;
                }
                VirtualFile baseFile = virtualFile;
                VirtualFile virtualFile3 = baseFile;
                return new StatusEntryKey(stamp, DbSrcFileStatus.Companion.getStamp(origFile), orphaned ? null : origFile.getUrl(), DbSrcFileStatus.Companion.getStamp(baseFile), virtualFile3 != null ? virtualFile3.getUrl() : null);
            }

            @NotNull
            public final StatusEntry getNON_MODIFIED_ENTRY() {
                return NON_MODIFIED_ENTRY;
            }

            @NotNull
            public final StatusEntry entryOf(@NotNull VirtualFile file) {
                VirtualFile baseFile;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                StatusEntryKey key2 = this.keyOf(file);
                if (key2.getMyOriginalFileUrl() != null && key2.getMyBaseFileUrl() != null && !Intrinsics.areEqual((Object)key2.getMyOriginalFileUrl(), (Object)key2.getMyBaseFileUrl())) {
                    boolean existsInDb = DbSrcFileSystemCore.ItemType.ORIG.is(key2.getMyOriginalFileUrl());
                    return new StatusEntry(key2, existsInDb ? FileStatus.MERGED_WITH_CONFLICTS : FileStatus.MERGED_WITH_PROPERTY_CONFLICTS, null);
                }
                String string = key2.getMyOriginalFileUrl();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    v1 = VirtualFileManager.getInstance().findFileByUrl(it);
                } else {
                    v1 = baseFile = null;
                }
                if (baseFile == null) {
                    if (DbSrcFileSystem.getInstance().isOrphaned(file)) {
                        return new StatusEntry(key2, FileStatus.DELETED, null);
                    }
                    return key2.getMyOriginalStamp() == key2.getMyStagingStamp() ? this.getNON_MODIFIED_ENTRY() : new StatusEntry(key2, FileStatus.UNKNOWN, null);
                }
                return new StatusEntry(key2, Intrinsics.areEqual((Object)DbSrcFileStatus.Companion.getContent(file, false), (Object)DbSrcFileStatus.Companion.getContent(baseFile, true)) ? null : FileStatus.MODIFIED, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J?\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry$StatusEntryKey;", "", "myStagingStamp", "", "myOriginalStamp", "myOriginalFileUrl", "", "myBaseStamp", "myBaseFileUrl", "<init>", "(JJLjava/lang/String;JLjava/lang/String;)V", "getMyStagingStamp", "()J", "getMyOriginalStamp", "getMyOriginalFileUrl", "()Ljava/lang/String;", "getMyBaseStamp", "getMyBaseFileUrl", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.connectivity"})
        private static final class StatusEntryKey {
            private final long myStagingStamp;
            private final long myOriginalStamp;
            @Nullable
            private final String myOriginalFileUrl;
            private final long myBaseStamp;
            @Nullable
            private final String myBaseFileUrl;

            public StatusEntryKey(long myStagingStamp, long myOriginalStamp, @Nullable String myOriginalFileUrl, long myBaseStamp, @Nullable String myBaseFileUrl) {
                this.myStagingStamp = myStagingStamp;
                this.myOriginalStamp = myOriginalStamp;
                this.myOriginalFileUrl = myOriginalFileUrl;
                this.myBaseStamp = myBaseStamp;
                this.myBaseFileUrl = myBaseFileUrl;
            }

            public final long getMyStagingStamp() {
                return this.myStagingStamp;
            }

            public final long getMyOriginalStamp() {
                return this.myOriginalStamp;
            }

            @Nullable
            public final String getMyOriginalFileUrl() {
                return this.myOriginalFileUrl;
            }

            public final long getMyBaseStamp() {
                return this.myBaseStamp;
            }

            @Nullable
            public final String getMyBaseFileUrl() {
                return this.myBaseFileUrl;
            }

            public final long component1() {
                return this.myStagingStamp;
            }

            public final long component2() {
                return this.myOriginalStamp;
            }

            @Nullable
            public final String component3() {
                return this.myOriginalFileUrl;
            }

            public final long component4() {
                return this.myBaseStamp;
            }

            @Nullable
            public final String component5() {
                return this.myBaseFileUrl;
            }

            @NotNull
            public final StatusEntryKey copy(long myStagingStamp, long myOriginalStamp, @Nullable String myOriginalFileUrl, long myBaseStamp, @Nullable String myBaseFileUrl) {
                return new StatusEntryKey(myStagingStamp, myOriginalStamp, myOriginalFileUrl, myBaseStamp, myBaseFileUrl);
            }

            public static /* synthetic */ StatusEntryKey copy$default(StatusEntryKey statusEntryKey, long l, long l2, String string, long l3, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    l = statusEntryKey.myStagingStamp;
                }
                if ((n & 2) != 0) {
                    l2 = statusEntryKey.myOriginalStamp;
                }
                if ((n & 4) != 0) {
                    string = statusEntryKey.myOriginalFileUrl;
                }
                if ((n & 8) != 0) {
                    l3 = statusEntryKey.myBaseStamp;
                }
                if ((n & 0x10) != 0) {
                    string2 = statusEntryKey.myBaseFileUrl;
                }
                return statusEntryKey.copy(l, l2, string, l3, string2);
            }

            @NotNull
            public String toString() {
                return "StatusEntryKey(myStagingStamp=" + this.myStagingStamp + ", myOriginalStamp=" + this.myOriginalStamp + ", myOriginalFileUrl=" + this.myOriginalFileUrl + ", myBaseStamp=" + this.myBaseStamp + ", myBaseFileUrl=" + this.myBaseFileUrl + ")";
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.myStagingStamp);
                result2 = result2 * 31 + Long.hashCode(this.myOriginalStamp);
                result2 = result2 * 31 + (this.myOriginalFileUrl == null ? 0 : this.myOriginalFileUrl.hashCode());
                result2 = result2 * 31 + Long.hashCode(this.myBaseStamp);
                result2 = result2 * 31 + (this.myBaseFileUrl == null ? 0 : this.myBaseFileUrl.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StatusEntryKey)) {
                    return false;
                }
                StatusEntryKey statusEntryKey = (StatusEntryKey)other;
                if (this.myStagingStamp != statusEntryKey.myStagingStamp) {
                    return false;
                }
                if (this.myOriginalStamp != statusEntryKey.myOriginalStamp) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.myOriginalFileUrl, (Object)statusEntryKey.myOriginalFileUrl)) {
                    return false;
                }
                if (this.myBaseStamp != statusEntryKey.myBaseStamp) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.myBaseFileUrl, (Object)statusEntryKey.myBaseFileUrl);
            }
        }
    }
}

